\name{point}
\title{Point Object}
\usage{point(data.frame, x='x', y='y') }
\alias{point}
\arguments{
\item{data.frame}{a data frame containing the x and y coordinates for each point and the variables observed at each point}
\item{x}{the name of the column in data.frame that contains the x coordinate}
\item{y}{the name of the column in data.frame that contains the y coordinate}
}
\value{A point object:
\item{x}{vector of x coordinates}
\item{y}{vector of ycoordinates}
\item{var1}{vector of the first variable}
\item{...}{...}
\item{varm}{vector of the mth variable}
}
\description{Create an object of class point from a data frame.

An object of class point represents the observed data of a spatial process. This includes the spatial location of sampling sites and
the values observed at those sites. A point object is stored as a data frame. The data frame must contain one column for the X
coordinate and one column for the Y coordinate of each point, as well as any number of columns representing data observed at the
points. }
\seealso{\code{\link{point}}}
\examples{
data(maas)
maas.pts <- point(maas) 
}
\references{
http://www.gis.iastate.edu/SGeoStat/homepage.html
}
