/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb;

import java.math.BigInteger;
import org.sat4j.pb.IPBSolver;
import org.sat4j.pb.ObjectiveFunction;
import org.sat4j.pb.PBSolverDecorator;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IOptimizationProblem;
import org.sat4j.specs.TimeoutException;

public class PseudoOptDecorator
extends PBSolverDecorator
implements IOptimizationProblem {
    private static final long serialVersionUID = 1L;
    private ObjectiveFunction objfct;
    private int[] prevmodel;
    private boolean[] prevfullmodel;

    public PseudoOptDecorator(IPBSolver iPBSolver) {
        super(iPBSolver);
    }

    public void setObjectiveFunction(ObjectiveFunction objectiveFunction) {
        this.objfct = objectiveFunction;
        ((IPBSolver)this.decorated()).setObjectiveFunction(objectiveFunction);
    }

    public boolean admitABetterSolution() throws TimeoutException {
        boolean bl = super.isSatisfiable(true);
        if (bl) {
            this.prevmodel = super.model();
            this.prevfullmodel = new boolean[this.nVars()];
            for (int i = 0; i < this.nVars(); ++i) {
                this.prevfullmodel[i] = ((IPBSolver)this.decorated()).model(i + 1);
            }
        }
        return bl;
    }

    public boolean hasNoObjectiveFunction() {
        return this.objfct == null;
    }

    public boolean nonOptimalMeansSatisfiable() {
        return true;
    }

    public Number calculateObjective() {
        return this.objfct.calculateDegree(this.prevmodel);
    }

    public void discard() throws ContradictionException {
        super.addPseudoBoolean(this.objfct.getVars(), this.objfct.getCoeffs(), false, this.objfct.calculateDegree(this.prevmodel).subtract(BigInteger.ONE));
    }

    public int[] model() {
        return this.prevmodel;
    }

    public boolean model(int n) {
        return this.prevfullmodel[n - 1];
    }

    public String toString(String string) {
        return string + "Pseudo Boolean Optimization\n" + super.toString(string);
    }
}

