/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.ByColumnStatisticAccumulator;
import com.insightful.miner.ChartEngineNode;
import com.insightful.miner.ColumnHeaderPanel;
import com.insightful.miner.DataPanel;
import com.insightful.miner.MinerApp;
import com.insightful.miner.MinerChartGUI;
import com.insightful.miner.ModifiableViewerFrame;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import com.insightful.miner.tree.gui.ColorBroker;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public class ChartBuilder {
    private static ResourceBundle chartBundles = null;
    private double categorylowerBoundPercentage = -1.0;
    public MinerChartGUI frame = null;
    private XTMetaData metaData = null;
    private XTProps chartStats = null;
    private int defaultInt = 0;
    private double defaultDouble = 0.0;
    private Vector requestedDisplayCols = null;
    private Vector groupedByCols = null;
    private int numBins = 0;
    private Vector selectedCharts = null;
    private Vector selectedRowOrColPanels = null;
    public Vector displayedCharts = null;
    private Vector emptyDisplayCols = null;
    private Vector emptyGBCols = null;
    private boolean dontShowCharts = false;
    private Number[] maxChartVals = null;
    private double[] maxChartCounts = null;
    private double[] minChartCounts = null;
    public boolean noConditionBys = false;
    public boolean chartsAreDisplayed = false;
    private boolean showstats = false;
    private boolean showLegend = true;
    private boolean sortNumerically = false;
    private boolean frameIsDisplayed = false;
    private boolean showCountPercents = false;
    private boolean useRelative = true;
    private Vector[] sortedLevels = null;
    private int[][] conversion = null;
    public XTProps nextStoreProps = null;
    public long numRowsDoneByViewer = 0L;
    public long rowCount = 0L;
    private boolean killThreads = false;
    public static final int HISTOGRAM_TYPE = 0;
    public static final int BOX_PLOT_TYPE = 1;
    public static final int DOT_CHART_TYPE = 2;
    public static final int BAR_CHART_TYPE = 3;
    public static final int PIE_CHART_TYPE = 4;
    public static final int COLUMN_CHART_TYPE = 5;
    private int continuousChartType = 0;
    private int categoricalChartType = 3;
    private ColorBroker colorBroker = null;

    public ChartBuilder(XTMetaData metadata, XTProps props) {
        this.metaData = metadata;
        this.chartStats = props;
        this.selectedCharts = new Vector();
        this.displayedCharts = new Vector();
        this.selectedRowOrColPanels = new Vector();
    }

    public void setCategoryLowerBoundPercentage(double value) {
        this.categorylowerBoundPercentage = value;
    }

    public boolean useRelative() {
        return this.useRelative;
    }

    public void setProps(XTProps props) {
        this.chartStats = props;
    }

    public void updateCharts(String newTitle, XTProps props, long numRowsDone) {
        if (!this.frameIsDisplayed) {
            return;
        }
        this.chartStats = props;
        this.frame.setTitle(newTitle);
        this.setMaxChartCounts();
        for (int i = 0; i < this.displayedCharts.size(); ++i) {
            DataPanel dp = (DataPanel)this.displayedCharts.elementAt(i);
            dp.updatePanel(this);
        }
        this.rowCount = numRowsDone;
    }

    public void setFrameClosed() {
        this.frameIsDisplayed = false;
        this.killThreads = true;
    }

    public boolean getThreadStopRequest() {
        return this.killThreads;
    }

    public long getTotalNumRows() {
        return this.metaData.getNumRows();
    }

    public void addChart(DataPanel chartPanel) {
        this.displayedCharts.add(chartPanel);
    }

    public void showStats(boolean b) {
        this.showStats(b, false);
    }

    public void showStats(boolean b, boolean justSelected) {
        this.showstats = b;
        Vector charts = justSelected ? this.selectedCharts : this.displayedCharts;
        for (int i = 0; i < charts.size(); ++i) {
            DataPanel dp = (DataPanel)charts.elementAt(i);
            if (b) {
                dp.showStatsPanel();
                continue;
            }
            dp.hideStatsPanel();
        }
        this.frame.validate();
        this.frame.repaint();
    }

    public void showLegend(boolean b) {
        this.showLegend(b, false);
    }

    public void showLegend(boolean b, boolean justSelected) {
        this.showLegend = b;
        Vector charts = justSelected ? this.selectedCharts : this.displayedCharts;
        for (int i = 0; i < charts.size(); ++i) {
            DataPanel dp = (DataPanel)this.displayedCharts.elementAt(i);
            dp.showLegend(b);
        }
        this.frame.validate();
        this.frame.repaint();
    }

    public int setDisplayInfo(int contChartType, int catChartType, Vector displayCols, Vector gbCols, int numbins, boolean show_stats, boolean showpercents, boolean relative) {
        return this.setDisplayInfo(contChartType, catChartType, displayCols, gbCols, numbins, show_stats, false, showpercents, relative);
    }

    public int setDisplayInfo(int contChartType, int catChartType, Vector displayCols, Vector gbCols, int numbins, boolean show_stats, boolean sort_numerically, boolean showCountsByPercent, boolean useRelativeValue) {
        this.categoricalChartType = catChartType;
        this.continuousChartType = contChartType;
        this.showstats = show_stats;
        this.sortNumerically = sort_numerically;
        this.showCountPercents = showCountsByPercent;
        this.useRelative = useRelativeValue;
        this.requestedDisplayCols = this.eliminateEmptyCols(displayCols, false);
        this.groupedByCols = this.eliminateEmptyCols(gbCols, true);
        if (this.emptyGBCols != null && this.emptyGBCols.size() > 0) {
            return -1;
        }
        if (this.groupedByCols.size() == 0) {
            this.noConditionBys = true;
        }
        this.numBins = numbins;
        if (catChartType == 3 || contChartType == 0 || catChartType == 2 || catChartType == 5) {
            this.setMaxChartCounts();
        }
        return 0;
    }

    private Vector eliminateEmptyCols(Vector vector, boolean isGroupByVector) {
        String col = null;
        Vector levels = new Vector();
        Vector<String> cols = new Vector<String>();
        for (int i = 0; i < vector.size(); ++i) {
            col = (String)vector.elementAt(i);
            if (this.isContinuous(col) || this.isDate(col)) {
                cols.add(col);
                continue;
            }
            if (this.isTypeString(col)) {
                JOptionPane.showMessageDialog(null, MinerApp.getText("ChartBuilder_msg_cannotDisplay") + " " + col + MinerApp.getText("ChartBuilder_msg_columnisaString"), MinerApp.getText("ChartBuilder_msg_stringColumn"), 2);
                continue;
            }
            levels = this.getLevels(col);
            if (levels.size() == 0) {
                if (isGroupByVector) {
                    JOptionPane.showMessageDialog(null, MinerApp.getText("ChartBuilder_msg_cannotDisplayCharts") + " " + col + ".", MinerApp.getText("ChartBuilder_msg_emptyColumn"), 0);
                    if (this.emptyGBCols == null) {
                        this.emptyGBCols = new Vector();
                    }
                    this.emptyGBCols.add(col);
                    continue;
                }
                JOptionPane.showMessageDialog(null, MinerApp.getText("ChartBuilder_msg_cannotDisplayEmptyColumn") + " " + col + ".", MinerApp.getText("ChartBuilder_msg_emptyCol"), 2);
                if (this.emptyDisplayCols == null) {
                    this.emptyDisplayCols = new Vector();
                }
                this.emptyDisplayCols.add(col);
                continue;
            }
            cols.add(col);
        }
        return cols;
    }

    public void clearMemory() {
        if (this.requestedDisplayCols != null) {
            this.requestedDisplayCols.removeAllElements();
        }
        if (this.groupedByCols != null) {
            this.groupedByCols.removeAllElements();
        }
        if (this.selectedCharts != null) {
            this.selectedCharts.removeAllElements();
        }
        if (this.selectedRowOrColPanels != null) {
            this.selectedRowOrColPanels.removeAllElements();
        }
        if (this.displayedCharts != null) {
            this.displayedCharts.removeAllElements();
        }
        if (this.emptyDisplayCols != null) {
            this.emptyDisplayCols.removeAllElements();
        }
        if (this.emptyGBCols != null) {
            this.emptyGBCols.removeAllElements();
        }
        this.maxChartVals = null;
        this.maxChartCounts = null;
    }

    public boolean statsVisible() {
        return this.showstats;
    }

    public boolean legendVisible() {
        return this.showLegend;
    }

    public Vector getRequestedDisplayCols() {
        return this.requestedDisplayCols;
    }

    public Vector getGroupedByCols() {
        return this.groupedByCols;
    }

    public boolean isDate(String colName) {
        return this.metaData.isDateTimeColumn(colName);
    }

    public boolean isContinuous(String colName) {
        return this.metaData.isContinuousColumn(colName);
    }

    public boolean isTypeString(String colName) {
        return this.metaData.isStringColumn(colName);
    }

    public boolean isCategorical(String colName) {
        return this.metaData.isCategoricalColumn(colName);
    }

    public Hashtable[] getConditions(Vector condCols) {
        int i;
        int[] numlevels = new int[condCols.size()];
        int[] numcounts = new int[condCols.size()];
        Vector v = null;
        for (int i2 = 0; i2 < condCols.size(); ++i2) {
            v = this.getLevels((String)condCols.elementAt(i2));
            numlevels[i2] = v.size();
        }
        v = null;
        numcounts[condCols.size() - 1] = 1;
        int factor = 1;
        if (numcounts.length == 1) {
            factor *= numlevels[0];
        }
        for (int i3 = condCols.size() - 1; i3 > 0; --i3) {
            numcounts[i3 - 1] = factor * numlevels[i3];
            factor = numcounts[i3 - 1];
        }
        Hashtable[] conditions = new Hashtable[numcounts[0] * numlevels[0]];
        String[] bycols = new String[condCols.size()];
        for (i = 0; i < condCols.size(); ++i) {
            bycols[i] = (String)condCols.elementAt(i);
        }
        for (i = 0; i < conditions.length; ++i) {
            conditions[i] = new Hashtable();
            conditions[i].put("bycols", bycols);
            conditions[i].put("levels", new String[bycols.length]);
        }
        Vector levelNames = null;
        String[] levels = null;
        for (int i4 = 0; i4 < condCols.size(); ++i4) {
            levelNames = this.sortNumerically ? this.getNumericallySortedLevels((String)condCols.elementAt(i4)) : this.getSortedLevels((String)condCols.elementAt(i4));
            int counter = 0;
            int index = 0;
            int reset_counter = numcounts[i4];
            for (int j = 0; j < conditions.length; ++j) {
                if (counter == reset_counter) {
                    counter = 0;
                    if (++index == levelNames.size()) {
                        index = 0;
                    }
                }
                levels = (String[])conditions[j].get("levels");
                levels[i4] = (String)levelNames.elementAt(index);
                conditions[j].put("levels", levels);
                ++counter;
            }
        }
        numlevels = null;
        numcounts = null;
        bycols = null;
        levelNames = null;
        levels = null;
        return conditions;
    }

    public Vector getLevels(String catColName) {
        if (this.metaData.isCategoricalColumn(catColName)) {
            return this.getSortedLevels(catColName);
        }
        return new Vector();
    }

    public Vector getSortedLevels(String catColName) {
        int colNum = this.metaData.nameToOrdinal(catColName);
        if (this.sortedLevels == null) {
            int numCols = this.metaData.getNumColumns();
            this.sortedLevels = new Vector[numCols];
            this.conversion = new int[numCols][];
        }
        if (this.sortedLevels[colNum] == null) {
            this.sortedLevels[colNum] = this.getSortedLevels(this.metaData, catColName, this.categorylowerBoundPercentage);
            Vector indices = this.getSortedIndices(this.metaData, catColName, this.categorylowerBoundPercentage);
            this.conversion[colNum] = new int[this.sortedLevels[colNum].size()];
            for (int i = 0; i < this.conversion[colNum].length; ++i) {
                this.conversion[colNum][i] = (Integer)indices.get(i);
            }
        }
        return this.sortedLevels[colNum];
    }

    private Vector getUnsortedLevels(XTMetaData metaData, String column, double lowerBoundPercent) {
        Vector ret = metaData.getCategoricalDataFieldLevels(column);
        double numRows = metaData.getNumRows();
        int rem = 0;
        for (int i = 0; i < ret.size(); ++i) {
            String level = (String)ret.get(i - rem);
            double num = Long.parseLong(metaData.getLevelCount(column, level));
            double reprPercent = num / numRows * 100.0;
            if (!(reprPercent < lowerBoundPercent)) continue;
            ret.remove(i - rem);
            ++rem;
        }
        return ret;
    }

    private Vector getSortedLevels(XTMetaData metaData, String column, double lowerBoundPercent) {
        Vector ret = metaData.getSortedCategoricalDataFieldLevels(column);
        double numRows = metaData.getNumRows();
        int rem = 0;
        for (int i = 0; i < ret.size(); ++i) {
            String level = (String)ret.get(i - rem);
            double num = Long.parseLong(metaData.getLevelCount(column, level));
            double reprPercent = num / numRows * 100.0;
            if (!(reprPercent < lowerBoundPercent)) continue;
            ret.remove(i - rem);
            ++rem;
        }
        return ret;
    }

    private Vector getSortedIndices(XTMetaData metaData, String column, double lowerBoundPercent) {
        Vector ret = metaData.getSortedCategoricalDataFieldLevelIndices(column);
        int columnNum = metaData.nameToOrdinal(column);
        double numRows = metaData.getNumRows();
        int rem = 0;
        for (int i = 0; i < ret.size(); ++i) {
            int index = (Integer)ret.get(i - rem);
            String level = metaData.getCategoricalDataFieldLevel(columnNum, index);
            double num = Long.parseLong(metaData.getLevelCount(column, level));
            double reprPercent = num / numRows * 100.0;
            if (!(reprPercent < lowerBoundPercent)) continue;
            ret.remove(i - rem);
            ++rem;
        }
        return ret;
    }

    public Vector getNumericallySortedLevels(String catColName) {
        Vector v = this.getSortedLevels(this.metaData, catColName, this.categorylowerBoundPercentage);
        int a = -1;
        int b = -1;
        String s = "";
        String ss = "";
        for (int i = 0; i < v.size() - 1; ++i) {
            for (int j = 0; j < v.size() - 1; ++j) {
                s = (String)v.elementAt(j);
                ss = (String)v.elementAt(j + 1);
                try {
                    a = Integer.parseInt(s);
                    b = Integer.parseInt(ss);
                    if (a <= b) continue;
                    v.set(j + 1, s);
                    v.set(j, ss);
                    continue;
                }
                catch (NumberFormatException nfe) {
                    return this.getSortedLevels(this.metaData, catColName, this.categorylowerBoundPercentage);
                }
            }
        }
        return v;
    }

    public int[] getColumnIndices(Vector columns) {
        int[] columnNums = new int[columns.size()];
        for (int i = 0; i < columns.size(); ++i) {
            columnNums[i] = this.metaData.nameToOrdinal((String)columns.get(i));
        }
        return columnNums;
    }

    public double[] getCounts(String desiredColName, Hashtable conditions) {
        boolean isContinuous;
        int numCounts = 0;
        boolean bl = isContinuous = this.isContinuous(desiredColName) || this.isDate(desiredColName);
        if (isContinuous) {
            numCounts = this.numBins;
        } else {
            numCounts = this.getLevels(desiredColName).size();
            if (this.metaData.getColumnMissingCount(desiredColName) > 0.0) {
                ++numCounts;
            }
        }
        double[] counts = new double[numCounts];
        String[] path = null;
        String[] byCols = null;
        String[] levels = null;
        if (conditions == null) {
            path = new String[5];
        } else {
            byCols = (String[])conditions.get("bycols");
            levels = (String[])conditions.get("levels");
            path = new String[5 + byCols.length * 2];
        }
        path[0] = desiredColName;
        int counter = 0;
        if (conditions != null) {
            for (int a = 0; a < byCols.length; ++a) {
                path[++counter] = byCols[a];
                path[++counter] = levels[a];
            }
        }
        path[++counter] = ChartEngineNode.STATS_ATTRIBUTE_TAG;
        path[++counter] = ChartEngineNode.BINS_ATTRIBUTE_TAG;
        int countLoc = counter + 2;
        path[countLoc] = ChartEngineNode.COUNT_ATTRIBUTE_TAG;
        int colNum = this.metaData.nameToOrdinal(desiredColName);
        ++counter;
        for (int i = 0; i < numCounts; ++i) {
            path[counter] = isContinuous ? Integer.toString(i) : (i < this.conversion[colNum].length ? Integer.toString(this.conversion[colNum][i]) : "NaN");
            counts[i] = this.chartStats.getDouble(path, this.defaultDouble);
        }
        path = null;
        byCols = null;
        levels = null;
        return counts;
    }

    public Double[][] getCountsForCharting(String desiredColName, Hashtable conditions) {
        int numCounts = 0;
        boolean isContinuous = this.isContinuous(desiredColName) || this.isDate(desiredColName);
        numCounts = isContinuous ? this.numBins : this.getLevels(desiredColName).size() + 1;
        Double[][] counts = new Double[numCounts][1];
        String[] path = null;
        String[] byCols = null;
        String[] levels = null;
        if (conditions == null) {
            path = new String[5];
        } else {
            byCols = (String[])conditions.get("bycols");
            levels = (String[])conditions.get("levels");
            path = new String[5 + byCols.length * 2];
        }
        path[0] = desiredColName;
        int counter = 0;
        if (conditions != null) {
            for (int a = 0; a < byCols.length; ++a) {
                path[++counter] = byCols[a];
                path[++counter] = levels[a];
            }
        }
        path[++counter] = ChartEngineNode.STATS_ATTRIBUTE_TAG;
        path[++counter] = ChartEngineNode.BINS_ATTRIBUTE_TAG;
        int countLoc = counter + 2;
        path[countLoc] = ChartEngineNode.COUNT_ATTRIBUTE_TAG;
        int colNum = this.metaData.nameToOrdinal(desiredColName);
        ++counter;
        for (int i = 0; i < numCounts; ++i) {
            if (isContinuous) {
                path[counter] = Integer.toString(i);
            } else {
                if (i == numCounts - 1) break;
                path[counter] = i < this.conversion[colNum].length ? Integer.toString(this.conversion[colNum][i]) : "NaN";
            }
            counts[i][0] = new Double(this.chartStats.getDouble(path, this.defaultDouble));
        }
        path = null;
        byCols = null;
        levels = null;
        if (!isContinuous) {
            counts[numCounts - 1][0] = new Double(this.metaData.getColumnMissingCount(desiredColName));
        }
        return counts;
    }

    public Double[] getRangeForCharting(String desiredColName, Hashtable conditions) {
        int numCounts = 0;
        boolean isContinuous = this.isContinuous(desiredColName) || this.isDate(desiredColName);
        numCounts = isContinuous ? this.numBins : this.getLevels(desiredColName).size() + 1;
        String[] path = null;
        String[] byCols = null;
        String[] levels = null;
        Double[] range = new Double[2];
        if (!this.useRelative && conditions != null) {
            range[0] = new Double(0.0);
            range[1] = new Double(this.metaData.getNumRows());
            return range;
        }
        if (conditions == null) {
            byCols = new String[]{};
            levels = new String[]{};
        } else {
            byCols = (String[])conditions.get("bycols");
            levels = (String[])conditions.get("levels");
        }
        path = new String[5 + byCols.length * 2];
        path[0] = desiredColName;
        int counter = 0;
        for (int a = 0; a < byCols.length; ++a) {
            path[++counter] = byCols[a];
            path[++counter] = levels[a];
        }
        path[++counter] = ChartEngineNode.STATS_ATTRIBUTE_TAG;
        path[++counter] = ChartEngineNode.BINS_ATTRIBUTE_TAG;
        int countLoc = counter + 2;
        path[countLoc] = ChartEngineNode.COUNT_ATTRIBUTE_TAG;
        int colNum = this.metaData.nameToOrdinal(desiredColName);
        ++counter;
        double min = Double.NaN;
        double max = Double.NaN;
        for (int i = 0; i < numCounts; ++i) {
            if (isContinuous) {
                path[counter] = Integer.toString(i);
            } else {
                if (i == numCounts - 1) break;
                path[counter] = i < this.conversion[colNum].length ? Integer.toString(this.conversion[colNum][i]) : "NaN";
            }
            double testVal = this.chartStats.getDouble(path, this.defaultDouble);
            if (Double.isNaN(min) || min > testVal) {
                min = testVal;
            }
            if (!Double.isNaN(max) && !(max < testVal)) continue;
            max = testVal;
        }
        path = null;
        byCols = null;
        levels = null;
        range[0] = new Double(min * 0.95);
        range[1] = new Double(max * 1.05);
        return range;
    }

    public Double[][] getCountPercentsForCharting(String desiredColName, Hashtable conditions) {
        int i;
        Double[][] countArray = this.getCountsForCharting(desiredColName, conditions);
        Double[][] returnArray = new Double[countArray.length][1];
        double totalCount = this.metaData.getColumnRowCount(desiredColName);
        if (this.useRelative) {
            for (i = 0; i < countArray.length; ++i) {
                if (i == 0) {
                    totalCount = countArray[i][0];
                    continue;
                }
                totalCount += countArray[i][0].doubleValue();
            }
        }
        for (i = 0; i < countArray.length; ++i) {
            returnArray[i][0] = new Double(countArray[i][0] / totalCount * 100.0);
        }
        return returnArray;
    }

    public Double[][][] getQuantileData(String desiredColName, Hashtable conditions) {
        Double[][][] data = new Double[1][1][5];
        String[] qpath = null;
        String[] path = null;
        String[] byCols = null;
        String[] levels = null;
        int pathArraySize = 3;
        int qpathArraySize = 4;
        if (conditions != null) {
            byCols = (String[])conditions.get("bycols");
            levels = (String[])conditions.get("levels");
            pathArraySize += byCols.length * 2;
            qpathArraySize += byCols.length * 2;
        }
        path = new String[pathArraySize];
        qpath = new String[qpathArraySize];
        path[0] = desiredColName;
        int counter = 0;
        if (conditions != null) {
            for (int a = 0; a < byCols.length; ++a) {
                path[++counter] = byCols[a];
                path[++counter] = levels[a];
            }
        }
        path[++counter] = ChartEngineNode.STATS_ATTRIBUTE_TAG;
        for (int q = 0; q < path.length; ++q) {
            qpath[q] = path[q];
        }
        int statType = counter + 1;
        int quantNum = counter + 2;
        path[statType] = ChartEngineNode.MINIMUM_ATTRIBUTE_TAG;
        data[0][0][0] = new Double(this.chartStats.getDouble(path, Double.NaN));
        path[statType] = ChartEngineNode.MAXIMUM_ATTRIBUTE_TAG;
        data[0][0][4] = new Double(this.chartStats.getDouble(path, Double.NaN));
        qpath[statType] = ChartEngineNode.QUANTILES_ATTRIBUTE_TAG;
        qpath[quantNum] = "0";
        data[0][0][1] = new Double(this.chartStats.getDouble(qpath, Double.NaN));
        qpath[quantNum] = "1";
        data[0][0][2] = new Double(this.chartStats.getDouble(qpath, Double.NaN));
        qpath[quantNum] = "2";
        data[0][0][3] = new Double(this.chartStats.getDouble(qpath, Double.NaN));
        path = null;
        qpath = null;
        byCols = null;
        levels = null;
        return data;
    }

    public long getCountsForContinuousChart(String desiredColName, Hashtable conditions) {
        double[] counts = this.getCounts(desiredColName, conditions);
        long countTotal = 0L;
        for (int i = 0; i < counts.length; ++i) {
            countTotal = (long)((double)countTotal + counts[i]);
        }
        counts = null;
        return countTotal;
    }

    public double getMissingDataForChart(String desiredColName, Hashtable conditions) {
        String[] path = null;
        String[] byCols = null;
        String[] levels = null;
        if (conditions == null) {
            path = new String[5];
        } else {
            byCols = (String[])conditions.get("bycols");
            levels = (String[])conditions.get("levels");
            path = new String[5 + byCols.length * 2];
        }
        path[0] = desiredColName;
        int counter = 0;
        if (conditions != null) {
            for (int a = 0; a < byCols.length; ++a) {
                path[++counter] = byCols[a];
                path[++counter] = levels[a];
            }
        }
        path[++counter] = ChartEngineNode.STATS_ATTRIBUTE_TAG;
        path[++counter] = ChartEngineNode.BINS_ATTRIBUTE_TAG;
        path[++counter] = ChartEngineNode.NAN_ATTRIBUTE_TAG;
        path[++counter] = ChartEngineNode.COUNT_ATTRIBUTE_TAG;
        double missingVals = this.chartStats.getDouble(path, this.defaultDouble);
        path = null;
        byCols = null;
        levels = null;
        return missingVals;
    }

    public void setMaxChartCounts() {
        Hashtable[] conditionsTable = null;
        if (!this.noConditionBys) {
            conditionsTable = this.getConditions(this.groupedByCols);
        }
        Vector cols = this.getRequestedDisplayCols();
        this.maxChartCounts = new double[cols.size()];
        this.minChartCounts = new double[cols.size()];
        double[] countArray = null;
        for (int i = 0; i < cols.size(); ++i) {
            double maxVal = Double.NaN;
            double minVal = Double.NaN;
            String col = (String)cols.elementAt(i);
            if (this.noConditionBys) {
                countArray = this.getCounts(col, null);
                maxVal = this.getMaxVal(maxVal, countArray);
                minVal = this.getMinVal(minVal, countArray);
            } else {
                for (int a = 0; a < conditionsTable.length; ++a) {
                    countArray = this.getCounts(col, conditionsTable[a]);
                    maxVal = this.getMaxVal(maxVal, countArray);
                    minVal = this.getMinVal(minVal, countArray);
                }
            }
            maxVal += maxVal * 0.05;
            minVal -= minVal * 0.05;
            this.maxChartCounts[i] = maxVal;
            this.minChartCounts[i] = minVal;
        }
        countArray = null;
        conditionsTable = null;
        cols = null;
    }

    private double getMaxVal(double maxVal, double[] array) {
        for (int k = 0; k < array.length; ++k) {
            if (!Double.isNaN(maxVal) && !(maxVal < array[k])) continue;
            maxVal = array[k];
        }
        return maxVal;
    }

    private double getMinVal(double minVal, double[] array) {
        for (int k = 0; k < array.length; ++k) {
            if (!Double.isNaN(minVal) && !(minVal > array[k])) continue;
            minVal = array[k];
        }
        return minVal;
    }

    public Number getMaxChartVal(int col) {
        return this.maxChartVals[col];
    }

    public double getMaxChartCount(int col) {
        return this.maxChartCounts[col];
    }

    public int getNumBins() {
        return this.numBins;
    }

    public double getBinSize(String desiredColName) {
        return this.metaData.getColumnMax(desiredColName) / (double)this.numBins;
    }

    public double getMaxValue(String desiredColName) {
        return this.metaData.getColumnMax(desiredColName);
    }

    public double getMinValue(String desiredColName) {
        return this.metaData.getColumnMin(desiredColName);
    }

    public double getMeanForChart(String desiredColName, Hashtable conditions) {
        double mean = conditions == null ? this.metaData.getColumnMean(desiredColName) : this.getStatsForChart(desiredColName, conditions, ByColumnStatisticAccumulator.MEAN_ATTRIBUTE_TAG);
        return this.roundToThousandths(mean);
    }

    public double getMaxForChart(String desiredColName, Hashtable conditions) {
        double max = conditions == null ? this.metaData.getColumnMax(desiredColName) : this.getStatsForChart(desiredColName, conditions, ByColumnStatisticAccumulator.MAXIMUM_ATTRIBUTE_TAG);
        return this.roundToThousandths(max);
    }

    public double getMinForChart(String desiredColName, Hashtable conditions) {
        double min = conditions == null ? this.metaData.getColumnMin(desiredColName) : this.getStatsForChart(desiredColName, conditions, ByColumnStatisticAccumulator.MINIMUM_ATTRIBUTE_TAG);
        return this.roundToThousandths(min);
    }

    public double getStDevForChart(String desiredColName, Hashtable conditions) {
        double stdev = conditions == null ? this.metaData.getColumnStandardDeviation(desiredColName) : this.getStatsForChart(desiredColName, conditions, ByColumnStatisticAccumulator.STANDARD_DEVIATION_ATTRIBUTE_TAG);
        return this.roundToThousandths(stdev);
    }

    private double getStatsForChart(String desiredColName, Hashtable conditions, String stat) {
        String[] byCols = (String[])conditions.get("bycols");
        String[] levels = (String[])conditions.get("levels");
        String[] path = new String[3 + byCols.length * 2];
        path[0] = desiredColName;
        int counter = 0;
        for (int a = 0; a < byCols.length; ++a) {
            path[++counter] = byCols[a];
            path[++counter] = levels[a];
        }
        path[++counter] = ChartEngineNode.STATS_ATTRIBUTE_TAG;
        path[++counter] = stat;
        double d = this.chartStats.getDouble(path, Double.NaN);
        path = null;
        byCols = null;
        levels = null;
        return d;
    }

    public void displayCharts() {
        this.displayCharts(null, true);
    }

    public void displayCharts(String frameTitle) {
        this.displayCharts(frameTitle, true);
    }

    public void displayCharts(String frameTitle, boolean makeWaitCursor) throws OutOfMemoryError {
        int numCharts;
        Cursor oldCursor;
        Component comp = MinerApp.getMainFrame() == null ? null : MinerApp.getMainFrame().getGlassPane();
        Cursor cursor = oldCursor = comp == null ? null : comp.getCursor();
        if (makeWaitCursor && comp != null) {
            comp.setCursor(Cursor.getPredefinedCursor(3));
            comp.setVisible(true);
        }
        if ((numCharts = this.requestedDisplayCols.size()) == 0) {
            JOptionPane.showMessageDialog(null, MinerApp.getText("ChartBuilder_msg_noChartsSelected"), MinerApp.getText("ChartBuilder_msg_dialogError"), 0);
            return;
        }
        if (this.groupedByCols.size() > 0) {
            numCharts *= this.getConditions(this.groupedByCols).length;
        }
        try {
            this.frame = new MinerChartGUI(this, this.groupedByCols, this.requestedDisplayCols, this.categoricalChartType, this.continuousChartType, this.showCountPercents);
            this.frame.setLocation(MinerApp.getNextWindowLocation());
            if (frameTitle != null) {
                this.frame.setTitle(frameTitle);
            }
            this.frame.show();
            this.selectChart(this.frame.firstSelectedChart, false);
            this.frame.firstSelectedChart.requestFocus();
            this.frameIsDisplayed = true;
        }
        catch (OutOfMemoryError e) {
            String msg = MinerApp.getText("ChartBuilder_msg_notEnoughMemory") + " " + numCharts + " " + MinerApp.getText("ChartBuilder_msg_charts");
            JOptionPane.showMessageDialog(null, msg, MinerApp.getText("ChartBuilder_msg_memoryLimitation"), 0);
            if (this.frame != null) {
                this.frame.clearMemory();
                this.frame.dispose();
            }
            this.displayedCharts.removeAllElements();
            throw e;
        }
        if (makeWaitCursor && comp != null) {
            comp.setCursor(oldCursor);
            comp.setVisible(false);
        }
    }

    public void selectRowOrColumn(ColumnHeaderPanel labelPanel, boolean allowMultiple) {
        int i;
        if (!allowMultiple) {
            this.deselectRowOrColPanels();
        }
        this.selectedRowOrColPanels.add(labelPanel);
        if (!allowMultiple) {
            this.deselectCharts();
        }
        for (i = 0; i < this.displayedCharts.size(); ++i) {
            DataPanel icPanel = (DataPanel)this.displayedCharts.elementAt(i);
            if (labelPanel.isColumn()) {
                if (!icPanel.getDisplayColName().equals((String)labelPanel.getColOrRow())) continue;
                this.selectChart(icPanel, true);
                continue;
            }
            if (!icPanel.matchConditions((Hashtable)labelPanel.getColOrRow(), labelPanel.getColumnIndex())) continue;
            this.selectChart(icPanel, true);
        }
        this.frame.disableViewChartProps();
        if (this.displayedCharts.size() > 1) {
            for (i = 0; i < this.displayedCharts.size(); ++i) {
                ((DataPanel)this.displayedCharts.elementAt(i)).disableChartProperties();
            }
        }
    }

    public boolean areMultipleChartsSelected() {
        return this.selectedCharts != null && this.selectedCharts.size() > 1;
    }

    public void selectChart(DataPanel chartPanel, boolean allowMultiple) {
        if (!allowMultiple) {
            this.deselectRowOrColPanels();
        }
        for (int i = 0; i < this.selectedCharts.size(); ++i) {
            DataPanel panel = (DataPanel)this.selectedCharts.elementAt(i);
            if (!panel.equals(chartPanel)) continue;
            if (allowMultiple) {
                chartPanel.clearSelectedBorders();
                this.selectedCharts.remove(i);
            } else {
                this.deselectCharts();
                this.selectedCharts.add(chartPanel);
                chartPanel.paintSelectedBorders();
                this.frame.enableViewChartProps();
            }
            this.frame.setEnableCopyMenu(this.selectedCharts.size() == 1);
            return;
        }
        if (this.selectedCharts.size() != 1) {
            chartPanel.drillDownMenuItem.setEnabled(true);
        }
        DataPanel dp = null;
        if (allowMultiple) {
            this.selectedCharts.add(chartPanel);
            chartPanel.paintSelectedBorders();
            chartPanel.disableChartProperties();
            this.frame.disableViewChartProps();
            this.frame.disableSaveMenu();
            this.frame.disablePrintMenu();
            this.frame.viewChartsMenuItem.setText(ChartBuilder.getText("clusterFrame_viewcharts"));
            for (int a = 0; a < this.selectedCharts.size(); ++a) {
                dp = (DataPanel)this.selectedCharts.elementAt(a);
                dp.printMenuItem.setEnabled(false);
                dp.saveMenuItem.setEnabled(false);
                dp.copyMenuItem.setEnabled(false);
                dp.drillDownMenuItem.setText(ChartBuilder.getText("clusterFrame_viewcharts"));
            }
        } else {
            this.deselectCharts();
            this.selectedCharts.add(chartPanel);
            chartPanel.paintSelectedBorders();
            chartPanel.enableChartProperties();
            this.frame.enableViewChartProps();
            this.frame.enableSaveMenu();
            this.frame.enablePrintMenu();
            this.frame.viewChartsMenuItem.setText(ChartBuilder.getText("clusterFrame_viewchart"));
            for (int a = 0; a < this.selectedCharts.size(); ++a) {
                dp = (DataPanel)this.selectedCharts.elementAt(a);
                dp.printMenuItem.setEnabled(true);
                dp.saveMenuItem.setEnabled(true);
                dp.copyMenuItem.setEnabled(true);
                dp.drillDownMenuItem.setText(ChartBuilder.getText("clusterFrame_viewchart"));
            }
        }
        this.frame.setEnableCopyMenu(this.selectedCharts.size() == 1);
        if (!chartPanel.hasFocus()) {
            chartPanel.requestFocus();
        }
    }

    public void deselectCharts() {
        this.frame.enableSaveMenu();
        this.frame.enablePrintMenu();
        this.frame.viewChartsMenuItem.setText(ChartBuilder.getText("clusterFrame_viewchart"));
        for (int i = 0; i < this.selectedCharts.size(); ++i) {
            DataPanel dp = (DataPanel)this.selectedCharts.elementAt(i);
            dp.clearSelectedBorders();
            dp.printMenuItem.setEnabled(true);
            dp.saveMenuItem.setEnabled(true);
            dp.copyMenuItem.setEnabled(true);
            dp.drillDownMenuItem.setText(ChartBuilder.getText("clusterFrame_viewchart"));
            dp.enableChartProperties();
        }
        this.selectedCharts.removeAllElements();
    }

    public void removeSelectedBorders() {
        for (int i = 0; i < this.selectedCharts.size(); ++i) {
            DataPanel dp = (DataPanel)this.selectedCharts.elementAt(i);
            dp.clearSelectedBorders();
        }
    }

    public void paintSelectedBorders() {
        for (int i = 0; i < this.selectedCharts.size(); ++i) {
            DataPanel dp = (DataPanel)this.selectedCharts.elementAt(i);
            dp.paintSelectedBorders();
        }
    }

    public void deselectRowOrColPanels() {
        for (int a = 0; a < this.selectedRowOrColPanels.size(); ++a) {
            ColumnHeaderPanel panel = (ColumnHeaderPanel)this.selectedRowOrColPanels.elementAt(a);
            panel.setBorder(BorderFactory.createLineBorder(ColorBroker.getColor("chartLabelBorderColor"), panel.getBorderWidth()));
            panel.repaint();
        }
        this.selectedRowOrColPanels.removeAllElements();
    }

    public DataPanel getSingleSelectedChart() {
        if (this.selectedCharts.size() == 1) {
            return (DataPanel)this.selectedCharts.elementAt(0);
        }
        return null;
    }

    public void showDrillDownCharts() {
        if (this.dontShowCharts) {
            return;
        }
        int drillDownFrameWidth = 500;
        int drillDownFrameHeight = 500;
        int size = this.selectedCharts.size();
        if (size > 10) {
            size = 10;
        }
        if (size > 6) {
            drillDownFrameHeight = 600;
        }
        ModifiableViewerFrame drillDownFrame = new ModifiableViewerFrame();
        drillDownFrame.setTitle(ChartBuilder.getText("clusterFrame_drilldown_title"));
        drillDownFrame.setIconImage(MinerApp.getResourceManager().getImage("minerapp.gif"));
        JPanel chartPanel = new JPanel();
        chartPanel.setBackground(ColorBroker.getColor("chartBackgroundColor"));
        chartPanel.setRequestFocusEnabled(true);
        chartPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(5, 10, 5, 10);
        c.fill = 1;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        int row = 0;
        int col = 1;
        for (int i = 0; i < size; ++i) {
            int height;
            boolean enableDrillDown = size != 1;
            DataPanel singlePanel = ((DataPanel)this.selectedCharts.elementAt(i)).copy(enableDrillDown);
            if (this.getLevels(singlePanel.getDisplayColName()).size() > 40) {
                singlePanel.showLegend(false);
            }
            if (!this.showstats) {
                singlePanel.hideStatsPanel();
            }
            int n = height = this.showstats ? 160 : 100;
            if (this.selectedCharts.size() / 2 * height > drillDownFrameHeight) {
                singlePanel.hideStatsPanel();
            }
            col = col == 1 ? 0 : 1;
            row = i / 2;
            c.gridx = col;
            c.gridy = row;
            chartPanel.add((Component)singlePanel, c);
        }
        drillDownFrame.getContentPane().add(chartPanel);
        drillDownFrame.setSize(drillDownFrameWidth, drillDownFrameHeight);
        chartPanel.registerKeyboardAction(new EscapeListener(drillDownFrame), KeyStroke.getKeyStroke("ESCAPE"), 2);
        drillDownFrame.setLocation(MinerApp.getNextWindowLocation());
        drillDownFrame.show();
        this.chartsAreDisplayed = true;
    }

    public DataPanel getSelectedChart() {
        if (this.selectedCharts != null && this.selectedCharts.size() > 0) {
            DataPanel dp = (DataPanel)this.selectedCharts.elementAt(0);
            return dp;
        }
        return null;
    }

    public void printSelectedChart() {
        for (int i = 0; i < this.selectedCharts.size(); ++i) {
            DataPanel dp = (DataPanel)this.selectedCharts.elementAt(i);
            dp.print();
        }
    }

    public void saveSelectedChart() {
        this.performSelectedChartAction("SAVE");
    }

    public void showChartProperties() {
        this.performSelectedChartAction("PROPERTIES");
    }

    private void performSelectedChartAction(String cmd) {
        if (this.selectedCharts.size() == 1) {
            DataPanel dp = (DataPanel)this.selectedCharts.elementAt(0);
            ActionEvent e = new ActionEvent(dp, 1001, cmd);
            dp.actionPerformed(e);
        }
    }

    public ColumnHeaderPanel createColumnHeaderPanel() {
        return new ColumnHeaderPanel(this);
    }

    public boolean isFrameDisplayed() {
        return this.frameIsDisplayed;
    }

    public static String getText(String key) {
        if (chartBundles == null) {
            chartBundles = MinerApp.getBundle("chartBundles");
        }
        String string = MinerApp.getBundleString(chartBundles, key);
        return string;
    }

    private double roundToThousandths(double d) {
        if (Double.isNaN(d)) {
            return d;
        }
        d *= 1000.0;
        long e = (long)Math.floor(d += 0.5);
        double x = (double)e / 1000.0;
        return x;
    }

    private class EscapeListener
    implements ActionListener {
        private JFrame m_frame;

        public EscapeListener(JFrame frame) {
            this.m_frame = frame;
        }

        public void actionPerformed(ActionEvent e) {
            this.m_frame.dispose();
        }
    }
}

