/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.XTMetaData;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ColumnDefinitions {
    protected Document document = null;
    protected Element dataDictionaryNode = null;
    protected Element lastDictionaryEntry = null;
    protected String lastDictionaryName = "";
    protected int lastDictionarySearch = -1;
    public static String DATA_DICTIONARY_NODE_TAG = "ColumnDefinitions";
    public static String DATA_FIELD_NODE_TAG = "ColumnInfo";
    public static String FIELD_COUNT_ATTRIBUTE_TAG = "fieldCount";
    public static String LEVEL_NODE_TAG = "Level";
    public static String NAME_ATTRIBUTE_TAG = "name";
    public static String TYPE_ATTRIBUTE_TAG = "type";
    public static String CONTINUOUS_TYPE_ATTRIBUTE_TAG = "continuous";
    public static String NUMERIC_TYPE_ATTRIBUTE_TAG = "numeric";
    public static String CATEGORICAL_TYPE_ATTRIBUTE_TAG = "categorical";
    public static String FACTOR_TYPE_ATTRIBUTE_TAG = "factor";
    public static String STRING_TYPE_ATTRIBUTE_TAG = "string";
    public static String DATE_TIME_TYPE_ATTRIBUTE_TAG = "date";
    public static String BLOB_TYPE_ATTRIBUTE_TAG = "blob";
    public static String BLOB_CLASS_NAME_ATTRIBUTE_TAG = "blobClassName";
    public static String WIDTH_ATTRIBUTE_TAG = "width";
    public static String ROLE_ATTRIBUTE_TAG = "role";
    public static String DEPENDENT_ROLE_ATTRIBUTE_TAG = "dependent";
    public static String INDEPENDENT_ROLE_ATTRIBUTE_TAG = "independent";
    public static String INFORMATION_ROLE_ATTRIBUTE_TAG = "information";
    public static String PREDICTION_ROLE_ATTRIBUTE_TAG = "prediction";
    public static String VALUE_ATTRIBUTE_TAG = "value";

    public ColumnDefinitions(Document doc) throws Exception {
        try {
            this.document = doc;
            this.dataDictionaryNode = this.document.createElement(DATA_DICTIONARY_NODE_TAG);
            this.dataDictionaryNode.setAttribute(FIELD_COUNT_ATTRIBUTE_TAG, "0");
        }
        catch (Exception e) {
            throw new Exception("Couldn't create MetaData object.");
        }
    }

    public ColumnDefinitions(Element xml) throws Exception {
        try {
            this.document = xml.getOwnerDocument();
            this.dataDictionaryNode = xml;
            if (!xml.getNodeName().equals(DATA_DICTIONARY_NODE_TAG)) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            throw new Exception("Couldn't create MetaData object.");
        }
    }

    public Element getElement() {
        return this.dataDictionaryNode;
    }

    public int getStringDataFieldWidth(String name) {
        if (this.findColumnDictionary(name)) {
            return this.getLastFoundStringColumnWidth();
        }
        return 0;
    }

    public int getStringDataFieldWidth(int num) {
        if (this.findColumnDictionary(num)) {
            return this.getLastFoundStringColumnWidth();
        }
        return 0;
    }

    public String getBlobDataFieldClassName(String name) {
        if (this.findColumnDictionary(name)) {
            return this.getLastFoundBlobColumnClassName();
        }
        return null;
    }

    public String getBlobDataFieldClassName(int num) {
        if (this.findColumnDictionary(num)) {
            return this.getLastFoundBlobColumnClassName();
        }
        return null;
    }

    public boolean isContinuousColumn(String name) {
        if (this.findColumnDictionary(name)) {
            return this.getLastFoundColumnType().equals(XTMetaData.CONTINUOUS_TYPE_ATTRIBUTE_TAG);
        }
        return false;
    }

    public boolean isContinuousColumn(int num) {
        if (this.findColumnDictionary(num)) {
            return this.getLastFoundColumnType().equals(XTMetaData.CONTINUOUS_TYPE_ATTRIBUTE_TAG);
        }
        return false;
    }

    public boolean isCategoricalColumn(String name) {
        if (this.findColumnDictionary(name)) {
            return this.getLastFoundColumnType().equals(XTMetaData.CATEGORICAL_TYPE_ATTRIBUTE_TAG);
        }
        return false;
    }

    public boolean isCategoricalColumn(int num) {
        if (this.findColumnDictionary(num)) {
            return this.getLastFoundColumnType().equals(XTMetaData.CATEGORICAL_TYPE_ATTRIBUTE_TAG);
        }
        return false;
    }

    public boolean isStringColumn(String name) {
        if (this.findColumnDictionary(name)) {
            return this.getLastFoundColumnType().equals(XTMetaData.STRING_TYPE_ATTRIBUTE_TAG);
        }
        return false;
    }

    public boolean isStringColumn(int num) {
        if (this.findColumnDictionary(num)) {
            return this.getLastFoundColumnType().equals(XTMetaData.STRING_TYPE_ATTRIBUTE_TAG);
        }
        return false;
    }

    public boolean isDateTimeColumn(String name) {
        if (this.findColumnDictionary(name)) {
            return this.getLastFoundColumnType().equals(XTMetaData.DATE_TIME_TYPE_ATTRIBUTE_TAG);
        }
        return false;
    }

    public boolean isDateTimeColumn(int num) {
        if (this.findColumnDictionary(num)) {
            return this.getLastFoundColumnType().equals(XTMetaData.DATE_TIME_TYPE_ATTRIBUTE_TAG);
        }
        return false;
    }

    public boolean isBlobColumn(String name) {
        if (this.findColumnDictionary(name)) {
            return this.getLastFoundColumnType().equals(BLOB_TYPE_ATTRIBUTE_TAG);
        }
        return false;
    }

    public boolean isBlobColumn(int num) {
        if (this.findColumnDictionary(num)) {
            return this.getLastFoundColumnType().equals(BLOB_TYPE_ATTRIBUTE_TAG);
        }
        return false;
    }

    public String getColumnType(String name) {
        if (this.findColumnDictionary(name)) {
            return this.getLastFoundColumnType();
        }
        return "";
    }

    public String getColumnType(int num) {
        if (this.findColumnDictionary(num)) {
            return this.getLastFoundColumnType();
        }
        return "";
    }

    public String getColumnRole(String name) {
        if (this.findColumnDictionary(name)) {
            return this.getLastFoundColumnRole();
        }
        return "";
    }

    public String getColumnRole(int num) {
        if (this.findColumnDictionary(num)) {
            return this.getLastFoundColumnRole();
        }
        return "";
    }

    public Vector getColumnRoles() {
        Vector<String> ret = new Vector<String>();
        for (Element dataField = (Element)this.dataDictionaryNode.getFirstChild(); dataField != null; dataField = (Element)dataField.getNextSibling()) {
            if (!dataField.getNodeName().equals(DATA_FIELD_NODE_TAG)) continue;
            ret.addElement(dataField.getAttribute(ROLE_ATTRIBUTE_TAG));
        }
        return ret;
    }

    public int getNumColumns() {
        try {
            return Integer.parseInt(this.dataDictionaryNode.getAttribute(FIELD_COUNT_ATTRIBUTE_TAG));
        }
        catch (Exception e) {
            return 0;
        }
    }

    public String getCategoricalDataFieldLevel(int column, int level) {
        if (this.findColumnDictionary(column) && this.lastDictionaryEntry.getAttribute(TYPE_ATTRIBUTE_TAG).equals(CATEGORICAL_TYPE_ATTRIBUTE_TAG)) {
            int i = 0;
            for (Element child = (Element)this.lastDictionaryEntry.getFirstChild(); child != null; child = (Element)child.getNextSibling()) {
                if (i == level) {
                    return child.getAttribute(VALUE_ATTRIBUTE_TAG);
                }
                ++i;
            }
        }
        return null;
    }

    public Vector getCategoricalDataFieldLevels(String name) {
        if (this.findColumnDictionary(name) && this.lastDictionaryEntry.getAttribute(TYPE_ATTRIBUTE_TAG).equals(CATEGORICAL_TYPE_ATTRIBUTE_TAG)) {
            Vector<String> ret = new Vector<String>();
            for (Element child = (Element)this.lastDictionaryEntry.getFirstChild(); child != null; child = (Element)child.getNextSibling()) {
                ret.addElement(child.getAttribute(VALUE_ATTRIBUTE_TAG));
            }
            return ret;
        }
        return new Vector();
    }

    public Vector getSortedCategoricalDataFieldLevels(String name) {
        if (this.findColumnDictionary(name) && this.lastDictionaryEntry.getAttribute(TYPE_ATTRIBUTE_TAG).equals(CATEGORICAL_TYPE_ATTRIBUTE_TAG)) {
            Vector<String> ret = new Vector<String>();
            for (Element child = (Element)this.lastDictionaryEntry.getFirstChild(); child != null; child = (Element)child.getNextSibling()) {
                ret.addElement(child.getAttribute(VALUE_ATTRIBUTE_TAG));
            }
            List list = ret.subList(0, ret.size());
            Collections.sort(list);
            ret = new Vector(list);
            return ret;
        }
        return new Vector();
    }

    public Vector getColumnNames() {
        Vector<String> ret = new Vector<String>();
        for (Element dataField = (Element)this.dataDictionaryNode.getFirstChild(); dataField != null; dataField = (Element)dataField.getNextSibling()) {
            if (!dataField.getNodeName().equals(DATA_FIELD_NODE_TAG)) continue;
            ret.addElement(dataField.getAttribute(NAME_ATTRIBUTE_TAG));
        }
        return ret;
    }

    public Vector getColumnTypes() {
        Vector<String> ret = new Vector<String>();
        for (Element dataField = (Element)this.dataDictionaryNode.getFirstChild(); dataField != null; dataField = (Element)dataField.getNextSibling()) {
            if (!dataField.getNodeName().equals(DATA_FIELD_NODE_TAG)) continue;
            ret.addElement(dataField.getAttribute(TYPE_ATTRIBUTE_TAG));
        }
        return ret;
    }

    public Vector getDataFieldsWithRole(String role) {
        Vector<String> ret = new Vector<String>();
        for (Element dataField = (Element)this.dataDictionaryNode.getFirstChild(); dataField != null; dataField = (Element)dataField.getNextSibling()) {
            if (!dataField.getNodeName().equals(DATA_FIELD_NODE_TAG)) continue;
            if (!dataField.hasAttribute(ROLE_ATTRIBUTE_TAG) && role.equals(INFORMATION_ROLE_ATTRIBUTE_TAG)) {
                ret.addElement(dataField.getAttribute(NAME_ATTRIBUTE_TAG));
                continue;
            }
            if (!role.equals(dataField.getAttribute(ROLE_ATTRIBUTE_TAG))) continue;
            ret.addElement(dataField.getAttribute(NAME_ATTRIBUTE_TAG));
        }
        return ret;
    }

    public Vector getDataFieldsWithType(String type) {
        Vector<String> ret = new Vector<String>();
        for (Element dataField = (Element)this.dataDictionaryNode.getFirstChild(); dataField != null; dataField = (Element)dataField.getNextSibling()) {
            if (!dataField.getNodeName().equals(DATA_FIELD_NODE_TAG) || !type.equals(dataField.getAttribute(TYPE_ATTRIBUTE_TAG))) continue;
            ret.addElement(dataField.getAttribute(NAME_ATTRIBUTE_TAG));
        }
        return ret;
    }

    public boolean modifyColumnName(String oldName, String newName) {
        try {
            if (this.findColumnDictionary(oldName)) {
                this.lastDictionaryEntry.setAttribute(NAME_ATTRIBUTE_TAG, newName);
                this.lastDictionaryName = newName;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean appendCategoricalDataField(String name, List levels) {
        try {
            if (this.findColumnDictionary(name)) {
                this.lastDictionaryEntry.setAttribute(TYPE_ATTRIBUTE_TAG, CATEGORICAL_TYPE_ATTRIBUTE_TAG);
                for (int i = 0; i < levels.size(); ++i) {
                    Element level = this.document.createElement(LEVEL_NODE_TAG);
                    level.setAttribute(VALUE_ATTRIBUTE_TAG, (String)levels.get(i));
                    this.lastDictionaryEntry.appendChild(level);
                }
                this.setNumColumns();
                return true;
            }
            Element dataField = this.document.createElement(DATA_FIELD_NODE_TAG);
            dataField.setAttribute(NAME_ATTRIBUTE_TAG, name);
            dataField.setAttribute(TYPE_ATTRIBUTE_TAG, CATEGORICAL_TYPE_ATTRIBUTE_TAG);
            for (int i = 0; i < levels.size(); ++i) {
                Element level = this.document.createElement(LEVEL_NODE_TAG);
                level.setAttribute(VALUE_ATTRIBUTE_TAG, (String)levels.get(i));
                dataField.appendChild(level);
            }
            this.dataDictionaryNode.appendChild(dataField);
            this.setNumColumns();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean appendCategoricalDataField(String name, String[] levels) {
        try {
            if (this.findColumnDictionary(name)) {
                this.lastDictionaryEntry.setAttribute(TYPE_ATTRIBUTE_TAG, CATEGORICAL_TYPE_ATTRIBUTE_TAG);
                for (int i = 0; i < levels.length; ++i) {
                    Element level = this.document.createElement(LEVEL_NODE_TAG);
                    level.setAttribute(VALUE_ATTRIBUTE_TAG, levels[i]);
                    this.lastDictionaryEntry.appendChild(level);
                }
                this.setNumColumns();
                return true;
            }
            Element dataField = this.document.createElement(DATA_FIELD_NODE_TAG);
            dataField.setAttribute(NAME_ATTRIBUTE_TAG, name);
            dataField.setAttribute(TYPE_ATTRIBUTE_TAG, CATEGORICAL_TYPE_ATTRIBUTE_TAG);
            for (int i = 0; i < levels.length; ++i) {
                Element level = this.document.createElement(LEVEL_NODE_TAG);
                level.setAttribute(VALUE_ATTRIBUTE_TAG, levels[i]);
                dataField.appendChild(level);
            }
            this.dataDictionaryNode.appendChild(dataField);
            this.setNumColumns();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean removeDataFieldLevels(String name) {
        try {
            if (this.findColumnDictionary(name) && this.lastDictionaryEntry.getAttribute(TYPE_ATTRIBUTE_TAG).equals(CATEGORICAL_TYPE_ATTRIBUTE_TAG)) {
                Vector<Element> removeList = new Vector<Element>();
                for (Element child = (Element)this.lastDictionaryEntry.getFirstChild(); child != null; child = (Element)child.getNextSibling()) {
                    removeList.add(child);
                }
                for (int i = 0; i < removeList.size(); ++i) {
                    this.lastDictionaryEntry.removeChild((Element)removeList.get(i));
                }
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean appendCategoricalLevel(String name, String level) {
        try {
            if (this.findColumnDictionary(name) && this.lastDictionaryEntry.getAttribute(TYPE_ATTRIBUTE_TAG).equals(CATEGORICAL_TYPE_ATTRIBUTE_TAG)) {
                Element element = this.document.createElement(LEVEL_NODE_TAG);
                element.setAttribute(VALUE_ATTRIBUTE_TAG, level);
                this.lastDictionaryEntry.appendChild(element);
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean setCategoricalLevels(String name, String[] levels) {
        try {
            if (this.findColumnDictionary(name) && this.lastDictionaryEntry.getAttribute(TYPE_ATTRIBUTE_TAG).equals(CATEGORICAL_TYPE_ATTRIBUTE_TAG)) {
                for (Element child = (Element)this.lastDictionaryEntry.getFirstChild(); child != null; child = (Element)child.getNextSibling()) {
                    Element del = child;
                    this.lastDictionaryEntry.removeChild(del);
                }
                for (int i = 0; i < levels.length; ++i) {
                    Element level = this.document.createElement(LEVEL_NODE_TAG);
                    level.setAttribute(VALUE_ATTRIBUTE_TAG, levels[i]);
                    this.lastDictionaryEntry.appendChild(level);
                }
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean appendContinousDataField(String name) {
        try {
            if (this.findColumnDictionary(name)) {
                this.lastDictionaryEntry.setAttribute(TYPE_ATTRIBUTE_TAG, CONTINUOUS_TYPE_ATTRIBUTE_TAG);
                for (Node node = this.lastDictionaryEntry.getFirstChild(); node != null; node = node.getNextSibling()) {
                    this.lastDictionaryEntry.removeChild(node);
                }
                this.setNumColumns();
                return true;
            }
            Element dataField = this.document.createElement(DATA_FIELD_NODE_TAG);
            dataField.setAttribute(NAME_ATTRIBUTE_TAG, name);
            dataField.setAttribute(TYPE_ATTRIBUTE_TAG, CONTINUOUS_TYPE_ATTRIBUTE_TAG);
            this.dataDictionaryNode.appendChild(dataField);
            this.setNumColumns();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean appendDateTimeDataField(String name) {
        try {
            if (this.findColumnDictionary(name)) {
                this.lastDictionaryEntry.setAttribute(TYPE_ATTRIBUTE_TAG, DATE_TIME_TYPE_ATTRIBUTE_TAG);
                for (Node node = this.lastDictionaryEntry.getFirstChild(); node != null; node = node.getNextSibling()) {
                    this.lastDictionaryEntry.removeChild(node);
                }
                this.setNumColumns();
                return true;
            }
            Element dataField = this.document.createElement(DATA_FIELD_NODE_TAG);
            dataField.setAttribute(NAME_ATTRIBUTE_TAG, name);
            dataField.setAttribute(TYPE_ATTRIBUTE_TAG, DATE_TIME_TYPE_ATTRIBUTE_TAG);
            this.dataDictionaryNode.appendChild(dataField);
            this.setNumColumns();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean appendStringDataField(String name, int width) {
        try {
            if (this.findColumnDictionary(name)) {
                this.lastDictionaryEntry.setAttribute(TYPE_ATTRIBUTE_TAG, STRING_TYPE_ATTRIBUTE_TAG);
                this.lastDictionaryEntry.setAttribute(WIDTH_ATTRIBUTE_TAG, Integer.toString(width));
                for (Node node = this.lastDictionaryEntry.getFirstChild(); node != null; node = node.getNextSibling()) {
                    this.lastDictionaryEntry.removeChild(node);
                }
                this.setNumColumns();
                return true;
            }
            Element dataField = this.document.createElement(DATA_FIELD_NODE_TAG);
            dataField.setAttribute(NAME_ATTRIBUTE_TAG, name);
            dataField.setAttribute(TYPE_ATTRIBUTE_TAG, STRING_TYPE_ATTRIBUTE_TAG);
            dataField.setAttribute(WIDTH_ATTRIBUTE_TAG, Integer.toString(width));
            this.dataDictionaryNode.appendChild(dataField);
            this.setNumColumns();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean appendBlobDataField(String name, String blobClassName) {
        try {
            if (this.findColumnDictionary(name)) {
                this.lastDictionaryEntry.setAttribute(TYPE_ATTRIBUTE_TAG, BLOB_TYPE_ATTRIBUTE_TAG);
                this.lastDictionaryEntry.setAttribute(BLOB_CLASS_NAME_ATTRIBUTE_TAG, blobClassName);
                for (Node node = this.lastDictionaryEntry.getFirstChild(); node != null; node = node.getNextSibling()) {
                    this.lastDictionaryEntry.removeChild(node);
                }
                this.setNumColumns();
                return true;
            }
            Element dataField = this.document.createElement(DATA_FIELD_NODE_TAG);
            dataField.setAttribute(NAME_ATTRIBUTE_TAG, name);
            dataField.setAttribute(TYPE_ATTRIBUTE_TAG, BLOB_TYPE_ATTRIBUTE_TAG);
            dataField.setAttribute(WIDTH_ATTRIBUTE_TAG, blobClassName);
            this.dataDictionaryNode.appendChild(dataField);
            this.setNumColumns();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean removeDataField(String name) {
        try {
            if (this.findColumnDictionary(name)) {
                this.dataDictionaryNode.removeChild(this.lastDictionaryEntry);
                this.lastDictionaryName = "";
                this.lastDictionarySearch = -1;
                this.setNumColumns();
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean setDataFieldRole(String name, String role) {
        try {
            if (this.findColumnDictionary(name)) {
                this.lastDictionaryEntry.setAttribute(ROLE_ATTRIBUTE_TAG, role);
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean setDataFieldRole(int num, String role) {
        try {
            if (this.findColumnDictionary(num)) {
                this.lastDictionaryEntry.setAttribute(ROLE_ATTRIBUTE_TAG, role);
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean setDataFieldRoleDependent(String name) {
        return this.setDataFieldRole(name, DEPENDENT_ROLE_ATTRIBUTE_TAG);
    }

    public boolean setDataFieldRoleIndependent(String name) {
        return this.setDataFieldRole(name, INDEPENDENT_ROLE_ATTRIBUTE_TAG);
    }

    public boolean setDataFieldRoleInformation(String name) {
        return this.setDataFieldRole(name, INFORMATION_ROLE_ATTRIBUTE_TAG);
    }

    public boolean setDataFieldRolePrediction(String name) {
        return this.setDataFieldRole(name, PREDICTION_ROLE_ATTRIBUTE_TAG);
    }

    public int nameToOrdinal(String columnName) {
        int i = 0;
        for (Element child = (Element)this.dataDictionaryNode.getFirstChild(); child != null; child = (Element)child.getNextSibling()) {
            if (child.getAttribute(NAME_ATTRIBUTE_TAG).equals(columnName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public String ordinalToName(int ordinal) {
        int i = 0;
        for (Element child = (Element)this.dataDictionaryNode.getFirstChild(); child != null; child = (Element)child.getNextSibling()) {
            if (i == ordinal) {
                return child.getAttribute(NAME_ATTRIBUTE_TAG);
            }
            ++i;
        }
        return "";
    }

    protected int getLastFoundStringColumnWidth() {
        try {
            return Integer.parseInt(this.lastDictionaryEntry.getAttribute(WIDTH_ATTRIBUTE_TAG));
        }
        catch (Exception e) {
            return 0;
        }
    }

    protected String getLastFoundBlobColumnClassName() {
        return this.lastDictionaryEntry.getAttribute(BLOB_CLASS_NAME_ATTRIBUTE_TAG);
    }

    protected String getLastFoundColumnType() {
        return this.lastDictionaryEntry.getAttribute(TYPE_ATTRIBUTE_TAG);
    }

    protected String getLastFoundColumnRole() {
        return this.lastDictionaryEntry.getAttribute(ROLE_ATTRIBUTE_TAG);
    }

    protected void setNumColumns() {
        int numberDataFields = this.dataDictionaryNode.getChildNodes().getLength();
        this.dataDictionaryNode.setAttribute(FIELD_COUNT_ATTRIBUTE_TAG, Integer.toString(numberDataFields));
    }

    protected boolean findColumnDictionary(int num) {
        if (num != this.lastDictionarySearch) {
            Element child = (Element)this.dataDictionaryNode.getFirstChild();
            for (int i = 0; i < num && child != null; child = (Element)child.getNextSibling(), ++i) {
            }
            if (child != null) {
                this.lastDictionaryName = this.ordinalToName(num);
                this.lastDictionaryEntry = child;
                this.lastDictionarySearch = num;
                return true;
            }
            return false;
        }
        return true;
    }

    protected boolean findColumnDictionary(String columnName) {
        boolean found = true;
        if (!columnName.equals(this.lastDictionaryName)) {
            found = false;
            for (Element child = (Element)this.dataDictionaryNode.getFirstChild(); child != null; child = (Element)child.getNextSibling()) {
                String str = child.getAttribute(NAME_ATTRIBUTE_TAG);
                if (str == null || !columnName.equals(str)) continue;
                this.lastDictionarySearch = this.nameToOrdinal(columnName);
                this.lastDictionaryEntry = child;
                this.lastDictionaryName = columnName;
                found = true;
                break;
            }
        }
        return found;
    }
}

