/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.cnkjava.CNKObj;
import com.insightful.cnkjava.CNKProcCov;
import com.insightful.miner.DataCacheRowBuf;
import com.insightful.miner.EngineNode;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.util.List;
import java.util.Vector;

public class CorrelationsEngineNode
extends EngineNode {
    public static String CORRELATION_COLUMNS_ATTRIBUTE_TAG = "correlationColumns";
    public static String TARGET_COLUMNS_ATTRIBUTE_TAG = "targetColumns";
    public static String CORRELATIONS_ATTRIBUTE_TAG = "correlation";
    public static String COVARIANCE_ATTRIBUTE_TAG = "covariance";

    public boolean hasCNKProc() {
        return false;
    }

    public boolean hasDataCacheProc() {
        return true;
    }

    private List getRegularColumns() {
        XTProps props = this.getNodeProperties();
        Vector v = props.getSubProperties(CORRELATION_COLUMNS_ATTRIBUTE_TAG);
        if (v.size() < 1) {
            XTMetaData md = this.getInputMetaData(0);
            v = md.getDataFieldsWithType(XTMetaData.CONTINUOUS_TYPE_ATTRIBUTE_TAG);
        }
        return v;
    }

    private List getTargetColumns() {
        XTProps props = this.getNodeProperties();
        List v = props.getSubProperties(TARGET_COLUMNS_ATTRIBUTE_TAG);
        if (v.size() < 1) {
            v = this.getRegularColumns();
        }
        return v;
    }

    public boolean executeDataCacheProc() throws Exception {
        double entry;
        int x;
        int y;
        int colNum;
        int i;
        CNKProcCov proc = new CNKProcCov();
        List correlationColumnNames = this.getRegularColumns();
        List targetColumnNames = this.getTargetColumns();
        int numCorrelationColumns = correlationColumnNames.size();
        int numTargetColumns = targetColumnNames.size();
        int[] correlationColumnNumbers = new int[numCorrelationColumns];
        int[] targetColumnNumbers = new int[numTargetColumns];
        XTMetaData inputMD = this.getInputMetaData(0);
        proc.clearCalcColumns();
        for (i = 0; i < numCorrelationColumns; ++i) {
            correlationColumnNumbers[i] = colNum = inputMD.nameToOrdinal((String)correlationColumnNames.get(i));
            if (colNum < 0) continue;
            proc.defineCorrelationColumn(colNum);
        }
        for (i = 0; i < numTargetColumns; ++i) {
            targetColumnNumbers[i] = colNum = inputMD.nameToOrdinal((String)targetColumnNames.get(i));
            if (colNum < 0) continue;
            proc.defineTargetColumn(colNum);
        }
        boolean ok = this.getNetworkManager().executeCNKProc(this.getNodeID(), proc);
        if (!ok) {
            this.procDelete(proc);
            return false;
        }
        this.printlnInformation(this.getNodeName() + ": values computed using " + proc.getTotalRowsProcessed() + " non-missing rows");
        XTProps data = new XTProps();
        String[] path = new String[]{COVARIANCE_ATTRIBUTE_TAG, "x", "y"};
        boolean outputCorrelation = this.getNodeProperties().getBoolean(CORRELATIONS_ATTRIBUTE_TAG, true);
        XTMetaData outputMD = (XTMetaData)this.getOutputMetaData(0).copy();
        FileOutputStream outputStream = new FileOutputStream(this.getOutputDataCacheFileName(0));
        BufferedOutputStream outputBuffer = new BufferedOutputStream(outputStream);
        DataOutputStream outputOutputStream = new DataOutputStream(outputBuffer);
        DataCacheRowBuf outputRowBuf = new DataCacheRowBuf(outputMD);
        path[0] = COVARIANCE_ATTRIBUTE_TAG;
        for (y = 0; y < numCorrelationColumns; ++y) {
            path[2] = (String)correlationColumnNames.get(y);
            for (x = 0; x < numTargetColumns; ++x) {
                path[1] = (String)targetColumnNames.get(x);
                entry = proc.getCovEntry(x, y);
                if (!outputCorrelation) {
                    if (x == 0) {
                        outputRowBuf.setString(x, path[2]);
                    }
                    outputRowBuf.setDouble(x + 1, entry);
                }
                data.set(path, Double.toString(entry));
            }
            if (outputCorrelation) continue;
            outputRowBuf.writeRow(outputOutputStream);
        }
        path[0] = CORRELATIONS_ATTRIBUTE_TAG;
        for (y = 0; y < numCorrelationColumns; ++y) {
            path[2] = (String)correlationColumnNames.get(y);
            for (x = 0; x < numTargetColumns; ++x) {
                path[1] = (String)targetColumnNames.get(x);
                entry = proc.getCorEntry(x, y);
                if (correlationColumnNumbers[y] == targetColumnNumbers[x] && !CNKObj.isDoubleNA(entry)) {
                    entry = 1.0;
                }
                if (outputCorrelation) {
                    if (x == 0) {
                        outputRowBuf.setString(x, path[2]);
                    }
                    outputRowBuf.setDouble(x + 1, entry);
                }
                data.set(path, Double.toString(entry));
            }
            if (!outputCorrelation) continue;
            outputRowBuf.writeRow(outputOutputStream);
        }
        this.setNodeCache("data", data);
        outputOutputStream.close();
        outputMD.setNumRows(numCorrelationColumns);
        this.setOutputMetaData(0, outputMD);
        this.procDelete(proc);
        return true;
    }

    public EngineNode.InputRequirements getInputRequirements(int inputNum) {
        return EngineNode.InputRequirements.getMinRequirements();
    }

    public XTMetaData calculateOutputMetaData(int outputNum) {
        try {
            List columns = this.getRegularColumns();
            List targets = this.getTargetColumns();
            int maxString = 0;
            int numRegularColumns = columns.size();
            for (int i = 0; i < numRegularColumns; ++i) {
                String columnName = (String)columns.get(i);
                maxString = Math.max(maxString, columnName == null ? 0 : columnName.length());
            }
            maxString += 4;
            boolean outputCorrelation = this.getNodeProperties().getBoolean(CORRELATIONS_ATTRIBUTE_TAG, true);
            XTMetaData outputMD = new XTMetaData();
            if (outputCorrelation) {
                outputMD.appendStringDataField("Correlations", maxString);
            } else {
                outputMD.appendStringDataField("Covariances", maxString);
            }
            for (int i = 0; i < targets.size(); ++i) {
                outputMD.appendContinousDataField((String)targets.get(i));
            }
            return outputMD;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

