/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.cnkjava.CNKProc;
import com.insightful.cnkjava.CNKProcJavaTransform;
import com.insightful.cnkjava.CNKProcJavaTransformExec;
import com.insightful.miner.EngineNode;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import com.insightful.miner.expression.ExpressionEvaluator;
import java.util.Random;
import java.util.Vector;

public class FilterRowsEngineNode
extends EngineNode
implements CNKProcJavaTransformExec {
    public static final String INCLUDE_ROWS_ATTRIBUTE_TAG = "includeRows";
    public static final String TEST_EXPRESSION_ATTRIBUTE_TAG = "testExpression";
    private int[] m_copyRows = null;
    private ExpressionEvaluator m_expressionEvaluator;
    private String m_parseErrorString;
    private boolean m_parseOK = false;
    private Random m_random = null;
    private long m_expressionNACount;
    private boolean m_includeRows;
    private int m_maxNext = 0;

    public CNKProc procCreate() {
        this.m_copyRows = null;
        CNKProcJavaTransform proc = new CNKProcJavaTransform();
        proc.setExecObject(this);
        return proc;
    }

    public void procDelete(CNKProc proc) {
        this.m_copyRows = null;
        this.cleanupEvaluator();
        super.procDelete(proc);
    }

    public void invalidateNodeState() {
        this.cleanupEvaluator();
    }

    public void cleanupEvaluator() {
        if (this.m_expressionEvaluator != null) {
            this.m_expressionEvaluator.cleanup();
        }
        this.m_expressionEvaluator = null;
    }

    public void procSetProperties(CNKProc proc) {
        this.m_random = this.getRandomGenerator();
        XTProps props = this.getNodeProperties();
        this.m_parseOK = this.parseExpression();
        this.m_expressionNACount = 0L;
        this.m_includeRows = props.getBoolean(INCLUDE_ROWS_ATTRIBUTE_TAG, true);
        this.m_maxNext = 0;
        if (this.m_parseOK) {
            this.m_expressionEvaluator.beginEval((CNKProcJavaTransform)proc, this.m_random);
            this.m_maxNext = this.m_expressionEvaluator.getMaxNext();
        }
    }

    public void procExtractResults(CNKProc proc) {
        if (this.m_expressionNACount > 0L) {
            this.printlnWarning(this.getNodeName() + ": " + this.m_expressionNACount + " input rows excluded because qualifier evaluated to NA");
        }
    }

    public void execute(CNKProcJavaTransform proc) {
        int inputRowsAvailable = proc.getChunkInputRows(0);
        if (inputRowsAvailable < 1) {
            if (proc.getChunkInputLast(0)) {
                proc.setChunkDone(true);
            }
            return;
        }
        if (!this.m_parseOK) {
            proc.addError("error parsing expression\n" + this.m_parseErrorString);
            return;
        }
        int inputRows = inputRowsAvailable;
        if (inputRows > 0 && !proc.getChunkInputLast(0)) {
            if (this.m_maxNext >= inputRows) {
                proc.addError("can't look ahead " + this.m_maxNext + " rows with a block size of " + inputRows + " rows");
                return;
            }
            inputRows -= this.m_maxNext;
        }
        long inputPosition = proc.getChunkInputPosition(0);
        this.m_expressionEvaluator.beginChunk(inputPosition, inputRows);
        int numColumns = this.getInputMetaData(0).getNumColumns();
        int firstOutputRow = 0;
        boolean newCopy = true;
        for (int row = 0; row < inputRows; ++row) {
            boolean copyRow;
            this.m_expressionEvaluator.setDataSourceRow(row);
            this.m_expressionEvaluator.updatePrevData(row, inputRows, inputRowsAvailable);
            ExpressionEvaluator.LogicalValue exprVal = this.m_expressionEvaluator.evalToLogical();
            if (ExpressionEvaluator.isLogicalNA(exprVal)) {
                ++this.m_expressionNACount;
                continue;
            }
            boolean bl = copyRow = this.m_includeRows && ExpressionEvaluator.isLogicalTrue(exprVal) || !this.m_includeRows && ExpressionEvaluator.isLogicalFalse(exprVal);
            if (!copyRow) continue;
            if (!newCopy) {
                proc.copyData(0, 0, firstOutputRow++, 0, 0, row, 1, numColumns);
                continue;
            }
            if (this.m_copyRows == null) {
                this.m_copyRows = new int[inputRows];
            } else if (this.m_copyRows.length <= firstOutputRow) {
                int[] newCopyRows = new int[100 + this.m_copyRows.length * 2];
                System.arraycopy(this.m_copyRows, 0, this.m_copyRows, 0, this.m_copyRows.length);
                this.m_copyRows = newCopyRows;
            }
            this.m_copyRows[firstOutputRow++] = row;
        }
        if (newCopy && firstOutputRow > 0) {
            proc.copyData(0, 0, 0, 0, 0, this.m_copyRows, firstOutputRow, numColumns);
        }
        proc.setChunkOutputReleaseRows(0, firstOutputRow);
        this.m_expressionEvaluator.endChunk();
        if (this.m_expressionEvaluator.hasEvalErrors()) {
            Vector errVec = this.m_expressionEvaluator.getEvalErrors();
            for (int errNum = 0; errNum < errVec.size(); ++errNum) {
                String errStr = (String)errVec.get(errNum);
                proc.addError("computing expression: " + errStr);
            }
        }
        int numInputs = proc.getNumInbufs();
        for (int i = 0; i < numInputs; ++i) {
            proc.setChunkInputReleaseRows(i, inputRows);
        }
    }

    private boolean expressionNeedsDataSummary() {
        boolean parseOK = this.parseExpression();
        if (!parseOK) {
            return false;
        }
        return this.m_expressionEvaluator.needsDataSummary();
    }

    private boolean parseExpression() {
        XTProps props = this.getNodeProperties();
        return this.parseExpression(props, this.getAllInputMetaData());
    }

    private boolean parseExpression(XTProps props, XTMetaData[] inputMD) {
        this.m_expressionEvaluator = null;
        this.m_parseErrorString = "";
        String exprString = props.getValue(TEST_EXPRESSION_ATTRIBUTE_TAG, "");
        exprString = this.getNetworkManager().substituteParaeters(exprString);
        ExpressionEvaluator exprEval = new ExpressionEvaluator();
        exprEval.setExpressionString(exprString);
        exprEval.setExpressionType(3);
        exprEval.setDataSourceMetaData(inputMD);
        exprEval.setWorksheetPropertiesManager(this.getNetworkManager().getWorksheetPropertiesManager());
        boolean ok = exprEval.constructParseTree();
        if (!ok || !(ok = exprEval.constructEvalTree())) {
            // empty if block
        }
        if (ok) {
            this.m_parseErrorString = "";
            this.m_expressionEvaluator = exprEval;
        } else {
            this.m_parseErrorString = exprEval.getFormattedError();
            this.m_expressionEvaluator = null;
        }
        return ok;
    }

    public String getParseErrors(XTProps props) {
        boolean ok = false;
        try {
            ok = this.parseExpression(props, this.getAllInputMetaData());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return ok ? "" : this.m_parseErrorString;
    }

    public XTMetaData calculateOutputMetaData(int outputNum) {
        XTMetaData md = null;
        try {
            XTMetaData inMD = this.getInputMetaData(0);
            int numColumns = inMD.getNumColumns();
            md = new XTMetaData();
            for (int i = 0; i < numColumns; ++i) {
                String colName = inMD.ordinalToName(i);
                if (inMD.isCategoricalColumn(i)) {
                    md.appendCategoricalDataField(colName, new String[0]);
                } else if (inMD.isStringColumn(i)) {
                    md.appendStringDataField(colName, inMD.getStringDataFieldWidth(i));
                } else if (inMD.isDateTimeColumn(i)) {
                    md.appendDateTimeDataField(colName);
                } else if (inMD.isBlobColumn(i)) {
                    md.appendBlobDataField(colName, inMD.getBlobDataFieldClassName(i));
                } else {
                    md.appendContinousDataField(colName);
                }
                md.setDataFieldRole(colName, inMD.getColumnRole(i));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return md;
    }

    public EngineNode.InputRequirements getInputRequirements(int inputNum) {
        if (this.expressionNeedsDataSummary()) {
            return new EngineNode.InputRequirements(false, false, false, true, true, false);
        }
        return EngineNode.InputRequirements.getMinRequirements();
    }
}

