/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.GridViewerModel;
import com.insightful.miner.Retrievable;

public class GridViewerRowNumberModel
extends GridViewerModel {
    public GridViewerRowNumberModel(int visibleRows, int visibleCols, Retrievable getDataFrom) throws NullPointerException {
        if (getDataFrom == null) {
            throw new NullPointerException("Data Source was not provided.");
        }
        this.dataSource = getDataFrom;
        this.totalNumRows = getDataFrom.getTotalRows();
        this.totalNumCols = getDataFrom.getTotalColumns();
        this.accessibleNumRows = visibleRows;
        this.accessibleNumCols = 1;
        this.accessibleData = new Object[this.accessibleNumRows][this.accessibleNumCols];
        for (int i = 0; i < this.accessibleNumRows; ++i) {
            this.accessibleData[i][0] = new Long(i + 1);
        }
    }

    public void changeGridViewerModel(int actualDataLocX, long actualDataLocY, int visibleRows, int visibleCols) {
        if (this.absoluteRowPos == actualDataLocY && this.accessibleNumRows == visibleRows) {
            return;
        }
        this.absoluteRowPos = actualDataLocY;
        if (visibleRows < 0) {
            visibleRows = 0;
        }
        if (visibleCols < 0) {
            visibleCols = 0;
        }
        this.accessibleNumRows = visibleRows;
        this.accessibleData = new Object[this.accessibleNumRows][1];
        for (int i = 0; i < this.accessibleNumRows; ++i) {
            if (this.absoluteRowPos + (long)i >= this.totalNumRows) continue;
            this.accessibleData[i][0] = new Long(this.absoluteRowPos + (long)i + 1L);
        }
        if (this.accessibleNumRows != 0) {
            this.fireTableStructureChanged();
        }
    }

    public long getTotalRowCount() {
        return this.totalNumRows;
    }

    public int getTotalColCount() {
        return 1;
    }

    public int getColumnWidth(int numCol) {
        return this.dataSource.getRowLabelWidth();
    }

    public String getColumnName(int numCol) {
        return "";
    }

    public int getColumnCount() {
        return 1;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        String label = this.dataSource.getRowLabel(rowIndex);
        if (label != null) {
            return label;
        }
        if (rowIndex < this.accessibleNumRows) {
            return this.accessibleData[rowIndex][0];
        }
        return new Object();
    }
}

