/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.ExtensionManager;
import com.insightful.miner.MinerApp;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleValue;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicSliderUI;

public class MultiSlider
extends JSlider {
    private boolean m_isDateLabels = false;
    private boolean m_useScientificNotationLabels = false;
    private boolean m_paintLabels = false;
    protected DoubleBoundedRangeModel doubleSliderModel;
    protected Vector doubleSliderModels = new Vector();
    private static final String uiClassID = "MultiSliderUI";
    private static Rectangle zeroRect = new Rectangle();
    private double doubleMajorTickSpacing;
    private double doubleMinorTickSpacing;
    private double startVal = 4.0;
    private Hashtable m_standardLabels = null;
    private double m_increment = 0.0;

    public MultiSlider(int orientation, double min, double max, double[] value) {
        this(new DoubleBoundedRangeModel(min, max - min, min, max));
        this.createThumbs(value.length);
        for (int i = 0; i < value.length; ++i) {
            this.setDoubleValueAt(value[i], i);
        }
    }

    private MultiSlider(DoubleBoundedRangeModel brm) {
        this.orientation = 0;
        this.init(brm);
    }

    private void init(DoubleBoundedRangeModel brm) {
        this.setModel(brm);
        this.doubleSliderModel.addChangeListener(this.changeListener);
        this.updateUI();
        ToolTipManager.sharedInstance().registerComponent(this);
        this.showLegend();
    }

    public boolean getDateLabels() {
        return this.m_isDateLabels;
    }

    public void setDateLabels(boolean date) {
        this.m_isDateLabels = date;
    }

    private String getRoundedDouble(boolean scientific, double val) {
        if (this.m_isDateLabels) {
            return MinerApp.getWorksheetPropertiesManager().getDateFormatter().convertJulianDateToString(val);
        }
        if (scientific) {
            return MinerApp.formatScientificDouble(val);
        }
        return MinerApp.formatDouble(val);
    }

    public void addChangeListener(ChangeListener listener) {
        this.getMultiModel().addChangeListener(listener);
        Enumeration enumeration = this.doubleSliderModels.elements();
        while (enumeration.hasMoreElements()) {
            ((DoubleBoundedRangeModel)enumeration.nextElement()).addChangeListener(listener);
        }
    }

    public void removeChangeListener(ChangeListener listener) {
        this.getMultiModel().removeChangeListener(listener);
        Enumeration enumeration = this.doubleSliderModels.elements();
        while (enumeration.hasMoreElements()) {
            ((DoubleBoundedRangeModel)enumeration.nextElement()).removeChangeListener(listener);
        }
    }

    public void resetSlider(double min, double max, double[] value) {
        this.init(new DoubleBoundedRangeModel(min, max - min, min, max));
        this.createThumbs(value.length);
        for (int i = 0; i < value.length; ++i) {
            this.setDoubleValueAt(value[i], i);
        }
        this.updateUI();
    }

    public void spreadThumbs() {
        int n = this.getThumbNum();
        double value = this.getDoubleMinimum();
        double spread = this.getDoubleMaximum() - value;
        double portion = spread / (double)(n + 1);
        for (int i = 0; i < n; ++i) {
            this.setDoubleValueAt(value += portion, i);
        }
        this.updateUI();
    }

    public double[] getEdgeValues() {
        int num = this.getThumbNum();
        double[] ret = new double[num];
        for (int i = 0; i < num; ++i) {
            ret[i] = this.getDoubleValueAt(i);
        }
        return ret;
    }

    public void createThumbs(int n) {
        this.doubleSliderModels.removeAllElements();
        DoubleBoundedRangeModel mod = this.getMultiModel();
        double min = mod.getMinimum();
        double max = mod.getMaximum();
        double val = mod.getValue();
        double ext = mod.getExtent();
        for (int i = 0; i < n; ++i) {
            this.doubleSliderModels.add(new DoubleBoundedRangeModel(val, ext, min, max));
        }
        this.updateUI();
        this.showLegend();
        this.spreadThumbs();
    }

    public void showLegend() {
        double max;
        DoubleBoundedRangeModel mod = this.getMultiModel();
        double min = mod.getMinimum();
        boolean valid = min != (max = mod.getMaximum());
        double majorTick = (max - min) / this.startVal;
        this.setDoubleMajorTickSpacing(majorTick);
        double minorTick = majorTick / 2.0;
        if (minorTick > 0.0) {
            this.setDoubleMinorTickSpacing(minorTick);
        }
        this.setPaintLabels(valid);
        this.setPaintTicks(valid);
        this.setPaintTrack(true);
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public void updateUI() {
        AssistantUIManager.setUIName(this);
        this.updateLabelUIs();
        this.setUI(new BasicMultiSliderUI());
    }

    public String getToolTipText(MouseEvent e) {
        int num = this.getThumbNum();
        Rectangle[] thumbRects = ((BasicMultiSliderUI)this.getUI()).additonalUi.getThumbRects();
        Point pt = e.getPoint();
        for (int i = 0; i < num; ++i) {
            if (!thumbRects[i].contains(pt)) continue;
            return this.getRoundedDouble(false, this.getDoubleValueAt(i));
        }
        return null;
    }

    public int getThumbNum() {
        if (this.doubleSliderModels == null) {
            return 0;
        }
        return this.doubleSliderModels.size();
    }

    public double getDoubleMajorTickSpacing() {
        return this.doubleMajorTickSpacing;
    }

    public double getDoubleMinorTickSpacing() {
        return this.doubleMinorTickSpacing;
    }

    public void setDoubleMajorTickSpacing(double n) {
        double oldValue = this.doubleMajorTickSpacing;
        this.doubleMajorTickSpacing = n;
        if (this.getDoubleMajorTickSpacing() > 0.0 && this.getPaintLabels()) {
            this.setLabelTable(this.createStandardLabels(this.getDoubleMajorTickSpacing()));
        }
        this.firePropertyChange("majorTickSpacing", oldValue, (double)this.majorTickSpacing);
        if ((double)this.majorTickSpacing != oldValue && this.getPaintTicks()) {
            this.repaint();
        }
    }

    public void setDoubleMinorTickSpacing(double n) {
        double oldValue = this.doubleMinorTickSpacing;
        this.doubleMinorTickSpacing = n;
        this.firePropertyChange("minorTickSpacing", oldValue, (double)this.minorTickSpacing);
        if ((double)this.minorTickSpacing != oldValue && this.getPaintTicks()) {
            this.repaint();
        }
    }

    public boolean getPaintLabels() {
        return this.m_paintLabels;
    }

    public void setPaintLabels(boolean paint) {
        boolean oldValue = this.m_paintLabels;
        this.m_paintLabels = paint;
        if (this.getDoubleMajorTickSpacing() > 0.0) {
            this.setLabelTable(this.createStandardLabels(this.getDoubleMajorTickSpacing()));
        }
        this.firePropertyChange("paintLabels", oldValue, this.m_paintLabels);
        if (this.m_paintLabels != oldValue) {
            this.revalidate();
            this.repaint();
        }
    }

    public double getDoubleValueAt(int index) {
        return this.getMultiModelAt(index).getValue();
    }

    public void setDoubleValueAt(double n, int index) {
        this.getMultiModelAt(index).setValue(n);
    }

    public double getDoubleMinimum() {
        return this.getMultiModel().getMinimum();
    }

    public double getDoubleMaximum() {
        return this.getMultiModel().getMaximum();
    }

    public DoubleBoundedRangeModel getMultiModelAt(int index) {
        return (DoubleBoundedRangeModel)this.doubleSliderModels.get(index);
    }

    public DoubleBoundedRangeModel getMultiModel() {
        return this.doubleSliderModel;
    }

    public void setModel(DoubleBoundedRangeModel newModel) {
        DoubleBoundedRangeModel oldModel = this.getMultiModel();
        if (oldModel != null) {
            oldModel.removeChangeListener(this.changeListener);
        }
        this.doubleSliderModel = newModel;
        if (newModel != null) {
            newModel.addChangeListener(this.changeListener);
            if (this.accessibleContext != null) {
                this.accessibleContext.firePropertyChange("AccessibleValue", oldModel == null ? null : new Double(oldModel.getValue()), newModel == null ? null : new Double(newModel.getValue()));
            }
        }
        this.firePropertyChange("model", oldModel, this.doubleSliderModel);
    }

    public double getDoubleValue() {
        return this.getMultiModel().getValue();
    }

    public void setDoubleValue(double n) {
        DoubleBoundedRangeModel m = this.getMultiModel();
        double oldValue = m.getValue();
        if (oldValue == n) {
            return;
        }
        m.setValue(n);
        if (this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleValue", new Double(oldValue), new Double(m.getValue()));
        }
    }

    public void setMinimum(double minimum) {
        double oldMin = this.getMultiModel().getMinimum();
        this.getMultiModel().setMinimum(minimum);
        this.firePropertyChange("minimum", new Double(oldMin), new Double(minimum));
    }

    public void setMaximum(int maximum) {
        double oldMax = this.getMultiModel().getMaximum();
        this.getMultiModel().setMaximum(maximum);
        this.firePropertyChange("maximum", new Double(oldMax), new Double(maximum));
    }

    public boolean getDoubleValueIsAdjusting() {
        return this.getMultiModel().getValueIsAdjusting();
    }

    public void setDoubleValueIsAdjusting(boolean adj) {
        this.getMultiModel().setValueIsAdjusting(adj);
    }

    public double getDoubleExtent() {
        return this.getMultiModel().getExtent();
    }

    public void setDoubleExtent(double extent) {
        this.getMultiModel().setExtent(extent);
    }

    public void setScientificNotationLabels(boolean set) {
        this.m_useScientificNotationLabels = set;
    }

    public boolean getScientificNotationLabels() {
        return this.m_useScientificNotationLabels;
    }

    public Hashtable createStandardLabels(double increment) {
        if (this.m_standardLabels == null || increment != this.m_increment) {
            this.m_standardLabels = this.createStandardLabels(increment, this.getDoubleMinimum());
            this.m_increment = increment;
        }
        return this.m_standardLabels;
    }

    public Hashtable createStandardLabels(double increment, double start) {
        if (start > this.getDoubleMaximum() || start < this.getDoubleMinimum()) {
            throw new IllegalArgumentException("Slider label start point out of range.");
        }
        class SmartHashtable
        extends Hashtable
        implements PropertyChangeListener {
            double increment = 0.0;
            double start = 0.0;
            boolean startAtMin = false;

            public SmartHashtable(double increment, double start) {
                this.increment = increment;
                this.start = start;
                this.startAtMin = start == MultiSlider.this.getDoubleMinimum();
                this.createLabels();
            }

            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("minimum") && this.startAtMin) {
                    this.start = MultiSlider.this.getDoubleMinimum();
                }
                if (e.getPropertyName().equals("minimum") || e.getPropertyName().equals("maximum")) {
                    Enumeration keys = MultiSlider.this.getLabelTable().keys();
                    Object key = null;
                    Hashtable hashtable = new Hashtable();
                    while (keys.hasMoreElements()) {
                        key = keys.nextElement();
                        Object value = MultiSlider.this.getLabelTable().get(key);
                        if (value instanceof 1SmartHashtable.LabelUIResource) continue;
                        hashtable.put(key, value);
                    }
                    this.clear();
                    this.createLabels();
                    keys = hashtable.keys();
                    while (keys.hasMoreElements()) {
                        key = keys.nextElement();
                        this.put(key, hashtable.get(key));
                    }
                    ((MultiSlider)e.getSource()).setLabelTable(this);
                }
            }

            void createLabels() {
                boolean scientific = MultiSlider.this.m_useScientificNotationLabels;
                double max = MultiSlider.this.getDoubleMaximum();
                double min = MultiSlider.this.getDoubleMinimum();
                double lastLabel = min + (max - min) * 0.91;
                if (min == max) {
                    String str = MultiSlider.this.getRoundedDouble(scientific, max);
                    this.put(new Double(max), new 1SmartHashtable.LabelUIResource("" + str, 0));
                    return;
                }
                if (Double.isInfinite(max) || Double.isInfinite(this.increment)) {
                    MultiSlider slider = MultiSlider.this;
                    for (int i = 0; i < slider.getThumbNum(); ++i) {
                        double val = slider.getDoubleValueAt(i);
                        String str = MultiSlider.this.getRoundedDouble(scientific, val);
                        this.put(new Double(val), new 1SmartHashtable.LabelUIResource("" + str, 0));
                    }
                } else {
                    for (double labelIndex = this.start; labelIndex <= max; labelIndex += this.increment) {
                        if (!(lastLabel > labelIndex)) continue;
                        String str = MultiSlider.this.getRoundedDouble(scientific, labelIndex);
                        this.put(new Double(labelIndex), new 1SmartHashtable.LabelUIResource("" + str, 0));
                    }
                    String str = MultiSlider.this.getRoundedDouble(scientific, max);
                    this.put(new Double(max), new 1SmartHashtable.LabelUIResource("" + str, 0));
                }
            }

            class 1SmartHashtable.LabelUIResource
            extends JLabel
            implements UIResource {
                public 1SmartHashtable.LabelUIResource(String text, int alignment) {
                    super(text, alignment);
                }
            }
        }
        SmartHashtable table = new SmartHashtable(increment, start);
        if (this.getLabelTable() != null && this.getLabelTable() instanceof PropertyChangeListener) {
            this.removePropertyChangeListener((PropertyChangeListener)((Object)this.getLabelTable()));
        }
        this.addPropertyChangeListener(table);
        return table;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleMultiSlider();
        }
        return this.accessibleContext;
    }

    protected class AccessibleMultiSlider
    extends JSlider.AccessibleJSlider
    implements AccessibleValue {
        protected AccessibleMultiSlider() {
            super(MultiSlider.this);
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet states = super.getAccessibleStateSet();
            if (MultiSlider.this.getDoubleValueIsAdjusting()) {
                states.add(AccessibleState.BUSY);
            }
            if (MultiSlider.this.getOrientation() == 1) {
                states.add(AccessibleState.VERTICAL);
            } else {
                states.add(AccessibleState.HORIZONTAL);
            }
            return states;
        }

        public Number getCurrentAccessibleValue() {
            return new Double(MultiSlider.this.getDoubleValue());
        }

        public Number getMinimumAccessibleValue() {
            return new Double(MultiSlider.this.getDoubleMinimum());
        }

        public Number getMaximumAccessibleValue() {
            return new Double(MultiSlider.this.getDoubleMaximum());
        }

        public boolean setCurrentAccessibleValue(Number n) {
            if (n instanceof Integer) {
                MultiSlider.this.setDoubleValue(n.intValue());
                return true;
            }
            if (n instanceof Double) {
                MultiSlider.this.setDoubleValue(n.doubleValue());
                return true;
            }
            return false;
        }
    }

    public static class DoubleBoundedRangeModel {
        protected transient ChangeEvent changeEvent = null;
        private double min;
        private double max;
        private double val;
        private double ext;
        private boolean adj;
        private Vector changeListeners;

        public DoubleBoundedRangeModel(double value, double extent, double min, double max) {
            this.min = min;
            this.max = max;
            this.val = value;
            this.ext = extent;
            this.adj = false;
            this.changeListeners = new Vector();
        }

        public DoubleBoundedRangeModel() {
            this(0.0, 0.0, 0.0, 0.0);
        }

        public double getMinimum() {
            return this.min;
        }

        public void setMinimum(double newMinimum) {
            this.min = newMinimum;
            this.fireStateChanged();
        }

        public double getMaximum() {
            return this.max;
        }

        public void setMaximum(double newMaximum) {
            this.max = newMaximum;
            this.fireStateChanged();
        }

        public double getValue() {
            return this.val;
        }

        public void setValue(double newValue) {
            this.val = newValue;
            this.fireStateChanged();
        }

        public void setValueIsAdjusting(boolean b) {
            this.adj = b;
        }

        public boolean getValueIsAdjusting() {
            return this.adj;
        }

        public double getExtent() {
            return this.ext;
        }

        public void setExtent(double newExtent) {
            this.ext = newExtent;
            this.fireStateChanged();
        }

        public void setRangeProperties(double value, double extent, double min, double max, boolean adjusting) {
            this.val = value;
            this.ext = extent;
            this.min = min;
            this.max = max;
            this.adj = adjusting;
            this.fireStateChanged();
        }

        public void addChangeListener(ChangeListener x) {
            this.changeListeners.add(x);
        }

        public void removeChangeListener(ChangeListener x) {
            this.changeListeners.remove(x);
        }

        protected void fireStateChanged() {
            Object[] listeners = this.changeListeners.toArray();
            for (int i = listeners.length - 1; i >= 0; --i) {
                if (!(listeners[i] instanceof ChangeListener)) continue;
                if (this.changeEvent == null) {
                    this.changeEvent = new ChangeEvent(this);
                }
                ((ChangeListener)listeners[i]).stateChanged(this.changeEvent);
            }
        }
    }

    public static class MultiSliderAdditionalUI {
        private MultiSlider mSlider;
        private BasicSliderUI ui;
        private Rectangle[] thumbRects;
        private int thumbNum;
        private transient boolean isDragging;
        private Icon thumbRenderer;
        private Rectangle trackRect;
        private ChangeHandler changeHandler;
        private MultiTrackListener trackListener;
        private static Rectangle unionRect = new Rectangle();

        public MultiSliderAdditionalUI(BasicSliderUI baseUI) {
            this.ui = baseUI;
        }

        public void installUI(JComponent c) {
            this.mSlider = (MultiSlider)c;
            this.thumbNum = this.mSlider.getThumbNum();
            this.thumbRects = new Rectangle[this.thumbNum];
            for (int i = 0; i < this.thumbNum; ++i) {
                this.thumbRects[i] = new Rectangle();
            }
            this.isDragging = false;
            this.trackListener = new MultiTrackListener(this.mSlider);
            this.changeHandler = new ChangeHandler();
        }

        public void uninstallUI(JComponent c) {
            this.thumbRects = null;
            this.trackListener = null;
            this.changeHandler = null;
        }

        protected void calculateThumbsSize() {
            Dimension size = ((MultiSliderAdditional)((Object)this.ui)).getThumbSize();
            for (int i = 0; i < this.thumbNum; ++i) {
                this.thumbRects[i].setSize(size.width, size.height);
            }
        }

        public Rectangle[] getThumbRects() {
            return this.thumbRects;
        }

        protected void calculateThumbsLocation() {
            for (int i = 0; i < this.thumbNum; ++i) {
                if (this.mSlider.getSnapToTicks()) {
                    double tickSpacing = this.mSlider.getDoubleMinorTickSpacing();
                    if (tickSpacing == 0.0) {
                        tickSpacing = this.mSlider.getDoubleMajorTickSpacing();
                    }
                    if (tickSpacing != 0.0) {
                        double sliderValue;
                        double snappedValue = sliderValue = this.mSlider.getDoubleValueAt(i);
                        double min = this.mSlider.getDoubleMinimum();
                        if ((sliderValue - min) % tickSpacing != 0.0) {
                            float temp = (float)(sliderValue - min) / (float)tickSpacing;
                            int whichTick = Math.round(temp);
                            snappedValue = min + (double)whichTick * tickSpacing;
                            this.mSlider.setDoubleValueAt(snappedValue, i);
                        }
                    }
                }
                this.trackRect = this.getTrackRect();
                if (this.mSlider.getOrientation() == 0) {
                    double value = this.mSlider.getDoubleValueAt(i);
                    int valuePosition = ((MultiSliderAdditional)((Object)this.ui)).xPositionForValue(value);
                    this.thumbRects[i].x = valuePosition - this.thumbRects[i].width / 2;
                    this.thumbRects[i].y = this.trackRect.y;
                    continue;
                }
                int valuePosition = ((MultiSliderAdditional)((Object)this.ui)).yPositionForValue(this.mSlider.getDoubleValueAt(i));
                this.thumbRects[i].x = this.trackRect.x;
                this.thumbRects[i].y = valuePosition - this.thumbRects[i].height / 2;
            }
        }

        public void setThumbLocationAt(int x, int y, int index) {
            Rectangle rect = this.thumbRects[index];
            unionRect.setBounds(rect);
            rect.setLocation(x, y);
            SwingUtilities.computeUnion(rect.x, rect.y, rect.width, rect.height, unionRect);
            this.mSlider.repaint(MultiSliderAdditionalUI.unionRect.x, MultiSliderAdditionalUI.unionRect.y, MultiSliderAdditionalUI.unionRect.width, MultiSliderAdditionalUI.unionRect.height);
        }

        public int getThumbNum() {
            return this.thumbNum;
        }

        public Rectangle getTrackRect() {
            return ((MultiSliderAdditional)((Object)this.ui)).getTrackRect();
        }

        public class MultiTrackListener
        extends MouseInputAdapter {
            protected transient int offset;
            protected transient int currentMouseX;
            protected transient int currentMouseY;
            protected Rectangle adjustingThumbRect = null;
            protected int adjustingThumbIndex;
            protected MultiSlider slider;
            protected Rectangle trackRect;

            public MultiTrackListener(MultiSlider slider) {
                this.slider = slider;
            }

            public void mousePressed(MouseEvent e) {
                if (!this.slider.isEnabled()) {
                    return;
                }
                this.currentMouseX = e.getX();
                this.currentMouseY = e.getY();
                this.slider.requestFocus();
                for (int i = 0; i < MultiSliderAdditionalUI.this.thumbNum; ++i) {
                    Rectangle rect = MultiSliderAdditionalUI.this.thumbRects[i];
                    if (!rect.contains(this.currentMouseX, this.currentMouseY)) continue;
                    switch (this.slider.getOrientation()) {
                        case 1: {
                            this.offset = this.currentMouseY - rect.y;
                            break;
                        }
                        case 0: {
                            this.offset = this.currentMouseX - rect.x;
                        }
                    }
                    MultiSliderAdditionalUI.this.isDragging = true;
                    this.slider.setDoubleValueIsAdjusting(true);
                    this.adjustingThumbRect = rect;
                    this.adjustingThumbIndex = i;
                    return;
                }
            }

            public void mouseDragged(MouseEvent e) {
                if (!(this.slider.isEnabled() && MultiSliderAdditionalUI.this.isDragging && this.slider.getDoubleValueIsAdjusting() && this.adjustingThumbRect != null)) {
                    return;
                }
                int thumbMiddle = 0;
                this.currentMouseX = e.getX();
                this.currentMouseY = e.getY();
                Rectangle rect = MultiSliderAdditionalUI.this.thumbRects[this.adjustingThumbIndex];
                this.trackRect = MultiSliderAdditionalUI.this.getTrackRect();
                BasicMultiSliderUI mUI = (BasicMultiSliderUI)MultiSliderAdditionalUI.this.ui;
                switch (this.slider.getOrientation()) {
                    case 1: {
                        int halfThumbHeight = rect.height / 2;
                        int thumbTop = e.getY() - this.offset;
                        int trackTop = this.trackRect.y;
                        int trackBottom = this.trackRect.y + (this.trackRect.height - 1);
                        thumbTop = Math.max(thumbTop, trackTop - halfThumbHeight);
                        thumbTop = Math.min(thumbTop, trackBottom - halfThumbHeight);
                        MultiSliderAdditionalUI.this.setThumbLocationAt(rect.x, thumbTop, this.adjustingThumbIndex);
                        thumbMiddle = thumbTop + halfThumbHeight;
                        MultiSliderAdditionalUI.this.mSlider.setDoubleValueAt(mUI.doubleValueForYPosition(thumbMiddle), this.adjustingThumbIndex);
                        break;
                    }
                    case 0: {
                        int halfThumbWidth = rect.width / 2;
                        int thumbLeft = e.getX() - this.offset;
                        int trackLeft = this.trackRect.x;
                        int trackRight = this.trackRect.x + (this.trackRect.width - 1);
                        thumbLeft = Math.max(thumbLeft, trackLeft - halfThumbWidth);
                        thumbLeft = Math.min(thumbLeft, trackRight - halfThumbWidth);
                        MultiSliderAdditionalUI.this.setThumbLocationAt(thumbLeft, rect.y, this.adjustingThumbIndex);
                        thumbMiddle = thumbLeft + halfThumbWidth;
                        MultiSliderAdditionalUI.this.mSlider.setDoubleValueAt(mUI.doubleValueForXPosition(thumbMiddle), this.adjustingThumbIndex);
                    }
                }
            }

            public void mouseReleased(MouseEvent e) {
                if (!this.slider.isEnabled()) {
                    return;
                }
                this.offset = 0;
                MultiSliderAdditionalUI.this.isDragging = false;
                MultiSliderAdditionalUI.this.mSlider.setDoubleValueIsAdjusting(false);
                MultiSliderAdditionalUI.this.mSlider.repaint();
            }

            public boolean shouldScroll(int direction) {
                return false;
            }
        }

        public class ChangeHandler
        implements ChangeListener {
            public void stateChanged(ChangeEvent e) {
                if (!MultiSliderAdditionalUI.this.isDragging) {
                    MultiSliderAdditionalUI.this.calculateThumbsLocation();
                    MultiSliderAdditionalUI.this.mSlider.repaint();
                }
            }
        }
    }

    public static interface MultiSliderAdditional {
        public Rectangle getTrackRect();

        public Dimension getThumbSize();

        public int xPositionForValue(double var1);

        public int yPositionForValue(double var1);
    }

    public static class BasicMultiSliderUI
    extends BasicSliderUI
    implements MultiSliderAdditional {
        public MultiSliderAdditionalUI additonalUi;
        private MouseInputAdapter mThumbTrackListener;
        private boolean multiThumbPaint = false;

        public static ComponentUI createUI(JComponent c) {
            return new BasicMultiSliderUI((JSlider)c);
        }

        public BasicMultiSliderUI() {
            super(null);
        }

        public BasicMultiSliderUI(JSlider b) {
            super(b);
            this.multiThumbPaint = false;
        }

        public void installUI(JComponent c) {
            this.additonalUi = new MultiSliderAdditionalUI(this);
            this.additonalUi.installUI(c);
            this.mThumbTrackListener = this.createMThumbTrackListener((JSlider)c);
            super.installUI(c);
            this.uninstallListeners((JSlider)c);
            this.installListeners((JSlider)c);
        }

        public void uninstallUI(JComponent c) {
            super.uninstallUI(c);
            this.additonalUi.uninstallUI(c);
            this.additonalUi = null;
            this.mThumbTrackListener = null;
        }

        public int getLabelRectWidth() {
            Dictionary dict = this.slider.getLabelTable();
            int width = 0;
            if (dict != null) {
                Enumeration enumeration = dict.elements();
                while (enumeration.hasMoreElements()) {
                    Component label = (Component)enumeration.nextElement();
                    width = (int)((double)width + (double)label.getPreferredSize().width * 1.05);
                }
            }
            return width;
        }

        public Dimension getMinimumSize() {
            int width = this.getLabelRectWidth();
            int height = super.getPreferredHorizontalSize().height;
            if (width > 350) {
                MultiSlider ms = (MultiSlider)this.slider;
                double increment = ms.getDoubleMajorTickSpacing();
                if (ms.getDateLabels()) {
                    double range = ms.getDoubleMaximum() - ms.getDoubleMinimum();
                    double val = ms.startVal - 1.0;
                    increment = range / val;
                    while (width > 350 || increment < range) {
                        ms.setDoubleMajorTickSpacing(increment);
                        double minorTick = increment / 2.0;
                        if (minorTick > 0.0) {
                            ms.setDoubleMinorTickSpacing(minorTick);
                        }
                        ms.setLabelTable(ms.createStandardLabels(increment));
                        if (val - 1.0 != 0.0) {
                            increment = range / (val -= 1.0);
                            width = this.getLabelRectWidth();
                            continue;
                        }
                        break;
                    }
                } else {
                    ms.setScientificNotationLabels(true);
                    ms.setLabelTable(ms.createStandardLabels(increment));
                    ms.setScientificNotationLabels(false);
                    width = this.getLabelRectWidth();
                }
            }
            return new Dimension(width, height);
        }

        public Dimension getPreferredHorizontalSize() {
            Dimension dim = this.getMinimumSize();
            dim.width = Math.max(300, dim.width);
            return dim;
        }

        protected MouseInputAdapter createMThumbTrackListener(JSlider slider) {
            return this.additonalUi.trackListener;
        }

        protected ComponentListener createComponentListener(JSlider slider) {
            return new MultiComponentAdapter();
        }

        protected FocusListener createFocusListener(JSlider slider) {
            return new MultiFocusHandler();
        }

        protected ChangeListener createChangeListener(JSlider slider) {
            return this.additonalUi.changeHandler;
        }

        protected PropertyChangeListener createPropertyChangeListener(JSlider slider) {
            return new DoublePropertyChangeHandler();
        }

        protected void installListeners(JSlider slider) {
            slider.addMouseListener(this.mThumbTrackListener);
            slider.addMouseMotionListener(this.mThumbTrackListener);
            slider.addFocusListener(this.focusListener);
            slider.addComponentListener(this.componentListener);
            slider.addPropertyChangeListener(this.propertyChangeListener);
            DoubleBoundedRangeModel m = ((MultiSlider)slider).getMultiModel();
            if (m != null) {
                m.addChangeListener(this.changeListener);
            }
        }

        protected void uninstallListeners(JSlider slider) {
            slider.removeMouseListener(this.mThumbTrackListener);
            slider.removeMouseMotionListener(this.mThumbTrackListener);
            slider.removeFocusListener(this.focusListener);
            slider.removeComponentListener(this.componentListener);
            slider.removePropertyChangeListener(this.propertyChangeListener);
            DoubleBoundedRangeModel m = ((MultiSlider)slider).getMultiModel();
            if (m != null) {
                m.removeChangeListener(this.changeListener);
            }
        }

        protected void calculateGeometry() {
            if (this.insetCache != null) {
                super.calculateGeometry();
            }
            if (this.additonalUi != null) {
                this.additonalUi.calculateThumbsSize();
                this.additonalUi.calculateThumbsLocation();
            }
        }

        public void paintThumb(Graphics g) {
            if (this.multiThumbPaint) {
                super.paintThumb(g);
            }
        }

        public void paint(Graphics g, JComponent c) {
            Rectangle clip = g.getClipBounds();
            this.thumbRect = zeroRect;
            super.paint(g, c);
            int thumbNum = this.additonalUi.getThumbNum();
            Rectangle[] thumbRects = this.additonalUi.getThumbRects();
            for (int i = thumbNum - 1; 0 <= i; --i) {
                if (!clip.intersects(thumbRects[i])) continue;
                this.thumbRect = thumbRects[i];
                this.multiThumbPaint = true;
                this.paintThumb(g);
                this.multiThumbPaint = false;
            }
        }

        protected void calculateThumbLocation() {
        }

        public void scrollByBlock(int direction) {
        }

        public void scrollByUnit(int direction) {
        }

        public Dimension getThumbSize() {
            return super.getThumbSize();
        }

        public Rectangle getTrackRect() {
            return this.trackRect;
        }

        public int xPositionForValue(double value) {
            int xPosition;
            MultiSlider ms = (MultiSlider)this.slider;
            double min = ms.getDoubleMinimum();
            double max = ms.getDoubleMaximum();
            int trackLength = this.trackRect.width;
            double valueRange = max - min;
            double pixelsPerValue = (double)trackLength / valueRange;
            int trackLeft = this.trackRect.x;
            int trackRight = this.trackRect.x + (this.trackRect.width - 1);
            if (!this.drawInverted()) {
                xPosition = trackLeft;
                xPosition = (int)((long)xPosition + Math.round(pixelsPerValue * (value - min)));
            } else {
                xPosition = trackRight;
                xPosition = (int)((long)xPosition - Math.round(pixelsPerValue * (value - min)));
            }
            xPosition = Math.max(trackLeft, xPosition);
            xPosition = Math.min(trackRight, xPosition);
            return xPosition;
        }

        public int yPositionForValue(double value) {
            int yPosition;
            MultiSlider ms = (MultiSlider)this.slider;
            double min = ms.getDoubleMinimum();
            double max = ms.getDoubleMaximum();
            int trackLength = this.trackRect.height;
            double valueRange = max - min;
            double pixelsPerValue = (double)trackLength / valueRange;
            int trackTop = this.trackRect.y;
            int trackBottom = this.trackRect.y + (this.trackRect.height - 1);
            if (!this.drawInverted()) {
                yPosition = trackTop;
                yPosition = (int)((long)yPosition + Math.round(pixelsPerValue * (max - value)));
            } else {
                yPosition = trackTop;
                yPosition = (int)((long)yPosition + Math.round(pixelsPerValue * (value - min)));
            }
            yPosition = Math.max(trackTop, yPosition);
            yPosition = Math.min(trackBottom, yPosition);
            return yPosition;
        }

        public double doubleValueForYPosition(int yPos) {
            double value;
            MultiSlider ms = (MultiSlider)this.slider;
            double minValue = ms.getDoubleMinimum();
            double maxValue = ms.getDoubleMaximum();
            int trackLength = this.trackRect.height;
            int trackTop = this.trackRect.y;
            int trackBottom = this.trackRect.y + (this.trackRect.height - 1);
            if (yPos <= trackTop) {
                value = this.drawInverted() ? minValue : maxValue;
            } else if (yPos >= trackBottom) {
                value = this.drawInverted() ? maxValue : minValue;
            } else {
                int distanceFromTrackTop = yPos - trackTop;
                double valueRange = maxValue - minValue;
                double valuePerPixel = valueRange / (double)trackLength;
                double valueFromTrackTop = (double)distanceFromTrackTop * valuePerPixel;
                value = this.drawInverted() ? minValue + valueFromTrackTop : maxValue - valueFromTrackTop;
            }
            return value;
        }

        public double doubleValueForXPosition(int xPos) {
            double value;
            MultiSlider ms = (MultiSlider)this.slider;
            double minValue = ms.getDoubleMinimum();
            double maxValue = ms.getDoubleMaximum();
            int trackLength = this.trackRect.width;
            int trackLeft = this.trackRect.x;
            int trackRight = this.trackRect.x + (this.trackRect.width - 1);
            if (xPos <= trackLeft) {
                value = this.drawInverted() ? maxValue : minValue;
            } else if (xPos >= trackRight) {
                value = this.drawInverted() ? minValue : maxValue;
            } else {
                int distanceFromTrackLeft = xPos - trackLeft;
                double valueRange = maxValue - minValue;
                double valuePerPixel = valueRange / (double)trackLength;
                double valueFromTrackLeft = (double)distanceFromTrackLeft * valuePerPixel;
                value = this.drawInverted() ? maxValue - valueFromTrackLeft : minValue + valueFromTrackLeft;
            }
            return value;
        }

        protected Component getLowestValueLabel() {
            Enumeration keys;
            Dictionary dictionary = this.slider.getLabelTable();
            Component label = null;
            if (dictionary != null && (keys = dictionary.keys()).hasMoreElements()) {
                double lowestValue = (Double)keys.nextElement();
                while (keys.hasMoreElements()) {
                    double value = (Double)keys.nextElement();
                    lowestValue = Math.min(value, lowestValue);
                }
                label = (Component)dictionary.get(new Double(lowestValue));
            }
            return label;
        }

        protected Component getHighestValueLabel() {
            Enumeration keys;
            Dictionary dictionary = this.slider.getLabelTable();
            Component label = null;
            if (dictionary != null && (keys = dictionary.keys()).hasMoreElements()) {
                double highestValue = (Double)keys.nextElement();
                while (keys.hasMoreElements()) {
                    double value = (Double)keys.nextElement();
                    highestValue = Math.max(value, highestValue);
                }
                label = (Component)dictionary.get(new Double(highestValue));
            }
            return label;
        }

        public void paintLabels(Graphics g) {
            Rectangle labelBounds = this.labelRect;
            MultiSlider ms = (MultiSlider)this.slider;
            Dictionary dictionary = this.slider.getLabelTable();
            if (dictionary != null) {
                Enumeration keys = dictionary.keys();
                double minValue = ms.getDoubleMinimum();
                double maxValue = ms.getDoubleMaximum();
                while (keys.hasMoreElements()) {
                    Double key = (Double)keys.nextElement();
                    double value = key;
                    if (!(value >= minValue) || !(value <= maxValue)) continue;
                    Component label = (Component)dictionary.get(key);
                    if (this.slider.getOrientation() == 0) {
                        g.translate(0, labelBounds.y);
                        this.paintHorizontalLabel(g, value, label);
                        g.translate(0, -labelBounds.y);
                        continue;
                    }
                    int offset = 0;
                    offset = labelBounds.width - label.getPreferredSize().width;
                    g.translate(labelBounds.x + offset, 0);
                    this.paintVerticalLabel(g, value, label);
                    g.translate(-labelBounds.x - offset, 0);
                }
            }
        }

        public void paintTicks(Graphics g) {
            MultiSlider ms = (MultiSlider)this.slider;
            Rectangle tickBounds = this.tickRect;
            g.setColor(this.slider.getBackground());
            g.fillRect(tickBounds.x, tickBounds.y, tickBounds.width, tickBounds.height);
            g.setColor(Color.black);
            double maj = ms.getDoubleMajorTickSpacing();
            double min = ms.getDoubleMinorTickSpacing();
            if (this.slider.getOrientation() == 0) {
                double value;
                g.translate(0, tickBounds.y);
                int xPos = 0;
                if (min > 0.0) {
                    for (value = ms.getDoubleMinimum(); value <= ms.getDoubleMaximum(); value += min) {
                        xPos = this.xPositionForValue(value);
                        this.paintMinorTickForHorizSlider(g, tickBounds, xPos);
                    }
                }
                if (maj > 0.0) {
                    for (value = ms.getDoubleMinimum(); value <= ms.getDoubleMaximum(); value += maj) {
                        xPos = this.xPositionForValue(value);
                        this.paintMajorTickForHorizSlider(g, tickBounds, xPos);
                    }
                }
                g.translate(0, -tickBounds.y);
            } else {
                double value;
                g.translate(tickBounds.x, 0);
                int yPos = 0;
                if (min > 0.0) {
                    for (value = ms.getDoubleMinimum(); value <= ms.getDoubleMaximum(); value += min) {
                        yPos = this.yPositionForValue(value);
                        this.paintMinorTickForVertSlider(g, tickBounds, yPos);
                    }
                }
                if (maj > 0.0) {
                    for (value = ms.getDoubleMinimum(); value <= ms.getDoubleMaximum(); value += maj) {
                        yPos = this.yPositionForValue(value);
                        this.paintMajorTickForVertSlider(g, tickBounds, yPos);
                    }
                }
                g.translate(-tickBounds.x, 0);
            }
        }

        protected void paintHorizontalLabel(Graphics g, double value, Component label) {
            int labelCenter = this.xPositionForValue(value);
            int labelLeft = labelCenter - label.getPreferredSize().width / 2;
            g.translate(labelLeft, 0);
            label.paint(g);
            g.translate(-labelLeft, 0);
        }

        protected void paintVerticalLabel(Graphics g, double value, Component label) {
            int labelCenter = this.yPositionForValue(value);
            int labelTop = labelCenter - label.getPreferredSize().height / 2;
            g.translate(0, labelTop);
            label.paint(g);
            g.translate(0, -labelTop);
        }

        protected InputMap getInputMap(int condition) {
            if (condition == 0) {
                InputMap rtlKeyMap;
                InputMap keyMap = (InputMap)UIManager.get("Slider.focusInputMap");
                if (this.slider.getComponentOrientation().isLeftToRight() || (rtlKeyMap = (InputMap)UIManager.get("Slider.focusInputMap.RightToLeft")) == null) {
                    return keyMap;
                }
                rtlKeyMap.setParent(keyMap);
                return rtlKeyMap;
            }
            return null;
        }

        public class DoublePropertyChangeHandler
        implements PropertyChangeListener {
            public void propertyChange(PropertyChangeEvent e) {
                String propertyName = e.getPropertyName();
                if (propertyName.equals("model")) {
                    if (e.getOldValue() != null) {
                        ((DoubleBoundedRangeModel)e.getOldValue()).removeChangeListener(BasicMultiSliderUI.this.changeListener);
                    }
                    ((DoubleBoundedRangeModel)e.getNewValue()).addChangeListener(BasicMultiSliderUI.this.changeListener);
                    BasicMultiSliderUI.this.calculateThumbLocation();
                    BasicMultiSliderUI.this.slider.repaint();
                } else if (propertyName.equals("componentOrientation")) {
                    BasicMultiSliderUI.this.calculateGeometry();
                    BasicMultiSliderUI.this.slider.repaint();
                    InputMap km = BasicMultiSliderUI.this.getInputMap(0);
                    SwingUtilities.replaceUIInputMap(BasicMultiSliderUI.this.slider, 0, km);
                } else if (propertyName.equals("orientation") || propertyName.equals("inverted") || propertyName.equals("labelTable") || propertyName.equals("majorTickSpacing") || propertyName.equals("minorTickSpacing") || propertyName.equals("paintTicks") || propertyName.equals("paintTrack") || propertyName.equals("paintLabels")) {
                    BasicMultiSliderUI.this.calculateGeometry();
                    BasicMultiSliderUI.this.slider.repaint();
                }
            }
        }

        private class MultiFocusHandler
        implements FocusListener {
            private MultiFocusHandler() {
            }

            public void focusGained(FocusEvent e) {
                if (BasicMultiSliderUI.this.additonalUi != null) {
                    BasicMultiSliderUI.this.additonalUi.mSlider.repaint();
                }
            }

            public void focusLost(FocusEvent e) {
                if (BasicMultiSliderUI.this.additonalUi != null) {
                    BasicMultiSliderUI.this.additonalUi.mSlider.repaint();
                }
            }
        }

        private class MultiComponentAdapter
        extends ComponentAdapter {
            private MultiComponentAdapter() {
            }

            public void componentResized(ComponentEvent e) {
                BasicMultiSliderUI.this.calculateGeometry();
                if (BasicMultiSliderUI.this.additonalUi != null) {
                    BasicMultiSliderUI.this.additonalUi.mSlider.repaint();
                }
            }
        }
    }

    public static class AssistantUIManager {
        public static ComponentUI createUI(JComponent c) {
            String componentName = c.getClass().getName();
            int index = componentName.lastIndexOf(".") + 1;
            StringBuffer sb = new StringBuffer();
            sb.append(componentName.substring(0, index));
            String lookAndFeelName = UIManager.getLookAndFeel().getName();
            if (lookAndFeelName.startsWith("CDE/")) {
                lookAndFeelName = lookAndFeelName.substring(4, lookAndFeelName.length());
            }
            sb.append(lookAndFeelName);
            sb.append(componentName.substring(index));
            sb.append("UI");
            ComponentUI componentUI = AssistantUIManager.getInstance(sb.toString());
            if (componentUI == null) {
                sb.setLength(0);
                sb.append(componentName.substring(0, index));
                sb.append("Basic");
                sb.append(componentName.substring(index));
                sb.append("UI");
                componentUI = AssistantUIManager.getInstance(sb.toString());
            }
            return componentUI;
        }

        private static ComponentUI getInstance(String name) {
            try {
                return (ComponentUI)ExtensionManager.getClassForName(name).newInstance();
            }
            catch (ClassNotFoundException ex) {
            }
            catch (IllegalAccessException ex) {
                ex.printStackTrace();
            }
            catch (InstantiationException ex) {
                ex.printStackTrace();
            }
            return null;
        }

        public static void setUIName(JComponent c) {
            String key = c.getUIClassID();
            String uiClassName = (String)UIManager.get(key);
            if (uiClassName == null) {
                String componentName = c.getClass().getName();
                int index = componentName.lastIndexOf(".") + 1;
                StringBuffer sb = new StringBuffer();
                sb.append(componentName.substring(0, index));
                String lookAndFeelName = UIManager.getLookAndFeel().getName();
                if (lookAndFeelName.startsWith("CDE/")) {
                    lookAndFeelName = lookAndFeelName.substring(4, lookAndFeelName.length());
                }
                sb.append(lookAndFeelName);
                sb.append(key);
                UIManager.put(key, sb.toString());
            }
        }
    }
}

