/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.HtmlFrame;
import com.insightful.miner.NaiveBayesDialog;
import com.insightful.miner.NaiveBayesEngineNode;
import com.insightful.miner.PredictableNodeModel;
import com.insightful.miner.XMLTree;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import java.awt.Frame;
import java.util.Vector;
import org.w3c.dom.Element;

public class NaiveBayesNodeModel
extends PredictableNodeModel {
    public void initializeNodeModel() {
        XTProps props = this.getXTProps();
        props.set(new String[]{"copyInputColumns", "independent"}, props.getValue(new String[]{"copyInputColumns", "independent"}, "false"));
        props.set(new String[]{"copyInputColumns", "dependent"}, props.getValue(new String[]{"copyInputColumns", "dependent"}, "true"));
        props.set(new String[]{"copyInputColumns", "other"}, props.getValue(new String[]{"copyInputColumns", "other"}, "false"));
        props.set(new String[]{"newColumns", "probability"}, props.getValue(new String[]{"newColumns", "probability"}, "true"));
        props.set(new String[]{"newColumns", "classification"}, props.getValue(new String[]{"newColumns", "classification"}, "true"));
        props.set(new String[]{"newColumns", "agreement"}, props.getValue(new String[]{"newColumns", "agreement"}, "false"));
    }

    public boolean isPropertiesValid() {
        boolean propsValid;
        XTProps props = this.getXTProps();
        Vector columnRoles = props.getSubPropertyValues(NaiveBayesEngineNode.COLUMN_ROLES_ATTRIBUTE_TAG);
        try {
            if (this.isInputValid()) {
                XTMetaData md = this.getInputMetaData(0);
                Vector columns = props.getSubProperties(NaiveBayesEngineNode.COLUMN_ROLES_ATTRIBUTE_TAG);
                for (int i = columns.size() - 1; i >= 0; --i) {
                    if (md.nameToOrdinal((String)columns.get(i)) != -1) continue;
                    return false;
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        boolean bl = propsValid = columnRoles.indexOf(XTMetaData.DEPENDENT_ROLE_ATTRIBUTE_TAG) != -1 && columnRoles.indexOf(XTMetaData.INDEPENDENT_ROLE_ATTRIBUTE_TAG) != -1;
        if (propsValid) {
            return true;
        }
        try {
            if (this.isInputValid()) {
                XTMetaData md = this.getInputMetaData(0);
                int numColumns = md.getNumColumns();
                boolean depCheck = false;
                boolean indepCheck = false;
                for (int i = 0; i < numColumns; ++i) {
                    if (!md.isCategoricalColumn(i)) continue;
                    String role = md.getColumnRole(i);
                    if (!depCheck && role.equals(XTMetaData.DEPENDENT_ROLE_ATTRIBUTE_TAG)) {
                        depCheck = true;
                    }
                    if (!indepCheck && role.equals(XTMetaData.INDEPENDENT_ROLE_ATTRIBUTE_TAG)) {
                        indepCheck = true;
                    }
                    if (!indepCheck || !depCheck) continue;
                    return true;
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return false;
    }

    public void showPropertiesDialog(boolean modality) {
        NaiveBayesDialog dialog = NaiveBayesDialog.getInstance();
        dialog.setModal(modality);
        dialog.show(this);
    }

    public String getModelOutputType() {
        return "classification";
    }

    public String getModelAlgorithm() {
        return "naiveBayes";
    }

    public void showView(Frame frame) {
        XTMetaData metaData = null;
        XMLTree fullCache = null;
        XTProps dataCache = null;
        XTProps dialogProps = null;
        try {
            dialogProps = this.getXTProps();
            metaData = this.getInputMetaData(0);
            fullCache = this.getFittedModel();
            dataCache = new XTProps((Element)fullCache.getXML().getElementsByTagName(XTProps.XT_PROPERTY_NODE_TAG).item(0));
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        String htmlString = NaiveBayesNodeModel.getView(dataCache, metaData, this.getLabelText());
        new HtmlFrame(htmlString);
    }

    public static String getView(XTProps dataCache, XTMetaData metaData, String title) {
        String[] path;
        Vector indepColumns = dataCache.getSubProperties(NaiveBayesEngineNode.COUNTS_ATTRIBUTE_TAG);
        int numIndepColumns = indepColumns.size();
        String depColumn = dataCache.getValue(NaiveBayesEngineNode.DEPENDENT_COLUMN_ATTRIBUTE_TAG);
        Vector depLevels = dataCache.getSubProperties(NaiveBayesEngineNode.DEPENDENT_COLUMN_ATTRIBUTE_TAG);
        int num = depLevels.size();
        if (num > 0) {
            depLevels.remove(num - 1);
            depLevels.remove(num - 2);
        }
        if (dataCache.getInt(path = new String[]{NaiveBayesEngineNode.DEPENDENT_COLUMN_ATTRIBUTE_TAG, "NaN"}, 0) > 0) {
            depLevels.add(path[1]);
        }
        StringBuffer htmlString = new StringBuffer();
        StringBuffer linkage = new StringBuffer();
        linkage.append("<UL><FONT SIZE=4>Tables with non-zero counts: </FONT>\n");
        for (int i = 0; i < numIndepColumns; ++i) {
            String indepColumn = (String)indepColumns.get(i);
            Vector indepLevels = metaData.getCategoricalDataFieldLevels(indepColumn);
            indepLevels.add("NaN");
            String caption = indepColumn + " and " + depColumn;
            NaiveBayesNodeModel.createHTMLTable(caption, depColumn, depLevels, indepColumn, indepLevels, dataCache, i, htmlString, linkage);
        }
        StringBuffer output = new StringBuffer();
        output.append("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">\n");
        output.append("<HTML>\n<TITLE>" + title + " Summary</TITLE>");
        output.append("<style type=\"text/css\">" + XMLTree.getCSSText() + "</style>");
        output.append("<P><H1 class=\"title\">" + title + " Summary</H1>\n</P><BR>");
        output.append("<H2 class=\"subtitle\">Dependent Column - " + depColumn + "</H2></P>" + "<BR>");
        output.append(linkage.toString() + "</UL>");
        output.append(htmlString.toString());
        output.append("</HTML>\n");
        return output.toString();
    }

    private static void createHTMLTable(String caption, String depColumn, Vector depLevels, String indepColumn, Vector indepLevels, XTProps dataCache, int linkNum, StringBuffer buffer, StringBuffer linkage) {
        boolean needsLink = false;
        buffer.append("<BR><BR>\n");
        buffer.append("<A NAME=\"");
        buffer.append(linkNum);
        buffer.append("\">\n");
        buffer.append("\t<table width=\"85%\" align=\"center\" border=\"0\" cellspacing=\"0\" cellpadding=\"3\">");
        buffer.append("\t\t<tr>");
        buffer.append("\t\t\t<td class=\"tableBG\">");
        if (!caption.equals("")) {
            buffer.append("\t\t\t\t\t<p><b><font size=\"4\" class=\"tableHead\">" + caption + "</font></b></p>");
        }
        buffer.append("\t\t\t\t\t\t<table width=\"100%\" border=\"0\" class=\"content\" cellspacing=\"1\">");
        buffer.append("\t\t\t\t\t\t\t<tbody>");
        int extraCols = 2;
        int numDepLevels = depLevels.size();
        int numIndepLevels = indepLevels.size();
        int[] colTotals = new int[numDepLevels];
        String[] path = new String[4];
        String[] nanPath = new String[3];
        nanPath[0] = path[0] = NaiveBayesEngineNode.COUNTS_ATTRIBUTE_TAG;
        nanPath[1] = path[1] = indepColumn;
        String[] classStr = new String[]{"blueBG", "whiteBG", "greyBG"};
        for (int i = 0; i < numIndepLevels + extraCols; ++i) {
            buffer.append("\t\t<TR>\n");
            if (i >= extraCols) {
                path[2] = (String)indepLevels.get(i - extraCols);
            }
            String str = classStr[i % 2 == 0 ? 1 : 2];
            if (i == 0) {
                nanPath[2] = (String)indepLevels.lastElement();
                if (!dataCache.isPathValid(nanPath)) {
                    --numIndepLevels;
                }
            }
            for (int j = 0; j < numDepLevels + extraCols; ++j) {
                if (j >= extraCols) {
                    path[3] = (String)depLevels.get(j - extraCols);
                }
                if (i < 2 && j < extraCols) {
                    buffer.append("\t\t\t<TD></TD>\n");
                } else {
                    if (i == 0 && j == extraCols) {
                        buffer.append("\t\t\t<TD class=\"" + classStr[0] + "\" COLSPAN=");
                        buffer.append(numDepLevels);
                        buffer.append("><CENTER><B><FONT SIZE=4>");
                        buffer.append(depColumn);
                        buffer.append("</FONT></B></CENTER></TD>\n");
                        break;
                    }
                    if (i == 1 && j >= extraCols) {
                        buffer.append("\t\t\t<TD class=\"" + classStr[0] + "\"><CENTER><I><FONT SIZE=3>");
                        buffer.append((String)depLevels.get(j - extraCols));
                        buffer.append("</FONT></I></CENTER></TD>\n");
                    } else if (i == 2 && j == 0) {
                        buffer.append("\t\t\t<TD class=\"" + classStr[0] + "\" ROWSPAN=");
                        buffer.append(numIndepLevels);
                        buffer.append("><CENTER><B><FONT SIZE=4>");
                        buffer.append(indepColumn);
                        buffer.append("</FONT></B></CENTER></TD>\n");
                    } else if (i > 1 && j == 1) {
                        buffer.append("\t\t\t<TD class=\"" + classStr[0] + "\"><CENTER><I><FONT SIZE=3>");
                        buffer.append(indepLevels.get(i - extraCols));
                        buffer.append("</FONT></I></CENTER></TD>\n");
                    } else if (i > 1 && j >= extraCols) {
                        int count = (int)dataCache.getDouble(path, 0.0);
                        if (!needsLink && count > 0) {
                            needsLink = true;
                        }
                        int n = j - extraCols;
                        colTotals[n] = colTotals[n] + count;
                        buffer.append("\t\t\t<TD align=\"right\" class=\"" + str + "\">");
                        buffer.append(count);
                        buffer.append("</TD>\n");
                    }
                }
                if (i != numIndepLevels + extraCols - 1 || j != numDepLevels + extraCols - 1) continue;
                String str2 = classStr[i % 2 == 0 ? 2 : 1];
                buffer.append("\t\t</TR>\n");
                buffer.append("\t\t<TR>\n");
                buffer.append("\t\t\t<TD class=\"" + classStr[0] + "\" COLSPAN=2><CENTER><B><FONT SIZE=3>");
                buffer.append("Totals</FONT></B></CENTER></TD>\n");
                int total = 0;
                for (int k = 0; k < numDepLevels; ++k) {
                    buffer.append("\t\t\t<TD align=\"right\" class=\"" + str2 + "\">");
                    buffer.append(colTotals[k]);
                    buffer.append("</TD>\n");
                    total += colTotals[k];
                }
                buffer.append("\t\t\t<TD></TD>\n");
            }
            buffer.append("\t\t</TR>\n");
        }
        buffer.append("\t\t\t\t\t\t\t</tbody>");
        buffer.append("\t\t\t\t\t\t</table>");
        buffer.append("\t\t\t</td>");
        buffer.append("\t\t</tr>");
        buffer.append("\t</table>");
        buffer.append("</A>\n");
        if (needsLink) {
            linkage.append("<LI><A HREF=\"#");
            linkage.append(linkNum);
            linkage.append("\">");
            linkage.append(caption);
            linkage.append("</A></LI>\n");
        }
    }
}

