/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.cnkjava.CNKBackingFileBuf;
import com.insightful.cnkjava.CNKMemoryBuf;
import com.insightful.cnkjava.CNKObj;
import com.insightful.cnkjava.CNKPipeline;
import com.insightful.cnkjava.CNKProc;
import com.insightful.cnkjava.CNKProcSplusTransform;
import com.insightful.miner.DataCacheRowBuf;
import com.insightful.miner.EngineNetworkManager;
import com.insightful.miner.MinerApp;
import com.insightful.miner.ModifyColumnsEngineNode;
import com.insightful.miner.ReadOtherFileEngineNode;
import com.insightful.miner.SplusScriptEngineNode;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import com.insightful.splus.SplusDataResult;
import com.insightful.splus.util.StringUtilities;
import java.io.EOFException;
import java.io.File;
import java.io.RandomAccessFile;

public class ReadSplusFileEngineNode
extends ReadOtherFileEngineNode {
    public static final String FILE_TYPE_SDD = "splusSDDFile";
    public static final String FILE_TYPE_CHAPTER = "splusChapterDirectory";
    public static final String VAR_NAME_TAG = "splusVarName";
    public static final String DEFAULT_VAR_NAME = "temp";
    public static final String SDD_INFO_CACHE_NAME = "sddInfo";
    public static final String SDD_FILE_NAME_TAG = "sddFileName";
    public static final String SDD_ERROR_TAG = "sddError";
    public static final String SDD_TEMP_DIR_CACHE_NAME = "sddDir";
    public static final String PREVIEW_DCF_CACHE_NAME = "previewDCF";
    private static String m_evalError = null;

    public void invalidateNodeState() {
        this.setNodeCache("datasourceMD", null);
        this.setNodeCache("datasourcePreview", null);
        this.setNodeCache("datasourceInfo", null);
        this.setNodeCache("datasourceProps", null);
        this.setNodeCache(SDD_INFO_CACHE_NAME, null);
        this.clearSDDTemp();
        this.deletePreviewDCF();
    }

    public String getError() {
        XTProps errProps = this.getNodeCacheXTProps("datasourceInfo");
        if (errProps == null) {
            return "";
        }
        String err = errProps.getValue("error", "");
        return err;
    }

    public boolean testOK() {
        this.updateDataSourceInfo(this.getNodeProperties(), false);
        return this.getError().equals("");
    }

    public boolean hasDynamicOutputs() {
        return !this.testOK();
    }

    public void setDataSourceError(String err) {
        try {
            XTProps info = new XTProps();
            info.set("error", err);
            this.setNodeCache("datasourceInfo", info);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void updateDataSourceInfo(XTProps currentProps, boolean getPreview) {
        try {
            XTProps mdProps = this.getNodeCacheXTProps("datasourceProps");
            if (mdProps == null || !mdProps.equals(currentProps) || getPreview) {
                this.setNodeCache("datasourceMD", null);
                this.setNodeCache("datasourcePreview", null);
                this.setNodeCache("datasourceInfo", null);
                this.setNodeCache("datasourceProps", null);
                XTProps info = new XTProps();
                if (!MinerApp.isSplusLicensed() && !MinerApp.isInBDL()) {
                    this.setDataSourceError("S-PLUS Library not installed.  Cannot read data.");
                    return;
                }
                String varName = this.getVarName(currentProps);
                if (varName.equals("")) {
                    this.setDataSourceError("empty variable name");
                    return;
                }
                XTMetaData md = new XTMetaData();
                XTProps preview = null;
                String errorString = "";
                String[] splusDataDirInfo = this.getSplusDataDirInfo(currentProps);
                if (!splusDataDirInfo[1].equals("")) {
                    this.setDataSourceError(splusDataDirInfo[1]);
                    return;
                }
                String splusDir = splusDataDirInfo[0];
                String fnBody = this.getReadDataFnBody(splusDir, varName);
                this.printlnDebug("executing Splus file read test to get meta-data");
                CNKProcSplusTransform proc = this.getNetworkManager().createSplusProc();
                if (!proc.getCreateOK()) {
                    this.setDataSourceError(proc.getCreateError());
                    return;
                }
                proc.setDefaultStringBytes(this.getWorksheetPropertiesManager().getDefaultStringSize());
                proc.setNumRows(10);
                proc.setUseFlexibleTransform(true);
                proc.setTransform(fnBody);
                proc.setTransformTempVariable(SplusScriptEngineNode.getTempSplusVar(this));
                CNKMemoryBuf buf = new CNKMemoryBuf();
                buf.setNumRows(0);
                buf.setNumColumns(0);
                proc.setOutbuf(0, buf);
                buf.init();
                proc.init();
                proc.doTransformTest();
                if (proc.hasError()) {
                    errorString = ReadSplusFileEngineNode.getCNKObjErrors(proc);
                    this.printlnDebug("finished Splus file read test: error: " + errorString);
                } else {
                    SplusScriptEngineNode.setMetaDataFromBuf(md, buf);
                    this.printlnDebug("finished Splus file read test: read " + md.getNumColumns() + " columns");
                }
                buf.destroyCNKObj();
                proc.destroyCNKObj();
                info.set("error", errorString);
                int numRowsToPreview = currentProps.getInt("rowsToPreview", 10);
                if (errorString.equals("") && getPreview && numRowsToPreview > 0) {
                    String dcfFileName = this.getPreviewDCFName();
                    XTMetaData mdWithLevels = this.writePreviewToDCF(dcfFileName, numRowsToPreview, varName, splusDir, md);
                    if (mdWithLevels != null) {
                        preview = this.readDCFToXTProps(dcfFileName, mdWithLevels, numRowsToPreview);
                    }
                    this.deletePreviewDCF();
                }
                this.setNodeCache("datasourceProps", currentProps);
                this.setNodeCache("datasourceMD", md);
                this.setNodeCache("datasourceInfo", info);
                this.setNodeCache("datasourcePreview", preview);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.setNodeCache("datasourceProps", null);
        }
    }

    private XTMetaData writePreviewToDCF(String dcfFileName, int numRowsToPreview, String varName, String splusDir, XTMetaData oldMD) throws Exception {
        this.deletePreviewDCF();
        XTMetaData md = (XTMetaData)oldMD.clone();
        int numColumns = md.getNumColumns();
        int bytesPerRow = DataCacheRowBuf.getDCFBytesPerRow(md);
        int maxRowsForBuf = this.getNetworkManager().limitRowsPerChunk(this.getNodeID(), bytesPerRow);
        String fnBody = this.getReadDataFnBody(splusDir, varName, numRowsToPreview);
        CNKProcSplusTransform proc = this.getNetworkManager().createSplusProc();
        proc.setDefaultStringBytes(this.getWorksheetPropertiesManager().getDefaultStringSize());
        proc.setNumRows(bytesPerRow);
        proc.setUseFlexibleTransform(true);
        proc.setTransform(fnBody);
        proc.setTransformTempVariable(SplusScriptEngineNode.getTempSplusVar(this));
        CNKBackingFileBuf buf = new CNKBackingFileBuf();
        buf.setNumRows(maxRowsForBuf);
        buf.setNumColumns(numColumns);
        EngineNetworkManager.setBufColumnDescription(buf, md, this.getWorksheetPropertiesManager().getMaxCategoricalLevels());
        buf.setFileName(dcfFileName);
        proc.setOutbuf(0, buf);
        CNKPipeline pip = new CNKPipeline();
        pip.add(proc);
        pip.add(buf);
        pip.init();
        boolean ok = true;
        while (pip.anyProcReady()) {
            if (this.isInterruptRequested()) {
                ok = false;
                break;
            }
            try {
                pip.execute(1L);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                ok = false;
                break;
            }
        }
        if (proc.hasError()) {
            this.printlnDebug("errors reading preview to DCF file " + dcfFileName + ": " + ReadSplusFileEngineNode.getCNKObjErrors(proc));
            ok = false;
        }
        buf.closeBackingFile();
        if (ok) {
            for (int col = 0; col < numColumns; ++col) {
                if (!md.isCategoricalColumn(col)) continue;
                String[] levels = buf.getColumnLevelStrings(col);
                md.setCategoricalLevels(md.ordinalToName(col), levels);
            }
        }
        pip.destroyPipeline(true);
        if (!ok) {
            return null;
        }
        return md;
    }

    private XTProps readDCFToXTProps(String dcfFileName, XTMetaData md, int numRowsToPreview) {
        RandomAccessFile in = null;
        XTProps preview = null;
        try {
            preview = new XTProps();
            String[] path = new String[]{"previewRows", "row", "col"};
            in = new RandomAccessFile(dcfFileName, "r");
            DataCacheRowBuf rowBuf = new DataCacheRowBuf(md, true);
            int numColumnsToPreview = md.getNumColumns();
            for (int row = 0; row < numRowsToPreview; ++row) {
                rowBuf.readRowUnsafe(in);
                path[1] = Integer.toString(row);
                for (int col = 0; col < numColumnsToPreview; ++col) {
                    path[2] = Integer.toString(col);
                    String val = "";
                    if (rowBuf.isDouble(col)) {
                        double dVal = rowBuf.getDouble(col);
                        if (!CNKObj.isDoubleNA(dVal)) {
                            val = this.getNetworkManager().getWorksheetPropertiesManager().formatFreeDouble(dVal);
                        }
                    } else if (rowBuf.isTimeDate(col)) {
                        long td = rowBuf.getTimeDate(col);
                        if (!CNKObj.isTimeDateNA(td)) {
                            val = this.getNetworkManager().getWorksheetPropertiesManager().getDateFormatter().convertTimeDateToString(td);
                        }
                    } else if (rowBuf.isFactor(col)) {
                        int levelNum = rowBuf.getLevelNum(col);
                        if (!CNKObj.isLevelNumNA(levelNum)) {
                            String levelString;
                            val = levelString = md.getCategoricalDataFieldLevel(col, levelNum);
                        }
                    } else {
                        val = rowBuf.getString(col);
                    }
                    if (CNKObj.isStringNA(val)) {
                        val = "";
                    }
                    preview.set(path, val);
                }
            }
        }
        catch (EOFException eofEx) {
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return preview;
    }

    public String getReadDataFnBody(String splusDir, String varName) {
        return this.getReadDataFnBody(splusDir, varName, -1);
    }

    public String getReadDataFnBody(String splusDir, String varName, int previewRows) {
        String getPreviewRowsCode = "";
        if (previewRows >= 0) {
            getPreviewRowsCode = "val <- val[seq(1,length=min(nrow(val)," + previewRows + ")),]\n";
        }
        String fnBody = "function(IM){\nv <- \"" + StringUtilities.escapeSpecialCharacters((String)varName) + "\"\n" + "sdir <- \"" + StringUtilities.escapeSpecialCharacters((String)splusDir) + "\"\n" + "if (!is.dir(sdir)) {return(list(error=paste(\"directory\",sdir,\"not found\")))}\n" + "if (!isChapter(sdir)) {return(list(error=paste(\"directory\",sdir,\"is not a valid S-PLUS chapter\")))}\n" + "if (!exists(v,where=sdir)) {return(list(error=paste(\"variable\",v,\"not found\")))}\n" + "val <- get(v,where=sdir)\n" + "if(is.null(val)){return(list(error=paste(\"variable\",v,\"is NULL\")))}\n" + "if (!(is.data.frame(val)||is.matrix(val)||is.atomic(val))){return(list(error=paste(v,\"cannot be read as a data frame\")))}\n" + "val <- as.data.frame(val,stringsAsFactors=F)\n" + getPreviewRowsCode + "list(out1=val)}\n";
        return fnBody;
    }

    public static String getCNKObjErrors(CNKObj obj) {
        StringBuffer buf = new StringBuffer();
        int numMessages = obj.getNumMessages();
        for (int i = 0; i < numMessages; ++i) {
            String msg = obj.getMessage(i);
            int severity = obj.getMessageSeverity(i);
            if (severity != 4) continue;
            if (buf.length() > 0) {
                buf.append("\n");
            }
            buf.append(msg);
        }
        return buf.toString();
    }

    public String getAbsoluteFileName(XTProps props) {
        String fileName = this.getNetworkManager().getAbsolutePath(props.getValue("filePath", ""));
        return fileName;
    }

    public String[] getSplusDataDirInfo(XTProps props) {
        String fileName = this.getAbsoluteFileName(props);
        String[] ret = new String[]{fileName, ""};
        if (fileName.equals("")) {
            ret[1] = "empty file name";
            this.clearSDDTemp();
            return ret;
        }
        File f = new File(fileName);
        if (!f.exists()) {
            ret[1] = "file doesn't exist: " + fileName;
            this.clearSDDTemp();
            return ret;
        }
        if (this.isSDDFile(props)) {
            if (!f.isFile()) {
                this.clearSDDTemp();
                ret[1] = "file name is not a regular file: " + fileName;
            } else {
                ret = this.readSDDTempSource(fileName);
            }
        } else {
            this.clearSDDTemp();
            if (!f.isDirectory()) {
                ret[1] = "file name is not a directory: " + fileName;
            }
        }
        return ret;
    }

    public boolean isSDDFile(XTProps props) {
        String type = props.getValue("fileType", FILE_TYPE_CHAPTER);
        return type.equals(FILE_TYPE_SDD);
    }

    public void deletePreviewDCF() {
        try {
            String dcf = this.getPreviewDCFName();
            File f = new File(dcf);
            if (f.exists()) {
                this.printlnDebug("deleting preview DCF file " + dcf);
                f.delete();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void clearSDDTemp() {
        String sddTempDirName = this.getSDDTempDirName();
        File f = new File(sddTempDirName);
        if (f.exists()) {
            this.printlnDebug("deleting SDD temp directory " + sddTempDirName);
            this.deleteRecursively(sddTempDirName);
        }
        this.setNodeCache(SDD_INFO_CACHE_NAME, null);
    }

    public void deleteRecursively(String fileName) {
        try {
            File f = new File(fileName);
            if (!f.exists()) {
                return;
            }
            if (f.isFile()) {
                f.delete();
            } else if (f.isDirectory()) {
                String[] sub = f.list();
                for (int i = 0; i < sub.length; ++i) {
                    this.deleteRecursively(fileName + "/" + sub[i]);
                }
                f.delete();
            }
        }
        catch (Exception ex) {
            this.printlnDebug("error deleting: " + ex);
        }
    }

    public String getCreateChapterCommand(String dirName) {
        String escapedDirName = StringUtilities.escapeSpecialCharacters((String)dirName);
        if (MinerApp.isWindowsOS()) {
            return "createChapter(\"" + escapedDirName + "\")";
        }
        return "shell(\"$SHOME/cmd/CHAPTER -d " + escapedDirName + "\", output.to.S=T)";
    }

    public String[] readSDDTempSource(String fileName) {
        try {
            String sddTempDirName = this.getSDDTempDirName();
            String[] ret = new String[]{sddTempDirName, ""};
            XTProps sddInfo = this.getNodeCacheXTProps(SDD_INFO_CACHE_NAME);
            if (sddInfo == null) {
                sddInfo = new XTProps();
            }
            String sddFileName = sddInfo.getValue(SDD_FILE_NAME_TAG, "");
            String sddError = sddInfo.getValue(SDD_ERROR_TAG, "");
            if (fileName.equals(sddFileName)) {
                ret[1] = sddError;
                return ret;
            }
            this.clearSDDTemp();
            this.printlnDebug("creating SDD temp directory " + sddTempDirName + " for SDD file " + fileName);
            String createChapterCmd = this.getCreateChapterCommand(sddTempDirName);
            String escapedSDDFileName = StringUtilities.escapeSpecialCharacters((String)fileName);
            String escapedSDDTempDir = StringUtilities.escapeSpecialCharacters((String)sddTempDirName);
            String splusExpr = "{" + createChapterCmd + ";" + "data.restore(\"" + escapedSDDFileName + "\",where=\"" + escapedSDDTempDir + "\")}";
            String err = this.splusEvalGetError(splusExpr);
            if (err != null) {
                ret[1] = err;
                this.printlnDebug("error creating SDD temp directory: " + ret[1]);
            } else {
                this.printlnDebug("finished creating SDD temp directory");
            }
            sddInfo.set(SDD_FILE_NAME_TAG, fileName);
            sddInfo.set(SDD_ERROR_TAG, ret[1]);
            this.setNodeCache(SDD_INFO_CACHE_NAME, sddInfo);
            return ret;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.setNodeCache(SDD_INFO_CACHE_NAME, null);
            return new String[]{"", "unknown error"};
        }
    }

    public String getSDDTempDirName() {
        String filename = this.getNetworkManager().getNodeCacheFileName(this.getNodeID(), SDD_TEMP_DIR_CACHE_NAME);
        return filename;
    }

    public String getPreviewDCFName() {
        String filename = this.getNetworkManager().getNodeCacheFileName(this.getNodeID(), PREVIEW_DCF_CACHE_NAME);
        return filename;
    }

    public String getVarName(XTProps props) {
        String varName = props.getValue(VAR_NAME_TAG, "");
        return varName;
    }

    public CNKProc procCreate() throws Exception {
        XTProps props;
        String varName;
        if (!this.testOK()) {
            this.invalidateNodeState();
            if (!this.testOK()) {
                throw new Exception(this.getError());
            }
        }
        if ((varName = this.getVarName(props = this.getNodeProperties())).equals("")) {
            throw new Exception("variable name empty");
        }
        String[] splusDataDirInfo = this.getSplusDataDirInfo(props);
        if (!splusDataDirInfo[1].equals("")) {
            throw new Exception(splusDataDirInfo[1]);
        }
        String fnBody = this.getReadDataFnBody(splusDataDirInfo[0], varName);
        CNKProcSplusTransform proc = this.getNetworkManager().createSplusProc();
        proc.setDefaultStringBytes(this.getWorksheetPropertiesManager().getDefaultStringSize());
        proc.setUseFlexibleTransform(true);
        proc.setTransform(fnBody);
        proc.setTransformTempVariable(SplusScriptEngineNode.getTempSplusVar(this));
        proc.setUseOutputColumnMap(true);
        proc.clearOutputColumnMap();
        XTMetaData fileMD = this.getDataSourceMetaData();
        int[] outputColumnToInputColumnMap = ModifyColumnsEngineNode.getOutputColumnToInputColumnArray(props, fileMD);
        for (int outCol = 0; outCol < outputColumnToInputColumnMap.length; ++outCol) {
            int inCol = outputColumnToInputColumnMap[outCol];
            if (inCol < 0) {
                throw new Exception("bad column map outCol=" + outCol + ", inCol=" + inCol);
            }
            proc.addOutputColumnMap(inCol);
        }
        return proc;
    }

    public void procSetProperties(CNKProc proc) throws Exception {
    }

    public long procGetEstimatedNumRows(CNKProc proc) {
        return -1L;
    }

    public XTProps getAllTableNames(XTProps currentProps, int maxTableNames) {
        XTProps tnprops = null;
        try {
            tnprops = new XTProps();
            String[] splusDataDirInfo = this.getSplusDataDirInfo(currentProps);
            if (!splusDataDirInfo[1].equals("")) {
                throw new Exception(splusDataDirInfo[1]);
            }
            String fileName = splusDataDirInfo[0];
            this.getTableNamesFromSplusDir(tnprops, fileName, maxTableNames);
        }
        catch (Exception ex) {
            tnprops.set("tableNameErrors", ex.getMessage() == null ? "Unknown error" : ex.getMessage());
        }
        return tnprops;
    }

    public void getTableNamesFromSplusDir(XTProps tnprops, String fileName, int maxTableNames) throws Exception {
        boolean[] bvals;
        File file = new File(fileName);
        if (fileName.equals("")) {
            throw new Exception("empty file name");
        }
        if (!file.exists()) {
            throw new Exception("Non-existant file: " + fileName);
        }
        if (!file.isDirectory()) {
            throw new Exception("Not a directory: " + fileName);
        }
        String sdir = StringUtilities.escapeSpecialCharacters((String)fileName);
        String splusExpr = "isChapter(\"" + sdir + "\")";
        SplusDataResult result = MinerApp.eval(splusExpr);
        if (!result.hasError() && !(bvals = result.getBooleanData())[0]) {
            throw new Exception("directory " + fileName + " is not a valid S-PLUS chapter");
        }
        splusExpr = "{(function(sdir){\nnm<-objects(where=sdir)\nfn<-function(nm,sdir){inherits(get(nm,where=sdir),\"data.frame\",which=F)}\nok<-sapply(nm,fn,sdir,simplify=T)\nnm[ok]})(\"" + sdir + "\")" + "}";
        result = MinerApp.eval(splusExpr);
        if (result.hasError()) {
            throw new Exception(result.getError());
        }
        String[] allVars = result.getStringData();
        int numVars = allVars.length;
        this.printlnDebug("data source has " + numVars + " variable names");
        int propsIndex = 0;
        for (int i = 0; i < numVars && propsIndex < maxTableNames; ++i) {
            String tableName = allVars[i];
            tnprops.set("tableNames", Integer.toString(propsIndex++), tableName);
        }
        tnprops.set("tableNameCount", propsIndex);
        this.printlnDebug("retrieved " + propsIndex + " table names");
    }

    public String splusEvalGetError(String splusExpr) {
        if (MinerApp.getSession() != null) {
            SplusDataResult result = MinerApp.eval(splusExpr);
            if (result.hasError()) {
                return result.getError();
            }
            return null;
        }
        if (MinerApp.isInBDL()) {
            m_evalError = "unknown error string";
            String fullExpr = "as.character(try({" + splusExpr + ";''}))";
            fullExpr = "{.JavaMethod('com.insightful.miner.ReadSplusFileEngineNode','setEvalError', '(Ljava/lang/String;)V'," + fullExpr + ");NULL}";
            try {
                CNKProcSplusTransform proc = this.getNetworkManager().createSplusProc();
                proc.setTransform(fullExpr);
                proc.setUseFlexibleTransform(true);
                String tempVar = SplusScriptEngineNode.getTempSplusVar(this);
                proc.setTransformTempVariable(tempVar);
                proc.setVarFrameNum(0);
                boolean ok = this.getNetworkManager().executeCNKProcBase(this.getNodeID(), proc, new CNKBackingFileBuf[0], new CNKBackingFileBuf[0], 10, false);
            }
            catch (Exception ex) {
                m_evalError = "Error running S-PLUS expression: " + ex;
            }
            if (m_evalError != null && m_evalError.length() > 0) {
                return m_evalError;
            }
            return null;
        }
        return "Unable to evaluate S-PLUS expression";
    }

    public static void setEvalError(String val) {
        m_evalError = val;
    }
}

