/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.ActivityNodeArea;
import com.insightful.miner.ActivityNodeModel;
import com.insightful.miner.AppAction;
import com.insightful.miner.ColumnFilterGenerator;
import com.insightful.miner.ColumnFilterTools;
import com.insightful.miner.CorrelationsNodeModel;
import com.insightful.miner.FilterColumnsNodeModel;
import com.insightful.miner.GridDataSource;
import com.insightful.miner.GridViewerComposite;
import com.insightful.miner.MinerApp;
import com.insightful.miner.ModifiableTypeGridViewerComposite;
import com.insightful.miner.ModifiableViewerFrame;
import com.insightful.miner.ModifyColumnsNodeModel;
import com.insightful.miner.Retrievable;
import com.insightful.miner.XTNetwork;
import com.insightful.miner.XTProps;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import org.w3c.dom.Element;

public class TableViewNodeModel
extends ActivityNodeModel {
    private GridDataSource m_dataSource;
    private GridViewerComposite m_gridViewer;

    public TableViewNodeModel(Element elt) {
        super(elt);
    }

    public TableViewNodeModel(XTNetwork.NodeInfo elt) {
        super(elt);
    }

    public static TableViewer getTableViewer(String title, int id, Retrievable dataSource, boolean secondHeader, ActivityNodeModel model, boolean modifiableType) throws Exception {
        return new TableViewer(title, id, dataSource, secondHeader, model, modifiableType);
    }

    protected static class TableViewer
    extends ModifiableViewerFrame {
        private Retrievable m_dataSource;
        private GridViewerComposite m_gridViewer;
        private ActivityNodeModel m_model;

        public TableViewer(String title, int id, Retrievable dataSource, boolean secondHeader, ActivityNodeModel model, boolean modifiableType) throws Exception {
            super(title);
            int decimalPlaces;
            this.m_model = model;
            int tableWidth = 400;
            int tableHeight = 400;
            int frameExtraWidth = 75;
            int frameExtraHeight = 92;
            if (secondHeader) {
                frameExtraHeight += GridViewerComposite.CELL_HEIGHT + 1;
            }
            this.m_dataSource = dataSource;
            long totalHeight = dataSource.getTotalRows() * (long)GridViewerComposite.CELL_HEIGHT;
            int numCols = dataSource.getTotalColumns();
            int totalWidth = 0;
            for (int i = 0; i < numCols && (totalWidth += dataSource.getColumnWidth(i) + 10) <= 800; ++i) {
            }
            if (totalWidth < 800) {
                tableWidth = totalWidth + dataSource.getRowLabelWidth();
                if (totalHeight < 600L) {
                    frameExtraWidth -= 17;
                }
            }
            if (totalHeight < 600L) {
                tableHeight = (int)totalHeight;
                if (totalWidth < 800) {
                    frameExtraHeight -= 17;
                }
            }
            if ((decimalPlaces = MinerApp.getWorksheetPropertiesManager().getNumDigitsInViewers()) > 0) {
                this.m_dataSource.setRounding(true, decimalPlaces);
            } else {
                this.m_dataSource.setRounding(false);
            }
            this.m_gridViewer = modifiableType ? new ModifiableTypeGridViewerComposite(this.m_dataSource, tableWidth, tableHeight) : new GridViewerComposite(this.m_dataSource, tableWidth, tableHeight);
            this.m_gridViewer.showSecondHeader(secondHeader);
            this.setIconImage(MinerApp.getResourceManager().getImage("minerapp.gif"));
            this.getContentPane().add(this.m_gridViewer);
            JMenuBar menuBar = new JMenuBar();
            AppAction action = null;
            JMenu edit = new JMenu(MinerApp.getText("MinerApp_menu_edit"));
            edit.setMnemonic('E');
            action = this.m_gridViewer.getScrollToCellAction(this);
            edit.add(new JMenuItem(action));
            action = this.m_gridViewer.getSelectAllAction();
            edit.add(new JMenuItem(action));
            action = this.m_gridViewer.getCopyAction();
            edit.add(new JMenuItem(action));
            menuBar.add(edit);
            ButtonGroup group = new ButtonGroup();
            JMenu menu = new JMenu(MinerApp.getText("NodeViewer_menu_rounding"));
            menu.setMnemonic('R');
            action = new AppAction(MinerApp.getText("NodeViewer_no_rounding")){

                public void actionPerformed(ActionEvent e) {
                    TableViewer.this.m_dataSource.setRounding(true, -1);
                    TableViewer.this.m_gridViewer.forceRefresh();
                }
            };
            JRadioButtonMenuItem menuItem = new JRadioButtonMenuItem(action);
            menu.add(menuItem);
            if (decimalPlaces < 0) {
                menuItem.setSelected(true);
            }
            group.add(menuItem);
            action = new AppAction(MinerApp.getText("NodeViewer_1_decimal_place")){

                public void actionPerformed(ActionEvent e) {
                    TableViewer.this.m_dataSource.setRounding(true, 1);
                    TableViewer.this.m_gridViewer.forceRefresh();
                }
            };
            menuItem = new JRadioButtonMenuItem(action);
            menu.add(menuItem);
            if (decimalPlaces == 1) {
                menuItem.setSelected(true);
            }
            group.add(menuItem);
            action = new AppAction(MinerApp.getText("NodeViewer_2_decimal_places")){

                public void actionPerformed(ActionEvent e) {
                    TableViewer.this.m_dataSource.setRounding(true, 2);
                    TableViewer.this.m_gridViewer.forceRefresh();
                }
            };
            menuItem = new JRadioButtonMenuItem(action);
            if (decimalPlaces == 2) {
                menuItem.setSelected(true);
            }
            menu.add(menuItem);
            group.add(menuItem);
            action = new AppAction(MinerApp.getText("NodeViewer_3_decimal_places")){

                public void actionPerformed(ActionEvent e) {
                    TableViewer.this.m_dataSource.setRounding(true, 3);
                    TableViewer.this.m_gridViewer.forceRefresh();
                }
            };
            menuItem = new JRadioButtonMenuItem(action);
            menu.add(menuItem);
            if (decimalPlaces == 3) {
                menuItem.setSelected(true);
            }
            group.add(menuItem);
            action = new AppAction(MinerApp.getText("NodeViewer_4_decimal_places")){

                public void actionPerformed(ActionEvent e) {
                    TableViewer.this.m_dataSource.setRounding(true, 4);
                    TableViewer.this.m_gridViewer.forceRefresh();
                }
            };
            menuItem = new JRadioButtonMenuItem(action);
            menu.add(menuItem);
            if (decimalPlaces == 4) {
                menuItem.setSelected(true);
            }
            group.add(menuItem);
            action = new AppAction(MinerApp.getText("NodeViewer_5_decimal_places")){

                public void actionPerformed(ActionEvent e) {
                    TableViewer.this.m_dataSource.setRounding(true, 5);
                    TableViewer.this.m_gridViewer.forceRefresh();
                }
            };
            menuItem = new JRadioButtonMenuItem(action);
            menu.add(menuItem);
            if (decimalPlaces == 5) {
                menuItem.setSelected(true);
            }
            group.add(menuItem);
            action = new AppAction(MinerApp.getText("NodeViewer_6_decimal_places")){

                public void actionPerformed(ActionEvent e) {
                    TableViewer.this.m_dataSource.setRounding(true, 6);
                    TableViewer.this.m_gridViewer.forceRefresh();
                }
            };
            menuItem = new JRadioButtonMenuItem(action);
            menu.add(menuItem);
            if (decimalPlaces == 6) {
                menuItem.setSelected(true);
            }
            group.add(menuItem);
            menuBar.add(menu);
            if (this.m_model instanceof TableViewNodeModel) {
                menu = new JMenu(MinerApp.getText("MinerApp_menu_tools"));
                menu.setMnemonic('T');
                action = new AppAction(MinerApp.getText("NodeViewer_generateModifyColumnsNode")){

                    public void actionPerformed(ActionEvent e) {
                        TableViewer.this.createModifyColumns();
                    }
                };
                menu.add(new JMenuItem(action));
                menuBar.add(menu);
            } else if (this.m_model instanceof CorrelationsNodeModel) {
                menu = new JMenu(MinerApp.getText("MinerApp_menu_tools"));
                menu.setMnemonic('T');
                action = new AppAction(MinerApp.getText("NodeViewer_generateFilterColumnsNode")){

                    public void actionPerformed(ActionEvent e) {
                        TableViewer.this.createFilterColumns();
                    }
                };
                menu.add(new JMenuItem(action));
                menuBar.add(menu);
            }
            this.setJMenuBar(menuBar);
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    TableViewer.this.exit();
                }
            });
            ActionListener cancelListener = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    TableViewer.this.exit();
                }
            };
            this.getJMenuBar().registerKeyboardAction(cancelListener, KeyStroke.getKeyStroke("ESCAPE"), 2);
            this.setSize(tableWidth + frameExtraWidth, tableHeight + frameExtraHeight);
            this.setLocation(MinerApp.getNextWindowLocation());
        }

        public void createModifyColumns() {
            try {
                Vector newTypes = ((ModifiableTypeGridViewerComposite)this.m_gridViewer).getChangedTypes();
                Vector newColumns = ((ModifiableTypeGridViewerComposite)this.m_gridViewer).getChangedColumns();
                int numChanged = newTypes.size();
                ModifyColumnsNodeModel model = new ModifyColumnsNodeModel();
                ActivityNodeArea area = new ActivityNodeArea();
                XTProps props = model.getXTProps();
                String[] path = new String[]{"columns", "", "datatype"};
                for (int i = 0; i < numChanged; ++i) {
                    path[1] = (String)newColumns.get(i);
                    props.set(path, (String)newTypes.get(i));
                }
                area.initialize(model);
                MinerApp.addChildNodeToView(area, this.m_model.getDocument().getWorksheetID(), this.m_model.getID());
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }

        public void createFilterColumns() {
            try {
                String[] colNames = ((ColumnFilterGenerator)((Object)this.m_model)).getFilterColumnsToExclude();
                FilterColumnsNodeModel model = ColumnFilterTools.createNodeModel(colNames, this.m_model.getInputMetaData(0));
                if (model != null) {
                    ActivityNodeArea newNodeArea = new ActivityNodeArea();
                    newNodeArea.initialize(model);
                    MinerApp.addChildNodeToView(newNodeArea, this.m_model.getDocument().getWorksheetID(), this.m_model.getID());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }

        public void exit() {
            this.dispose();
        }
    }
}

