/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.cnkjava.CNKProc;
import com.insightful.cnkjava.CNKProcJavaTransform;
import com.insightful.cnkjava.CNKProcJavaTransformExec;
import com.insightful.miner.EngineNode;
import com.insightful.miner.HexBinStatisticAccumulator;
import com.insightful.miner.MinerApp;
import com.insightful.miner.MinerRandom;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import java.util.Vector;

public class TwoDimChartEngineNode
extends EngineNode
implements CNKProcJavaTransformExec {
    public static String BIN_COUNT_CACHE_FILENAME = "bin.cache";
    public static String HEX_BIN_ATTRIBUTE_TAG = "hexBin";
    public static String SCATTER_ATTRIBUTE_TAG = "scatter";
    public static String X_COLUMN_ATTRIBUTE_TAG = "xColumns";
    public static String Y_COLUMN_ATTRIBUTE_TAG = "yColumns";
    public static String SHAPE_ATTRIBUTE_TAG = "shape";
    public static String X_BINS_ATTRIBUTE_TAG = "xBins";
    public static String NUM_SCATTER_ATTRIBUTE_TAG = "numScatter";
    public static String STYLE_ATTRIBUTE_TAG = "style";
    public static String GRAYSCALE_ATTRIBUTE_TAG = "grayscale";
    public static String LATTICE_ATTRIBUTE_TAG = "lattice";
    public static String CENTROIDS_ATTRIBUTE_TAG = "centroids";
    public static String NESTED_LATTICE_ATTRIBUTE_TAG = "nested.lattice";
    public static String NESTED_CENTROIDS_ATTRIBUTE_TAG = "nested.centroids";
    public static String X_BINS_DEFAULT = "30";
    public static String SHAPE_DEFAULT = "1.0";
    public static String NUM_SCATTER_DEFAULT = "1000";
    private boolean m_hexBin;
    private int[] m_xColumns = null;
    private int[] m_yColumns = null;
    private int m_numScatter;
    private long m_totalRows;
    private long m_numDrawn;
    private long m_curRow;
    private int[][] m_pairCount = null;
    private double[][][][] m_xyValues = null;
    private MinerRandom m_random = null;
    private XTProps m_scatterProps = null;
    private HexBinStatisticAccumulator m_hex = null;
    public static String I_MAX_ATTRIBUTE_TAG = HexBinStatisticAccumulator.I_MAX_ATTRIBUTE_TAG;
    public static String J_MAX_ATTRIBUTE_TAG = HexBinStatisticAccumulator.J_MAX_ATTRIBUTE_TAG;
    public static String CHARTS_ATTRIBUTE_TAG = HexBinStatisticAccumulator.CHARTS_ATTRIBUTE_TAG;
    public static String MAPPING_ATTRIBUTE_TAG = HexBinStatisticAccumulator.MAPPING_ATTRIBUTE_TAG;
    public static String COUNTS_ATTRIBUTE_TAG = HexBinStatisticAccumulator.COUNTS_ATTRIBUTE_TAG;
    public static String X_CENTERS_ATTRIBUTE_TAG = HexBinStatisticAccumulator.X_CENTERS_ATTRIBUTE_TAG;
    public static String Y_CENTERS_ATTRIBUTE_TAG = HexBinStatisticAccumulator.Y_CENTERS_ATTRIBUTE_TAG;
    public static String Y_ATTRIBUTE_TAG = "y";
    public static String X_ATTRIBUTE_TAG = "x";

    public boolean hasCNKProc() {
        return true;
    }

    public boolean hasDataCacheProc() {
        return false;
    }

    public CNKProc procCreate() {
        CNKProcJavaTransform proc = new CNKProcJavaTransform();
        proc.setExecObject(this);
        return proc;
    }

    public void procSetProperties(CNKProc proc) {
        try {
            int i;
            XTMetaData metaData = this.getInputMetaData(0);
            XTProps props = this.getNodeProperties();
            Vector xColumns = this.getSubProperties(props, metaData, X_COLUMN_ATTRIBUTE_TAG);
            Vector yColumns = this.getSubProperties(props, metaData, Y_COLUMN_ATTRIBUTE_TAG);
            int numXColumns = xColumns.size();
            int numYColumns = yColumns.size();
            this.m_hexBin = props.getBoolean(HEX_BIN_ATTRIBUTE_TAG, true);
            if (this.m_hexBin) {
                double shape = props.getDouble(SHAPE_ATTRIBUTE_TAG, 1.0);
                int xBins = props.getInt(X_BINS_ATTRIBUTE_TAG, 30);
                this.m_hex = new HexBinStatisticAccumulator(xColumns, yColumns, metaData, shape, xBins);
            } else {
                this.m_totalRows = metaData.getNumRows();
                this.m_numScatter = props.getInt(NUM_SCATTER_ATTRIBUTE_TAG, 0);
                if (this.m_totalRows < (long)this.m_numScatter) {
                    this.m_numScatter = (int)this.m_totalRows;
                }
                try {
                    this.m_xyValues = new double[numXColumns][numYColumns][2][this.m_numScatter];
                    this.m_pairCount = new int[numXColumns][numYColumns];
                }
                catch (OutOfMemoryError oom) {
                    this.m_xyValues = null;
                    this.m_pairCount = null;
                    System.gc();
                    this.printlnError("Out of memory.  Too many XY pairs selected (" + this.m_numScatter + " pairs)");
                    return;
                }
                this.m_random = new MinerRandom();
                this.m_scatterProps = new XTProps();
                this.m_scatterProps.set(new String[]{CHARTS_ATTRIBUTE_TAG}, Long.toString(this.m_numScatter));
                this.m_numDrawn = 0L;
                this.m_curRow = 0L;
            }
            this.m_xColumns = new int[numXColumns];
            for (i = 0; i < numXColumns; ++i) {
                this.m_xColumns[i] = metaData.nameToOrdinal((String)xColumns.get(i));
            }
            this.m_yColumns = new int[numYColumns];
            for (i = 0; i < numYColumns; ++i) {
                this.m_yColumns[i] = metaData.nameToOrdinal((String)yColumns.get(i));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void procExtractResults(CNKProc proc) {
        try {
            if (this.m_hexBin) {
                XTProps props = this.m_hex.outputColumnStats();
                this.setNodeCache(BIN_COUNT_CACHE_FILENAME, props);
            } else {
                StringBuffer xBuf = new StringBuffer();
                StringBuffer yBuf = new StringBuffer();
                String[] path = new String[]{CHARTS_ATTRIBUTE_TAG, "", ""};
                int charts = 0;
                for (int x = 0; x < this.m_xColumns.length; ++x) {
                    for (int y = 0; y < this.m_yColumns.length; ++y) {
                        for (int i = 0; i < this.m_numScatter; ++i) {
                            xBuf.append(this.m_xyValues[x][y][0][i]);
                            yBuf.append(this.m_xyValues[x][y][1][i]);
                            if (i >= this.m_numScatter) continue;
                            xBuf.append(" ");
                            yBuf.append(" ");
                        }
                        path[1] = Integer.toString(charts++);
                        path[2] = X_ATTRIBUTE_TAG;
                        this.m_scatterProps.set(path, xBuf.toString());
                        xBuf.setLength(0);
                        path[2] = Y_ATTRIBUTE_TAG;
                        this.m_scatterProps.set(path, yBuf.toString());
                        yBuf.setLength(0);
                    }
                }
                this.setNodeCache(BIN_COUNT_CACHE_FILENAME, this.m_scatterProps);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void execute(CNKProcJavaTransform proc) {
        if (!this.getNetworkManager().isSplusLicensed() && !MinerApp.isInBDL()) {
            proc.setError("S-PLUS Library not installed.  Cannot execute component.");
            return;
        }
        this.gatherInfoForChunk(proc);
    }

    protected void gatherInfoForChunk(CNKProcJavaTransform proc) {
        int inputRows = proc.getChunkInputRows(0);
        int numXColumns = this.m_xColumns.length;
        int numYColumns = this.m_yColumns.length;
        if (numXColumns == 0 || numYColumns == 0) {
            proc.setError("Chart requires valid X and Y columns.");
            return;
        }
        double[][] xColumns = new double[numXColumns][];
        for (int i = 0; i < numXColumns; ++i) {
            xColumns[i] = proc.getChunkInputColumnData(0, this.m_xColumns[i]);
        }
        double[][] yColumns = new double[numYColumns][];
        for (int i = 0; i < numYColumns; ++i) {
            yColumns[i] = proc.getChunkInputColumnData(0, this.m_yColumns[i]);
        }
        if (this.m_hexBin) {
            this.m_hex.updateStatistics(xColumns, yColumns, inputRows);
        } else {
            for (int i = 0; i < inputRows; ++i) {
                if (this.m_totalRows == (long)this.m_numScatter || this.m_random.nextDouble() * (double)(this.m_totalRows - this.m_curRow) < (double)((long)this.m_numScatter - this.m_numDrawn)) {
                    for (int x = 0; x < numXColumns; ++x) {
                        double xVal = xColumns[x][i];
                        int y = 0;
                        while (y < numYColumns) {
                            double yVal = yColumns[y][i];
                            this.m_xyValues[x][y][0][this.m_pairCount[x][y]] = xVal;
                            this.m_xyValues[x][y][1][this.m_pairCount[x][y]] = yVal;
                            int[] nArray = this.m_pairCount[x];
                            int n = y++;
                            nArray[n] = nArray[n] + 1;
                        }
                    }
                    ++this.m_numDrawn;
                }
                ++this.m_curRow;
            }
        }
    }

    public Vector getSubProperties(XTProps props, XTMetaData metaData, String name) {
        Vector ret = props.getSubProperties(name);
        for (int i = ret.size() - 1; i >= 0; --i) {
            if (metaData.isContinuousColumn((String)ret.get(i))) continue;
            ret.remove(i);
        }
        return ret;
    }
}

