/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.AcceleratorOptionPane;
import com.insightful.miner.MinerApp;
import com.insightful.miner.MinerLicenseInfo;

public class UnixLicenseManager {
    private static final int LMAPI_CONNECTERROR_NOCONNECT_CACHEBAD = 0;
    private static final int LMAPI_CONNECTERROR_SERVERDOWN = 1;
    private static final int LMAPI_CONNECTERROR_CANTRECONNECT = 2;
    private static final int LMAPI_CONNECTERROR_NOLICENSE = 3;
    private static final int LMAPI_CONNECTERROR_LICENSEINVALIDATED = 4;
    private static final int LMAPI_CONNECTERROR_NOCONNECT_CACHEGOOD = 5;
    private static final int LMAPI_CONNECTERROR_OUTOFCPUS = 6;
    private static final int LMAPI_CONNECTERROR_INVALIDLMVERSION = 7;
    private static final String TITLE_LMERROR = "License Manager Error";
    private static final String MESSAGE_NOCONNECT_CACHEBAD = "Cannot contact the license manager.  This may be caused by\nnetwork problems or server problems.  It may also be caused\nby a missing or invalid configuration file called 'lmaccess.ini'\nlocated in the program install directory.\n\nThis client has not previously been granted a license, or\nhas run the maximum number of allowable time since the\nlicense server was last contacted.\n\nThe license manager problems must be resolved before this\napplication may be used.";
    private static final String TITLE_NOCONNECT_CACHEBAD = "Cannot Contact License Manager:  No License";
    private static final String MESSAGE_NOCONNECT_CACHEGOOD = "Cannot contact the license manager.  This may be caused by\nnetwork problems or server problems.  It may also be caused\nby a missing or invalid configuration file called 'lmaccess.ini'\nlocated in the program install directory.\n\nThis client has previously been granted a license.  The\napplication may be run a limited number of times under\na temporary license.\n\nThe license manager problems must be resolved to assure future\naccess to the application.";
    private static final String TITLE_CONNECT_NOLICENSE = "No License Available";
    private static final String MESSAGE_CONNECT_NOLICENSE = "No license is available for this product, or all available\nlicenses have been allocated to other users or servers.";
    private static final String TITLE_NOCONNECT_CACHEGOOD = "Cannot Contact License Manager:  Temporary License";
    private static final String TITLE_CONNECT_LICENSEINVALID = "License Invalid";
    private static final String MESSAGE_CONNECT_LICENSEINVALID = "The license for this user or server has been invalidated.\n\nPlease contact your system administrator for more information.";
    private static final String TITLE_CONNECT_OUTOFCPUS = "Exceeded licensed CPUs";
    private static final String MESSAGE_CONNECT_OUTOFCPUS = "You have exceeded the number of CPUs licensed on this server.\nPlease contact Insightful for additional CPU licenses.";
    private static final String TITLE_CONNECT_INVALIDLMVERSION = "Invalid version of the License Manager";
    private static final String MESSAGE_CONNECT_INVALIDLMVERSION = "The version of the license manager is significantly lower than the version\nof this program which uses it.  A newer version of the license manager must\nbe installed to use this program.\n\nPlease contact your system adminstrator to update the license manager to the lastest version.";
    private static MinerLicenseInfo g_licenseInfo = new MinerLicenseInfo();
    private static boolean g_doingNativeCheck = false;
    private static String g_licenseErrorMessage;
    private static String g_licenseErrorTitle;
    private static int g_licenseErrorType;
    private static boolean g_hasLicense;
    private static boolean g_checkedLicense;
    private static boolean g_librariesLoaded;

    private UnixLicenseManager() {
    }

    public static boolean hasValidLicense() {
        if (g_checkedLicense) {
            return g_hasLicense;
        }
        boolean validFlag = false;
        UnixLicenseManager.loadLicenseManagerLibraries();
        g_licenseErrorMessage = null;
        g_licenseErrorTitle = null;
        g_licenseErrorType = -1;
        g_doingNativeCheck = true;
        class LicenseChecker
        extends Thread {
            boolean myvalidFlag = false;

            public void run() {
                g_doingNativeCheck = true;
                this.myvalidFlag = false;
                this.myvalidFlag = UnixLicenseManager.nativeIsLicenseValid(MinerApp.isInteractive(), g_licenseInfo);
                g_doingNativeCheck = false;
            }

            public boolean getValidity() {
                return this.myvalidFlag;
            }
        }
        LicenseChecker licenseCheck = new LicenseChecker();
        licenseCheck.start();
        String timeVal = System.getProperty("iminer.license.timeout", "60");
        int timeout = 60000;
        try {
            timeout = 1000 * Integer.decode(timeVal);
        }
        catch (Exception ex) {
            timeout = 60000;
        }
        int waitInterval = 200;
        while (g_doingNativeCheck && timeout > 0) {
            try {
                Thread.sleep(waitInterval);
            }
            catch (Exception e) {
                System.out.println("### License Check Interrupted ###\n");
                e.printStackTrace();
            }
            timeout -= waitInterval;
        }
        if (timeout <= 0) {
            g_licenseErrorMessage = "The license manager is not responding.\n\nTry killing any hung client processes and restarting your license manager,\nor contact Insightful technical support.\n\nAborting Insightful Miner start-up.";
            g_licenseErrorTitle = "License Manager Not Responding";
            g_licenseErrorType = 0;
            validFlag = false;
        } else {
            validFlag = licenseCheck.getValidity();
        }
        if (g_licenseErrorType != -1) {
            System.out.println("\n### " + g_licenseErrorTitle + " ###\n");
            System.out.println(g_licenseErrorMessage + "\n");
            System.out.flush();
        }
        long daysLeft = UnixLicenseManager.getLicenseInfo().getDaysLeft();
        if (!validFlag && daysLeft == 0L) {
            System.out.println("\n### License Expired ###\n");
            System.out.println("This Insightful Miner license has expired.\n");
            System.out.println("Contact Insightful Corp to renew the license.\n");
        }
        if (validFlag && daysLeft >= 0L && daysLeft <= 30L) {
            System.out.println("\n### Limited Days Remaining ###\n");
            System.out.println("This Insightful Miner license will expire in " + daysLeft + " days.\n");
        }
        g_checkedLicense = true;
        g_hasLicense = validFlag;
        return validFlag;
    }

    public static MinerLicenseInfo getLicenseInfo() {
        return g_licenseInfo;
    }

    public static int shutdownLicenseManager() {
        int exitCode = 0;
        if (g_checkedLicense && g_hasLicense) {
            exitCode = UnixLicenseManager.nativeShutdownLicenseManager();
        }
        return exitCode;
    }

    public static boolean handleLicenseManagerErrorMessage(int errorCode, String sErrorInfoFromLM) {
        boolean result = false;
        g_licenseErrorMessage = "Error code:  " + errorCode + "\n\nError message: " + sErrorInfoFromLM;
        g_licenseErrorTitle = TITLE_LMERROR;
        g_licenseErrorType = 0;
        return result;
    }

    private static final void loadLicenseManagerLibraries() {
        if (!g_librariesLoaded) {
            try {
                String loadLib = MinerApp.getSplusHome() + "/newfun/lib/" + System.mapLibraryName("winlink");
                System.load(loadLib);
            }
            catch (Exception e) {
                AcceleratorOptionPane.showOKDialog(MinerApp.getMainFrame(), MinerApp.getText("UnixTools_msg_errorLoadingReqLib"), MinerApp.getText("UnixTools_msg_errorLoadingLib"), 2);
                System.exit(1);
            }
            g_librariesLoaded = true;
        }
    }

    private static native boolean nativeIsLicenseValid(boolean var0, MinerLicenseInfo var1);

    private static native int nativeShutdownLicenseManager();

    static {
        g_licenseErrorType = -1;
        g_hasLicense = false;
        g_checkedLicense = false;
        g_librariesLoaded = false;
    }
}

