/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.MinerApp;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.filechooser.FileSystemView;

public class WideFileChooser
extends JFileChooser {
    public int returnValue;
    private boolean windowsAddExamplesFolderOnce = true;

    public WideFileChooser(File curDir) {
        super(curDir);
    }

    public WideFileChooser(File curDir, FileSystemView fsv) {
        super(curDir, fsv);
    }

    public WideFileChooser(FileSystemView fsv) {
        super(fsv);
    }

    public WideFileChooser(String curDir) {
        super(curDir);
    }

    public WideFileChooser(String curDir, FileSystemView fsv) {
        super(curDir, fsv);
    }

    public int showSaveDialog(Component comp) {
        return this.showSaveDialog(comp, -1);
    }

    public int showSaveDialog(Component comp, int specifiedWidth) {
        this.setDialogType(1);
        return this.showDialog(comp, specifiedWidth);
    }

    public int showOpenDialog(Component comp) {
        return this.showOpenDialog(comp, -1);
    }

    public int showOpenDialog(Component comp, int specifiedWidth) {
        this.setDialogType(0);
        return this.showDialog(comp, specifiedWidth);
    }

    public int showSaveDialog(Dialog comp) {
        return this.showSaveDialog(comp, -1);
    }

    public int showSaveDialog(Dialog comp, int specifiedWidth) {
        this.setDialogType(1);
        return this.showDialog(comp, specifiedWidth);
    }

    public int showOpenDialog(Dialog comp) {
        return this.showOpenDialog(comp, -1);
    }

    public int showOpenDialog(Dialog comp, int specifiedWidth) {
        this.setDialogType(0);
        return this.showDialog(comp, specifiedWidth);
    }

    private int showDialog(Component comp, int specifiedWidth) {
        JDialog dialog = this.createDialog(comp);
        return this.initView(dialog, specifiedWidth);
    }

    private int showDialog(Dialog owner, int specifiedWidth) {
        JDialog dialog = this.createDialog(owner);
        return this.initView(dialog, specifiedWidth);
    }

    private int initView(JDialog dialog, int specifiedWidth) {
        dialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                WideFileChooser.this.returnValue = 1;
            }
        });
        this.returnValue = -1;
        this.addActionListener(new WFCListener(dialog));
        this.rescanCurrentDirectory();
        if (this.windowsAddExamplesFolderOnce) {
            JToolBar shortCutPanel = (JToolBar)this.searchForShortcutPanel(this);
            if (shortCutPanel != null) {
                Vector otherButtons = this.searchShortcutPanelForButtons(shortCutPanel);
                JToggleButton exButton = new JToggleButton(new AbstractAction("Examples", MinerApp.getIcon("folder.gif")){

                    public void actionPerformed(ActionEvent e) {
                        String dir = MinerApp.getUserExamplesDirectory(WideFileChooser.this);
                        if (dir != null) {
                            WideFileChooser.this.setCurrentDirectory(new File(dir));
                        }
                    }
                });
                ButtonGroup bg = new ButtonGroup();
                bg.add(exButton);
                JToggleButton exampleButton = null;
                for (int i = 0; i < otherButtons.size(); ++i) {
                    if (i == 0) {
                        exampleButton = (JToggleButton)otherButtons.get(i);
                    }
                    bg.add((JToggleButton)otherButtons.get(i));
                }
                exButton.setHorizontalTextPosition(0);
                exButton.setVerticalTextPosition(3);
                exButton.setAlignmentX(0.5f);
                if (exampleButton != null) {
                    exButton.setForeground(exampleButton.getForeground());
                    exButton.setBackground(exampleButton.getBackground());
                    exButton.setPreferredSize(exampleButton.getPreferredSize());
                    exButton.setMaximumSize(exampleButton.getMaximumSize());
                }
                shortCutPanel.add(exButton);
            } else {
                this.setAccessory(new SolarisExamplesPanel());
            }
            this.windowsAddExamplesFolderOnce = false;
        }
        dialog.pack();
        Dimension dim = dialog.getSize();
        int width = Math.max(dim.width, specifiedWidth);
        dialog.setSize(width, dim.height);
        dialog.show();
        dialog.dispose();
        dialog = null;
        return this.returnValue;
    }

    protected JDialog createDialog(Dialog owner) {
        boolean supportsWindowDecorations;
        String title = this.getUI().getDialogTitle(this);
        JDialog dialog = new JDialog(owner, title, true);
        Container contentPane = dialog.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)this, "Center");
        if (JDialog.isDefaultLookAndFeelDecorated() && (supportsWindowDecorations = UIManager.getLookAndFeel().getSupportsWindowDecorations())) {
            dialog.getRootPane().setWindowDecorationStyle(6);
        }
        dialog.pack();
        dialog.setLocationRelativeTo(owner);
        return dialog;
    }

    Container searchForShortcutPanel(Container container) {
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Container cont;
            Component comp = container.getComponent(i);
            if (comp instanceof JToggleButton && container instanceof JToolBar && container instanceof ActionListener) {
                return container;
            }
            if (!(comp instanceof Container) || (cont = this.searchForShortcutPanel((Container)comp)) == null) continue;
            return cont;
        }
        return null;
    }

    Vector searchShortcutPanelForButtons(JToolBar shortcut) {
        Vector<Component> retVec = new Vector<Component>();
        for (int i = 0; i < shortcut.getComponentCount(); ++i) {
            Component comp = shortcut.getComponent(i);
            if (!(comp instanceof JToggleButton)) continue;
            retVec.add(comp);
        }
        return retVec;
    }

    class SolarisExamplesPanel
    extends JPanel {
        public SolarisExamplesPanel() {
            JToggleButton exButton = new JToggleButton(new AbstractAction("Examples", MinerApp.getIcon("folder.gif")){

                public void actionPerformed(ActionEvent e) {
                    String dir = MinerApp.getUserExamplesDirectory(WideFileChooser.this);
                    if (dir != null) {
                        WideFileChooser.this.setCurrentDirectory(new File(dir));
                    }
                }
            });
            exButton.setHorizontalTextPosition(0);
            exButton.setVerticalTextPosition(3);
            exButton.setAlignmentX(0.5f);
            this.add(exButton);
        }
    }

    public class WFCListener
    implements ActionListener {
        private JDialog m_dialog;

        public WFCListener(JDialog dialog) {
            this.m_dialog = dialog;
        }

        public void actionPerformed(ActionEvent ae) {
            String commandString = ae.getActionCommand();
            WideFileChooser.this.returnValue = commandString.equals("ApproveSelection") ? 0 : (commandString.equals("CancelSelection") ? 1 : -1);
            if (this.m_dialog != null) {
                this.m_dialog.setVisible(false);
            }
        }
    }
}

