/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.AppAction;
import com.insightful.miner.MinerApp;
import com.insightful.miner.NodeDialog;
import com.insightful.miner.PredictionPanel;
import com.insightful.miner.ReadOtherFileDialog;
import com.insightful.miner.WriteHTMLFileEngineNode;
import com.insightful.miner.WritePMMLFileDialog;
import com.insightful.miner.XTProps;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class WriteHTMLFileDialog
extends WritePMMLFileDialog {
    private JComboBox m_formatComboBox;
    private JRadioButton[] m_xslTransformRadioButtons;
    private JTextField m_xslTransformFilename;
    private JButton m_browseButton;
    private static String[] m_xslTypeDescriptionList = new String[]{"XSL files (*.xsl*)"};
    private static String[][] m_xslExtensionList = new String[][]{{".xslt", ".xsl"}};
    protected static String[] m_typeDescriptionList = WriteHTMLFileEngineNode.m_typeDescriptionList;
    protected static String[][] m_extensionList = WriteHTMLFileEngineNode.m_extensionList;
    private static WriteHTMLFileDialog m_WriteHTMLFileDialog = null;

    public static WriteHTMLFileDialog getWriteHTMLFileDialog() {
        if (m_WriteHTMLFileDialog == null) {
            m_WriteHTMLFileDialog = new WriteHTMLFileDialog();
        }
        return m_WriteHTMLFileDialog;
    }

    protected String getFilenameLabelText() {
        return MinerApp.getText("WriteHTMLFileDialog_filename");
    }

    protected char getFilenameLabelHotkey() {
        return MinerApp.getText("WriteHTMLFileDialog_filenameHotkey").charAt(0);
    }

    public void createActions() {
        super.createActions();
        this.m_browseAction = new AbstractAction(MinerApp.getText("ReadPMMLFileDialog_browse")){

            public void actionPerformed(ActionEvent e) {
                ReadOtherFileDialog.browseReadFileName(m_WriteHTMLFileDialog, WriteHTMLFileDialog.this.m_fileNameTextField, m_extensionList, m_typeDescriptionList, WriteHTMLFileDialog.this.m_formatComboBox);
            }
        };
    }

    public void restoreProperties() {
        super.restoreProperties();
        XTProps props = this.getNodeModel().getXTProps();
        this.m_formatComboBox.setSelectedItem(props.getValue(WriteHTMLFileEngineNode.REPORT_TYPE, m_typeDescriptionList[0]));
        this.m_xslTransformRadioButtons[1].setSelected(props.getBoolean(WriteHTMLFileEngineNode.SPECIFY_TAG, false));
        this.m_xslTransformFilename.setText(props.getValue(WriteHTMLFileEngineNode.XSL_FILENAME_TAG));
        if (this.m_xslTransformRadioButtons[1].isSelected()) {
            this.m_xslTransformRadioButtons[1].doClick();
        } else {
            this.m_xslTransformRadioButtons[0].doClick();
        }
    }

    public void saveProperties() throws NodeDialog.DialogException {
        super.saveProperties();
        XTProps props = this.getNodeModel().getXTProps();
        props.set(WriteHTMLFileEngineNode.REPORT_TYPE, this.m_formatComboBox.getSelectedItem().toString());
        props.set(WriteHTMLFileEngineNode.SPECIFY_TAG, this.m_xslTransformRadioButtons[1].isSelected());
        props.set(WriteHTMLFileEngineNode.XSL_FILENAME_TAG, this.m_xslTransformFilename.getText());
    }

    private void enableXSLControls() {
        boolean enabled = this.m_xslTransformRadioButtons[1].isSelected();
        this.m_xslTransformFilename.setEditable(enabled);
        this.m_xslTransformFilename.setEnabled(enabled);
        this.m_browseButton.setEnabled(enabled);
    }

    protected JPanel createReadWriteOptionsPanel(boolean write) {
        JLabel label = new JLabel(this.getFilenameLabelText());
        label.setDisplayedMnemonic(this.getFilenameLabelHotkey());
        this.m_fileNameTextField = new JTextField(10);
        label.setLabelFor(this.m_fileNameTextField);
        JButton browse = new JButton(this.m_browseAction);
        browse.setMnemonic(MinerApp.getText("ReadPMMLFileDialog_browseHotkey").charAt(0));
        JPanel optionsPanel = new JPanel(new GridBagLayout());
        optionsPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = write ? 0.0 : 1.0;
        optionsPanel.add((Component)label, gbc);
        ++gbc.gridx;
        gbc.weightx = 1.0;
        optionsPanel.add((Component)this.m_fileNameTextField, gbc);
        ++gbc.gridx;
        gbc.weightx = 0.0;
        optionsPanel.add((Component)browse, gbc);
        JLabel formatLabel = new JLabel(MinerApp.getText("WriteHTMLFileDialog_format"));
        formatLabel.setDisplayedMnemonic(MinerApp.getText("WriteHTMLFileDialog_formatHotkey").charAt(0));
        this.m_formatComboBox = new JComboBox<String>(m_typeDescriptionList);
        formatLabel.setLabelFor(this.m_formatComboBox);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        optionsPanel.add((Component)formatLabel, gbc);
        ++gbc.gridx;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        optionsPanel.add((Component)this.m_formatComboBox, gbc);
        if (write) {
            ++gbc.gridy;
            gbc.gridx = 0;
            gbc.weighty = 1.0;
            gbc.fill = 2;
            gbc.gridwidth = 0;
            this.m_modelPanel = new PredictionPanel.ModelPanel();
            optionsPanel.add((Component)this.m_modelPanel, gbc);
        } else {
            this.m_modelPanel = null;
        }
        return optionsPanel;
    }

    public Vector createOtherTabs() {
        JPanel xsltPanel = this.createXSLTPanel();
        xsltPanel.setName(MinerApp.getText("WriteHTMLFileDialog_transform"));
        Vector<JPanel> ret = new Vector<JPanel>();
        ret.add(xsltPanel);
        return ret;
    }

    private JPanel createXSLTPanel() {
        this.m_xslTransformRadioButtons = new JRadioButton[2];
        this.m_xslTransformRadioButtons[0] = new JRadioButton(MinerApp.getText("WriteHTMLFileDialog_useDefault"));
        this.m_xslTransformRadioButtons[0].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WriteHTMLFileDialog.this.enableXSLControls();
            }
        });
        this.m_xslTransformRadioButtons[0].setMnemonic(MinerApp.getText("WriteHTMLFileDialog_useDefaultHotkey").charAt(0));
        this.m_xslTransformRadioButtons[1] = new JRadioButton(MinerApp.getText("WriteHTMLFileDialog_specify"));
        this.m_xslTransformRadioButtons[1].addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WriteHTMLFileDialog.this.enableXSLControls();
            }
        });
        this.m_xslTransformRadioButtons[1].setMnemonic(MinerApp.getText("WriteHTMLFileDialog_specifyHotkey").charAt(0));
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.m_xslTransformRadioButtons[0]);
        bg.add(this.m_xslTransformRadioButtons[1]);
        JLabel filenameLabel = new JLabel(MinerApp.getText("WriteHTMLFileDialog_xslFilename"));
        this.m_xslTransformFilename = new JTextField(10);
        filenameLabel.setLabelFor(this.m_xslTransformFilename);
        this.m_browseButton = new JButton(new AppAction(MinerApp.getText("ReadPMMLFileDialog_browse")){

            public void actionPerformed(ActionEvent e) {
                ReadOtherFileDialog.browseReadFileName(m_WriteHTMLFileDialog, WriteHTMLFileDialog.this.m_xslTransformFilename, m_xslExtensionList, m_xslTypeDescriptionList, null);
            }
        });
        this.m_browseButton.setMnemonic(MinerApp.getText("ReadPMMLFileDialog_browseHotkey").charAt(1));
        Insets none = new Insets(0, 0, 0, 0);
        Insets minor = new Insets(0, 10, 0, 0);
        Insets major = new Insets(0, 20, 0, 0);
        JPanel xslPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weighty = 0.0;
        gbc.weightx = 0.0;
        gbc.fill = 2;
        gbc.insets = minor;
        xslPanel.add((Component)this.m_xslTransformRadioButtons[0], gbc);
        ++gbc.gridy;
        gbc.weightx = 0.0;
        gbc.insets = minor;
        xslPanel.add((Component)this.m_xslTransformRadioButtons[1], gbc);
        JPanel filePanel = new JPanel();
        filePanel.setLayout(new BoxLayout(filePanel, 0));
        filePanel.add(filenameLabel);
        filePanel.add(Box.createHorizontalStrut(5));
        filePanel.add(this.m_xslTransformFilename);
        filePanel.add(Box.createHorizontalStrut(5));
        filePanel.add(this.m_browseButton);
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        ++gbc.gridy;
        gbc.insets = major;
        xslPanel.add((Component)filePanel, gbc);
        return xslPanel;
    }
}

