/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner.dndtree;

import com.insightful.miner.dndtree.DefaultNodeInfo;
import com.insightful.miner.dndtree.DefaultTransferInfo;
import com.insightful.miner.dndtree.DndId;
import com.insightful.miner.dndtree.SubTreeNode;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;

public class DefaultTransferable
implements Transferable {
    public static final DataFlavor DEFAULT_NODE_INFO_FLAVOUR = new DataFlavor(DefaultNodeInfo.class, "Default Node Info");
    private static DataFlavor[] m_flavours;
    private DefaultTransferInfo m_data;

    protected static void addMimeType(Vector v, String mimetype) {
        try {
            v.addElement(new DataFlavor(mimetype));
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
    }

    public DefaultTransferable(DefaultMutableTreeNode node, DndId dndId) {
        this.m_data = new DefaultTransferInfo(new SubTreeNode[]{new SubTreeNode(node, true)}, dndId);
    }

    public DefaultTransferable(DefaultMutableTreeNode[] nodes, DndId dndId) {
        SubTreeNode[] stn = new SubTreeNode[nodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            stn[i] = new SubTreeNode(nodes[i], true);
        }
        this.m_data = new DefaultTransferInfo(stn, dndId);
    }

    public DataFlavor[] getTransferDataFlavors() {
        return m_flavours;
    }

    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        Object retval;
        if (flavor.equals(DEFAULT_NODE_INFO_FLAVOUR)) {
            retval = this.m_data;
        } else if (flavor.equals(DataFlavor.stringFlavor)) {
            StringBuffer sbuff = new StringBuffer();
            for (int i = 0; i < this.m_data.getNodes().length; ++i) {
                sbuff.append(this.m_data.getNodes()[i].toString());
            }
            retval = sbuff.toString();
        } else if (flavor.isMimeTypeEqual("text/plain")) {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)os, flavor.getParameter("charset"));
            PrintWriter wr = new PrintWriter(osw);
            for (int i = 0; i < this.m_data.getNodes().length; ++i) {
                wr.println(this.m_data.getNodes()[i].toString());
            }
            wr.flush();
            wr.close();
            retval = new ByteArrayInputStream(os.toByteArray());
        } else if (flavor.equals(DataFlavor.javaFileListFlavor)) {
            File dir = File.createTempFile("paste", "");
            dir.mkdir();
            dir.deleteOnExit();
            ArrayList<File> list = new ArrayList<File>();
            for (int i = 0; i < this.m_data.getNodes().length; ++i) {
                list.add(this.m_data.getNodes()[i].toFile(dir));
            }
            retval = list;
        } else {
            throw new UnsupportedFlavorException(flavor);
        }
        return retval;
    }

    public boolean isDataFlavorSupported(DataFlavor flavor) {
        boolean retval = false;
        for (int i = 0; i < m_flavours.length; ++i) {
            if (!flavor.equals(m_flavours[i])) continue;
            retval = true;
            break;
        }
        return retval;
    }

    static {
        Vector<DataFlavor> v = new Vector<DataFlavor>();
        v.addElement(DEFAULT_NODE_INFO_FLAVOUR);
        v.addElement(DataFlavor.stringFlavor);
        v.addElement(DataFlavor.javaFileListFlavor);
        DefaultTransferable.addMimeType(v, "text/plain; charset=UTF-16BE");
        DefaultTransferable.addMimeType(v, "text/plain; charset=UTF-16LE");
        DefaultTransferable.addMimeType(v, "text/plain; charset=UTF-16");
        DefaultTransferable.addMimeType(v, "text/plain; charset=ISO-8859-1");
        DefaultTransferable.addMimeType(v, "text/plain; charset=UTF-8");
        DefaultTransferable.addMimeType(v, "text/plain; charset=US-ASCII");
        DefaultTransferable.addMimeType(v, "text/plain; charset=ascii");
        m_flavours = new DataFlavor[v.size()];
        v.copyInto(m_flavours);
    }
}

