/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner.tree.gui;

import com.insightful.miner.ActivityNodeArea;
import com.insightful.miner.BaseNodeArea;
import com.insightful.miner.ColumnFilterTools;
import com.insightful.miner.FilterColumnsNodeModel;
import com.insightful.miner.InsBasicChartPanel;
import com.insightful.miner.MinerApp;
import com.insightful.miner.WorksheetDocument;
import com.insightful.miner.WorksheetView;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.tree.gui.ClassificationTreeGUI;
import com.insightful.miner.tree.model.TreeCollection;
import com.jrefinery.chart.JFreeChart;
import com.jrefinery.chart.NumberAxis;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoSelection;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class InsVarDevianceChartPanel
extends InsBasicChartPanel {
    public static final String FILTER_ACTION_COMMAND = "FILTER";
    private TreeCollection treeCollection = null;
    private JFrame parentFrame = null;
    private JMenuItem propertiesMenuItem = null;

    public InsVarDevianceChartPanel(JFrame caller, TreeCollection tc, JFreeChart chart, int width, int height, double minimumDrawWidth, double minimumDrawHeight, boolean useBuffer, boolean properties, boolean save, boolean print, boolean zoom, boolean tooltips) {
        super(chart, width, height, minimumDrawWidth, minimumDrawHeight, useBuffer, properties, save, print, zoom, tooltips);
        this.addMenuItems(this.popup);
        this.treeCollection = tc;
        this.parentFrame = caller;
    }

    public InsVarDevianceChartPanel(JFrame caller, TreeCollection tc, JFreeChart chart) {
        this(caller, tc, chart, 250, 250, 250.0, 250.0, true, true, true, true, true, true);
    }

    public NumberAxis getRangeAxis() {
        if (this.chart != null) {
            return (NumberAxis)this.chart.getPlot().getHorizontalAxis();
        }
        return null;
    }

    public Frame getParentFrame() {
        return this.parentFrame;
    }

    private void handleLeftClick(MouseEvent e) {
    }

    private void handleRightClick(MouseEvent e) {
    }

    private void handleDoubleClick() {
    }

    private void addMenuItems(JPopupMenu popup) {
        popup.addSeparator();
        this.propertiesMenuItem = new JMenuItem(ClassificationTreeGUI.getText("treevis_gui_filechartprops"));
        this.propertiesMenuItem.setActionCommand("PROPERTIES");
        this.propertiesMenuItem.addActionListener(this);
        popup.add(this.propertiesMenuItem);
        popup.addSeparator();
        JMenuItem createFilterMenuItem = new JMenuItem(ClassificationTreeGUI.getText("treevis_gui_createFilter"));
        createFilterMenuItem.setActionCommand(FILTER_ACTION_COMMAND);
        createFilterMenuItem.addActionListener(this);
        popup.add(createFilterMenuItem);
    }

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if (command.equals(FILTER_ACTION_COMMAND)) {
            XTMetaData md;
            WorksheetView view = MinerApp.getViewWithID(this.treeCollection.getDocID());
            WorksheetDocument doc = view.getDoc();
            JGoSelection selection = view.getSelection();
            BaseNodeArea obj = doc.findNodeByID(this.treeCollection.getNodeID());
            String[] colNames = ColumnFilterTools.showDefaultFilterSpecificationDialog(this.parentFrame, this.treeCollection.getIndependentColNames(), this.treeCollection.getImportanceValues(), MinerApp.getText("ColumnFilterSpecificationDialog_treeFiltering_statistic"));
            FilterColumnsNodeModel model = ColumnFilterTools.createNodeModel(colNames, md = this.treeCollection.getInputMetaData());
            if (model != null) {
                ActivityNodeArea newNodeArea = new ActivityNodeArea();
                newNodeArea.initialize(model);
                if (obj != null) {
                    Point iPoint = obj.getSpotLocation(7);
                    view.copyFromExplorerPane(newNodeArea, iPoint);
                } else {
                    view.copyFromExplorerPane(newNodeArea);
                }
                view.getDoc().addObjectAtTail((JGoObject)newNodeArea);
                selection.selectObject((JGoObject)newNodeArea);
            }
        } else {
            super.actionPerformed(event);
        }
    }

    public double getMaxVal() {
        double max = 0.0;
        double[] array = this.treeCollection.getImportanceValues();
        for (int i = 0; i < array.length; ++i) {
            if (!(max < array[i])) continue;
            max = array[i];
        }
        return max;
    }

    public double getMinVal() {
        return 0.0;
    }
}

