/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus;

import com.insightful.gdevice.SCanvas;
import com.insightful.splus.ActiveDocument;
import com.insightful.splus.ClientObjectFactoryImpl;
import com.insightful.splus.ObjectsSummaryWindow;
import com.insightful.splus.RemoteFileInputStream;
import com.insightful.splus.RemoteFileOutputStream;
import com.insightful.splus.Splash;
import com.insightful.splus.SplusAltKeyListener;
import com.insightful.splus.SplusCanvasHandler;
import com.insightful.splus.SplusDataResult;
import com.insightful.splus.SplusEngineBusyException;
import com.insightful.splus.SplusEngineQueryHandler;
import com.insightful.splus.SplusHelpManagerInstance;
import com.insightful.splus.SplusHelpManagerInstanceImpl;
import com.insightful.splus.SplusHelpQueryHandler;
import com.insightful.splus.SplusIncompleteExpressionException;
import com.insightful.splus.SplusMainActionListener;
import com.insightful.splus.SplusMainMenuBar;
import com.insightful.splus.SplusMainToolBar;
import com.insightful.splus.SplusOptionsManager;
import com.insightful.splus.SplusOutputHandlerImpl;
import com.insightful.splus.SplusServerFileHandler;
import com.insightful.splus.SplusSession;
import com.insightful.splus.SplusSessionImpl;
import com.insightful.splus.SplusSystem;
import com.insightful.splus.SplusWinSessionEvent;
import com.insightful.splus.SplusWinSessionImpl;
import com.insightful.splus.SplusWinSessionListener;
import com.insightful.splus.WindowArranger;
import com.insightful.splus.client.ServerFileSystemView;
import com.insightful.splus.commands.CommandsWindow;
import com.insightful.splus.graph.GraphWindow;
import com.insightful.splus.report.ReportWindow;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.rmi.RemoteException;
import javax.swing.ImageIcon;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JWindow;
import javax.swing.UIManager;
import javax.swing.filechooser.FileSystemView;

public class SplusGui
extends JFrame
implements Runnable,
SplusCanvasHandler,
SplusEngineQueryHandler,
SplusHelpQueryHandler,
SplusServerFileHandler {
    public static final int WINDOW_WIDTH = 700;
    public static final int WINDOW_HEIGHT = 400;
    private static final int INITIAL_WIDTH = 800;
    private static final int INITIAL_HEIGHT = 600;
    private String textPaste;
    private boolean waitingOnSplusOutput = false;
    InputStream origIn;
    PrintStream origOut;
    PrintStream origErr;
    private SplusSession splusSession = null;
    private FileSystemView m_fileSystemView = null;
    JDesktopPane desktop;
    SplusMainActionListener mainActionListener;
    SplusMainMenuBar mainMenuBar;
    SplusMainToolBar mainToolBar;
    ReportWindow reportWindow;
    CommandsWindow commandsWindow;
    ObjectsSummaryWindow objectsSummaryWindow = null;
    SplusHelpManagerInstanceImpl helpManager;
    WindowArranger m_wa;
    private static SplusGui defaultGui;
    Cursor savedCurrentCursor;
    Cursor waitCursor = new Cursor(3);
    String[] clArgs;
    private static String engineBusyText;
    private static String engineBusyTitle;
    private Object m_engineQueryLock = new Object();
    static boolean m_guiRunning;

    public SplusSession getSplusSession() {
        return this.splusSession;
    }

    public static boolean getSplusUsePipes() {
        return System.getProperty("splus.use.pipes", "true").equals("true");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SplusGui(InputStream inputStream, PrintStream printStream, PrintStream printStream2, String[] stringArray) {
        super("S-PLUS");
        this.setSize(800, 600);
        this.clArgs = stringArray;
        File file = null;
        try {
            file = System.getProperty("S_MYSWORK") != null ? new File(System.getProperty("S_MYSWORK")) : new File(System.getProperty("user.dir"));
        }
        finally {
            if (file == null) {
                file = new File(".");
            }
        }
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.origIn = inputStream;
        this.origOut = printStream;
        this.origErr = printStream2;
    }

    public void run() {
        System.setProperty("splus.gui", "true");
        JWindow jWindow = new JWindow();
        Dimension dimension = jWindow.getToolkit().getScreenSize();
        jWindow.setBounds((dimension.width - 500) / 2, (dimension.height - 330) / 2, 500, 330);
        jWindow.getContentPane().add(new Splash());
        jWindow.pack();
        jWindow.setVisible(true);
        this.setIconImage(new ImageIcon(System.getProperty("splus.shome", "") + "/java/res/app.gif").getImage());
        ActiveDocument.Init(this);
        defaultGui = this;
        SplusSystem.setDefaultFrame(this);
        SplusSystem.setEngineQueryHandler(this);
        SplusSystem.setHelpQueryHandler(this);
        SplusSystem.setCanvasHandler(this);
        SplusSystem.setServerFileHandler(this);
        this.addWindowListener(new WindowListener(){

            public void windowClosing(WindowEvent windowEvent) {
                SplusGui.this.exit();
            }

            public void windowClosed(WindowEvent windowEvent) {
            }

            public void windowOpened(WindowEvent windowEvent) {
            }

            public void windowIconified(WindowEvent windowEvent) {
            }

            public void windowDeiconified(WindowEvent windowEvent) {
            }

            public void windowActivated(WindowEvent windowEvent) {
            }

            public void windowDeactivated(WindowEvent windowEvent) {
            }
        });
        this.desktop = new JDesktopPane();
        this.getContentPane().add(this.desktop);
        this.m_wa = new WindowArranger(this.desktop);
        this.commandsWindow = new CommandsWindow(this);
        this.mainActionListener = new SplusMainActionListener(this);
        SplusSystem.setMainActionListener(this.mainActionListener);
        this.mainMenuBar = new SplusMainMenuBar(this.mainActionListener, this.m_wa);
        this.setJMenuBar(this.mainMenuBar);
        SplusSystem.setMainMenuBar(this.mainMenuBar);
        this.mainToolBar = new SplusMainToolBar(this.mainActionListener);
        this.getContentPane().add((Component)this.mainToolBar, "North");
        SplusSystem.setMainToolBar(this.mainToolBar);
        this.addWindow(this.commandsWindow);
        this.commandsWindow.show();
        this.reportWindow = new ReportWindow(this);
        this.reportWindow.setVisible(false);
        this.addWindow(this.reportWindow);
        this.savedCurrentCursor = this.getCursor();
        m_guiRunning = true;
        this.pack();
        this.setSize(800, 600);
        this.setLocation((dimension.width - 800) / 2, (dimension.height - 600) / 2);
        this.getRootPane().addKeyListener(new SplusAltKeyListener(this));
        try {
            if (System.getProperty("splus.client.mode") == null) {
                if (System.getProperty("os.name", "").toLowerCase().indexOf("windows") < 0) {
                    if (SplusGui.getSplusUsePipes()) {
                        this.splusSession = new SplusSessionImpl(this.clArgs);
                    } else {
                        System.setProperty("splus.interactive.commandline", "T");
                        this.splusSession = new SplusWinSessionImpl(this.clArgs);
                        ((SplusWinSessionImpl)this.splusSession).addListener(new LocalWinSessionListener());
                    }
                } else {
                    this.splusSession = new SplusWinSessionImpl(this.clArgs);
                }
            } else {
                this.splusSession = SplusSessionImpl.getRemoteSession(true, new ClientObjectFactoryImpl(), this.clArgs);
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
            exception.printStackTrace();
        }
        this.processDataQuery("", 10000);
        this.processDataQuery("library(menu);invisible(NULL)", 10000);
        File file = null;
        if (System.getProperty("splus.client.mode", "").equals("true")) {
            try {
                file = new ServerFileSystemView().getHomeDirectory();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            file = new File(System.getProperty("user.dir"));
        }
        SplusSystem.setCwd(file);
        new Thread(){

            public void run() {
                try {
                    if (System.getProperty("splus.help.off", "").length() == 0) {
                        SplusGui.this.helpManager = new SplusHelpManagerInstanceImpl(SplusGui.this.commandsWindow, true);
                        SplusGui.this.processDataQuery("help.start(visible = F)", 60);
                    } else {
                        SplusGui.this.helpManager = new SplusHelpManagerInstanceImpl(SplusGui.this.commandsWindow, false);
                    }
                }
                catch (Exception exception) {
                    System.err.println("Could not create HelpSet");
                }
            }
        }.start();
        this.show();
        jWindow.dispose();
        try {
            this.splusSession.startPollOutput(new SplusOutputHandlerImpl());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.exit();
        }
        boolean bl = true;
        while (bl) {
            try {
                Thread.currentThread();
                Thread.sleep(300000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.splusSession.isRemote();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.exit();
            }
        }
    }

    public void addWindow(JInternalFrame jInternalFrame) {
        int n = 25;
        int n2 = this.desktop.getAllFrames().length;
        int n3 = n2 % 6 * n;
        jInternalFrame.setLocation(n3, n3);
        this.desktop.add(jInternalFrame);
    }

    public void addGraphWindow(GraphWindow graphWindow) {
        this.addWindow(graphWindow);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processDialogCommand(String string) {
        Object object = this.m_engineQueryLock;
        synchronized (object) {
            boolean bl;
            String string2 = SplusOptionsManager.getOption("textOutputWindow");
            boolean bl2 = string2.equals("") || string2.equals("Report Window");
            String string3 = SplusOptionsManager.getOption("echoCommand");
            boolean bl3 = bl = string3.equals("T") || string3.equals("TRUE");
            if (bl2) {
                Cursor cursor = this.getCursor();
                this.setCursor(this.waitCursor);
                SplusDataResult splusDataResult = this.processDataQuery(string, true, false, true, true, true);
                StringBuffer stringBuffer = new StringBuffer();
                if (splusDataResult == null) {
                    if (this.getCursor().getType() == 3) {
                        this.setCursor(cursor);
                    }
                    return;
                }
                if (bl && splusDataResult.hasExpression()) {
                    stringBuffer = stringBuffer.append("Command:\n" + splusDataResult.getExpression() + "\n");
                }
                if (splusDataResult.hasOutput()) {
                    stringBuffer = stringBuffer.append(splusDataResult.getOutput());
                }
                if (splusDataResult.hasError()) {
                    stringBuffer = stringBuffer.append(splusDataResult.getError());
                }
                if (splusDataResult.hasWarning()) {
                    String[] stringArray = splusDataResult.getWarning();
                    if (stringArray.length > 0) {
                        stringBuffer.append("Warning messages:\n");
                    }
                    for (int i = 0; i < stringArray.length; ++i) {
                        stringBuffer = stringBuffer.append("  " + stringArray[i]);
                    }
                }
                if (stringBuffer.toString().trim().length() > 0) {
                    this.reportWindow.append(stringBuffer.toString());
                    if (!this.reportWindow.isVisible()) {
                        this.reportWindow.setVisible(true);
                    }
                    if (this.reportWindow.isClosed()) {
                        this.showReportWindow();
                    }
                }
                if (this.getCursor().getType() == 3) {
                    this.setCursor(cursor);
                }
            } else {
                this.commandsWindow.processCommand(string + "\n", bl);
            }
        }
    }

    public void processCommand(String string) {
        this.commandsWindow.processCommand(string + "\n", true);
    }

    public String evaluateCommand(String string) {
        this.savedCurrentCursor = this.commandsWindow.getCursor();
        this.commandsWindow.setCursor(this.waitCursor);
        try {
            this.splusSession.writeSplusIn(string);
        }
        catch (Exception exception) {
            String string2 = exception.toString();
            System.out.println(string2);
        }
        this.waitingOnSplusOutput = true;
        return "";
    }

    public void writeEngineOutput(String string, boolean bl) {
        if (bl && this.getCursor().getType() == 3) {
            this.commandsWindow.setCursor(this.savedCurrentCursor);
        }
        this.commandsWindow.append(string);
        if (this.waitingOnSplusOutput) {
            this.waitingOnSplusOutput = false;
            try {
                Thread.currentThread();
                Thread.sleep(4L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SplusDataResult processDataQuery(String string) {
        Object object = this.m_engineQueryLock;
        synchronized (object) {
            try {
                return this.splusSession.evalDataQuery(string);
            }
            catch (SplusEngineBusyException splusEngineBusyException) {
                JOptionPane.showMessageDialog(this, engineBusyText, engineBusyTitle, 0);
                return new SplusDataResult(null, null, null, null);
            }
            catch (SplusIncompleteExpressionException splusIncompleteExpressionException) {
                JOptionPane.showMessageDialog(this, splusIncompleteExpressionException.getMessage(), "Data Query Error:  Incomplete Expression", 0);
                return new SplusDataResult(null, null, null, null);
            }
            catch (RemoteException remoteException) {
                JOptionPane.showMessageDialog(this, "Problem contacting engine:\n" + remoteException.getMessage(), "Data Query Error:  Remote Exception", 0);
                return new SplusDataResult(null, null, null, null);
            }
        }
    }

    public SplusDataResult processDataQuery(String string, int n) {
        try {
            return this.splusSession.evalDataQuery(string, n);
        }
        catch (SplusEngineBusyException splusEngineBusyException) {
            JOptionPane.showMessageDialog(this, engineBusyText, engineBusyTitle, 0);
            return new SplusDataResult(null, null, null, null);
        }
        catch (SplusIncompleteExpressionException splusIncompleteExpressionException) {
            JOptionPane.showMessageDialog(this, splusIncompleteExpressionException.getMessage(), "Data Query Error:  Incomplete Expression", 0);
            return new SplusDataResult(null, null, null, null);
        }
        catch (RemoteException remoteException) {
            JOptionPane.showMessageDialog(this, "Problem contacting engine:\n" + remoteException.getMessage(), "Data Query Error:  Remote Exception", 0);
            return new SplusDataResult(null, null, null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SplusDataResult processDataQuery(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        Object object = this.m_engineQueryLock;
        synchronized (object) {
            try {
                return this.splusSession.evalDataQuery(string, bl, bl2, bl3, bl4, bl5);
            }
            catch (SplusEngineBusyException splusEngineBusyException) {
                JOptionPane.showMessageDialog(this, engineBusyText, engineBusyTitle, 0);
                return new SplusDataResult(null, null, null, null);
            }
            catch (SplusIncompleteExpressionException splusIncompleteExpressionException) {
                JOptionPane.showMessageDialog(this, splusIncompleteExpressionException.getMessage(), "Data Query Error:  Incomplete Expression", 0);
                return new SplusDataResult(null, null, null, null);
            }
            catch (RemoteException remoteException) {
                JOptionPane.showMessageDialog(this, "Problem contacting engine:\n" + remoteException.getMessage(), "Data Query Error:  Remote Exception", 0);
                return new SplusDataResult(null, null, null, null);
            }
        }
    }

    public SplusDataResult processDataQuery(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, int n) {
        try {
            return this.splusSession.evalDataQuery(string, bl, bl2, bl3, bl4, bl5, n);
        }
        catch (SplusEngineBusyException splusEngineBusyException) {
            JOptionPane.showMessageDialog(this, engineBusyText, engineBusyTitle, 0);
            return new SplusDataResult(null, null, null, null);
        }
        catch (SplusIncompleteExpressionException splusIncompleteExpressionException) {
            JOptionPane.showMessageDialog(this, splusIncompleteExpressionException.getMessage(), "Data Query Error:  Incomplete Expression", 0);
            return new SplusDataResult(null, null, null, null);
        }
        catch (RemoteException remoteException) {
            JOptionPane.showMessageDialog(this, "Problem contacting engine:\n" + remoteException.getMessage(), "Data Query Error:  Remote Exception", 0);
            return new SplusDataResult(null, null, null, null);
        }
    }

    public void displayHelpView(String string) {
        this.processDataQuery("help.start(view=\"" + string + "\")");
    }

    public void displayHelpOnTopic(String string) {
        try {
            this.processDataQuery("help.start()");
            String string2 = "displayJhelp(\"" + string + "\")";
            this.processDataQuery(string2);
        }
        catch (Exception exception) {
            System.err.println("Could not enable HelpSet for " + string);
        }
    }

    public void showCommandsWindow() {
        this.showInternalFrame(this.commandsWindow);
    }

    public void showReportWindow() {
        this.showInternalFrame(this.reportWindow);
    }

    public void showObjectsSummaryWindow() {
        if (this.objectsSummaryWindow == null) {
            this.objectsSummaryWindow = new ObjectsSummaryWindow(this);
            this.addWindow(this.objectsSummaryWindow);
        }
        this.showInternalFrame(this.objectsSummaryWindow);
    }

    private void showInternalFrame(JInternalFrame jInternalFrame) {
        if (jInternalFrame.isClosed()) {
            this.desktop.add(jInternalFrame);
            jInternalFrame.show();
            try {
                jInternalFrame.setClosed(false);
            }
            catch (PropertyVetoException propertyVetoException) {
                System.out.println(propertyVetoException);
            }
        } else {
            jInternalFrame.show();
        }
    }

    public void interruptSplus() {
        try {
            this.splusSession.Interrupt();
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    public void exit() {
        try {
            if (this.helpManager != null) {
                this.helpManager.closeJhelp();
            }
            this.splusSession.sessionExit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.exit(0);
    }

    public void showNewCanvas(SCanvas sCanvas) {
        new GraphWindow(this, sCanvas);
    }

    public static boolean getGuiRunning() {
        return m_guiRunning;
    }

    public SCanvas getActiveCanvas() {
        JInternalFrame jInternalFrame = ActiveDocument.get();
        if (jInternalFrame != null && jInternalFrame instanceof GraphWindow) {
            GraphWindow graphWindow = (GraphWindow)jInternalFrame;
            return graphWindow.getCanvas();
        }
        return null;
    }

    public SCanvas getCurrentDeviceCanvas() {
        try {
            SplusDataResult splusDataResult = SplusSystem.getEngineQueryHandler().processDataQuery("as.character(dev.cur())");
            String[] stringArray = splusDataResult.getStringData();
            if (stringArray == null || stringArray.length < 1) {
                return null;
            }
            int n = Integer.parseInt(stringArray[0]);
            if (n < 1) {
                return null;
            }
            JInternalFrame[] jInternalFrameArray = SplusGui.defaultGui.desktop.getAllFrames();
            for (int i = 0; i < jInternalFrameArray.length; ++i) {
                GraphWindow graphWindow;
                SCanvas sCanvas;
                JInternalFrame jInternalFrame = jInternalFrameArray[i];
                if (!(jInternalFrame instanceof GraphWindow) || (sCanvas = (graphWindow = (GraphWindow)jInternalFrame).getCanvas()).getDeviceNumber() != n) continue;
                return sCanvas.getGraphicsDevice().getCanvas();
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        return null;
    }

    public boolean WaitingOnOutput() {
        return this.waitingOnSplusOutput;
    }

    public SplusHelpManagerInstance getHelpManagerInstance() {
        return this.helpManager;
    }

    public FileSystemView getServerFileSystemView() {
        if (this.m_fileSystemView == null) {
            if (System.getProperty("splus.client.mode", "").equals("true")) {
                try {
                    this.m_fileSystemView = new ServerFileSystemView(this.getSplusSession().getClientUtilities());
                }
                catch (RemoteException remoteException) {
                    remoteException.printStackTrace();
                }
            } else {
                this.m_fileSystemView = FileSystemView.getFileSystemView();
            }
        }
        return this.m_fileSystemView;
    }

    public FileInputStream getServerFileInputStream(String string) throws FileNotFoundException {
        if (System.getProperty("splus.client.mode", "").equals("true")) {
            return new RemoteFileInputStream(string, this.getSplusSession());
        }
        return new FileInputStream(string);
    }

    public FileOutputStream getServerFileOutputStream(String string) throws FileNotFoundException, IOException {
        if (System.getProperty("splus.client.mode", "").equals("true")) {
            return new RemoteFileOutputStream(string, this.getSplusSession());
        }
        return new FileOutputStream(string);
    }

    public static void clearDefaultCommandsWindow() {
        if (defaultGui != null && SplusGui.defaultGui.commandsWindow != null) {
            SplusGui.defaultGui.commandsWindow.clear();
        }
    }

    public static void saveDefaultCommandsWindow(String string) throws FileNotFoundException, IOException {
        if (defaultGui != null && SplusGui.defaultGui.commandsWindow != null) {
            SplusGui.defaultGui.commandsWindow.save(string);
        }
    }

    public static void clearDefaultReportWindow() {
        if (defaultGui != null && SplusGui.defaultGui.reportWindow != null) {
            SplusGui.defaultGui.reportWindow.clear();
        }
    }

    public static void saveDefaultReportWindow(String string) throws FileNotFoundException, IOException {
        if (defaultGui != null && SplusGui.defaultGui.reportWindow != null) {
            SplusGui.defaultGui.reportWindow.save(string);
        }
    }

    static {
        engineBusyText = "The S-PLUS computation engine is not responding.\nThis condition may be caused by one of the following:\n\n1)  The Commands window is waiting for input.\n2)  Another S-PLUS operation is already in progress.\n3)  Other processes are preempting S-PLUS.\n4)  Low memory is causing thrashing in virtual memory.\n\n";
        engineBusyTitle = "Data Query Error:  Engine Busy";
        m_guiRunning = false;
    }

    private class LocalWinSessionListener
    implements SplusWinSessionListener {
        private LocalWinSessionListener() {
        }

        public void eventOccurred(SplusWinSessionEvent splusWinSessionEvent) {
            if (splusWinSessionEvent.getType() == 32) {
                System.exit(0);
            }
        }
    }
}

