/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus;

import com.insightful.splus.ActiveDocument;
import com.insightful.splus.PrintCommand;
import com.insightful.splus.PrintSetupCommand;
import com.insightful.splus.SaveAsable;
import com.insightful.splus.SplusAboutBox;
import com.insightful.splus.SplusGui;
import com.insightful.splus.SplusSystem;
import com.insightful.splus.dataview.NewDataViewerDialog;
import com.insightful.splus.graph.ExportGraphCommand;
import com.insightful.splus.graph.GraphColorsDialog;
import com.insightful.splus.graph.GraphFrame;
import com.insightful.splus.graph.GraphWindow;
import com.insightful.splus.util.ClassUtilities;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JDialog;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;

public class SplusMainActionListener
implements ActionListener {
    SplusGui parentGui;

    protected SplusMainActionListener() {
    }

    public SplusMainActionListener(SplusGui splusGui) {
        this.parentGui = splusGui;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        Cursor cursor = this.parentGui.getCursor();
        this.parentGui.setCursor(new Cursor(3));
        this.handleAction(string);
        if (this.parentGui.getCursor().getType() == 3) {
            this.parentGui.setCursor(cursor);
        }
    }

    protected void handleAction(String string) {
        JInternalFrame jInternalFrame;
        if (string.startsWith("D:")) {
            String string2 = string.substring(2);
            try {
                Class clazz = ClassUtilities.getClassForName(string2);
                try {
                    Class[] classArray = new Class[]{};
                    Constructor constructor = clazz.getConstructor(classArray);
                    if (clazz.equals(GraphColorsDialog.class) && !GraphFrame.isLegacyGraphicsMode()) {
                        JOptionPane.showMessageDialog(SplusSystem.getDefaultFrame(), GraphFrame.getColorSetErrorMsg(), GraphFrame.getColorSetErrorTitle(), 0);
                        return;
                    }
                    Object var6_12 = null;
                    try {
                        var6_12 = constructor.newInstance(new Object[0]);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        System.out.println(invocationTargetException.getTargetException().toString());
                    }
                    JDialog jDialog = var6_12;
                    this.displayDialog(jDialog);
                }
                catch (Exception exception) {
                    System.out.println(exception.toString());
                    exception.printStackTrace(System.out);
                    System.out.flush();
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.out.println("Finding class " + string2);
                System.out.println("Class not found");
            }
        } else if (string.startsWith("S:")) {
            this.parentGui.processCommand(string.substring(2));
        } else if (string.equals("Exit")) {
            this.parentGui.exit();
        } else if (string.equals("ViewCommandsWindow")) {
            this.parentGui.showCommandsWindow();
        } else if (string.equals("ViewObjectsSummary")) {
            this.parentGui.showObjectsSummaryWindow();
        } else if (string.equals("ViewReportWindow")) {
            this.parentGui.showReportWindow();
        } else if (string.equals("NewDataViewer")) {
            new NewDataViewerDialog(this.parentGui).show();
        } else if (string.equals("NewGraphWindow")) {
            this.parentGui.processDataQuery("java.graph()");
        } else if (string.equals("ExportGraph")) {
            new ExportGraphCommand(this.parentGui).doExecute();
        } else if (string.equals("Print")) {
            new PrintCommand(this.parentGui).doExecute();
        } else if (string.equals("PrintSetup")) {
            new PrintSetupCommand().doExecute();
        } else if (string.equals("WindowTile")) {
            this.parentGui.m_wa.tile();
        } else if (string.equals("WindowCascade")) {
            this.parentGui.m_wa.cascade();
        } else if (string.startsWith("Zoom")) {
            JInternalFrame jInternalFrame2 = ActiveDocument.get();
            if (jInternalFrame2 instanceof GraphWindow) {
                GraphWindow graphWindow = (GraphWindow)jInternalFrame2;
                if (string.equals("ZoomIn")) {
                    graphWindow.zoom(1.5);
                } else if (string.equals("ZoomOut")) {
                    graphWindow.zoom(0.6666666865348816);
                } else if (string.equals("ZoomRect")) {
                    graphWindow.zoomToRect();
                } else if (string.equals("ZoomWindow")) {
                    graphWindow.zoomToFrame();
                }
            }
        } else if (string.equals("Help Contents")) {
            SplusSystem.getHelpQueryHandler().displayHelpView("TOC");
        } else if (string.equals("Index")) {
            SplusSystem.getHelpQueryHandler().displayHelpView("Index");
        } else if (string.equals("Search")) {
            SplusSystem.getHelpQueryHandler().displayHelpView("Search");
        } else if (string.equals("Help About")) {
            new SplusAboutBox().show();
        } else if (string.equals("Save As") && (jInternalFrame = ActiveDocument.get()) instanceof SaveAsable) {
            File file = ((SaveAsable)((Object)jInternalFrame)).saveAs(SplusSystem.getDefaultFrame(), SplusSystem.getCwd());
            SplusSystem.setCwd(file);
        }
    }

    protected void displayDialog(JDialog jDialog) {
        jDialog.show();
        jDialog.repaint();
    }
}

