/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.client;

import com.insightful.gdevice.XMLElement;
import com.insightful.splus.client.SessionProfile;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;

public class SessionProfileList
extends LinkedList {
    private String saveFileName = System.getProperty("user.home") + System.getProperty("file.separator") + ".splusclientrc";

    public SessionProfileList() {
        this.load();
    }

    public String[] getProfileNames() {
        String[] stringArray = new String[this.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = ((SessionProfile)this.get(i)).getProfileName();
        }
        return stringArray;
    }

    public synchronized void load() {
        try {
            File file = new File(this.saveFileName);
            if (file.exists()) {
                FileReader fileReader = new FileReader(file);
                this.addAll(this.readXML(fileReader));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public synchronized void store() {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.saveFileName);
            PrintWriter printWriter = new PrintWriter(fileOutputStream);
            this.writeXML(printWriter);
            printWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    protected void writeXML(PrintWriter printWriter) {
        if (printWriter != null) {
            printWriter.println("<SessionProfileList VERSION = \"1.0\">");
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                ((SessionProfile)iterator.next()).writeXML(printWriter);
            }
            printWriter.println("</SessionProfileList>");
        }
    }

    protected Vector readXML(Reader reader) {
        Vector<SessionProfile> vector = new Vector<SessionProfile>();
        try {
            if (reader != null) {
                XMLElement xMLElement = new XMLElement();
                xMLElement.parseFromReader(reader);
                if (xMLElement.getTagName().equalsIgnoreCase("SessionProfileList")) {
                    Enumeration enumeration = xMLElement.enumerateChildren();
                    while (enumeration.hasMoreElements()) {
                        XMLElement xMLElement2 = (XMLElement)enumeration.nextElement();
                        if (!xMLElement2.getTagName().equalsIgnoreCase("SessionProfile")) continue;
                        vector.add(new SessionProfile(xMLElement2));
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return vector;
    }
}

