/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.statdlg;

import com.insightful.controls.SplusBoxFiller;
import com.insightful.controls.SplusButton;
import com.insightful.controls.SplusCheckBox;
import com.insightful.controls.SplusComboBox;
import com.insightful.controls.SplusDialog;
import com.insightful.controls.SplusFunctionInfo;
import com.insightful.controls.SplusGroupPanel;
import com.insightful.controls.SplusTextField;
import com.insightful.controls.SplusWideBoxFiller;
import com.insightful.controls.SplusWideTextField;
import com.insightful.splus.SplusDataColumnComboBox;
import com.insightful.splus.SplusDataColumnListBox;
import com.insightful.splus.SplusDataColumnListProvider;
import com.insightful.splus.SplusDataSetComboBox;
import com.insightful.splus.SplusSubsetField;
import com.insightful.splus.statdlg.MixedEffectsCorrelationGroup;
import com.insightful.splus.statdlg.MixedEffectsVarianceGroup;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class NonlinearMixedEffectsDialog
extends SplusDialog {
    SplusDataSetComboBox dataSet;
    SplusDataSetComboBox predictSaveIn;
    SplusDataSetComboBox predictAugSaveIn;
    SplusDataSetComboBox predictNewData;
    SplusDataSetComboBox predictAugNewData;
    SplusDataColumnComboBox dependentColumn;
    SplusDataColumnComboBox plotGroupColumn;
    SplusDataColumnComboBox plotAugPredColumn;
    SplusDataColumnComboBox predictAugColumn;
    SplusDataColumnListBox independentColumnList;
    SplusWideTextField fixedFormula;
    SplusWideTextField randomFormula;
    SplusWideTextField plotFormulaField;
    SplusWideTextField formulaField;
    SplusWideTextField parametersField;
    SplusButton formulaButton;
    SplusCheckBox plotAugPred;
    SplusCheckBox plotVariogram;
    SplusCheckBox plotRandomDot;
    SplusCheckBox plotRandomScatter;
    SplusCheckBox plotRandomQQ;
    SplusCheckBox plotSpecifiedFormula;
    SplusCheckBox predictSavePredictions;
    SplusCheckBox predictAugSavePredictions;
    SplusTextField plotAugPredMin;
    SplusTextField plotAugPredMax;
    SplusTextField plotAugPredLength;
    SplusTextField plotVariogramFormula;
    SplusTextField predictAugMin;
    SplusTextField predictAugMax;
    SplusTextField predictAugLength;
    SplusComboBox plotAugPredLevels;
    SplusComboBox plotRandomLevels;
    SplusComboBox predictAugLevels;
    SplusComboBox predictLevels;
    PlotRandomActionListener randomListener;
    MixedEffectsVarianceGroup varGroup;
    MixedEffectsCorrelationGroup corGroup;

    public NonlinearMixedEffectsDialog() {
        super("Nonlinear Mixed Effects Models");
        JTabbedPane jTabbedPane = new JTabbedPane();
        SplusFunctionInfo splusFunctionInfo = new SplusFunctionInfo("menuNlme");
        this.setFunctionInfo(splusFunctionInfo);
        JPanel jPanel = new JPanel();
        jTabbedPane.addTab("Model", jPanel);
        Box box = new Box(0);
        Box box2 = new Box(1);
        Box box3 = new Box(1);
        Box box4 = new Box(1);
        box.add(box3);
        box.add(box4);
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(box);
        jPanel.add(box2);
        SplusGroupPanel splusGroupPanel = new SplusGroupPanel("Data");
        box3.add(splusGroupPanel);
        this.dataSet = new SplusDataSetComboBox();
        splusGroupPanel.add(this.dataSet);
        splusFunctionInfo.add(this.dataSet, "data");
        SplusSubsetField splusSubsetField = new SplusSubsetField();
        splusGroupPanel.add(splusSubsetField);
        splusFunctionInfo.add(splusSubsetField, "subset");
        SplusCheckBox splusCheckBox = new SplusCheckBox("Omit Rows with Missing Values", 'M');
        splusCheckBox.setValue("T");
        splusGroupPanel.add(splusCheckBox);
        splusFunctionInfo.add(splusCheckBox, "na.omit.p");
        box4.add(new SplusBoxFiller(2));
        SplusGroupPanel splusGroupPanel2 = new SplusGroupPanel("Save Model Object");
        box4.add(splusGroupPanel2);
        SplusTextField splusTextField = new SplusTextField("Save As", 'S');
        splusGroupPanel2.add(splusTextField);
        splusFunctionInfo.setResultControl(splusTextField);
        SplusGroupPanel splusGroupPanel3 = new SplusGroupPanel("Effects");
        box2.add(splusGroupPanel3);
        this.fixedFormula = new SplusWideTextField("Fixed", 'X');
        splusGroupPanel3.add(this.fixedFormula);
        splusFunctionInfo.add(this.fixedFormula, "fixed");
        this.randomFormula = new SplusWideTextField("Random", 'N');
        splusGroupPanel3.add(this.randomFormula);
        splusFunctionInfo.add(this.randomFormula, "random");
        SplusGroupPanel splusGroupPanel4 = new SplusGroupPanel("Model");
        box2.add(splusGroupPanel4);
        this.formulaField = new SplusWideTextField("Formula", 'F');
        splusGroupPanel4.add(this.formulaField);
        splusFunctionInfo.add(this.formulaField, "model");
        this.parametersField = new SplusWideTextField("Parameters (name = value)", 'P');
        splusGroupPanel4.add(this.parametersField);
        splusFunctionInfo.add(this.parametersField, "start", false, true);
        jPanel.add(new SplusWideBoxFiller());
        JPanel jPanel2 = new JPanel();
        jTabbedPane.addTab("Options", jPanel2);
        Box box5 = new Box(1);
        Box box6 = new Box(1);
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(box5);
        jPanel2.add(box6);
        this.varGroup = new MixedEffectsVarianceGroup("Within-Group Variance", this.dataSet);
        box5.add(this.varGroup);
        this.varGroup.registerControls(splusFunctionInfo);
        SplusGroupPanel splusGroupPanel5 = new SplusGroupPanel("Optimization Options");
        box5.add(splusGroupPanel5);
        SplusComboBox splusComboBox = new SplusComboBox("Method", 'M', new String[]{"REML", "ML"});
        splusComboBox.setValue("ML");
        splusComboBox.setEditable(false);
        splusGroupPanel5.add(splusComboBox);
        splusFunctionInfo.add(splusComboBox, "method", true);
        SplusTextField splusTextField2 = new SplusTextField("Control", 'N');
        splusGroupPanel5.add(splusTextField2);
        splusFunctionInfo.add(splusTextField2, "control", false, true);
        box5.add(new SplusBoxFiller());
        this.corGroup = new MixedEffectsCorrelationGroup("Within-Group Correlation", this.dataSet);
        box6.add(this.corGroup);
        this.corGroup.registerControls(splusFunctionInfo);
        box6.add(new SplusBoxFiller());
        JPanel jPanel3 = new JPanel();
        jTabbedPane.addTab("Results", jPanel3);
        Box box7 = new Box(1);
        Box box8 = new Box(1);
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel3.add(box7);
        jPanel3.add(box8);
        SplusGroupPanel splusGroupPanel6 = new SplusGroupPanel("Printed Results");
        box7.add(splusGroupPanel6);
        SplusCheckBox splusCheckBox2 = new SplusCheckBox("Short Output", 'S');
        splusGroupPanel6.add(splusCheckBox2);
        splusFunctionInfo.add(splusCheckBox2, "print.short.p");
        SplusCheckBox splusCheckBox3 = new SplusCheckBox("Long Output", 'L');
        splusCheckBox3.setValue("T");
        splusGroupPanel6.add(splusCheckBox3);
        splusFunctionInfo.add(splusCheckBox3, "print.long.p");
        SplusCheckBox splusCheckBox4 = new SplusCheckBox("ANOVA Table", 'A');
        splusGroupPanel6.add(splusCheckBox4);
        splusFunctionInfo.add(splusCheckBox4, "print.anova.p");
        SplusCheckBox splusCheckBox5 = new SplusCheckBox("Confidence Intervals", 'C');
        splusGroupPanel6.add(splusCheckBox5);
        splusFunctionInfo.add(splusCheckBox5, "print.intervals.p");
        box7.add(new SplusBoxFiller());
        SplusGroupPanel splusGroupPanel7 = new SplusGroupPanel("Saved Results");
        box8.add(splusGroupPanel7);
        SplusDataSetComboBox splusDataSetComboBox = new SplusDataSetComboBox("Save In", 'I');
        splusDataSetComboBox.setValue("");
        splusGroupPanel7.add(splusDataSetComboBox);
        splusFunctionInfo.add(splusDataSetComboBox, "save.name", true);
        SplusComboBox splusComboBox2 = new SplusComboBox("Levels", 'V', new String[]{"0", "1", "2", "3", "4", "5"});
        splusComboBox2.setValue("");
        splusGroupPanel7.add(splusComboBox2);
        splusFunctionInfo.add(splusComboBox2, "save.level", false, true);
        SplusCheckBox splusCheckBox6 = new SplusCheckBox("Fitted Values", 'F');
        splusGroupPanel7.add(splusCheckBox6);
        splusFunctionInfo.add(splusCheckBox6, "save.fit.p");
        SplusCheckBox splusCheckBox7 = new SplusCheckBox("Pearson Residuals", 'P');
        splusGroupPanel7.add(splusCheckBox7);
        splusFunctionInfo.add(splusCheckBox7, "save.pearson.p");
        SplusCheckBox splusCheckBox8 = new SplusCheckBox("Normalized Residuals", 'N');
        splusGroupPanel7.add(splusCheckBox8);
        splusFunctionInfo.add(splusCheckBox8, "save.normalized.p");
        SplusCheckBox splusCheckBox9 = new SplusCheckBox("Response Residuals", 'R');
        splusGroupPanel7.add(splusCheckBox9);
        splusFunctionInfo.add(splusCheckBox9, "save.response.p");
        box8.add(new SplusBoxFiller());
        JPanel jPanel4 = new JPanel();
        jTabbedPane.addTab("Plot", jPanel4);
        Box box9 = new Box(0);
        Box box10 = new Box(1);
        Box box11 = new Box(1);
        Box box12 = new Box(1);
        box9.add(box11);
        box9.add(box12);
        jPanel4.setLayout(new BoxLayout(jPanel4, 1));
        jPanel4.add(box9);
        jPanel4.add(box10);
        SplusGroupPanel splusGroupPanel8 = new SplusGroupPanel("Plots");
        box11.add(splusGroupPanel8);
        SplusCheckBox splusCheckBox10 = new SplusCheckBox("Residuals vs Fit", 'R');
        splusGroupPanel8.add(splusCheckBox10);
        splusFunctionInfo.add(splusCheckBox10, "plotResidVsFit.p");
        SplusCheckBox splusCheckBox11 = new SplusCheckBox("Sqrt Abs Residuals vs Fit", 'Q');
        splusGroupPanel8.add(splusCheckBox11);
        splusFunctionInfo.add(splusCheckBox11, "plotSqrtAbsResid.p");
        SplusCheckBox splusCheckBox12 = new SplusCheckBox("Response vs Fit", 'P');
        splusGroupPanel8.add(splusCheckBox12);
        splusFunctionInfo.add(splusCheckBox12, "plotResponseVsFit.p");
        SplusCheckBox splusCheckBox13 = new SplusCheckBox("Residuals Normal QQ", 'Q');
        splusGroupPanel8.add(splusCheckBox13);
        splusFunctionInfo.add(splusCheckBox13, "plotQQ.p");
        this.plotAugPred = new SplusCheckBox("Augmented Predictions", 'Q');
        splusGroupPanel8.add(this.plotAugPred);
        splusFunctionInfo.add(this.plotAugPred, "plotAugPred.p");
        SplusCheckBox splusCheckBox14 = new SplusCheckBox("Autocorrelation of Residuals", 'U');
        splusGroupPanel8.add(splusCheckBox14);
        splusFunctionInfo.add(splusCheckBox14, "plotAcf.p");
        this.plotVariogram = new SplusCheckBox("Variogram of Residuals", 'O');
        splusGroupPanel8.add(this.plotVariogram);
        splusFunctionInfo.add(this.plotVariogram, "plotVariogram.p");
        this.plotRandomDot = new SplusCheckBox("Random Effects Dot", 'D');
        splusGroupPanel8.add(this.plotRandomDot);
        splusFunctionInfo.add(this.plotRandomDot, "plotRandomEffectsDot.p");
        this.plotRandomScatter = new SplusCheckBox("Random Effects Scatter", 'E');
        splusGroupPanel8.add(this.plotRandomScatter);
        splusFunctionInfo.add(this.plotRandomScatter, "plotRandomEffectsScatter.p");
        this.plotRandomQQ = new SplusCheckBox("Random Effects Normal QQ", 'T');
        splusGroupPanel8.add(this.plotRandomQQ);
        splusFunctionInfo.add(this.plotRandomQQ, "plotRandomEffectsQQ.p");
        this.plotSpecifiedFormula = new SplusCheckBox("Specified Formula", 'E');
        splusGroupPanel8.add(this.plotSpecifiedFormula);
        splusFunctionInfo.add(this.plotSpecifiedFormula, "plotFormula.p");
        SplusGroupPanel splusGroupPanel9 = new SplusGroupPanel("Specified Formula Options");
        box10.add(splusGroupPanel9);
        this.plotFormulaField = new SplusWideTextField("Plot Formula", 'F');
        this.plotFormulaField.setEnabled(false);
        splusGroupPanel9.add(this.plotFormulaField);
        splusFunctionInfo.add(this.plotFormulaField, "plotFormulaString", true);
        this.plotSpecifiedFormula.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = NonlinearMixedEffectsDialog.this.plotSpecifiedFormula.getValue().equals("T");
                NonlinearMixedEffectsDialog.this.plotFormulaField.setEnabled(bl);
            }
        });
        box10.add(new SplusBoxFiller());
        SplusGroupPanel splusGroupPanel10 = new SplusGroupPanel("General Options");
        box12.add(splusGroupPanel10);
        this.plotGroupColumn = new SplusDataColumnComboBox("Group Variable", 'G', (SplusDataColumnListProvider)this.dataSet);
        this.plotGroupColumn.setValue("");
        splusGroupPanel10.add(this.plotGroupColumn);
        splusFunctionInfo.add(this.plotGroupColumn, "plotGroupVars", true, true);
        SplusCheckBox splusCheckBox15 = new SplusCheckBox("Include Grid", 'I');
        splusGroupPanel10.add(splusCheckBox15);
        splusFunctionInfo.add(splusCheckBox15, "plotGrid.p");
        SplusGroupPanel splusGroupPanel11 = new SplusGroupPanel("Augmented Predictions Options");
        box12.add(splusGroupPanel11);
        this.plotAugPredLevels = new SplusComboBox("Levels", 'V', new String[]{"0", "1", "2", "3", "4", "5"});
        this.plotAugPredLevels.setValue("");
        this.plotAugPredLevels.setEnabled(false);
        splusGroupPanel11.add(this.plotAugPredLevels);
        splusFunctionInfo.add(this.plotAugPredLevels, "plotAugLevel", false, true);
        this.plotAugPredColumn = new SplusDataColumnComboBox("Primary Covariate", 'C', (SplusDataColumnListProvider)this.dataSet);
        this.plotAugPredColumn.setValue("");
        this.plotAugPredColumn.setEnabled(false);
        splusGroupPanel11.add(this.plotAugPredColumn);
        splusFunctionInfo.add(this.plotAugPredColumn, "plotAugPrimary", true);
        this.plotAugPredMin = new SplusTextField("Minimum", 'M');
        this.plotAugPredMin.setEnabled(false);
        splusGroupPanel11.add(this.plotAugPredMin);
        splusFunctionInfo.add(this.plotAugPredMin, "plotAugMin");
        this.plotAugPredMax = new SplusTextField("Maximum", 'X');
        this.plotAugPredMax.setEnabled(false);
        splusGroupPanel11.add(this.plotAugPredMax);
        splusFunctionInfo.add(this.plotAugPredMax, "plotAugMax");
        this.plotAugPredLength = new SplusTextField("Number of Values", 'N');
        this.plotAugPredLength.setEnabled(false);
        splusGroupPanel11.add(this.plotAugPredLength);
        splusFunctionInfo.add(this.plotAugPredLength, "plotAugLength");
        this.plotAugPred.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = NonlinearMixedEffectsDialog.this.plotAugPred.getValue().equals("T");
                NonlinearMixedEffectsDialog.this.plotAugPredColumn.setEnabled(bl);
                NonlinearMixedEffectsDialog.this.plotAugPredLevels.setEnabled(bl);
                NonlinearMixedEffectsDialog.this.plotAugPredMin.setEnabled(bl);
                NonlinearMixedEffectsDialog.this.plotAugPredMax.setEnabled(bl);
                NonlinearMixedEffectsDialog.this.plotAugPredLength.setEnabled(bl);
            }
        });
        SplusGroupPanel splusGroupPanel12 = new SplusGroupPanel("Variogram Options");
        box12.add(splusGroupPanel12);
        this.plotVariogramFormula = new SplusTextField("Formula", 'O');
        this.plotVariogramFormula.setEnabled(false);
        splusGroupPanel12.add(this.plotVariogramFormula);
        splusFunctionInfo.add(this.plotVariogramFormula, "plotVariogramFormula");
        this.plotVariogram.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = NonlinearMixedEffectsDialog.this.plotVariogram.getValue().equals("T");
                NonlinearMixedEffectsDialog.this.plotVariogramFormula.setEnabled(bl);
            }
        });
        SplusGroupPanel splusGroupPanel13 = new SplusGroupPanel("Random Effects Options");
        box12.add(splusGroupPanel13);
        this.plotRandomLevels = new SplusComboBox("Levels", 'V', new String[]{"0", "1", "2", "3", "4", "5"});
        this.plotRandomLevels.setValue("");
        this.plotRandomLevels.setEnabled(false);
        splusGroupPanel13.add(this.plotRandomLevels);
        splusFunctionInfo.add(this.plotRandomLevels, "plotRandomEffectsLevel", false, true);
        this.randomListener = new PlotRandomActionListener();
        this.plotRandomDot.addActionListener(this.randomListener);
        this.plotRandomScatter.addActionListener(this.randomListener);
        this.plotRandomQQ.addActionListener(this.randomListener);
        box12.add(new SplusBoxFiller());
        JPanel jPanel5 = new JPanel();
        jTabbedPane.addTab("Predict", jPanel5);
        Box box13 = new Box(1);
        Box box14 = new Box(1);
        jPanel5.setLayout(new BoxLayout(jPanel5, 0));
        jPanel5.add(box13);
        jPanel5.add(box14);
        SplusGroupPanel splusGroupPanel14 = new SplusGroupPanel("Standard Predictions");
        box13.add(splusGroupPanel14);
        this.predictSavePredictions = new SplusCheckBox("Save Predictions", 'P');
        splusGroupPanel14.add(this.predictSavePredictions);
        splusFunctionInfo.add(this.predictSavePredictions, "predict.p");
        this.predictSaveIn = new SplusDataSetComboBox("Save In", 'I');
        this.predictSaveIn.setValue("");
        this.predictSaveIn.setEnabled(false);
        splusGroupPanel14.add(this.predictSaveIn);
        splusFunctionInfo.add(this.predictSaveIn, "predName", true);
        this.predictLevels = new SplusComboBox("Levels", 'V', new String[]{"0", "1", "2", "3", "4", "5"});
        this.predictLevels.setValue("");
        this.predictLevels.setEnabled(false);
        splusGroupPanel14.add(this.predictLevels);
        splusFunctionInfo.add(this.predictLevels, "predLevel", false, true);
        this.predictNewData = new SplusDataSetComboBox("New Data", 'N');
        this.predictNewData.setValue("");
        this.predictNewData.setEnabled(false);
        splusGroupPanel14.add(this.predictNewData);
        splusFunctionInfo.add(this.predictNewData, "predNewdata");
        this.predictSavePredictions.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = NonlinearMixedEffectsDialog.this.predictSavePredictions.getValue().equals("T");
                NonlinearMixedEffectsDialog.this.predictSaveIn.setEnabled(bl);
                NonlinearMixedEffectsDialog.this.predictLevels.setEnabled(bl);
                NonlinearMixedEffectsDialog.this.predictNewData.setEnabled(bl);
            }
        });
        box13.add(new SplusBoxFiller());
        SplusGroupPanel splusGroupPanel15 = new SplusGroupPanel("Augmented Predictions");
        box14.add(splusGroupPanel15);
        this.predictAugSavePredictions = new SplusCheckBox("Save Augmented Predictions", 'A');
        splusGroupPanel15.add(this.predictAugSavePredictions);
        splusFunctionInfo.add(this.predictAugSavePredictions, "augPred.p");
        this.predictAugSaveIn = new SplusDataSetComboBox("Save In", 'E');
        this.predictAugSaveIn.setValue("");
        this.predictAugSaveIn.setEnabled(false);
        splusGroupPanel15.add(this.predictAugSaveIn);
        splusFunctionInfo.add(this.predictAugSaveIn, "augPredName", true);
        this.predictAugLevels = new SplusComboBox("Levels", 'V', new String[]{"0", "1", "2", "3", "4", "5"});
        this.predictAugLevels.setValue("");
        this.predictAugLevels.setEnabled(false);
        splusGroupPanel15.add(this.predictAugLevels);
        splusFunctionInfo.add(this.predictAugLevels, "augPredLevel", false, true);
        this.predictAugColumn = new SplusDataColumnComboBox("Primary Covariate", 'C', (SplusDataColumnListProvider)this.dataSet);
        this.predictAugColumn.setValue("");
        this.predictAugColumn.setEnabled(false);
        splusGroupPanel15.add(this.predictAugColumn);
        splusFunctionInfo.add(this.predictAugColumn, "augPredPrimary", true);
        this.predictAugMin = new SplusTextField("Minimum", 'M');
        this.predictAugMin.setEnabled(false);
        splusGroupPanel15.add(this.predictAugMin);
        splusFunctionInfo.add(this.predictAugMin, "augPredMin");
        this.predictAugMax = new SplusTextField("Maximum", 'X');
        this.predictAugMax.setEnabled(false);
        splusGroupPanel15.add(this.predictAugMax);
        splusFunctionInfo.add(this.predictAugMax, "augPredMax");
        this.predictAugLength = new SplusTextField("Number of Values", 'U');
        this.predictAugLength.setEnabled(false);
        splusGroupPanel15.add(this.predictAugLength);
        splusFunctionInfo.add(this.predictAugLength, "augPredLength");
        this.predictAugSavePredictions.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = NonlinearMixedEffectsDialog.this.predictAugSavePredictions.getValue().equals("T");
                NonlinearMixedEffectsDialog.this.predictAugSaveIn.setEnabled(bl);
                NonlinearMixedEffectsDialog.this.predictAugColumn.setEnabled(bl);
                NonlinearMixedEffectsDialog.this.predictAugLevels.setEnabled(bl);
                NonlinearMixedEffectsDialog.this.predictAugMin.setEnabled(bl);
                NonlinearMixedEffectsDialog.this.predictAugMax.setEnabled(bl);
                NonlinearMixedEffectsDialog.this.predictAugLength.setEnabled(bl);
            }
        });
        box14.add(new SplusBoxFiller());
        this.setCenterPanel(jTabbedPane);
    }

    public boolean isComplete() {
        return this.warnIfEmpty(this.dataSet);
    }

    private class PlotRandomActionListener
    implements ActionListener {
        private PlotRandomActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = NonlinearMixedEffectsDialog.this.plotRandomDot.getValue().equals("T") || NonlinearMixedEffectsDialog.this.plotRandomScatter.getValue().equals("T") || NonlinearMixedEffectsDialog.this.plotRandomQQ.getValue().equals("T");
            NonlinearMixedEffectsDialog.this.plotRandomLevels.setEnabled(bl);
        }
    }
}

