/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splusserver.api.storage;

import com.insightful.splusserver.exception.StorageException;
import com.insightful.splusserver.storage.IClientStorage;
import com.insightful.webdavaccess.client.WebdavClient;
import com.insightful.webdavaccess.client.WebdavInfo;
import java.io.File;
import java.io.Serializable;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClientStorage
implements IClientStorage,
Serializable {
    private static final long serialVersionUID = 5105L;
    private static Log log = LogFactory.getLog(ClientStorage.class);
    private final WebdavClient client;

    public ClientStorage() throws StorageException {
        this.client = new WebdavClient();
    }

    public ClientStorage(String user, String password) throws StorageException {
        this.client = new WebdavClient(user, password);
    }

    public boolean copy(String source, String destination, boolean overwrite) throws StorageException {
        try {
            return this.client.doCopy(source, destination, overwrite);
        }
        catch (Exception e) {
            log.error((Object)"Unable to copy resource", (Throwable)e);
            throw new StorageException((Throwable)e);
        }
    }

    public Vector findProperties(String url, String[] propNames) throws StorageException {
        try {
            return this.client.findProperties(url, propNames);
        }
        catch (Exception e) {
            log.error((Object)"Unable to find properties", (Throwable)e);
            throw new StorageException((Throwable)e);
        }
    }

    public Vector findProperties(String uri, String[] propNames, String depth, String type) throws StorageException {
        try {
            return this.client.findProperties(uri, propNames, depth, type);
        }
        catch (Exception e) {
            log.error((Object)"Unable to find properties", (Throwable)e);
            throw new StorageException((Throwable)e);
        }
    }

    public boolean move(String source, String destination, boolean overwrite) throws StorageException {
        try {
            return this.client.doMove(source, destination, overwrite);
        }
        catch (Exception e) {
            log.error((Object)"Unable to move resource", (Throwable)e);
            throw new StorageException((Throwable)e);
        }
    }

    public boolean setProperties(String url, String[] propNames, String[] propValues) throws StorageException {
        try {
            return this.client.setProperties(url, propNames, propValues);
        }
        catch (Exception e) {
            log.error((Object)"Unable to set properties", (Throwable)e);
            throw new StorageException((Throwable)e);
        }
    }

    public boolean downloadFile(String url, File file) throws StorageException {
        try {
            return this.client.doDownloadFile(url, file);
        }
        catch (Exception e) {
            log.error((Object)"Unable to create download file", (Throwable)e);
            throw new StorageException((Throwable)e);
        }
    }

    public boolean createFolder(String url) throws StorageException {
        try {
            return this.client.doMkcol(url, null, null, null);
        }
        catch (Exception e) {
            log.error((Object)"Unable to create folder", (Throwable)e);
            throw new StorageException((Throwable)e);
        }
    }

    public boolean delete(String url) throws StorageException {
        try {
            return this.client.doDelete(url);
        }
        catch (Exception e) {
            log.error((Object)"Unable to delete resource", (Throwable)e);
            throw new StorageException((Throwable)e);
        }
    }

    public Vector getList(String url) throws StorageException {
        try {
            return this.client.getList(url);
        }
        catch (Exception e) {
            log.error((Object)"Unable to get list", (Throwable)e);
            throw new StorageException((Throwable)e);
        }
    }

    public WebdavInfo getInfo(String url) throws StorageException {
        try {
            return this.client.getInfo(url);
        }
        catch (Exception e) {
            log.error((Object)"Unable to get info", (Throwable)e);
            throw new StorageException((Throwable)e);
        }
    }

    public boolean uploadFile(String url, File file) throws StorageException {
        try {
            return this.client.doUploadFile(url, file);
        }
        catch (Exception e) {
            log.error((Object)"Unable to upload file", (Throwable)e);
            throw new StorageException((Throwable)e);
        }
    }

    public int getStatusCode() {
        return this.client.getCurrentStatusCode();
    }

    public String getStatusMessage() {
        return this.client.getCurrentStatusMessage();
    }

    public boolean exists(String url) throws StorageException {
        try {
            return this.client.doExists(url);
        }
        catch (Exception e) {
            log.error((Object)"Unable to check if resource exists", (Throwable)e);
            throw new StorageException((Throwable)e);
        }
    }

    public boolean isCollection(String url) throws StorageException {
        try {
            return this.client.doIsCollection(url);
        }
        catch (Exception e) {
            log.error((Object)"Unable to check if resource is collection", (Throwable)e);
            throw new StorageException((Throwable)e);
        }
    }
}

