/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.CRIFImpl;
import com.sun.media.jai.opimage.ConstantOpImage;
import com.sun.media.jai.opimage.RIFUtil;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderContext;
import javax.media.jai.ImageLayout;

public class ConstantCRIF
extends CRIFImpl {
    private static final int DEFAULT_TILE_SIZE = 128;

    public ConstantCRIF() {
        super("constant");
    }

    public RenderedImage create(ParameterBlock parameterBlock, RenderingHints renderingHints) {
        ImageLayout imageLayout = RIFUtil.getImageLayoutHint(renderingHints);
        int n = Math.round(parameterBlock.getFloatParameter(0));
        int n2 = Math.round(parameterBlock.getFloatParameter(1));
        Number[] numberArray = (Number[])parameterBlock.getObjectParameter(2);
        int n3 = 0;
        int n4 = 0;
        int n5 = Math.min(n, 128);
        int n6 = Math.min(n2, 128);
        if (imageLayout != null) {
            if (imageLayout.isValid(1)) {
                n3 = imageLayout.getMinX(null);
            }
            if (imageLayout.isValid(2)) {
                n4 = imageLayout.getMinY(null);
            }
            if (imageLayout.isValid(64)) {
                n5 = imageLayout.getTileWidth(null);
            }
            if (imageLayout.isValid(128)) {
                n6 = imageLayout.getTileHeight(null);
            }
        }
        return new ConstantOpImage(n3, n4, n, n2, n5, n6, numberArray);
    }

    public RenderedImage create(RenderContext renderContext, ParameterBlock parameterBlock) {
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = parameterBlock.getFloatParameter(0);
        float f4 = parameterBlock.getFloatParameter(1);
        Number[] numberArray = (Number[])parameterBlock.getObjectParameter(2);
        AffineTransform affineTransform = renderContext.getTransform();
        float[] fArray = new float[8];
        float[] fArray2 = new float[8];
        fArray[0] = f;
        fArray[1] = f2;
        fArray[2] = f + f3;
        fArray[3] = f2;
        fArray[4] = f + f3;
        fArray[5] = f2 + f4;
        fArray[6] = f;
        fArray[7] = f2 + f4;
        affineTransform.transform(fArray, 0, fArray2, 0, 4);
        f = Math.min(fArray2[0], fArray2[2]);
        f = Math.min(f, fArray2[4]);
        f = Math.min(f, fArray2[6]);
        float f5 = Math.max(fArray2[0], fArray2[2]);
        f5 = Math.max(f5, fArray2[4]);
        f5 = Math.max(f5, fArray2[6]);
        f2 = Math.min(fArray2[1], fArray2[3]);
        f2 = Math.min(f2, fArray2[5]);
        f2 = Math.min(f2, fArray2[7]);
        float f6 = Math.max(fArray2[1], fArray2[3]);
        f6 = Math.max(f6, fArray2[5]);
        f6 = Math.max(f6, fArray2[7]);
        int n = (int)f;
        int n2 = (int)f2;
        int n3 = (int)f5 - n;
        int n4 = (int)f6 - n2;
        return new ConstantOpImage(n, n2, n3, n4, Math.min(n3, 128), Math.min(n4, 128), numberArray);
    }

    public Rectangle2D getBounds2D(ParameterBlock parameterBlock) {
        return new Rectangle2D.Float(0.0f, 0.0f, parameterBlock.getFloatParameter(0), parameterBlock.getFloatParameter(1));
    }
}

