/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import java.awt.image.ComponentSampleModel;
import java.awt.image.SampleModel;

public final class RasterFormatTag {
    private static final int COPY_MASK = 384;
    private static final int UNCOPIED = 0;
    private static final int COPIED = 128;
    private int formatTagID;
    private int[] bankIndices;
    private int numBands;
    private int[] bandOffsets;
    private int pixelStride;
    private boolean isPixelSequential;

    public RasterFormatTag(SampleModel sampleModel, int n) {
        this.formatTagID = n;
        if ((n & 0x180) == 0) {
            ComponentSampleModel componentSampleModel = (ComponentSampleModel)sampleModel;
            this.bankIndices = componentSampleModel.getBankIndices();
            this.numBands = componentSampleModel.getNumDataElements();
            this.bandOffsets = componentSampleModel.getBandOffsets();
            this.pixelStride = componentSampleModel.getPixelStride();
            if (this.pixelStride != this.bandOffsets.length) {
                this.isPixelSequential = false;
            } else {
                this.isPixelSequential = true;
                int n2 = 0;
                while (n2 < this.bandOffsets.length) {
                    if (this.bandOffsets[n2] >= this.pixelStride || this.bankIndices[n2] != this.bankIndices[0]) {
                        this.isPixelSequential = false;
                    }
                    int n3 = n2 + 1;
                    while (n3 < this.bandOffsets.length) {
                        if (this.bandOffsets[n2] == this.bandOffsets[n3]) {
                            this.isPixelSequential = false;
                        }
                        ++n3;
                    }
                    if (this.isPixelSequential) {
                        ++n2;
                        continue;
                    }
                    break;
                }
            }
        } else if ((n & 0x180) == 128) {
            this.numBands = sampleModel.getNumBands();
            this.bandOffsets = new int[this.numBands];
            this.pixelStride = this.numBands;
            this.bankIndices = new int[this.numBands];
            int n4 = 0;
            while (n4 < this.numBands) {
                this.bandOffsets[n4] = n4;
                this.bankIndices[n4] = 0;
                ++n4;
            }
            this.isPixelSequential = true;
        }
    }

    public final int[] getBandOffsets() {
        if (this.isPixelSequential) {
            return this.bandOffsets;
        }
        return null;
    }

    public final int[] getBankIndices() {
        if (this.isPixelSequential) {
            return this.bankIndices;
        }
        return null;
    }

    public final int getFormatTagID() {
        return this.formatTagID;
    }

    public final int getNumBands() {
        return this.numBands;
    }

    public final int getPixelStride() {
        return this.pixelStride;
    }

    public final boolean isPixelSequential() {
        return this.isPixelSequential;
    }
}

