/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.gdevice;

import com.insightful.gdevice.IDHash;
import com.insightful.gdevice.SCanvasAWT;
import com.insightful.gdevice.SGraphCommand;
import com.insightful.gdevice.XML;
import com.insightful.gdevice.XMLElement;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.io.PrintWriter;

class SGraphPolygon
extends SGraphCommand {
    private float[] m_ax;
    private float[] m_ay;
    private transient Polygon m_poly;

    SGraphPolygon(float[] fArray, float[] fArray2) {
        this.m_ax = fArray;
        this.m_ay = fArray2;
    }

    void graphSizeChanged() {
        this.m_poly = null;
    }

    public void releaseMemory() {
        this.m_poly = null;
    }

    void display(SCanvasAWT sCanvasAWT, Graphics graphics) {
        Rectangle rectangle = this.setParClip(sCanvasAWT, graphics);
        int n = this.getColorInt();
        if (this.getUseNewColor()) {
            this.setPolygonColor(sCanvasAWT, graphics);
        } else if (sCanvasAWT.usingPDFColorScheme()) {
            this.setPolygonColor(sCanvasAWT, graphics);
        } else if (n < 17 || n > 116) {
            this.setPolygonColor(sCanvasAWT, graphics);
        } else {
            graphics.setColor(sCanvasAWT.getImageColor((int)(1.0 + (double)(n - 17) * 255.0 / 99.0)));
        }
        if (this.m_poly == null) {
            this.m_poly = new Polygon();
            for (int i = 0; i < this.m_ax.length; ++i) {
                int n2 = this.valToWindowX(sCanvasAWT, this.m_ax[i]);
                int n3 = this.valToWindowY(sCanvasAWT, this.m_ay[i]);
                this.m_poly.addPoint(n2, n3);
            }
        }
        graphics.fillPolygon(this.m_poly);
        this.resetClip(sCanvasAWT, graphics, rectangle);
    }

    public String getXMLTag() {
        return "POLYGON";
    }

    public void writeXMLContents(PrintWriter printWriter) {
        XML.writeData(printWriter, "X", this.m_ax);
        XML.writeData(printWriter, "Y", this.m_ay);
    }

    public static SGraphCommand createFromXML(XMLElement xMLElement, IDHash iDHash) {
        float[] fArray = XML.getFloatArrayData(xMLElement, "X");
        float[] fArray2 = XML.getFloatArrayData(xMLElement, "Y");
        return new SGraphPolygon(fArray, fArray2);
    }
}

