/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.director;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.equinox.internal.provisional.p2.engine.InstallableUnitOperand;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnitFragment;
import org.eclipse.equinox.internal.provisional.p2.metadata.MetadataFactory;
import org.eclipse.equinox.internal.provisional.p2.metadata.query.InstallableUnitQuery;
import org.eclipse.equinox.internal.provisional.p2.query.Collector;

public class OperationGenerator {
    private static final IInstallableUnit NULL_IU = MetadataFactory.createResolvedInstallableUnit((IInstallableUnit)MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)new MetadataFactory.InstallableUnitDescription()), (IInstallableUnitFragment[])new IInstallableUnitFragment[0]);

    public InstallableUnitOperand[] generateOperation(Collection from_, Collection to_) {
        ArrayList from = new ArrayList(from_);
        Collections.sort(from);
        ArrayList to = new ArrayList(to_);
        Collections.sort(to);
        ArrayList operations = new ArrayList();
        this.generateUpdates(from, to, operations);
        this.generateInstallUninstall(from, to, operations);
        InstallableUnitOperand[] ops = operations.toArray(new InstallableUnitOperand[operations.size()]);
        return ops;
    }

    private void generateInstallUninstall(List from, List to, ArrayList operations) {
        int toIdx = 0;
        int fromIdx = 0;
        while (fromIdx != from.size() && toIdx != to.size()) {
            IInstallableUnit fromIU = (IInstallableUnit)from.get(fromIdx);
            IInstallableUnit toIU = (IInstallableUnit)to.get(toIdx);
            int comparison = toIU.compareTo((Object)fromIU);
            if (comparison < 0) {
                operations.add(this.createInstallOperation(toIU));
                ++toIdx;
                continue;
            }
            if (comparison == 0) {
                ++toIdx;
                ++fromIdx;
                continue;
            }
            operations.add(this.createUninstallOperation(fromIU));
            ++fromIdx;
        }
        if (fromIdx != from.size()) {
            int i = fromIdx;
            while (i < from.size()) {
                operations.add(this.createUninstallOperation((IInstallableUnit)from.get(i)));
                ++i;
            }
        }
        if (toIdx != to.size()) {
            int i = toIdx;
            while (i < to.size()) {
                operations.add(this.createInstallOperation((IInstallableUnit)to.get(i)));
                ++i;
            }
        }
    }

    private void generateUpdates(List from, List to, ArrayList operations) {
        HashSet<IInstallableUnit> processed = new HashSet<IInstallableUnit>();
        HashSet<IInstallableUnit> removedFromTo = new HashSet<IInstallableUnit>();
        int toIdx = 0;
        while (toIdx < to.size()) {
            InstallableUnitQuery updateQuery;
            Iterator updates;
            IInstallableUnit iuTo = (IInstallableUnit)to.get(toIdx);
            if (iuTo.getId().equals(this.next(to, toIdx).getId())) {
                toIdx = this.skip(to, iuTo, toIdx) - 1;
            } else if (iuTo.getUpdateDescriptor() != null && (updates = (updateQuery = new InstallableUnitQuery(iuTo.getUpdateDescriptor().getId(), iuTo.getUpdateDescriptor().getRange())).perform(from.iterator(), new Collector()).iterator()).hasNext()) {
                IInstallableUnit iuFrom = (IInstallableUnit)updates.next();
                if (!updates.hasNext()) {
                    if (iuTo.equals(iuFrom)) {
                        from.remove(iuFrom);
                        removedFromTo.add(iuTo);
                    } else {
                        operations.add(this.createUpdateOperation(iuFrom, iuTo));
                        from.remove(iuFrom);
                        processed.add(iuTo);
                    }
                }
            }
            ++toIdx;
        }
        to.removeAll(processed);
        to.removeAll(removedFromTo);
    }

    private InstallableUnitOperand createUninstallOperation(IInstallableUnit iu) {
        return new InstallableUnitOperand(iu, null);
    }

    private InstallableUnitOperand createInstallOperation(IInstallableUnit iu) {
        return new InstallableUnitOperand(null, iu);
    }

    private InstallableUnitOperand createUpdateOperation(IInstallableUnit from, IInstallableUnit to) {
        return new InstallableUnitOperand(from, to);
    }

    private IInstallableUnit next(List l, int i) {
        if (++i >= l.size()) {
            return NULL_IU;
        }
        return (IInstallableUnit)l.get(i);
    }

    private int skip(List c, IInstallableUnit id, int idx) {
        int i = idx;
        while (i < c.size()) {
            if (!id.getId().equals(((IInstallableUnit)c.get(i)).getId())) {
                return i;
            }
            ++i;
        }
        return i;
    }
}

