/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart.demo;

import com.jrefinery.chart.Axis;
import com.jrefinery.chart.AxisNotCompatibleException;
import com.jrefinery.chart.ChartFactory;
import com.jrefinery.chart.HorizontalNumberAxis;
import com.jrefinery.chart.HorizontalSymbolicAxis;
import com.jrefinery.chart.JFreeChart;
import com.jrefinery.chart.JFreeChartConstants;
import com.jrefinery.chart.JFreeChartFrame;
import com.jrefinery.chart.PlotNotCompatibleException;
import com.jrefinery.chart.StandardXYItemRenderer;
import com.jrefinery.chart.ValueAxis;
import com.jrefinery.chart.VerticalSymbolicAxis;
import com.jrefinery.chart.XYPlot;
import com.jrefinery.chart.combination.CombinedChart;
import com.jrefinery.chart.combination.CombinedPlot;
import com.jrefinery.chart.combination.OverlaidPlot;
import com.jrefinery.chart.demo.SampleXYSymbolicDataset;
import com.jrefinery.chart.demo.SampleYSymbolicDataset;
import com.jrefinery.chart.tooltips.SymbolicXYToolTipGenerator;
import com.jrefinery.data.CombinedDataset;
import com.jrefinery.data.Dataset;
import com.jrefinery.data.SeriesDataset;
import com.jrefinery.data.SubSeriesDataset;
import com.jrefinery.data.XYDataset;
import com.jrefinery.data.XisSymbolic;
import com.jrefinery.data.YisSymbolic;
import com.jrefinery.ui.JRefineryUtilities;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Window;
import java.lang.reflect.Array;
import javax.swing.JFrame;

public class SymbolicXYPlotDemo {
    private static void displayXYSymbolic(XYDataset xYDataset, String string, String string2, String string3) {
        JFreeChart jFreeChart = SymbolicXYPlotDemo.createXYSymbolicPlot(string, string2, string3, xYDataset, true);
        jFreeChart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 1000.0f, 0.0f, Color.green));
        JFreeChartFrame jFreeChartFrame = new JFreeChartFrame("XYPlot", jFreeChart);
        jFreeChartFrame.pack();
        JRefineryUtilities.positionFrameRandomly((JFrame)jFreeChartFrame);
        jFreeChartFrame.show();
    }

    private static void displayXYSymbolicCombinedVertically(XYDataset xYDataset, XYDataset xYDataset2) {
        Object object;
        String string = "Pollutant Vertically Combined";
        String string2 = "Contamination and Type";
        String string3 = "Pollutant";
        String[] stringArray = SampleXYSymbolicDataset.combineXSymbolicDataset((XisSymbolic)xYDataset, (XisSymbolic)xYDataset2);
        CombinedDataset combinedDataset = new CombinedDataset();
        combinedDataset.add((SeriesDataset)xYDataset);
        combinedDataset.add((SeriesDataset)xYDataset2);
        SubSeriesDataset subSeriesDataset = new SubSeriesDataset((SeriesDataset)combinedDataset, 0);
        SubSeriesDataset subSeriesDataset2 = new SubSeriesDataset((SeriesDataset)combinedDataset, 1);
        JFreeChart jFreeChart = null;
        try {
            object = new HorizontalSymbolicAxis(string2, stringArray);
            VerticalSymbolicAxis verticalSymbolicAxis = new VerticalSymbolicAxis(string3, ((YisSymbolic)xYDataset).getYSymbolicValues());
            VerticalSymbolicAxis verticalSymbolicAxis2 = new VerticalSymbolicAxis(string3, ((YisSymbolic)xYDataset2).getYSymbolicValues());
            verticalSymbolicAxis.setCrosshairVisible(false);
            verticalSymbolicAxis2.setCrosshairVisible(false);
            ((ValueAxis)object).setCrosshairVisible(false);
            CombinedPlot combinedPlot = new CombinedPlot((Axis)object, 1);
            combinedPlot.add(SymbolicXYPlotDemo.createCombinableXYChart((ValueAxis)object, verticalSymbolicAxis, (Dataset)subSeriesDataset, 0));
            combinedPlot.add(SymbolicXYPlotDemo.createCombinableXYChart((ValueAxis)object, verticalSymbolicAxis2, (Dataset)subSeriesDataset2, 0));
            combinedPlot.adjustPlots();
            jFreeChart = new JFreeChart((Dataset)combinedDataset, combinedPlot, string, JFreeChartConstants.DEFAULT_TITLE_FONT, true);
        }
        catch (AxisNotCompatibleException axisNotCompatibleException) {
            System.err.println("axis not compatible: " + axisNotCompatibleException);
        }
        catch (PlotNotCompatibleException plotNotCompatibleException) {
            System.err.println("axis not compatible: " + plotNotCompatibleException);
        }
        jFreeChart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.blue));
        object = new JFreeChartFrame("XYPlot", jFreeChart);
        ((Window)object).pack();
        JRefineryUtilities.positionFrameRandomly((JFrame)object);
        ((Window)object).show();
    }

    private static void displayXYSymbolicCombinedHorizontally(XYDataset xYDataset, XYDataset xYDataset2) {
        Object object;
        String string = "Pollutant Horizontally Combined";
        String string2 = "Contamination";
        String string3 = "Type";
        String string4 = "Pollutant";
        String[] stringArray = SampleXYSymbolicDataset.combineYSymbolicDataset((YisSymbolic)xYDataset, (YisSymbolic)xYDataset2);
        CombinedDataset combinedDataset = new CombinedDataset();
        combinedDataset.add((SeriesDataset)xYDataset);
        combinedDataset.add((SeriesDataset)xYDataset2);
        SubSeriesDataset subSeriesDataset = new SubSeriesDataset((SeriesDataset)combinedDataset, 0);
        SubSeriesDataset subSeriesDataset2 = new SubSeriesDataset((SeriesDataset)combinedDataset, 1);
        JFreeChart jFreeChart = null;
        try {
            object = new HorizontalSymbolicAxis(string2, ((XisSymbolic)xYDataset).getXSymbolicValues());
            HorizontalSymbolicAxis horizontalSymbolicAxis = new HorizontalSymbolicAxis(string3, ((XisSymbolic)xYDataset2).getXSymbolicValues());
            VerticalSymbolicAxis verticalSymbolicAxis = new VerticalSymbolicAxis(string4, stringArray);
            verticalSymbolicAxis.setCrosshairVisible(false);
            ((ValueAxis)object).setCrosshairVisible(false);
            horizontalSymbolicAxis.setCrosshairVisible(false);
            CombinedPlot combinedPlot = new CombinedPlot((Axis)verticalSymbolicAxis, 0);
            combinedPlot.add(SymbolicXYPlotDemo.createCombinableXYChart((ValueAxis)object, verticalSymbolicAxis, (Dataset)subSeriesDataset, 0));
            combinedPlot.add(SymbolicXYPlotDemo.createCombinableXYChart(horizontalSymbolicAxis, verticalSymbolicAxis, (Dataset)subSeriesDataset2, 0));
            combinedPlot.adjustPlots();
            jFreeChart = new JFreeChart((Dataset)combinedDataset, combinedPlot, string, JFreeChartConstants.DEFAULT_TITLE_FONT, true);
        }
        catch (AxisNotCompatibleException axisNotCompatibleException) {
            System.err.println("axis not compatible: " + axisNotCompatibleException);
        }
        catch (PlotNotCompatibleException plotNotCompatibleException) {
            System.err.println("axis not compatible: " + plotNotCompatibleException);
        }
        jFreeChart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.blue));
        object = new JFreeChartFrame("XYPlot", jFreeChart);
        ((Window)object).pack();
        JRefineryUtilities.positionFrameRandomly((JFrame)object);
        ((Window)object).show();
    }

    private static void displayXYSymbolicOverlaid(XYDataset xYDataset, XYDataset xYDataset2) {
        Object object;
        String string = "Pollutant Overlaided";
        String string2 = "Contamination and Type";
        String string3 = "Pollutant";
        String[] stringArray = SampleXYSymbolicDataset.combineXSymbolicDataset((XisSymbolic)xYDataset, (XisSymbolic)xYDataset2);
        String[] stringArray2 = SampleXYSymbolicDataset.combineYSymbolicDataset((YisSymbolic)xYDataset, (YisSymbolic)xYDataset2);
        CombinedDataset combinedDataset = new CombinedDataset();
        combinedDataset.add((SeriesDataset)xYDataset);
        combinedDataset.add((SeriesDataset)xYDataset2);
        SubSeriesDataset subSeriesDataset = new SubSeriesDataset((SeriesDataset)combinedDataset, 0);
        SubSeriesDataset subSeriesDataset2 = new SubSeriesDataset((SeriesDataset)combinedDataset, 1);
        JFreeChart jFreeChart = null;
        try {
            object = new HorizontalSymbolicAxis(string2, stringArray);
            VerticalSymbolicAxis verticalSymbolicAxis = new VerticalSymbolicAxis(string3, stringArray2);
            ((ValueAxis)object).setCrosshairVisible(false);
            verticalSymbolicAxis.setCrosshairVisible(false);
            OverlaidPlot overlaidPlot = new OverlaidPlot((Axis)object, verticalSymbolicAxis);
            overlaidPlot.add(SymbolicXYPlotDemo.createCombinableXYChart((ValueAxis)object, verticalSymbolicAxis, (Dataset)subSeriesDataset, 0));
            overlaidPlot.add(SymbolicXYPlotDemo.createCombinableXYChart((ValueAxis)object, verticalSymbolicAxis, (Dataset)subSeriesDataset2, 0));
            overlaidPlot.adjustPlots();
            jFreeChart = new JFreeChart((Dataset)combinedDataset, overlaidPlot, string, JFreeChartConstants.DEFAULT_TITLE_FONT, true);
        }
        catch (AxisNotCompatibleException axisNotCompatibleException) {
            System.err.println("axis not compatible: " + axisNotCompatibleException);
        }
        catch (PlotNotCompatibleException plotNotCompatibleException) {
            System.err.println("axis not compatible: " + plotNotCompatibleException);
        }
        jFreeChart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 0.0f, 1000.0f, Color.blue));
        object = new JFreeChartFrame("XYPlot", jFreeChart);
        ((Window)object).pack();
        JRefineryUtilities.positionFrameRandomly((JFrame)object);
        ((Window)object).show();
    }

    public static JFreeChart createYSymbolicPlot(String string, String string2, String string3, XYDataset xYDataset, boolean bl) {
        HorizontalNumberAxis horizontalNumberAxis = new HorizontalNumberAxis(string2);
        VerticalSymbolicAxis verticalSymbolicAxis = new VerticalSymbolicAxis(string3, ((YisSymbolic)xYDataset).getYSymbolicValues());
        XYPlot xYPlot = new XYPlot(horizontalNumberAxis, verticalSymbolicAxis);
        xYPlot.setXYItemRenderer(new StandardXYItemRenderer(1));
        xYPlot.setToolTipGenerator(new SymbolicXYToolTipGenerator());
        JFreeChart jFreeChart = new JFreeChart((Dataset)xYDataset, xYPlot, string, JFreeChartConstants.DEFAULT_TITLE_FONT, bl);
        return jFreeChart;
    }

    public static JFreeChart createXYSymbolicPlot(String string, String string2, String string3, XYDataset xYDataset, boolean bl) {
        HorizontalSymbolicAxis horizontalSymbolicAxis = new HorizontalSymbolicAxis(string2, ((XisSymbolic)xYDataset).getXSymbolicValues());
        VerticalSymbolicAxis verticalSymbolicAxis = new VerticalSymbolicAxis(string3, ((YisSymbolic)xYDataset).getYSymbolicValues());
        XYPlot xYPlot = new XYPlot(horizontalSymbolicAxis, verticalSymbolicAxis);
        xYPlot.setXYItemRenderer(new StandardXYItemRenderer(1));
        xYPlot.setToolTipGenerator(new SymbolicXYToolTipGenerator());
        JFreeChart jFreeChart = new JFreeChart((Dataset)xYDataset, xYPlot, string, JFreeChartConstants.DEFAULT_TITLE_FONT, bl);
        return jFreeChart;
    }

    public static CombinedChart createCombinableXYChart(ValueAxis valueAxis, ValueAxis valueAxis2, Dataset dataset, int n) {
        XYPlot xYPlot = new XYPlot(valueAxis, valueAxis2);
        xYPlot.setXYItemRenderer(new StandardXYItemRenderer(1));
        return ChartFactory.createCombinableChart(dataset, xYPlot);
    }

    public static SampleYSymbolicDataset createYSymbolicSample1() {
        String[] stringArray = new String[]{"Lion", "Elephant", "Monkey", "Hippopotamus", "Giraffe"};
        SampleYSymbolicDataset sampleYSymbolicDataset = new SampleYSymbolicDataset("AY Sample", 20, stringArray, 4, 20, new String[]{"Fall", "Spring", "Summer", "Winter"});
        return sampleYSymbolicDataset;
    }

    public static SampleYSymbolicDataset createYSymbolicSample2() {
        String[] stringArray = new String[]{"Giraffe", "Gazelle", "Zebra", "Gnu"};
        SampleYSymbolicDataset sampleYSymbolicDataset = new SampleYSymbolicDataset("BY Sample", 40, stringArray, 4, 10, new String[]{"Fall", "Spring", "Summer", "Winter"});
        return sampleYSymbolicDataset;
    }

    public static SampleXYSymbolicDataset createXYSymbolicSample1() {
        String[] stringArray = new String[]{"Atmosphere", "Continental Ecosystem", "Limnic Ecosystem", "Marine Ecosystem"};
        String[] stringArray2 = new String[]{"Ionizing radiations", "Thermic pollutants", "Hydrocarbon", "Synthetic materials", "Pesticides", "Detergent", "Synthetic organic materials", "Sulphur", "Nitrate", "Phosphate", "Heavy metals", "Fluors", "Aerosols", "Dead organic materials", "Pathogen micro-organisms"};
        int[][] nArrayArray = new int[][]{{0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3}};
        int[][] nArrayArray2 = new int[][]{{0, 2, 3, 7, 10, 11, 12, 14, 0, 2, 3, 4, 7, 8, 9, 10, 11, 12, 14, 0, 1, 2, 3, 4, 5, 7, 8, 9, 10, 13, 14, 0, 1, 2, 3, 4, 5, 8, 9, 10, 13, 14}};
        Integer[][] integerArray = (Integer[][])SymbolicXYPlotDemo.toArray(nArrayArray);
        Integer[][] integerArray2 = (Integer[][])SymbolicXYPlotDemo.toArray(nArrayArray2);
        SampleXYSymbolicDataset sampleXYSymbolicDataset = new SampleXYSymbolicDataset("AXY Sample", integerArray, integerArray2, stringArray, stringArray2, new String[]{"A"});
        return sampleXYSymbolicDataset;
    }

    public static SampleXYSymbolicDataset createXYSymbolicSample2() {
        String[] stringArray = new String[]{"Physic pollutant", "Chemical pollutant", "Biological pollutant"};
        String[] stringArray2 = new String[]{"Ionizing radiations", "Thermic pollutants", "Hydrocarbon", "Synthetic materials", "Pesticides", "Detergent", "Synthetic organic materials", "Sulphur", "Nitrate", "Phosphate", "Heavy metals", "Fluors", "Aerosols", "Dead organic materials", "Pathogen micro-organisms"};
        int[][] nArrayArray = new int[][]{{0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2}};
        int[][] nArrayArray2 = new int[][]{{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14}};
        Integer[][] integerArray = (Integer[][])SymbolicXYPlotDemo.toArray(nArrayArray);
        Integer[][] integerArray2 = (Integer[][])SymbolicXYPlotDemo.toArray(nArrayArray2);
        SampleXYSymbolicDataset sampleXYSymbolicDataset = new SampleXYSymbolicDataset("BXY Sample", integerArray, integerArray2, stringArray, stringArray2, new String[]{"B"});
        return sampleXYSymbolicDataset;
    }

    public static void main(String[] stringArray) {
        SampleXYSymbolicDataset sampleXYSymbolicDataset = SymbolicXYPlotDemo.createXYSymbolicSample1();
        SampleXYSymbolicDataset sampleXYSymbolicDataset2 = SymbolicXYPlotDemo.createXYSymbolicSample2();
        SymbolicXYPlotDemo.displayXYSymbolic(sampleXYSymbolicDataset, "Pollutant", "contamination", "pollutant");
        SymbolicXYPlotDemo.displayXYSymbolic(sampleXYSymbolicDataset2, "Pollutant", "type", "pollutant");
        SymbolicXYPlotDemo.displayXYSymbolicCombinedVertically((SampleXYSymbolicDataset)((Object)sampleXYSymbolicDataset.clone()), (SampleXYSymbolicDataset)((Object)sampleXYSymbolicDataset2.clone()));
        SymbolicXYPlotDemo.displayXYSymbolicCombinedHorizontally((SampleXYSymbolicDataset)((Object)sampleXYSymbolicDataset.clone()), (SampleXYSymbolicDataset)((Object)sampleXYSymbolicDataset2.clone()));
        SymbolicXYPlotDemo.displayXYSymbolicOverlaid((SampleXYSymbolicDataset)((Object)sampleXYSymbolicDataset.clone()), (SampleXYSymbolicDataset)((Object)sampleXYSymbolicDataset2.clone()));
    }

    private static Object toArray(Object object) {
        if (object == null) {
            return object;
        }
        Class<?> clazz = object.getClass();
        if (!clazz.isArray()) {
            return object;
        }
        Class<?> clazz2 = clazz.getComponentType();
        int n = 1;
        while (!clazz2.isPrimitive()) {
            if (!clazz2.isArray()) {
                return object;
            }
            ++n;
            clazz2 = clazz2.getComponentType();
        }
        int[] nArray = new int[n];
        nArray[0] = Array.getLength(object);
        Object[] objectArray = null;
        try {
            if (clazz2.equals(Integer.TYPE)) {
                objectArray = (Object[])Array.newInstance(Class.forName("java.lang.Integer"), nArray);
            } else if (clazz2.equals(Double.TYPE)) {
                objectArray = (Object[])Array.newInstance(Class.forName("java.lang.Double"), nArray);
            } else if (clazz2.equals(Long.TYPE)) {
                objectArray = (Object[])Array.newInstance(Class.forName("java.lang.Long"), nArray);
            } else if (clazz2.equals(Float.TYPE)) {
                objectArray = (Object[])Array.newInstance(Class.forName("java.lang.Float"), nArray);
            } else if (clazz2.equals(Short.TYPE)) {
                objectArray = (Object[])Array.newInstance(Class.forName("java.lang.Short"), nArray);
            } else if (clazz2.equals(Byte.TYPE)) {
                objectArray = (Object[])Array.newInstance(Class.forName("java.lang.Byte"), nArray);
            } else if (clazz2.equals(Character.TYPE)) {
                objectArray = (Object[])Array.newInstance(Class.forName("java.lang.Character"), nArray);
            } else if (clazz2.equals(Boolean.TYPE)) {
                objectArray = (Object[])Array.newInstance(Class.forName("java.lang.Boolean"), nArray);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println(classNotFoundException);
        }
        int n2 = 0;
        while (n2 < nArray[0]) {
            objectArray[n2] = n != 1 ? SymbolicXYPlotDemo.toArray(Array.get(object, n2)) : Array.get(object, n2);
            ++n2;
        }
        return objectArray;
    }
}

