/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.data;

import com.jrefinery.data.Day;
import com.jrefinery.data.TimePeriod;
import com.jrefinery.data.TimePeriodFormatException;
import com.jrefinery.data.Year;
import com.jrefinery.date.SerialDate;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class Week
extends TimePeriod {
    public static int FIRST_WEEK_IN_YEAR = 1;
    public static int LAST_WEEK_IN_YEAR = 52;
    protected Year year;
    protected int week;

    public Week() {
        this(new Date());
    }

    public Week(int n, int n2) {
        this(n, new Year(n2));
    }

    public Week(int n, Year year) {
        if (n < 1 && n > 52) {
            throw new IllegalArgumentException("Week(...): week outside valid range.");
        }
        this.week = n;
        this.year = year;
    }

    public Week(Date date) {
        this(date, TimePeriod.DEFAULT_TIME_ZONE);
    }

    public Week(Date date, TimeZone timeZone) {
        Calendar calendar = Calendar.getInstance(timeZone);
        calendar.setTime(date);
        this.week = Math.min(calendar.get(3), 52);
        this.year = new Year(calendar.get(1));
    }

    public Year getYear() {
        return this.year;
    }

    public int getYearValue() {
        return this.year.getYear();
    }

    public int getWeek() {
        return this.week;
    }

    public TimePeriod previous() {
        Year year;
        Week week = this.week != FIRST_WEEK_IN_YEAR ? new Week(this.week - 1, this.year) : ((year = (Year)this.year.previous()) != null ? new Week(LAST_WEEK_IN_YEAR, year) : null);
        return week;
    }

    public TimePeriod next() {
        Year year;
        Week week = this.week != LAST_WEEK_IN_YEAR ? new Week(this.week + 1, this.year) : ((year = (Year)this.year.next()) != null ? new Week(FIRST_WEEK_IN_YEAR, year) : null);
        return week;
    }

    public String toString() {
        return "Week " + this.week + ", " + this.year;
    }

    public boolean equals(Object object) {
        if (object != null) {
            if (object instanceof Week) {
                Week week = (Week)object;
                return this.week == week.getWeek() && this.year.equals(week.getYear());
            }
            return false;
        }
        return false;
    }

    public int compareTo(Object object) {
        int n;
        if (object instanceof Week) {
            Week week = (Week)object;
            n = this.year.getYear() - week.getYear().getYear();
            if (n == 0) {
                n = this.week - week.getWeek();
            }
        } else {
            n = object instanceof TimePeriod ? 0 : 1;
        }
        return n;
    }

    public long getStart(Calendar calendar) {
        SerialDate serialDate = SerialDate.createInstance(1, 1, this.year.getYear());
        SerialDate serialDate2 = SerialDate.addDays((this.week - 1) * 7, serialDate);
        Day day = new Day(serialDate2);
        return day.getStart(calendar);
    }

    public long getEnd(Calendar calendar) {
        if (this.week == LAST_WEEK_IN_YEAR) {
            return this.year.getEnd(calendar);
        }
        SerialDate serialDate = SerialDate.createInstance(1, 1, this.year.getYear());
        SerialDate serialDate2 = SerialDate.addDays(this.week * 7 - 1, serialDate);
        Day day = new Day(serialDate2);
        return day.getEnd(calendar);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Week parseWeek(String string) throws TimePeriodFormatException {
        Week week = null;
        if (string == null) return week;
        int n = Week.findSeparator(string = string.trim());
        if (n == -1) throw new TimePeriodFormatException("Week.parseWeek(String): could not find separator.");
        String string2 = string.substring(0, n).trim();
        String string3 = string.substring(n + 1, string.length()).trim();
        Year year = Week.evaluateAsYear(string2);
        if (year != null) {
            int n2 = Week.stringToWeek(string3);
            if (n2 != -1) return new Week(n2, year);
            throw new TimePeriodFormatException("Week.parseWeek(String): can't evaluate the week.");
        }
        year = Week.evaluateAsYear(string3);
        if (year == null) throw new TimePeriodFormatException("Week.parseWeek(String): can't evaluate the year.");
        int n3 = Week.stringToWeek(string2);
        if (n3 != -1) return new Week(n3, year);
        throw new TimePeriodFormatException("Week.parseWeek(String): can't evaluate the week.");
    }

    private static int findSeparator(String string) {
        int n = -1;
        n = string.indexOf(45);
        if (n == -1) {
            n = string.indexOf(44);
        }
        if (n == -1) {
            n = string.indexOf(32);
        }
        if (n == -1) {
            n = string.indexOf(46);
        }
        return n;
    }

    private static Year evaluateAsYear(String string) {
        Year year = null;
        try {
            year = Year.parseYear(string);
        }
        catch (TimePeriodFormatException timePeriodFormatException) {
            // empty catch block
        }
        return year;
    }

    private static int stringToWeek(String string) {
        int n = -1;
        string = string.replace('W', ' ');
        string = string.trim();
        try {
            n = Integer.parseInt(string);
            if (n < 1 || n > 52) {
                n = -1;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n;
    }

    public static void main(String[] stringArray) {
        Week week = Week.parseWeek("W09-2000");
    }
}

