/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.apps;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.FOURIResolver;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.InputHandler;
import org.apache.fop.fo.ElementMapping;
import org.apache.fop.fo.FOEventHandler;
import org.apache.fop.layoutmgr.LayoutManagerMaker;
import org.apache.fop.pdf.PDFEncryptionParams;
import org.apache.fop.render.Renderer;
import org.apache.fop.render.XMLHandlerRegistry;

public class FOUserAgent {
    public static final float DEFAULT_PX2MM = 0.35277778f;
    private XMLHandlerRegistry xmlHandlers = new XMLHandlerRegistry();
    private String baseURL;
    private URIResolver uriResolver = null;
    private URIResolver foURIResolver = new FOURIResolver();
    private PDFEncryptionParams pdfEncryptionParams;
    private float px2mm = 0.35277778f;
    private Map rendererOptions = new HashMap();
    private InputHandler inputHandler = null;
    private File outputFile = null;
    private Renderer rendererOverride = null;
    private FOEventHandler foEventHandlerOverride = null;
    private LayoutManagerMaker lmMakerOverride = null;
    private Configuration userConfig = null;
    private Log log = LogFactory.getLog("FOP");
    private boolean strictValidation = true;
    private List additionalElementMappings = null;
    protected String producer = "Apache FOP Version " + Fop.getVersion();
    protected String creator = null;
    protected Date creationDate = null;
    protected String author = null;
    protected String title = null;
    protected String keywords = null;

    public void setInputHandler(InputHandler inputHandler) {
        this.inputHandler = inputHandler;
    }

    public InputHandler getInputHandler() {
        return this.inputHandler;
    }

    public void addElementMapping(ElementMapping elementMapping) {
        if (this.additionalElementMappings == null) {
            this.additionalElementMappings = new ArrayList();
        }
        this.additionalElementMappings.add(elementMapping);
    }

    public List getAdditionalElementMappings() {
        return this.additionalElementMappings;
    }

    public void setRendererOverride(Renderer renderer) {
        this.rendererOverride = renderer;
    }

    public Renderer getRendererOverride() {
        return this.rendererOverride;
    }

    public void setFOEventHandlerOverride(FOEventHandler handler) {
        this.foEventHandlerOverride = handler;
    }

    public FOEventHandler getFOEventHandlerOverride() {
        return this.foEventHandlerOverride;
    }

    public void setStrictValidation(boolean validateStrictly) {
        this.strictValidation = validateStrictly;
    }

    public boolean validateStrictly() {
        return this.strictValidation;
    }

    public void setLayoutManagerMakerOverride(LayoutManagerMaker lmMaker) {
        this.lmMakerOverride = lmMaker;
    }

    public LayoutManagerMaker getLayoutManagerMakerOverride() {
        return this.lmMakerOverride;
    }

    public void setProducer(String producer) {
        this.producer = producer;
    }

    public String getProducer() {
        return this.producer;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public void setKeywords(String keywords) {
        this.keywords = keywords;
    }

    public String getKeywords() {
        return this.keywords;
    }

    public Map getRendererOptions() {
        return this.rendererOptions;
    }

    public void setUserConfig(Configuration userConfig) {
        this.userConfig = userConfig;
    }

    public Configuration getUserConfig() {
        return this.userConfig;
    }

    public Configuration getUserRendererConfig(String mimeType) {
        if (this.userConfig == null || mimeType == null) {
            return null;
        }
        Configuration userRendererConfig = null;
        Configuration[] cfgs = this.userConfig.getChild("renderers").getChildren("renderer");
        for (int i = 0; i < cfgs.length; ++i) {
            Configuration cfg = cfgs[i];
            try {
                if (!cfg.getAttribute("mime").equals(mimeType)) continue;
                userRendererConfig = cfg;
                break;
            }
            catch (ConfigurationException e) {
                // empty catch block
            }
        }
        this.log.debug((userRendererConfig == null ? "No u" : "U") + "ser configuration found for MIME type " + mimeType);
        return userRendererConfig;
    }

    public void setBaseURL(String baseURL) {
        this.baseURL = baseURL;
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    public void setURIResolver(URIResolver uriResolver) {
        this.uriResolver = uriResolver;
    }

    public URIResolver getURIResolver() {
        return this.uriResolver;
    }

    public PDFEncryptionParams getPDFEncryptionParams() {
        return this.pdfEncryptionParams;
    }

    public void setPDFEncryptionParams(PDFEncryptionParams pdfEncryptionParams) {
        this.pdfEncryptionParams = pdfEncryptionParams;
    }

    public Source resolveURI(String uri) {
        Source source = null;
        URIResolver uriResolver = this.getURIResolver();
        if (uriResolver != null) {
            try {
                source = uriResolver.resolve(uri, this.getBaseURL());
            }
            catch (TransformerException te) {
                this.log.error("Attempt to resolve URI '" + uri + "' failed: ", te);
            }
        }
        if (source == null) {
            try {
                source = this.foURIResolver.resolve(uri, this.getBaseURL());
            }
            catch (TransformerException te) {
                this.log.error("Attempt to resolve URI '" + uri + "' failed: ", te);
            }
        }
        return source;
    }

    public void setOutputFile(File f) {
        this.outputFile = f;
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    public float getPixelUnitToMillimeter() {
        return this.px2mm;
    }

    public void setResolution(int dpi) {
        this.px2mm = (float)(25.4 / (double)dpi);
    }

    public boolean linkToFootnotes() {
        return true;
    }

    public XMLHandlerRegistry getXMLHandlerRegistry() {
        return this.xmlHandlers;
    }
}

