/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.ColorType;
import org.apache.fop.datatypes.Length;
import org.apache.fop.datatypes.Numeric;
import org.apache.fop.fo.CharIterator;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FOText;
import org.apache.fop.fo.FObjMixed;
import org.apache.fop.fo.NullCharIterator;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.PropertySets;
import org.apache.fop.fo.RecursiveCharIterator;
import org.apache.fop.fo.ValidationException;
import org.apache.fop.fo.properties.CommonAccessibility;
import org.apache.fop.fo.properties.CommonAural;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.fo.properties.CommonFont;
import org.apache.fop.fo.properties.CommonHyphenation;
import org.apache.fop.fo.properties.CommonMarginBlock;
import org.apache.fop.fo.properties.CommonRelativePosition;
import org.apache.fop.fo.properties.KeepProperty;
import org.apache.fop.fo.properties.SpaceProperty;
import org.apache.fop.util.CharUtilities;
import org.xml.sax.Locator;

public class Block
extends FObjMixed {
    private boolean blockOrInlineItemFound = false;
    private boolean initialPropertySetFound = false;
    private CommonAccessibility commonAccessibility;
    private CommonAural commonAural;
    private CommonBorderPaddingBackground commonBorderPaddingBackground;
    private CommonFont commonFont;
    private CommonHyphenation commonHyphenation;
    private CommonMarginBlock commonMarginBlock;
    private CommonRelativePosition commonRelativePosition;
    private int breakAfter;
    private int breakBefore;
    private ColorType color;
    private Length textDepth;
    private Length textAltitude;
    private int hyphenationKeep;
    private Numeric hyphenationLadderCount;
    private String id;
    private int intrusionDisplace;
    private KeepProperty keepTogether;
    private KeepProperty keepWithNext;
    private KeepProperty keepWithPrevious;
    private Length lastLineEndIndent;
    private int linefeedTreatment;
    private SpaceProperty lineHeight;
    private int lineHeightShiftAdjustment;
    private int lineStackingStrategy;
    private Numeric orphans;
    private int whiteSpaceTreatment;
    private int span;
    private int textAlign;
    private int textAlignLast;
    private Length textIndent;
    private int visibility;
    private int whiteSpaceCollapse;
    private Numeric widows;
    private int wrapOption;
    private boolean anythingLaidOut = false;
    private FONode firstInlineChild = null;

    public Block(FONode parent) {
        super(parent);
    }

    public void bind(PropertyList pList) throws FOPException {
        this.commonAccessibility = pList.getAccessibilityProps();
        this.commonAural = pList.getAuralProps();
        this.commonBorderPaddingBackground = pList.getBorderPaddingBackgroundProps();
        this.commonFont = pList.getFontProps();
        this.commonHyphenation = pList.getHyphenationProps();
        this.commonMarginBlock = pList.getMarginBlockProps();
        this.commonRelativePosition = pList.getRelativePositionProps();
        this.breakAfter = pList.get(58).getEnum();
        this.breakBefore = pList.get(59).getEnum();
        this.color = pList.get(66).getColorType();
        this.textDepth = pList.get(227).getLength();
        this.textAltitude = pList.get(225).getLength();
        this.hyphenationKeep = pList.get(109).getEnum();
        this.hyphenationLadderCount = pList.get(110).getNumeric();
        this.id = pList.get(113).getString();
        this.intrusionDisplace = pList.get(247).getEnum();
        this.keepTogether = pList.get(118).getKeep();
        this.keepWithNext = pList.get(119).getKeep();
        this.keepWithPrevious = pList.get(120).getKeep();
        this.lastLineEndIndent = pList.get(122).getLength();
        this.linefeedTreatment = pList.get(130).getEnum();
        this.lineHeight = pList.get(131).getSpace();
        this.lineHeightShiftAdjustment = pList.get(132).getEnum();
        this.lineStackingStrategy = pList.get(133).getEnum();
        this.orphans = pList.get(152).getNumeric();
        this.whiteSpaceTreatment = pList.get(239).getEnum();
        this.span = pList.get(204).getEnum();
        this.textAlign = pList.get(223).getEnum();
        this.textAlignLast = pList.get(224).getEnum();
        this.textIndent = pList.get(228).getLength();
        this.visibility = pList.get(235).getEnum();
        this.whiteSpaceCollapse = pList.get(238).getEnum();
        this.widows = pList.get(240).getNumeric();
        this.wrapOption = pList.get(243).getEnum();
    }

    protected void startOfNode() throws FOPException {
        this.checkId(this.id);
        this.getFOEventHandler().startBlock(this);
    }

    protected void endOfNode() throws FOPException {
        super.endOfNode();
        this.handleWhiteSpace();
        this.getFOEventHandler().endBlock(this);
    }

    public CommonMarginBlock getCommonMarginBlock() {
        return this.commonMarginBlock;
    }

    public CommonBorderPaddingBackground getCommonBorderPaddingBackground() {
        return this.commonBorderPaddingBackground;
    }

    public CommonFont getCommonFont() {
        return this.commonFont;
    }

    public CommonHyphenation getCommonHyphenation() {
        return this.commonHyphenation;
    }

    public int getBreakAfter() {
        return this.breakAfter;
    }

    public int getBreakBefore() {
        return this.breakBefore;
    }

    public KeepProperty getKeepWithNext() {
        return this.keepWithNext;
    }

    public KeepProperty getKeepWithPrevious() {
        return this.keepWithPrevious;
    }

    public KeepProperty getKeepTogether() {
        return this.keepTogether;
    }

    public int getOrphans() {
        return this.orphans.getValue();
    }

    public int getWidows() {
        return this.widows.getValue();
    }

    public int getLineStackingStrategy() {
        return this.lineStackingStrategy;
    }

    public ColorType getColor() {
        return this.color;
    }

    public String getId() {
        return this.id;
    }

    public SpaceProperty getLineHeight() {
        return this.lineHeight;
    }

    public int getSpan() {
        return this.span;
    }

    public int getTextAlign() {
        return this.textAlign;
    }

    public int getTextAlignLast() {
        return this.textAlignLast;
    }

    public Length getTextIndent() {
        return this.textIndent;
    }

    protected void validateChildNode(Locator loc, String nsURI, String localName) throws ValidationException {
        if (FO_URI.equals(nsURI) && localName.equals("marker")) {
            if (this.blockOrInlineItemFound || this.initialPropertySetFound) {
                this.nodesOutOfOrderError(loc, "fo:marker", "initial-property-set? (#PCDATA|%inline;|%block;)");
            }
        } else if (FO_URI.equals(nsURI) && localName.equals("initial-property-set")) {
            if (this.initialPropertySetFound) {
                this.tooManyNodesError(loc, "fo:initial-property-set");
            } else if (this.blockOrInlineItemFound) {
                this.nodesOutOfOrderError(loc, "fo:initial-property-set", "(#PCDATA|%inline;|%block;)");
            } else {
                this.initialPropertySetFound = true;
            }
        } else if (this.isBlockOrInlineItem(nsURI, localName)) {
            this.blockOrInlineItemFound = true;
        } else {
            this.invalidChildError(loc, nsURI, localName);
        }
    }

    public void addChildNode(FONode child) throws FOPException {
        this.flushText();
        if (child instanceof FOText || PropertySets.generatesInlineAreas(child.getNameId())) {
            if (this.firstInlineChild == null) {
                this.firstInlineChild = child;
            }
        } else {
            this.handleWhiteSpace();
        }
        super.addChildNode(child);
    }

    protected void notifyChildRemoval(FONode node) {
        if (node != null && node == this.firstInlineChild) {
            this.firstInlineChild = null;
        }
    }

    private void handleWhiteSpace() {
        if (this.firstInlineChild != null) {
            boolean bInWS = false;
            boolean bPrevWasLF = false;
            boolean bSeenNonWSYet = false;
            RecursiveCharIterator charIter = new RecursiveCharIterator(this, this.firstInlineChild);
            LFchecker lfCheck = new LFchecker(charIter);
            while (charIter.hasNext()) {
                char currentChar = charIter.nextChar();
                block0 : switch (CharUtilities.classOf(currentChar)) {
                    case 4: {
                        boolean bIgnore = false;
                        switch (this.whiteSpaceTreatment) {
                            case 60: {
                                bIgnore = true;
                                break;
                            }
                            case 62: {
                                bIgnore = lfCheck.nextIsLF();
                                break;
                            }
                            case 63: {
                                bIgnore = bPrevWasLF || lfCheck.nextIsLF();
                                break;
                            }
                            case 61: {
                                bIgnore = bPrevWasLF;
                                break;
                            }
                        }
                        if (bIgnore) {
                            charIter.remove();
                            break;
                        }
                        if (this.whiteSpaceCollapse == 149) {
                            if (bInWS || this.linefeedTreatment == 108 && (bPrevWasLF || lfCheck.nextIsLF())) {
                                charIter.remove();
                                break;
                            }
                            bInWS = true;
                            if (!bSeenNonWSYet) {
                                charIter.remove();
                                break;
                            }
                            if (currentChar == ' ') break;
                            charIter.replaceChar(' ');
                            break;
                        }
                        if (currentChar == ' ') break;
                        charIter.replaceChar(' ');
                        break;
                    }
                    case 1: {
                        lfCheck.reset();
                        bPrevWasLF = true;
                        switch (this.linefeedTreatment) {
                            case 60: {
                                charIter.remove();
                                break block0;
                            }
                            case 147: {
                                if (bInWS) {
                                    charIter.remove();
                                    break block0;
                                }
                                if (this.whiteSpaceCollapse == 149) {
                                    bInWS = true;
                                    if (!bSeenNonWSYet) {
                                        charIter.remove();
                                    }
                                }
                                charIter.replaceChar(' ');
                                break block0;
                            }
                            case 148: {
                                charIter.replaceChar('\u200b');
                            }
                            case 108: {
                                bInWS = false;
                            }
                        }
                        break;
                    }
                    case 0: 
                    case 2: 
                    case 3: {
                        bPrevWasLF = false;
                        bInWS = false;
                        bSeenNonWSYet = true;
                        lfCheck.reset();
                    }
                }
            }
            this.firstInlineChild = null;
        }
    }

    public CharIterator charIterator() {
        return NullCharIterator.getInstance();
    }

    public String getName() {
        return "fo:block";
    }

    public int getNameId() {
        return 3;
    }

    private static class LFchecker {
        private boolean bNextIsLF = false;
        private RecursiveCharIterator charIter;

        LFchecker(RecursiveCharIterator charIter) {
            this.charIter = charIter;
        }

        boolean nextIsLF() {
            if (!this.bNextIsLF) {
                CharIterator lfIter = this.charIter.mark();
                while (lfIter.hasNext()) {
                    char c = lfIter.nextChar();
                    if (c == '\n') {
                        this.bNextIsLF = true;
                        break;
                    }
                    if (CharUtilities.classOf(c) == 4) continue;
                    break;
                }
            }
            return this.bNextIsLF;
        }

        void reset() {
            this.bNextIsLF = false;
        }
    }
}

