/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import java.awt.geom.Point2D;
import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.Length;
import org.apache.fop.datatypes.PercentBase;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.ValidationException;
import org.apache.fop.fo.XMLObj;
import org.apache.fop.fo.properties.CommonAccessibility;
import org.apache.fop.fo.properties.CommonAural;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.fo.properties.CommonMarginInline;
import org.apache.fop.fo.properties.CommonRelativePosition;
import org.apache.fop.fo.properties.KeepProperty;
import org.apache.fop.fo.properties.LengthRangeProperty;
import org.xml.sax.Locator;

public class InstreamForeignObject
extends FObj {
    private CommonAccessibility commonAccessibility;
    private CommonAural commonAural;
    private CommonBorderPaddingBackground commonBorderPaddingBackground;
    private CommonMarginInline commonMarginInline;
    private CommonRelativePosition commonRelativePosition;
    private Length alignmentAdjust;
    private int alignmentBaseline;
    private Length baselineShift;
    private LengthRangeProperty blockProgressionDimension;
    private Length contentHeight;
    private String contentType;
    private Length contentWidth;
    private int displayAlign;
    private int dominantBaseline;
    private Length height;
    private String id;
    private LengthRangeProperty inlineProgressionDimension;
    private KeepProperty keepWithNext;
    private KeepProperty keepWithPrevious;
    private Length lineHeight;
    private int overflow;
    private int scaling;
    private int scalingMethod;
    private int textAlign;
    private int verticalAlign;
    private Length width;
    private Point2D intrinsicDimensions;

    public InstreamForeignObject(FONode parent) {
        super(parent);
    }

    public void bind(PropertyList pList) throws FOPException {
        this.commonAccessibility = pList.getAccessibilityProps();
        this.commonAural = pList.getAuralProps();
        this.commonBorderPaddingBackground = pList.getBorderPaddingBackgroundProps();
        this.commonMarginInline = pList.getMarginInlineProps();
        this.commonRelativePosition = pList.getRelativePositionProps();
        this.alignmentAdjust = pList.get(3).getLength();
        this.alignmentBaseline = pList.get(4).getEnum();
        this.baselineShift = pList.get(15).getLength();
        this.blockProgressionDimension = pList.get(17).getLengthRange();
        this.contentHeight = pList.get(72).getLength();
        this.contentType = pList.get(73).getString();
        this.contentWidth = pList.get(74).getLength();
        this.displayAlign = pList.get(81).getEnum();
        this.dominantBaseline = pList.get(82).getEnum();
        this.height = pList.get(106).getLength();
        this.id = pList.get(113).getString();
        this.inlineProgressionDimension = pList.get(116).getLengthRange();
        this.keepWithNext = pList.get(119).getKeep();
        this.keepWithPrevious = pList.get(120).getKeep();
        this.lineHeight = pList.get(131).getLength();
        this.overflow = pList.get(153).getEnum();
        this.scaling = pList.get(193).getEnum();
        this.scalingMethod = pList.get(194).getEnum();
        this.textAlign = pList.get(223).getEnum();
        this.verticalAlign = pList.get(234).getEnum();
        this.width = pList.get(241).getLength();
    }

    protected void startOfNode() throws FOPException {
        this.checkId(this.id);
    }

    protected void endOfNode() throws FOPException {
        if (this.childNodes.size() != 1) {
            this.missingChildElementError("one (1) non-XSL namespace child");
        }
    }

    protected void validateChildNode(Locator loc, String nsURI, String localName) throws ValidationException {
        if (FO_URI.equals(nsURI)) {
            this.invalidChildError(loc, nsURI, localName);
        } else if (this.childNodes != null) {
            this.tooManyNodesError(loc, "child element");
        }
    }

    public int computeXOffset(int ipd, int cwidth) {
        int xoffset = 0;
        switch (this.textAlign) {
            case 23: {
                xoffset = (ipd - cwidth) / 2;
                break;
            }
            case 39: {
                xoffset = ipd - cwidth;
                break;
            }
            case 135: {
                break;
            }
        }
        return xoffset;
    }

    public int computeYOffset(int bpd, int cheight) {
        int yoffset = 0;
        switch (this.displayAlign) {
            case 13: {
                break;
            }
            case 3: {
                yoffset = bpd - cheight;
                break;
            }
            case 23: {
                yoffset = (bpd - cheight) / 2;
                break;
            }
        }
        return yoffset;
    }

    public String getId() {
        return this.id;
    }

    public CommonBorderPaddingBackground getCommonBorderPaddingBackground() {
        return this.commonBorderPaddingBackground;
    }

    public Length getLineHeight() {
        return this.lineHeight;
    }

    public LengthRangeProperty getInlineProgressionDimension() {
        return this.inlineProgressionDimension;
    }

    public LengthRangeProperty getBlockProgressionDimension() {
        return this.blockProgressionDimension;
    }

    public Length getHeight() {
        return this.height;
    }

    public Length getWidth() {
        return this.width;
    }

    public Length getContentHeight() {
        return this.contentHeight;
    }

    public Length getContentWidth() {
        return this.contentWidth;
    }

    public int getScaling() {
        return this.scaling;
    }

    public int getVerticalAlign() {
        return this.verticalAlign;
    }

    public int getOverflow() {
        return this.overflow;
    }

    public String getName() {
        return "fo:instream-foreign-object";
    }

    public int getNameId() {
        return 17;
    }

    public Number getLayoutDimension(PercentBase.LayoutDimension key) {
        if (key == PercentBase.IMAGE_INTRINSIC_WIDTH) {
            return new Integer(this.getIntrinsicWidth());
        }
        if (key == PercentBase.IMAGE_INTRINSIC_HEIGHT) {
            return new Integer(this.getIntrinsicHeight());
        }
        return super.getLayoutDimension(key);
    }

    private void prepareIntrinsicSize() {
        if (this.intrinsicDimensions == null) {
            XMLObj child = (XMLObj)this.childNodes.get(0);
            Point2D.Float csize = new Point2D.Float(-1.0f, -1.0f);
            this.intrinsicDimensions = child.getDimension(csize);
            if (this.intrinsicDimensions == null) {
                this.getLogger().error("Intrinsic dimensions of  instream-foreign-object could not be determined");
            }
        }
    }

    public int getIntrinsicWidth() {
        this.prepareIntrinsicSize();
        if (this.intrinsicDimensions != null) {
            return (int)(this.intrinsicDimensions.getX() * 1000.0);
        }
        return 0;
    }

    public int getIntrinsicHeight() {
        this.prepareIntrinsicSize();
        if (this.intrinsicDimensions != null) {
            return (int)(this.intrinsicDimensions.getY() * 1000.0);
        }
        return 0;
    }

    protected void addChildNode(FONode child) throws FOPException {
        super.addChildNode(child);
    }
}

