/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.inline;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.apache.fop.area.Trait;
import org.apache.fop.area.inline.TextArea;
import org.apache.fop.fo.FOText;
import org.apache.fop.fo.flow.Inline;
import org.apache.fop.fonts.Font;
import org.apache.fop.layoutmgr.KnuthBox;
import org.apache.fop.layoutmgr.KnuthElement;
import org.apache.fop.layoutmgr.KnuthGlue;
import org.apache.fop.layoutmgr.KnuthPenalty;
import org.apache.fop.layoutmgr.KnuthSequence;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LeafPosition;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.PositionIterator;
import org.apache.fop.layoutmgr.TraitSetter;
import org.apache.fop.layoutmgr.inline.HyphContext;
import org.apache.fop.layoutmgr.inline.KnuthInlineBox;
import org.apache.fop.layoutmgr.inline.LeafNodeLayoutManager;
import org.apache.fop.traits.MinOptMax;
import org.apache.fop.traits.SpaceVal;

public class TextLayoutManager
extends LeafNodeLayoutManager {
    private ArrayList vecAreaInfo;
    private static final String BREAK_CHARS = "-/";
    private FOText foText;
    private char[] textArray;
    private static final char NEWLINE = '\n';
    private static final char SPACE = ' ';
    private static final char NBSPACE = '\u00a0';
    private static final char LINEBREAK = '\u2028';
    private static final char ZERO_WIDTH_SPACE = '\u200b';
    private static final char ZERO_WIDTH_NOBREAK_SPACE = '\ufeff';
    private short iAreaStart = 0;
    private short iNextStart = 0;
    private MinOptMax ipdTotal;
    private int spaceCharIPD;
    private MinOptMax wordSpaceIPD;
    private MinOptMax letterSpaceIPD;
    private int hyphIPD;
    private SpaceVal halfWS;
    private int iNbSpacesPending;
    private Font fs;
    private boolean bChanged = false;
    private int iReturnedIndex = 0;
    private short iThisStart = 0;
    private short iTempStart = 0;
    private LinkedList changeList = null;
    private int textHeight;
    private int lead = 0;
    private int total = 0;
    private int middle = 0;
    private int verticalAlignment = 12;

    public TextLayoutManager(FOText node) {
        this.foText = node;
        this.textArray = new char[node.endIndex - node.startIndex];
        System.arraycopy(node.ca, node.startIndex, this.textArray, 0, node.endIndex - node.startIndex);
        this.vecAreaInfo = new ArrayList();
        this.fs = this.foText.getCommonFont().getFontState(this.foText.getFOEventHandler().getFontInfo());
        this.spaceCharIPD = this.fs.getCharWidth(' ');
        this.hyphIPD = this.fs.getCharWidth(this.foText.getCommonHyphenation().hyphenationCharacter);
        SpaceVal ls = SpaceVal.makeLetterSpacing(this.foText.getLetterSpacing());
        SpaceVal ws = SpaceVal.makeWordSpacing(this.foText.getWordSpacing(), ls, this.fs);
        this.halfWS = new SpaceVal(MinOptMax.multiply(ws.getSpace(), 0.5), ws.isConditional(), ws.isForcing(), ws.getPrecedence());
        this.letterSpaceIPD = ls.getSpace();
        this.wordSpaceIPD = MinOptMax.add(new MinOptMax(this.spaceCharIPD), ws.getSpace());
        this.textHeight = this.fs.getAscender() - this.fs.getDescender();
        if (this.foText.getParent() instanceof Inline) {
            this.setAlignment(((Inline)this.foText.getParent()).getVerticalAlign());
        }
        switch (this.verticalAlignment) {
            case 84: {
                this.middle = this.textHeight / 2;
                break;
            }
            case 20: 
            case 145: {
                this.total = this.textHeight;
                break;
            }
            default: {
                this.lead = this.fs.getAscender();
                this.total = this.textHeight;
            }
        }
    }

    public void resetPosition(Position prevPos) {
        if (prevPos != null) {
            LeafPosition tbp;
            AreaInfo ai;
            if (prevPos.getLM() != this) {
                log.error("TextLayoutManager.resetPosition: LM mismatch!!!");
            }
            if ((ai = (AreaInfo)this.vecAreaInfo.get((tbp = (LeafPosition)prevPos).getLeafPos())).iBreakIndex != this.iNextStart) {
                this.iNextStart = ai.iBreakIndex;
                this.vecAreaInfo.ensureCapacity(tbp.getLeafPos() + 1);
                this.ipdTotal = ai.ipdArea;
                this.setFinished(false);
            }
        } else {
            this.vecAreaInfo.clear();
            this.iNextStart = 0;
            this.setFinished(false);
        }
    }

    private boolean getHyphenIPD(HyphContext hc, MinOptMax hyphIPD) {
        boolean bCanHyphenate = true;
        int iStopIndex = this.iNextStart + hc.getNextHyphPoint();
        if (this.textArray.length < iStopIndex) {
            iStopIndex = this.textArray.length;
            bCanHyphenate = false;
        }
        hc.updateOffset(iStopIndex - this.iNextStart);
        while (this.iNextStart < iStopIndex) {
            char c = this.textArray[this.iNextStart];
            hyphIPD.opt += this.fs.getCharWidth(c);
            this.iNextStart = (short)(this.iNextStart + 1);
        }
        return bCanHyphenate;
    }

    public void addAreas(PositionIterator posIter, LayoutContext context) {
        AreaInfo ai = null;
        int iStart = -1;
        int iWScount = 0;
        int iLScount = 0;
        MinOptMax realWidth = new MinOptMax(0);
        while (posIter.hasNext()) {
            LeafPosition tbpNext = (LeafPosition)posIter.next();
            if (tbpNext.getLeafPos() == -1) continue;
            ai = (AreaInfo)this.vecAreaInfo.get(tbpNext.getLeafPos());
            if (iStart == -1) {
                iStart = ai.iStartIndex;
            }
            iWScount += ai.iWScount;
            iLScount += ai.iLScount;
            realWidth.add(ai.ipdArea);
        }
        if (ai == null) {
            return;
        }
        TextArea word = null;
        int adjust = 0;
        if (this.textArray[ai.iBreakIndex - 1] == '\n') {
            adjust = 1;
        }
        String str = new String(this.textArray, iStart, ai.iBreakIndex - iStart - adjust);
        if (context.isLastArea() && ai.bHyphenated) {
            str = str + this.foText.getCommonHyphenation().hyphenationCharacter;
            realWidth.add(new MinOptMax(this.hyphIPD));
        }
        int iDifference = 0;
        int iTotalAdjust = 0;
        int iWordSpaceDim = this.wordSpaceIPD.opt;
        int iLetterSpaceDim = this.letterSpaceIPD.opt;
        double dIPDAdjust = context.getIPDAdjust();
        double dSpaceAdjust = context.getSpaceAdjust();
        iDifference = dIPDAdjust > 0.0 ? (int)((double)(realWidth.max - realWidth.opt) * dIPDAdjust) : (int)((double)(realWidth.opt - realWidth.min) * dIPDAdjust);
        iLetterSpaceDim = dIPDAdjust > 0.0 ? (iLetterSpaceDim += (int)((double)(this.letterSpaceIPD.max - this.letterSpaceIPD.opt) * dIPDAdjust)) : (iLetterSpaceDim += (int)((double)(this.letterSpaceIPD.opt - this.letterSpaceIPD.min) * dIPDAdjust));
        iTotalAdjust += (iLetterSpaceDim - this.letterSpaceIPD.opt) * iLScount;
        if (iWScount > 0) {
            iWordSpaceDim += (iDifference - iTotalAdjust) / iWScount;
        }
        TextArea t = this.createTextArea(str, realWidth.opt + (iTotalAdjust += (iWordSpaceDim - this.wordSpaceIPD.opt) * iWScount), context);
        t.setTextLetterSpaceAdjust(iLetterSpaceDim);
        t.setTextWordSpaceAdjust(iWordSpaceDim - this.spaceCharIPD - 2 * t.getTextLetterSpaceAdjust());
        word = t;
        if (word != null) {
            this.parentLM.addChildArea(word);
        }
    }

    protected TextArea createTextArea(String str, int width, LayoutContext context) {
        TextArea textArea = new TextArea();
        textArea.setIPD(width);
        textArea.setBPD(this.fs.getAscender() - this.fs.getDescender());
        int bpd = textArea.getBPD();
        switch (this.verticalAlignment) {
            case 84: {
                textArea.setOffset(context.getMiddleBaseline() + this.fs.getXHeight() / 2);
                break;
            }
            case 145: {
                textArea.setOffset(context.getTopBaseline() + this.fs.getAscender());
                break;
            }
            case 20: {
                textArea.setOffset(context.getBottomBaseline() - bpd + this.fs.getAscender());
                break;
            }
            default: {
                textArea.setOffset(context.getBaseline());
            }
        }
        textArea.setTextArea(str);
        textArea.addTrait(Trait.FONT_NAME, this.fs.getFontName());
        textArea.addTrait(Trait.FONT_SIZE, new Integer(this.fs.getFontSize()));
        textArea.addTrait(Trait.COLOR, this.foText.getColor());
        TraitSetter.addTextDecoration(textArea, this.foText.getTextDecoration());
        return textArea;
    }

    public void setAlignment(int al) {
        this.verticalAlignment = al;
    }

    public LinkedList getNextKnuthElements(LayoutContext context, int alignment) {
        LinkedList<KnuthSequence> returnList = new LinkedList<KnuthSequence>();
        KnuthSequence sequence = new KnuthSequence(true);
        returnList.add(sequence);
        block5: while (this.iNextStart < this.textArray.length) {
            if (this.textArray[this.iNextStart] == ' ' || this.textArray[this.iNextStart] == '\u00a0') {
                if (this.textArray[this.iNextStart] == '\u00a0') {
                    sequence.add(new KnuthPenalty(0, 1000, false, new LeafPosition(this, this.vecAreaInfo.size() - 1), false));
                }
                switch (alignment) {
                    case 23: {
                        this.vecAreaInfo.add(new AreaInfo(this.iNextStart, (short)(this.iNextStart + 1), 1, 0, this.wordSpaceIPD, false));
                        sequence.add(new KnuthGlue(0, 10008, 0, new LeafPosition(this, this.vecAreaInfo.size() - 1), false));
                        sequence.add(new KnuthPenalty(0, 0, false, new LeafPosition(this, -1), true));
                        sequence.add(new KnuthGlue(this.wordSpaceIPD.opt, -20016, 0, new LeafPosition(this, -1), true));
                        sequence.add(new KnuthInlineBox(0, 0, 0, 0, new LeafPosition(this, -1), true));
                        sequence.add(new KnuthPenalty(0, 1000, false, new LeafPosition(this, -1), true));
                        sequence.add(new KnuthGlue(0, 10008, 0, new LeafPosition(this, -1), true));
                        this.iNextStart = (short)(this.iNextStart + 1);
                        continue block5;
                    }
                    case 39: 
                    case 135: {
                        this.vecAreaInfo.add(new AreaInfo(this.iNextStart, (short)(this.iNextStart + 1), 1, 0, this.wordSpaceIPD, false));
                        sequence.add(new KnuthGlue(0, 3 * this.wordSpaceIPD.opt, 0, new LeafPosition(this, this.vecAreaInfo.size() - 1), false));
                        sequence.add(new KnuthPenalty(0, 0, false, new LeafPosition(this, -1), true));
                        sequence.add(new KnuthGlue(this.wordSpaceIPD.opt, -3 * this.wordSpaceIPD.opt, 0, new LeafPosition(this, -1), true));
                        this.iNextStart = (short)(this.iNextStart + 1);
                        continue block5;
                    }
                    case 70: {
                        this.vecAreaInfo.add(new AreaInfo(this.iNextStart, (short)(this.iNextStart + 1), 1, 0, this.wordSpaceIPD, false));
                        sequence.add(new KnuthGlue(this.wordSpaceIPD.opt, this.wordSpaceIPD.max - this.wordSpaceIPD.opt, this.wordSpaceIPD.opt - this.wordSpaceIPD.min, new LeafPosition(this, this.vecAreaInfo.size() - 1), false));
                        this.iNextStart = (short)(this.iNextStart + 1);
                        continue block5;
                    }
                }
                this.vecAreaInfo.add(new AreaInfo(this.iNextStart, (short)(this.iNextStart + 1), 1, 0, this.wordSpaceIPD, false));
                sequence.add(new KnuthGlue(this.wordSpaceIPD.opt, this.wordSpaceIPD.max - this.wordSpaceIPD.opt, 0, new LeafPosition(this, this.vecAreaInfo.size() - 1), false));
                this.iNextStart = (short)(this.iNextStart + 1);
                continue;
            }
            if (this.textArray[this.iNextStart] == '\u00a0') {
                this.vecAreaInfo.add(new AreaInfo(this.iNextStart, (short)(this.iNextStart + 1), 1, 0, this.wordSpaceIPD, false));
                sequence.add(new KnuthPenalty(0, 1000, false, new LeafPosition(this, this.vecAreaInfo.size() - 1), false));
                sequence.add(new KnuthGlue(this.wordSpaceIPD.opt, this.wordSpaceIPD.max - this.wordSpaceIPD.opt, this.wordSpaceIPD.opt - this.wordSpaceIPD.min, new LeafPosition(this, this.vecAreaInfo.size() - 1), false));
                this.iNextStart = (short)(this.iNextStart + 1);
                continue;
            }
            if (this.textArray[this.iNextStart] == '\n') {
                sequence.add(new KnuthPenalty(0, -1000, false, null, false));
                sequence = new KnuthSequence(true);
                returnList.add(sequence);
                this.iNextStart = (short)(this.iNextStart + 1);
                continue;
            }
            this.iThisStart = this.iNextStart;
            this.iTempStart = this.iNextStart;
            MinOptMax wordIPD = new MinOptMax(0);
            while (this.iTempStart < this.textArray.length && this.textArray[this.iTempStart] != ' ' && this.textArray[this.iTempStart] != '\u00a0' && this.textArray[this.iTempStart] != '\n' && (this.iTempStart <= this.iNextStart || alignment != 70 || BREAK_CHARS.indexOf(this.textArray[this.iTempStart - 1]) < 0)) {
                wordIPD.add(this.fs.getCharWidth(this.textArray[this.iTempStart]));
                this.iTempStart = (short)(this.iTempStart + 1);
            }
            int iLetterSpaces = this.iTempStart - this.iThisStart - 1;
            wordIPD.add(MinOptMax.multiply(this.letterSpaceIPD, iLetterSpaces));
            this.vecAreaInfo.add(new AreaInfo(this.iThisStart, this.iTempStart, 0, (short)iLetterSpaces, wordIPD, false));
            if (this.letterSpaceIPD.min == this.letterSpaceIPD.max) {
                sequence.add(new KnuthInlineBox(wordIPD.opt, this.lead, this.total, this.middle, new LeafPosition(this, this.vecAreaInfo.size() - 1), false));
            } else {
                sequence.add(new KnuthInlineBox(wordIPD.opt - iLetterSpaces * this.letterSpaceIPD.opt, this.lead, this.total, this.middle, new LeafPosition(this, this.vecAreaInfo.size() - 1), false));
                sequence.add(new KnuthPenalty(0, 1000, false, new LeafPosition(this, -1), true));
                sequence.add(new KnuthGlue(iLetterSpaces * this.letterSpaceIPD.opt, iLetterSpaces * (this.letterSpaceIPD.max - this.letterSpaceIPD.opt), iLetterSpaces * (this.letterSpaceIPD.opt - this.letterSpaceIPD.min), new LeafPosition(this, -1), true));
                sequence.add(new KnuthInlineBox(0, this.lead, this.total, this.middle, new LeafPosition(this, -1), true));
            }
            if (BREAK_CHARS.indexOf(this.textArray[this.iTempStart - 1]) >= 0 && this.iTempStart < this.textArray.length && this.textArray[this.iTempStart] != ' ' && this.textArray[this.iTempStart] != '\u00a0') {
                sequence.add(new KnuthPenalty(0, 50, true, new LeafPosition(this, -1), false));
                sequence.add(new KnuthGlue(this.letterSpaceIPD.opt, this.letterSpaceIPD.max - this.letterSpaceIPD.opt, this.letterSpaceIPD.opt - this.letterSpaceIPD.min, new LeafPosition(this, -1), false));
                AreaInfo ai = (AreaInfo)this.vecAreaInfo.get(this.vecAreaInfo.size() - 1);
                AreaInfo.access$408(ai);
            }
            this.iNextStart = this.iTempStart;
        }
        if (((List)returnList.getLast()).size() == 0) {
            returnList.removeLast();
        }
        this.setFinished(true);
        if (returnList.size() > 0) {
            return returnList;
        }
        return null;
    }

    public List addALetterSpaceTo(List oldList) {
        ListIterator<KnuthElement> oldListIterator = oldList.listIterator();
        KnuthElement el = (KnuthElement)oldListIterator.next();
        LeafPosition pos = (LeafPosition)((KnuthBox)el).getPosition();
        AreaInfo ai = (AreaInfo)this.vecAreaInfo.get(pos.getLeafPos());
        AreaInfo.access$408(ai);
        ai.ipdArea.add(this.letterSpaceIPD);
        if (BREAK_CHARS.indexOf(this.textArray[this.iTempStart - 1]) >= 0) {
            oldListIterator = oldList.listIterator(oldList.size());
            oldListIterator.add(new KnuthPenalty(0, 50, true, new LeafPosition(this, -1), false));
            oldListIterator.add(new KnuthGlue(this.letterSpaceIPD.opt, this.letterSpaceIPD.max - this.letterSpaceIPD.opt, this.letterSpaceIPD.opt - this.letterSpaceIPD.min, new LeafPosition(this, -1), false));
        } else if (this.letterSpaceIPD.min == this.letterSpaceIPD.max) {
            oldListIterator.set(new KnuthInlineBox(((AreaInfo)ai).ipdArea.opt, this.lead, this.total, this.middle, pos, false));
        } else {
            oldListIterator.next();
            oldListIterator.next();
            oldListIterator.set(new KnuthGlue(ai.iLScount * this.letterSpaceIPD.opt, ai.iLScount * (this.letterSpaceIPD.max - this.letterSpaceIPD.opt), ai.iLScount * (this.letterSpaceIPD.opt - this.letterSpaceIPD.min), new LeafPosition(this, -1), true));
        }
        return oldList;
    }

    public void hyphenate(Position pos, HyphContext hc) {
        AreaInfo ai = (AreaInfo)this.vecAreaInfo.get(((LeafPosition)pos).getLeafPos());
        int iStartIndex = ai.iStartIndex;
        boolean bNothingChanged = true;
        while (iStartIndex < ai.iBreakIndex) {
            boolean bHyphenFollows;
            int iStopIndex;
            MinOptMax newIPD = new MinOptMax(0);
            if (hc.hasMoreHyphPoints() && (iStopIndex = iStartIndex + hc.getNextHyphPoint()) <= ai.iBreakIndex) {
                bHyphenFollows = true;
            } else {
                bHyphenFollows = false;
                iStopIndex = ai.iBreakIndex;
            }
            hc.updateOffset(iStopIndex - iStartIndex);
            for (int i = iStartIndex; i < iStopIndex; ++i) {
                char c = this.textArray[i];
                newIPD.add(new MinOptMax(this.fs.getCharWidth(c)));
            }
            boolean bIsWordEnd = iStopIndex == ai.iBreakIndex && ai.iLScount < ai.iBreakIndex - ai.iStartIndex;
            newIPD.add(MinOptMax.multiply(this.letterSpaceIPD, bIsWordEnd ? iStopIndex - iStartIndex - 1 : iStopIndex - iStartIndex));
            if (!bNothingChanged || iStopIndex != ai.iBreakIndex || bHyphenFollows) {
                if (this.changeList == null) {
                    this.changeList = new LinkedList();
                }
                this.changeList.add(new PendingChange(new AreaInfo((short)iStartIndex, (short)iStopIndex, 0, (short)(bIsWordEnd ? iStopIndex - iStartIndex - 1 : iStopIndex - iStartIndex), newIPD, bHyphenFollows), ((LeafPosition)pos).getLeafPos()));
                bNothingChanged = false;
            }
            iStartIndex = iStopIndex;
        }
        if (!this.bChanged && !bNothingChanged) {
            this.bChanged = true;
        }
    }

    public boolean applyChanges(List oldList) {
        this.setFinished(false);
        if (this.changeList != null) {
            int iAddedAI = 0;
            int iRemovedAI = 0;
            int iOldIndex = -1;
            PendingChange currChange = null;
            ListIterator changeListIterator = this.changeList.listIterator();
            while (changeListIterator.hasNext()) {
                currChange = (PendingChange)changeListIterator.next();
                if (currChange.index != iOldIndex) {
                    iOldIndex = currChange.index;
                    this.vecAreaInfo.remove(currChange.index + ++iAddedAI - ++iRemovedAI);
                    this.vecAreaInfo.add(currChange.index + iAddedAI - iRemovedAI, currChange.ai);
                    continue;
                }
                this.vecAreaInfo.add(currChange.index + ++iAddedAI - iRemovedAI, currChange.ai);
            }
            this.changeList.clear();
        }
        this.iReturnedIndex = 0;
        return this.bChanged;
    }

    public LinkedList getChangedKnuthElements(List oldList, int alignment) {
        if (this.isFinished()) {
            return null;
        }
        LinkedList<KnuthElement> returnList = new LinkedList<KnuthElement>();
        block5: while (this.iReturnedIndex < this.vecAreaInfo.size()) {
            AreaInfo ai = (AreaInfo)this.vecAreaInfo.get(this.iReturnedIndex);
            if (ai.iWScount == 0) {
                if (BREAK_CHARS.indexOf(this.textArray[ai.iBreakIndex - 1]) >= 0 && ai.iLScount == ai.iBreakIndex - ai.iStartIndex) {
                    ai.ipdArea.add(new MinOptMax(-this.letterSpaceIPD.min, -this.letterSpaceIPD.opt, -this.letterSpaceIPD.max));
                }
                if (this.letterSpaceIPD.min == this.letterSpaceIPD.max) {
                    returnList.add(new KnuthInlineBox(((AreaInfo)ai).ipdArea.opt, this.lead, this.total, this.middle, new LeafPosition(this, this.iReturnedIndex), false));
                } else {
                    returnList.add(new KnuthInlineBox(((AreaInfo)ai).ipdArea.opt - ai.iLScount * this.letterSpaceIPD.opt, this.lead, this.total, this.middle, new LeafPosition(this, this.iReturnedIndex), false));
                    returnList.add(new KnuthPenalty(0, 1000, false, new LeafPosition(this, -1), true));
                    returnList.add(new KnuthGlue(ai.iLScount * this.letterSpaceIPD.opt, ai.iLScount * (this.letterSpaceIPD.max - this.letterSpaceIPD.opt), ai.iLScount * (this.letterSpaceIPD.opt - this.letterSpaceIPD.min), new LeafPosition(this, -1), true));
                    returnList.add(new KnuthInlineBox(0, 0, 0, 0, new LeafPosition(this, -1), true));
                }
                if (ai.bHyphenated) {
                    returnList.add(new KnuthPenalty(this.hyphIPD, 50, true, new LeafPosition(this, -1), false));
                }
                if (BREAK_CHARS.indexOf(this.textArray[ai.iBreakIndex - 1]) >= 0 && ai.iLScount == ai.iBreakIndex - ai.iStartIndex) {
                    returnList.add(new KnuthPenalty(0, 50, true, new LeafPosition(this, -1), false));
                    returnList.add(new KnuthGlue(this.letterSpaceIPD.opt, this.letterSpaceIPD.max - this.letterSpaceIPD.opt, this.letterSpaceIPD.opt - this.letterSpaceIPD.min, new LeafPosition(this, -1), false));
                }
                ++this.iReturnedIndex;
                continue;
            }
            if (this.textArray[ai.iStartIndex] == '\u00a0') {
                returnList.add(new KnuthPenalty(0, 1000, false, new LeafPosition(this, -1), false));
            }
            switch (alignment) {
                case 23: {
                    returnList.add(new KnuthGlue(0, 10008, 0, new LeafPosition(this, this.iReturnedIndex), false));
                    returnList.add(new KnuthPenalty(0, 0, false, new LeafPosition(this, -1), true));
                    returnList.add(new KnuthGlue(this.wordSpaceIPD.opt, -20016, 0, new LeafPosition(this, -1), true));
                    returnList.add(new KnuthInlineBox(0, 0, 0, 0, new LeafPosition(this, -1), true));
                    returnList.add(new KnuthPenalty(0, 1000, false, new LeafPosition(this, -1), true));
                    returnList.add(new KnuthGlue(0, 10008, 0, new LeafPosition(this, -1), true));
                    ++this.iReturnedIndex;
                    continue block5;
                }
                case 39: 
                case 135: {
                    returnList.add(new KnuthGlue(0, 10008, 0, new LeafPosition(this, this.iReturnedIndex), false));
                    returnList.add(new KnuthPenalty(0, 0, false, new LeafPosition(this, -1), true));
                    returnList.add(new KnuthGlue(this.wordSpaceIPD.opt, -10008, 0, new LeafPosition(this, -1), true));
                    ++this.iReturnedIndex;
                    continue block5;
                }
                case 70: {
                    returnList.add(new KnuthGlue(this.wordSpaceIPD.opt, this.wordSpaceIPD.max - this.wordSpaceIPD.opt, this.wordSpaceIPD.opt - this.wordSpaceIPD.min, new LeafPosition(this, this.iReturnedIndex), false));
                    ++this.iReturnedIndex;
                    continue block5;
                }
            }
            returnList.add(new KnuthGlue(this.wordSpaceIPD.opt, this.wordSpaceIPD.max - this.wordSpaceIPD.opt, 0, new LeafPosition(this, this.iReturnedIndex), false));
            ++this.iReturnedIndex;
        }
        this.setFinished(true);
        return returnList;
    }

    public void getWordChars(StringBuffer sbChars, Position pos) {
        int iLeafValue = ((LeafPosition)pos).getLeafPos();
        if (iLeafValue != -1) {
            AreaInfo ai = (AreaInfo)this.vecAreaInfo.get(iLeafValue);
            sbChars.append(new String(this.textArray, (int)ai.iStartIndex, ai.iBreakIndex - ai.iStartIndex));
        }
    }

    private class PendingChange {
        public AreaInfo ai;
        public int index;

        public PendingChange(AreaInfo ai, int index) {
            this.ai = ai;
            this.index = index;
        }
    }

    private class AreaInfo {
        private short iStartIndex;
        private short iBreakIndex;
        private short iWScount;
        private short iLScount;
        private MinOptMax ipdArea;
        private boolean bHyphenated;

        public AreaInfo(short iSIndex, short iBIndex, short iWS, short iLS, MinOptMax ipd, boolean bHyph) {
            this.iStartIndex = iSIndex;
            this.iBreakIndex = iBIndex;
            this.iWScount = iWS;
            this.iLScount = iLS;
            this.ipdArea = ipd;
            this.bHyphenated = bHyph;
        }

        static /* synthetic */ short access$408(AreaInfo x0) {
            short s = x0.iLScount;
            x0.iLScount = (short)(s + 1);
            return s;
        }
    }
}

