/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.rtf;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ListIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.fo.FOEventHandler;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FOText;
import org.apache.fop.fo.flow.BasicLink;
import org.apache.fop.fo.flow.Block;
import org.apache.fop.fo.flow.BlockContainer;
import org.apache.fop.fo.flow.Character;
import org.apache.fop.fo.flow.ExternalGraphic;
import org.apache.fop.fo.flow.Footnote;
import org.apache.fop.fo.flow.FootnoteBody;
import org.apache.fop.fo.flow.Inline;
import org.apache.fop.fo.flow.InstreamForeignObject;
import org.apache.fop.fo.flow.Leader;
import org.apache.fop.fo.flow.ListBlock;
import org.apache.fop.fo.flow.ListItem;
import org.apache.fop.fo.flow.ListItemLabel;
import org.apache.fop.fo.flow.PageNumber;
import org.apache.fop.fo.flow.Table;
import org.apache.fop.fo.flow.TableBody;
import org.apache.fop.fo.flow.TableCell;
import org.apache.fop.fo.flow.TableColumn;
import org.apache.fop.fo.flow.TableHeader;
import org.apache.fop.fo.flow.TableRow;
import org.apache.fop.fo.pagination.Flow;
import org.apache.fop.fo.pagination.PageSequence;
import org.apache.fop.fo.pagination.SimplePageMaster;
import org.apache.fop.fonts.FontSetup;
import org.apache.fop.render.rtf.FoUnitsConverter;
import org.apache.fop.render.rtf.ListAttributesConverter;
import org.apache.fop.render.rtf.PageAttributesConverter;
import org.apache.fop.render.rtf.TableAttributesConverter;
import org.apache.fop.render.rtf.TextAttributesConverter;
import org.apache.fop.render.rtf.rtflib.rtfdoc.IRtfAfterContainer;
import org.apache.fop.render.rtf.rtflib.rtfdoc.IRtfBeforeContainer;
import org.apache.fop.render.rtf.rtflib.rtfdoc.IRtfListContainer;
import org.apache.fop.render.rtf.rtflib.rtfdoc.IRtfTableContainer;
import org.apache.fop.render.rtf.rtflib.rtfdoc.IRtfTextrunContainer;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfAfter;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfAttributes;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfBefore;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfDocumentArea;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfElement;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfExternalGraphic;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfFile;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfFootnote;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfHyperLink;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfList;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfListItem;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfSection;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfTable;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfTableCell;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfTableRow;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfTextrun;
import org.apache.fop.render.rtf.rtflib.tools.BuilderContext;
import org.apache.fop.render.rtf.rtflib.tools.TableContext;
import org.xml.sax.SAXException;

public class RTFHandler
extends FOEventHandler {
    private RtfFile rtfFile;
    private final OutputStream os;
    private static Log log = LogFactory.getLog(class$org$apache$fop$render$rtf$RTFHandler == null ? (class$org$apache$fop$render$rtf$RTFHandler = RTFHandler.class$("org.apache.fop.render.rtf.RTFHandler")) : class$org$apache$fop$render$rtf$RTFHandler);
    private RtfSection sect;
    private RtfDocumentArea docArea;
    private int iNestCount;
    private boolean bDefer;
    private boolean bDeferredExecution;
    private boolean bPrevHeaderSpecified = false;
    private boolean bPrevFooterSpecified = false;
    private boolean bHeaderSpecified = false;
    private boolean bFooterSpecified = false;
    private BuilderContext builderContext = new BuilderContext(null);
    static /* synthetic */ Class class$org$apache$fop$render$rtf$RTFHandler;
    static /* synthetic */ Class class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfBeforeContainer;
    static /* synthetic */ Class class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfAfterContainer;
    static /* synthetic */ Class class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfTextrunContainer;
    static /* synthetic */ Class class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfTableContainer;
    static /* synthetic */ Class class$org$apache$fop$render$rtf$rtflib$rtfdoc$RtfTable;
    static /* synthetic */ Class class$org$apache$fop$render$rtf$rtflib$rtfdoc$RtfTableRow;
    static /* synthetic */ Class class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfListContainer;
    static /* synthetic */ Class class$org$apache$fop$render$rtf$rtflib$rtfdoc$RtfList;
    static /* synthetic */ Class class$org$apache$fop$render$rtf$rtflib$rtfdoc$RtfListItem;
    static /* synthetic */ Class class$org$apache$fop$render$rtf$rtflib$rtfdoc$RtfFootnote;

    public RTFHandler(FOUserAgent userAgent, OutputStream os) {
        super(userAgent);
        this.os = os;
        this.bDefer = false;
        this.bDeferredExecution = false;
        this.iNestCount = 0;
        FontSetup.setup(this.fontInfo, null);
    }

    public void startDocument() throws SAXException {
        try {
            this.rtfFile = new RtfFile(new OutputStreamWriter(this.os));
            this.docArea = this.rtfFile.startDocumentArea();
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
    }

    public void endDocument() throws SAXException {
        try {
            this.rtfFile.flush();
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
    }

    public void startPageSequence(PageSequence pageSeq) {
        try {
            if (this.bDefer) {
                return;
            }
            this.sect = this.docArea.newSection();
            String reference = pageSeq.getMasterReference();
            SimplePageMaster pagemaster = pageSeq.getRoot().getLayoutMasterSet().getSimplePageMaster(reference);
            if (pagemaster != null) {
                this.sect.getRtfAttributes().set(PageAttributesConverter.convertPageAttributes(pagemaster));
            } else {
                log.warn("Only simple-page-masters are supported on page-sequences: " + reference);
            }
            this.builderContext.pushContainer(this.sect);
            this.bHeaderSpecified = false;
            this.bFooterSpecified = false;
        }
        catch (IOException ioe) {
            log.error("startPageSequence: " + ioe.getMessage());
        }
    }

    public void endPageSequence(PageSequence pageSeq) {
        if (this.bDefer) {
            return;
        }
        this.builderContext.popContainer();
    }

    public void startFlow(Flow fl) {
        if (this.bDefer) {
            return;
        }
        try {
            log.debug("starting flow: " + fl.getFlowName());
            if (fl.getFlowName().equals("xsl-region-body")) {
                RtfAttributes attr;
                if (this.bPrevHeaderSpecified && !this.bHeaderSpecified) {
                    attr = new RtfAttributes();
                    attr.set("header");
                    IRtfBeforeContainer contBefore = (IRtfBeforeContainer)((Object)this.builderContext.getContainer(class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfBeforeContainer == null ? (class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfBeforeContainer = RTFHandler.class$("org.apache.fop.render.rtf.rtflib.rtfdoc.IRtfBeforeContainer")) : class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfBeforeContainer, true, this));
                    contBefore.newBefore(attr);
                }
                if (this.bPrevFooterSpecified && !this.bFooterSpecified) {
                    attr = new RtfAttributes();
                    attr.set("footer");
                    IRtfAfterContainer contAfter = (IRtfAfterContainer)((Object)this.builderContext.getContainer(class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfAfterContainer == null ? (class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfAfterContainer = RTFHandler.class$("org.apache.fop.render.rtf.rtflib.rtfdoc.IRtfAfterContainer")) : class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfAfterContainer, true, this));
                    contAfter.newAfter(attr);
                }
            } else if (fl.getFlowName().equals("xsl-region-before")) {
                this.bHeaderSpecified = true;
                this.bPrevHeaderSpecified = true;
                IRtfBeforeContainer c = (IRtfBeforeContainer)((Object)this.builderContext.getContainer(class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfBeforeContainer == null ? (class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfBeforeContainer = RTFHandler.class$("org.apache.fop.render.rtf.rtflib.rtfdoc.IRtfBeforeContainer")) : class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfBeforeContainer, true, this));
                RtfAttributes beforeAttributes = ((RtfElement)((Object)c)).getRtfAttributes();
                if (beforeAttributes == null) {
                    beforeAttributes = new RtfAttributes();
                }
                beforeAttributes.set("header");
                RtfBefore before = c.newBefore(beforeAttributes);
                this.builderContext.pushContainer(before);
            } else if (fl.getFlowName().equals("xsl-region-after")) {
                this.bFooterSpecified = true;
                this.bPrevFooterSpecified = true;
                IRtfAfterContainer c = (IRtfAfterContainer)((Object)this.builderContext.getContainer(class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfAfterContainer == null ? (class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfAfterContainer = RTFHandler.class$("org.apache.fop.render.rtf.rtflib.rtfdoc.IRtfAfterContainer")) : class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfAfterContainer, true, this));
                RtfAttributes afterAttributes = ((RtfElement)((Object)c)).getRtfAttributes();
                if (afterAttributes == null) {
                    afterAttributes = new RtfAttributes();
                }
                afterAttributes.set("footer");
                RtfAfter after = c.newAfter(afterAttributes);
                this.builderContext.pushContainer(after);
            }
        }
        catch (IOException ioe) {
            log.error("startFlow: " + ioe.getMessage());
            throw new RuntimeException(ioe.getMessage());
        }
        catch (Exception e) {
            log.error("startFlow: " + e.getMessage());
            throw new RuntimeException(e.getMessage());
        }
    }

    public void endFlow(Flow fl) {
        if (this.bDefer) {
            return;
        }
        try {
            if (!fl.getFlowName().equals("xsl-region-body")) {
                if (fl.getFlowName().equals("xsl-region-before")) {
                    this.builderContext.popContainer();
                } else if (fl.getFlowName().equals("xsl-region-after")) {
                    this.builderContext.popContainer();
                }
            }
        }
        catch (Exception e) {
            log.error("endFlow: " + e.getMessage());
            throw new RuntimeException(e.getMessage());
        }
    }

    public void startBlock(Block bl) {
        ++this.iNestCount;
        if (!this.bDeferredExecution) {
            this.bDefer = true;
        }
        if (this.bDefer) {
            return;
        }
        try {
            RtfAttributes rtfAttr = TextAttributesConverter.convertAttributes(bl);
            IRtfTextrunContainer container = (IRtfTextrunContainer)((Object)this.builderContext.getContainer(class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfTextrunContainer == null ? (class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfTextrunContainer = RTFHandler.class$("org.apache.fop.render.rtf.rtflib.rtfdoc.IRtfTextrunContainer")) : class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfTextrunContainer, true, this));
            RtfTextrun textrun = container.getTextrun();
            textrun.addParagraphBreak();
            textrun.pushAttributes(rtfAttr);
        }
        catch (IOException ioe) {
            log.error("startBlock: " + ioe.getMessage());
            throw new RuntimeException("IOException: " + ioe);
        }
        catch (Exception e) {
            log.error("startBlock: " + e.getMessage());
            throw new RuntimeException("Exception: " + e);
        }
    }

    public void endBlock(Block bl) {
        --this.iNestCount;
        if (!this.bDeferredExecution && this.iNestCount == 0) {
            this.bDefer = false;
            this.bDeferredExecution = true;
            this.recurseFONode(bl);
            this.bDeferredExecution = false;
            return;
        }
        if (this.bDefer) {
            return;
        }
        try {
            IRtfTextrunContainer container = (IRtfTextrunContainer)((Object)this.builderContext.getContainer(class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfTextrunContainer == null ? (class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfTextrunContainer = RTFHandler.class$("org.apache.fop.render.rtf.rtflib.rtfdoc.IRtfTextrunContainer")) : class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfTextrunContainer, true, this));
            RtfTextrun textrun = container.getTextrun();
            textrun.addParagraphBreak();
            textrun.popAttributes();
        }
        catch (IOException ioe) {
            log.error("startBlock:" + ioe.getMessage());
            throw new RuntimeException(ioe.getMessage());
        }
        catch (Exception e) {
            log.error("startBlock:" + e.getMessage());
            throw new RuntimeException(e.getMessage());
        }
    }

    public void startBlockContainer(BlockContainer blc) {
        if (this.bDefer) {
            return;
        }
        try {
            RtfAttributes rtfAttr = TextAttributesConverter.convertBlockContainerAttributes(blc);
            IRtfTextrunContainer container = (IRtfTextrunContainer)((Object)this.builderContext.getContainer(class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfTextrunContainer == null ? (class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfTextrunContainer = RTFHandler.class$("org.apache.fop.render.rtf.rtflib.rtfdoc.IRtfTextrunContainer")) : class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfTextrunContainer, true, this));
            RtfTextrun textrun = container.getTextrun();
            textrun.addParagraphBreak();
            textrun.pushAttributes(rtfAttr);
        }
        catch (IOException ioe) {
            log.error("startBlock: " + ioe.getMessage());
            throw new RuntimeException("IOException: " + ioe);
        }
        catch (Exception e) {
            log.error("startBlock: " + e.getMessage());
            throw new RuntimeException("Exception: " + e);
        }
    }

    public void endBlockContainer(BlockContainer bl) {
        if (this.bDefer) {
            return;
        }
        try {
            IRtfTextrunContainer container = (IRtfTextrunContainer)((Object)this.builderContext.getContainer(class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfTextrunContainer == null ? (class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfTextrunContainer = RTFHandler.class$("org.apache.fop.render.rtf.rtflib.rtfdoc.IRtfTextrunContainer")) : class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfTextrunContainer, true, this));
            RtfTextrun textrun = container.getTextrun();
            textrun.addParagraphBreak();
            textrun.popAttributes();
        }
        catch (IOException ioe) {
            log.error("startBlock:" + ioe.getMessage());
            throw new RuntimeException(ioe.getMessage());
        }
        catch (Exception e) {
            log.error("startBlock:" + e.getMessage());
            throw new RuntimeException(e.getMessage());
        }
    }

    public void startTable(Table tbl) {
        if (this.bDefer) {
            return;
        }
        TableContext tableContext = new TableContext(this.builderContext);
        try {
            RtfAttributes atts = TableAttributesConverter.convertTableAttributes(tbl);
            IRtfTableContainer tc = (IRtfTableContainer)((Object)this.builderContext.getContainer(class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfTableContainer == null ? (class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfTableContainer = RTFHandler.class$("org.apache.fop.render.rtf.rtflib.rtfdoc.IRtfTableContainer")) : class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfTableContainer, true, null));
            this.builderContext.pushContainer(tc.newTable(atts, tableContext));
        }
        catch (Exception e) {
            log.error("startTable:" + e.getMessage());
            throw new RuntimeException(e.getMessage());
        }
        this.builderContext.pushTableContext(tableContext);
    }

    public void endTable(Table tbl) {
        if (this.bDefer) {
            return;
        }
        this.builderContext.popTableContext();
        this.builderContext.popContainer();
    }

    public void startColumn(TableColumn tc) {
        if (this.bDefer) {
            return;
        }
        try {
            Integer iWidth = new Integer(tc.getColumnWidth().getValue() / 1000);
            String strWidth = iWidth.toString() + "pt";
            Float width = new Float(FoUnitsConverter.getInstance().convertToTwips(strWidth));
            this.builderContext.getTableContext().setNextColumnWidth(width);
            this.builderContext.getTableContext().setNextColumnRowSpanning(new Integer(0), null);
        }
        catch (Exception e) {
            log.error("startColumn: " + e.getMessage());
            throw new RuntimeException(e.getMessage());
        }
    }

    public void endColumn(TableColumn tc) {
        if (this.bDefer) {
            return;
        }
    }

    public void startHeader(TableBody th) {
    }

    public void endHeader(TableBody th) {
    }

    public void startFooter(TableBody tf) {
    }

    public void endFooter(TableBody tf) {
    }

    public void startInline(Inline inl) {
        if (this.bDefer) {
            return;
        }
        try {
            RtfAttributes rtfAttr = TextAttributesConverter.convertCharacterAttributes(inl);
            IRtfTextrunContainer container = (IRtfTextrunContainer)((Object)this.builderContext.getContainer(class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfTextrunContainer == null ? (class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfTextrunContainer = RTFHandler.class$("org.apache.fop.render.rtf.rtflib.rtfdoc.IRtfTextrunContainer")) : class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfTextrunContainer, true, this));
            RtfTextrun textrun = container.getTextrun();
            textrun.pushAttributes(rtfAttr);
        }
        catch (IOException ioe) {
            log.error("startInline:" + ioe.getMessage());
            throw new RuntimeException(ioe.getMessage());
        }
        catch (FOPException fe) {
            log.error("startInline:" + fe.getMessage());
            throw new RuntimeException(fe.getMessage());
        }
        catch (Exception e) {
            log.error("startInline:" + e.getMessage());
            throw new RuntimeException(e.getMessage());
        }
    }

    public void endInline(Inline inl) {
        if (this.bDefer) {
            return;
        }
        try {
            IRtfTextrunContainer container = (IRtfTextrunContainer)((Object)this.builderContext.getContainer(class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfTextrunContainer == null ? (class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfTextrunContainer = RTFHandler.class$("org.apache.fop.render.rtf.rtflib.rtfdoc.IRtfTextrunContainer")) : class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfTextrunContainer, true, this));
            RtfTextrun textrun = container.getTextrun();
            textrun.popAttributes();
        }
        catch (IOException ioe) {
            log.error("startInline:" + ioe.getMessage());
            throw new RuntimeException(ioe.getMessage());
        }
        catch (Exception e) {
            log.error("startInline:" + e.getMessage());
            throw new RuntimeException(e.getMessage());
        }
    }

    public void startBody(TableBody tb) {
        if (this.bDefer) {
            return;
        }
        try {
            RtfAttributes atts = TableAttributesConverter.convertTableBodyAttributes(tb);
            RtfTable tbl = (RtfTable)this.builderContext.getContainer(class$org$apache$fop$render$rtf$rtflib$rtfdoc$RtfTable == null ? (class$org$apache$fop$render$rtf$rtflib$rtfdoc$RtfTable = RTFHandler.class$("org.apache.fop.render.rtf.rtflib.rtfdoc.RtfTable")) : class$org$apache$fop$render$rtf$rtflib$rtfdoc$RtfTable, true, this);
            tbl.setHeaderAttribs(atts);
        }
        catch (Exception e) {
            log.error("startBody: " + e.getMessage());
            throw new RuntimeException(e.getMessage());
        }
    }

    public void endBody(TableBody tb) {
        if (this.bDefer) {
            return;
        }
        try {
            RtfTable tbl = (RtfTable)this.builderContext.getContainer(class$org$apache$fop$render$rtf$rtflib$rtfdoc$RtfTable == null ? (class$org$apache$fop$render$rtf$rtflib$rtfdoc$RtfTable = RTFHandler.class$("org.apache.fop.render.rtf.rtflib.rtfdoc.RtfTable")) : class$org$apache$fop$render$rtf$rtflib$rtfdoc$RtfTable, true, this);
            tbl.setHeaderAttribs(null);
        }
        catch (Exception e) {
            log.error("endBody: " + e.getMessage());
            throw new RuntimeException(e.getMessage());
        }
    }

    public void startRow(TableRow tr) {
        if (this.bDefer) {
            return;
        }
        try {
            RtfTable tbl = (RtfTable)this.builderContext.getContainer(class$org$apache$fop$render$rtf$rtflib$rtfdoc$RtfTable == null ? (class$org$apache$fop$render$rtf$rtflib$rtfdoc$RtfTable = RTFHandler.class$("org.apache.fop.render.rtf.rtflib.rtfdoc.RtfTable")) : class$org$apache$fop$render$rtf$rtflib$rtfdoc$RtfTable, true, null);
            RtfAttributes atts = TableAttributesConverter.convertRowAttributes(tr, tbl.getHeaderAttribs());
            if (tr.getParent() instanceof TableHeader) {
                atts.set("trhdr");
            }
            this.builderContext.pushContainer(tbl.newTableRow(atts));
            this.builderContext.getTableContext().selectFirstColumn();
        }
        catch (Exception e) {
            log.error("startRow: " + e.getMessage());
            throw new RuntimeException(e.getMessage());
        }
    }

    public void endRow(TableRow tr) {
        if (this.bDefer) {
            return;
        }
        this.builderContext.popContainer();
        this.builderContext.getTableContext().decreaseRowSpannings();
    }

    public void startCell(TableCell tc) {
        if (this.bDefer) {
            return;
        }
        try {
            TableContext tctx = this.builderContext.getTableContext();
            RtfTableRow row = (RtfTableRow)this.builderContext.getContainer(class$org$apache$fop$render$rtf$rtflib$rtfdoc$RtfTableRow == null ? (class$org$apache$fop$render$rtf$rtflib$rtfdoc$RtfTableRow = RTFHandler.class$("org.apache.fop.render.rtf.rtflib.rtfdoc.RtfTableRow")) : class$org$apache$fop$render$rtf$rtflib$rtfdoc$RtfTableRow, true, null);
            while (tctx.getNumberOfColumns() > tctx.getColumnIndex() && tctx.getColumnRowSpanningNumber() > 0) {
                row.newTableCellMergedVertically((int)tctx.getColumnWidth(), tctx.getColumnRowSpanningAttrs());
                tctx.selectNextColumn();
            }
            float width = tctx.getColumnWidth();
            RtfAttributes atts = TableAttributesConverter.convertCellAttributes(tc);
            RtfTableCell cell = row.newTableCell((int)width, atts);
            int numberRowsSpanned = tc.getNumberRowsSpanned();
            if (numberRowsSpanned > 1) {
                cell.setVMerge(1);
                tctx.setCurrentColumnRowSpanning(new Integer(numberRowsSpanned), cell.getRtfAttributes());
            } else {
                tctx.setCurrentColumnRowSpanning(new Integer(numberRowsSpanned), null);
            }
            this.builderContext.pushContainer(cell);
        }
        catch (Exception e) {
            log.error("startCell: " + e.getMessage());
            throw new RuntimeException(e.getMessage());
        }
    }

    public void endCell(TableCell tc) {
        if (this.bDefer) {
            return;
        }
        this.builderContext.popContainer();
        this.builderContext.getTableContext().selectNextColumn();
    }

    public void startList(ListBlock lb) {
        if (this.bDefer) {
            return;
        }
        try {
            IRtfListContainer c = (IRtfListContainer)((Object)this.builderContext.getContainer(class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfListContainer == null ? (class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfListContainer = RTFHandler.class$("org.apache.fop.render.rtf.rtflib.rtfdoc.IRtfListContainer")) : class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfListContainer, true, this));
            RtfList newList = c.newList(ListAttributesConverter.convertAttributes(lb));
            this.builderContext.pushContainer(newList);
        }
        catch (IOException ioe) {
            log.error("startList: " + ioe.getMessage());
            throw new RuntimeException(ioe.getMessage());
        }
        catch (FOPException fe) {
            log.error("startList: " + fe.getMessage());
            throw new RuntimeException(fe.getMessage());
        }
        catch (Exception e) {
            log.error("startList: " + e.getMessage());
            throw new RuntimeException(e.getMessage());
        }
    }

    public void endList(ListBlock lb) {
        if (this.bDefer) {
            return;
        }
        this.builderContext.popContainer();
    }

    public void startListItem(ListItem li) {
        if (this.bDefer) {
            return;
        }
        try {
            RtfList list = (RtfList)this.builderContext.getContainer(class$org$apache$fop$render$rtf$rtflib$rtfdoc$RtfList == null ? (class$org$apache$fop$render$rtf$rtflib$rtfdoc$RtfList = RTFHandler.class$("org.apache.fop.render.rtf.rtflib.rtfdoc.RtfList")) : class$org$apache$fop$render$rtf$rtflib$rtfdoc$RtfList, true, this);
            this.builderContext.pushContainer(list.newListItem());
        }
        catch (IOException ioe) {
            log.error("startList: " + ioe.getMessage());
            throw new RuntimeException(ioe.getMessage());
        }
        catch (FOPException fe) {
            log.error("startList: " + fe.getMessage());
            throw new RuntimeException(fe.getMessage());
        }
        catch (Exception e) {
            log.error("startList: " + e.getMessage());
            throw new RuntimeException(e.getMessage());
        }
    }

    public void endListItem(ListItem li) {
        if (this.bDefer) {
            return;
        }
        this.builderContext.popContainer();
    }

    public void startListLabel() {
        if (this.bDefer) {
            return;
        }
        try {
            RtfListItem item;
            RtfListItem rtfListItem = item = (RtfListItem)this.builderContext.getContainer(class$org$apache$fop$render$rtf$rtflib$rtfdoc$RtfListItem == null ? (class$org$apache$fop$render$rtf$rtflib$rtfdoc$RtfListItem = RTFHandler.class$("org.apache.fop.render.rtf.rtflib.rtfdoc.RtfListItem")) : class$org$apache$fop$render$rtf$rtflib$rtfdoc$RtfListItem, true, this);
            rtfListItem.getClass();
            RtfListItem.RtfListItemLabel label = new RtfListItem.RtfListItemLabel(rtfListItem, item);
            this.builderContext.pushContainer(label);
        }
        catch (IOException ioe) {
            log.error("startPageNumber:" + ioe.getMessage());
            throw new RuntimeException(ioe.getMessage());
        }
        catch (Exception e) {
            log.error("startPageNumber: " + e.getMessage());
            throw new RuntimeException(e.getMessage());
        }
    }

    public void endListLabel() {
        if (this.bDefer) {
            return;
        }
        this.builderContext.popContainer();
    }

    public void startListBody() {
    }

    public void endListBody() {
    }

    public void startStatic() {
    }

    public void endStatic() {
    }

    public void startMarkup() {
    }

    public void endMarkup() {
    }

    public void startLink(BasicLink basicLink) {
        if (this.bDefer) {
            return;
        }
        try {
            IRtfTextrunContainer container = (IRtfTextrunContainer)((Object)this.builderContext.getContainer(class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfTextrunContainer == null ? (class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfTextrunContainer = RTFHandler.class$("org.apache.fop.render.rtf.rtflib.rtfdoc.IRtfTextrunContainer")) : class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfTextrunContainer, true, this));
            RtfTextrun textrun = container.getTextrun();
            RtfHyperLink link = textrun.addHyperlink(new RtfAttributes());
            if (basicLink.getExternalDestination() != null) {
                link.setExternalURL(basicLink.getExternalDestination());
            } else {
                link.setInternalURL(basicLink.getInternalDestination());
            }
            this.builderContext.pushContainer(link);
        }
        catch (IOException ioe) {
            log.error("startLink:" + ioe.getMessage());
            throw new RuntimeException(ioe.getMessage());
        }
        catch (Exception e) {
            log.error("startLink: " + e.getMessage());
            throw new RuntimeException(e.getMessage());
        }
    }

    public void endLink() {
        if (this.bDefer) {
            return;
        }
        this.builderContext.popContainer();
    }

    public void image(ExternalGraphic eg) {
        if (this.bDefer) {
            return;
        }
        try {
            IRtfTextrunContainer c = (IRtfTextrunContainer)((Object)this.builderContext.getContainer(class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfTextrunContainer == null ? (class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfTextrunContainer = RTFHandler.class$("org.apache.fop.render.rtf.rtflib.rtfdoc.IRtfTextrunContainer")) : class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfTextrunContainer, true, this));
            RtfExternalGraphic newGraphic = c.getTextrun().newImage();
            newGraphic.setURL(eg.getSrc());
            if (eg.getScaling() == 154) {
                newGraphic.setScaling("uniform");
            }
            newGraphic.setWidth((float)eg.getWidth().getValue() / 1000.0f + "pt");
            newGraphic.setHeight((float)eg.getHeight().getValue() / 1000.0f + "pt");
            int compression = 0;
            if (compression != 0 && !newGraphic.setCompressionRate(compression)) {
                log.warn("The compression rate " + compression + " is invalid. The value has to be between 1 and 100 %.");
            }
        }
        catch (Exception e) {
            log.error("image: " + e.getMessage());
        }
    }

    public void pageRef() {
    }

    public void foreignObject(InstreamForeignObject ifo) {
    }

    public void startFootnote(Footnote footnote) {
        if (this.bDefer) {
            return;
        }
        try {
            IRtfTextrunContainer container = (IRtfTextrunContainer)((Object)this.builderContext.getContainer(class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfTextrunContainer == null ? (class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfTextrunContainer = RTFHandler.class$("org.apache.fop.render.rtf.rtflib.rtfdoc.IRtfTextrunContainer")) : class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfTextrunContainer, true, this));
            RtfTextrun textrun = container.getTextrun();
            RtfFootnote rtfFootnote = textrun.addFootnote();
            this.builderContext.pushContainer(rtfFootnote);
        }
        catch (IOException ioe) {
            log.error("startFootnote: " + ioe.getMessage());
            throw new RuntimeException("IOException: " + ioe);
        }
        catch (Exception e) {
            log.error("startFootnote: " + e.getMessage());
            throw new RuntimeException("Exception: " + e);
        }
    }

    public void endFootnote(Footnote footnote) {
        if (this.bDefer) {
            return;
        }
        this.builderContext.popContainer();
    }

    public void startFootnoteBody(FootnoteBody body) {
        if (this.bDefer) {
            return;
        }
        try {
            RtfFootnote rtfFootnote = (RtfFootnote)this.builderContext.getContainer(class$org$apache$fop$render$rtf$rtflib$rtfdoc$RtfFootnote == null ? (class$org$apache$fop$render$rtf$rtflib$rtfdoc$RtfFootnote = RTFHandler.class$("org.apache.fop.render.rtf.rtflib.rtfdoc.RtfFootnote")) : class$org$apache$fop$render$rtf$rtflib$rtfdoc$RtfFootnote, true, this);
            rtfFootnote.startBody();
        }
        catch (IOException ioe) {
            log.error("startFootnoteBody: " + ioe.getMessage());
            throw new RuntimeException("IOException: " + ioe);
        }
        catch (Exception e) {
            log.error("startFootnoteBody: " + e.getMessage());
            throw new RuntimeException("Exception: " + e);
        }
    }

    public void endFootnoteBody(FootnoteBody body) {
        if (this.bDefer) {
            return;
        }
        try {
            RtfFootnote rtfFootnote = (RtfFootnote)this.builderContext.getContainer(class$org$apache$fop$render$rtf$rtflib$rtfdoc$RtfFootnote == null ? (class$org$apache$fop$render$rtf$rtflib$rtfdoc$RtfFootnote = RTFHandler.class$("org.apache.fop.render.rtf.rtflib.rtfdoc.RtfFootnote")) : class$org$apache$fop$render$rtf$rtflib$rtfdoc$RtfFootnote, true, this);
            rtfFootnote.endBody();
        }
        catch (IOException ioe) {
            log.error("endFootnoteBody: " + ioe.getMessage());
            throw new RuntimeException("IOException: " + ioe);
        }
        catch (Exception e) {
            log.error("endFootnoteBody: " + e.getMessage());
            throw new RuntimeException("Exception: " + e);
        }
    }

    public void leader(Leader l) {
    }

    public void character(Character c) {
        if (this.bDefer) {
            return;
        }
        try {
            RtfAttributes rtfAttr = TextAttributesConverter.convertCharacterAttributes(c);
            IRtfTextrunContainer container = (IRtfTextrunContainer)((Object)this.builderContext.getContainer(class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfTextrunContainer == null ? (class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfTextrunContainer = RTFHandler.class$("org.apache.fop.render.rtf.rtflib.rtfdoc.IRtfTextrunContainer")) : class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfTextrunContainer, true, this));
            RtfTextrun textrun = container.getTextrun();
            textrun.pushAttributes(rtfAttr);
            textrun.addString(new String(new char[]{c.getCharacter()}));
            textrun.popAttributes();
        }
        catch (IOException ioe) {
            log.error("character: " + ioe.getMessage());
            throw new RuntimeException(ioe.getMessage());
        }
        catch (Exception e) {
            log.error("character:" + e.getMessage());
            throw new RuntimeException(e.getMessage());
        }
    }

    public void characters(char[] data, int start, int length) {
        if (this.bDefer) {
            return;
        }
        try {
            IRtfTextrunContainer container = (IRtfTextrunContainer)((Object)this.builderContext.getContainer(class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfTextrunContainer == null ? (class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfTextrunContainer = RTFHandler.class$("org.apache.fop.render.rtf.rtflib.rtfdoc.IRtfTextrunContainer")) : class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfTextrunContainer, true, this));
            RtfTextrun textrun = container.getTextrun();
            textrun.addString(new String(data, start, length - start));
        }
        catch (IOException ioe) {
            log.error("characters: " + ioe.getMessage());
            throw new RuntimeException(ioe.getMessage());
        }
        catch (Exception e) {
            log.error("characters:" + e.getMessage());
            throw new RuntimeException(e.getMessage());
        }
    }

    public void startPageNumber(PageNumber pagenum) {
        if (this.bDefer) {
            return;
        }
        try {
            RtfAttributes rtfAttr = TextAttributesConverter.convertCharacterAttributes(pagenum);
            IRtfTextrunContainer container = (IRtfTextrunContainer)((Object)this.builderContext.getContainer(class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfTextrunContainer == null ? (class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfTextrunContainer = RTFHandler.class$("org.apache.fop.render.rtf.rtflib.rtfdoc.IRtfTextrunContainer")) : class$org$apache$fop$render$rtf$rtflib$rtfdoc$IRtfTextrunContainer, true, this));
            RtfTextrun textrun = container.getTextrun();
            textrun.addPageNumber(rtfAttr);
        }
        catch (IOException ioe) {
            log.error("startPageNumber:" + ioe.getMessage());
            throw new RuntimeException(ioe.getMessage());
        }
        catch (Exception e) {
            log.error("startPageNumber: " + e.getMessage());
            throw new RuntimeException(e.getMessage());
        }
    }

    public void endPageNumber(PageNumber pagenum) {
        if (this.bDefer) {
            return;
        }
    }

    private void invokeDeferredEvent(FONode foNode, boolean bStart) {
        if (foNode instanceof Block) {
            if (bStart) {
                this.startBlock((Block)foNode);
            } else {
                this.endBlock((Block)foNode);
            }
        } else if (foNode instanceof Inline) {
            if (bStart) {
                this.startInline((Inline)foNode);
            } else {
                this.endInline((Inline)foNode);
            }
        } else if (foNode instanceof FOText) {
            if (bStart) {
                FOText text = (FOText)foNode;
                this.characters(text.ca, text.startIndex, text.endIndex);
            }
        } else if (foNode instanceof Character) {
            if (bStart) {
                Character c = (Character)foNode;
                this.character(c);
            }
        } else if (foNode instanceof BasicLink) {
            if (bStart) {
                this.startLink((BasicLink)foNode);
            } else {
                this.endLink();
            }
        } else if (foNode instanceof PageNumber) {
            if (bStart) {
                this.startPageNumber((PageNumber)foNode);
            } else {
                this.endPageNumber((PageNumber)foNode);
            }
        } else if (foNode instanceof Footnote) {
            if (bStart) {
                this.startFootnote((Footnote)foNode);
            } else {
                this.endFootnote((Footnote)foNode);
            }
        } else if (foNode instanceof FootnoteBody) {
            if (bStart) {
                this.startFootnoteBody((FootnoteBody)foNode);
            } else {
                this.endFootnoteBody((FootnoteBody)foNode);
            }
        } else if (foNode instanceof ListBlock) {
            if (bStart) {
                this.startList((ListBlock)foNode);
            } else {
                this.endList((ListBlock)foNode);
            }
        } else if (foNode instanceof ListItem) {
            if (bStart) {
                this.startListItem((ListItem)foNode);
            } else {
                this.endListItem((ListItem)foNode);
            }
        } else if (foNode instanceof ListItemLabel) {
            if (bStart) {
                this.startListLabel();
            } else {
                this.endListLabel();
            }
        } else if (foNode instanceof Table) {
            if (bStart) {
                this.startTable((Table)foNode);
            } else {
                this.endTable((Table)foNode);
            }
        } else if (foNode instanceof TableColumn) {
            if (bStart) {
                this.startColumn((TableColumn)foNode);
            } else {
                this.endColumn((TableColumn)foNode);
            }
        } else if (foNode instanceof TableRow) {
            if (bStart) {
                this.startRow((TableRow)foNode);
            } else {
                this.endRow((TableRow)foNode);
            }
        } else if (foNode instanceof TableCell) {
            if (bStart) {
                this.startCell((TableCell)foNode);
            } else {
                this.endCell((TableCell)foNode);
            }
        }
    }

    private void recurseFONode(FONode foNode) {
        this.invokeDeferredEvent(foNode, true);
        if (foNode.getChildNodes() != null) {
            ListIterator it = foNode.getChildNodes();
            while (it.hasNext()) {
                this.recurseFONode((FONode)it.next());
            }
        }
        this.invokeDeferredEvent(foNode, false);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

