/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.forms.widgets;

import java.util.HashMap;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;

public class FormFonts {
    private static FormFonts instance;
    private HashMap fonts;
    private HashMap ids;

    public static FormFonts getInstance() {
        if (instance == null) {
            instance = new FormFonts();
        }
        return instance;
    }

    private FormFonts() {
    }

    public Font getBoldFont(Display display, Font font) {
        this.checkHashMaps();
        FontIdentifier fid = new FontIdentifier(display, font);
        FontReference result = (FontReference)this.fonts.get(fid);
        if (result != null && !result.getFont().isDisposed()) {
            result.incCount();
            return result.getFont();
        }
        Font boldFont = this.createBoldFont(display, font);
        this.fonts.put(fid, new FontReference(boldFont));
        this.ids.put(boldFont, fid);
        return boldFont;
    }

    public boolean markFinished(Font boldFont) {
        FontReference ref;
        this.checkHashMaps();
        FontIdentifier id = (FontIdentifier)this.ids.get(boldFont);
        if (id != null && (ref = (FontReference)this.fonts.get(id)) != null) {
            if (ref.decCount()) {
                this.fonts.remove(id);
                this.ids.remove(ref.getFont());
                ref.getFont().dispose();
                this.validateHashMaps();
            }
            return true;
        }
        boldFont.dispose();
        return false;
    }

    private Font createBoldFont(Display display, Font regularFont) {
        FontData[] fontDatas = regularFont.getFontData();
        int i = 0;
        while (i < fontDatas.length) {
            fontDatas[i].setStyle(fontDatas[i].getStyle() | 1);
            ++i;
        }
        return new Font((Device)display, fontDatas);
    }

    private void checkHashMaps() {
        if (this.fonts == null) {
            this.fonts = new HashMap();
        }
        if (this.ids == null) {
            this.ids = new HashMap();
        }
    }

    private void validateHashMaps() {
        if (this.fonts.size() == 0) {
            this.fonts = null;
        }
        if (this.ids.size() == 0) {
            this.ids = null;
        }
    }

    private class FontIdentifier {
        private Display fDisplay;
        private Font fFont;

        FontIdentifier(Display display, Font font) {
            this.fDisplay = display;
            this.fFont = font;
        }

        public boolean equals(Object obj) {
            if (obj instanceof FontIdentifier) {
                FontIdentifier id = (FontIdentifier)obj;
                return id.fDisplay.equals(this.fDisplay) && id.fFont.equals((Object)this.fFont);
            }
            return false;
        }

        public int hashCode() {
            return this.fDisplay.hashCode() * 7 + this.fFont.hashCode();
        }
    }

    private class FontReference {
        private Font fFont;
        private int fCount;

        public FontReference(Font font) {
            this.fFont = font;
            this.fCount = 1;
        }

        public Font getFont() {
            return this.fFont;
        }

        public boolean decCount() {
            return --this.fCount == 0;
        }

        public void incCount() {
            ++this.fCount;
        }
    }
}

