/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo.engine;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.jdo.engine.SQLTypeConverters;
import org.castor.jdo.engine.SQLTypeInfos;
import org.castor.mapping.BindingType;
import org.castor.util.Messages;
import org.exolab.castor.jdo.engine.BaseFactory;
import org.exolab.castor.jdo.engine.JDOClassDescriptor;
import org.exolab.castor.jdo.engine.JDOFieldDescriptor;
import org.exolab.castor.jdo.engine.JDOFieldDescriptorImpl;
import org.exolab.castor.jdo.engine.KeyGeneratorDescriptor;
import org.exolab.castor.jdo.engine.KeyGeneratorRegistry;
import org.exolab.castor.mapping.AccessMode;
import org.exolab.castor.mapping.ClassDescriptor;
import org.exolab.castor.mapping.CollectionHandler;
import org.exolab.castor.mapping.ExtendedFieldHandler;
import org.exolab.castor.mapping.FieldDescriptor;
import org.exolab.castor.mapping.FieldHandler;
import org.exolab.castor.mapping.GeneralizedFieldHandler;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.mapping.TypeConvertor;
import org.exolab.castor.mapping.loader.AbstractFieldDescriptor;
import org.exolab.castor.mapping.loader.AbstractMappingLoader;
import org.exolab.castor.mapping.loader.CollectionHandlers;
import org.exolab.castor.mapping.loader.FieldDescriptorImpl;
import org.exolab.castor.mapping.loader.FieldHandlerFriend;
import org.exolab.castor.mapping.loader.FieldHandlerImpl;
import org.exolab.castor.mapping.loader.TypeInfo;
import org.exolab.castor.mapping.loader.Types;
import org.exolab.castor.mapping.xml.CacheTypeMapping;
import org.exolab.castor.mapping.xml.ClassMapping;
import org.exolab.castor.mapping.xml.FieldMapping;
import org.exolab.castor.mapping.xml.KeyGeneratorDef;
import org.exolab.castor.mapping.xml.MappingRoot;
import org.exolab.castor.mapping.xml.NamedQuery;
import org.exolab.castor.mapping.xml.Param;
import org.exolab.castor.mapping.xml.types.SqlDirtyType;

public final class JDOMappingLoader
extends AbstractMappingLoader {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$exolab$castor$jdo$engine$JDOMappingLoader == null ? (class$org$exolab$castor$jdo$engine$JDOMappingLoader = JDOMappingLoader.class$("org.exolab.castor.jdo.engine.JDOMappingLoader")) : class$org$exolab$castor$jdo$engine$JDOMappingLoader));
    private static final char LEFT_PARAM_SEPARATOR = '[';
    private static final char RIGHT_PARAM_SEPARATOR = ']';
    private final Map _keyGenDescs = new HashMap();
    private final KeyGeneratorRegistry _keyGenReg = new KeyGeneratorRegistry();
    private final Set _queryNames = new HashSet();
    private BaseFactory _factory;
    static /* synthetic */ Class class$org$exolab$castor$jdo$engine$JDOMappingLoader;
    static /* synthetic */ Class class$org$exolab$castor$jdo$TimeStampable;
    static /* synthetic */ Class class$org$exolab$castor$mapping$FieldHandler;

    public static String definition2param(String sqlTypeDef) {
        int left = sqlTypeDef.indexOf(91);
        int right = sqlTypeDef.indexOf(93);
        if (right < 0) {
            right = sqlTypeDef.length();
        }
        if (left < 0) {
            return null;
        }
        return sqlTypeDef.substring(left + 1, right);
    }

    public static String definition2type(String sqlTypeDef) {
        int sep = sqlTypeDef.indexOf(91);
        if (sep < 0) {
            return sqlTypeDef;
        }
        return sqlTypeDef.substring(0, sep);
    }

    public JDOMappingLoader(ClassLoader loader) {
        super(loader);
    }

    public BindingType getBindingType() {
        return BindingType.JDO;
    }

    public void loadMapping(MappingRoot mapping, Object param) throws MappingException {
        if (this.loadMapping()) {
            this._factory = (BaseFactory)param;
            this.createKeyGenDescriptors(mapping);
            this.createClassDescriptors(mapping);
        }
    }

    private void createKeyGenDescriptors(MappingRoot mapping) throws MappingException {
        Enumeration enumeration = mapping.enumerateKeyGeneratorDef();
        while (enumeration.hasMoreElements()) {
            KeyGeneratorDescriptor desc;
            KeyGeneratorDef def = (KeyGeneratorDef)enumeration.nextElement();
            String name = def.getAlias();
            if (name == null) {
                name = def.getName();
            }
            if ((desc = (KeyGeneratorDescriptor)this._keyGenDescs.get(name)) != null) {
                throw new MappingException(Messages.format("mapping.dupKeyGen", name));
            }
            Properties params = new Properties();
            Enumeration enumerateParam = def.enumerateParam();
            while (enumerateParam.hasMoreElements()) {
                Param par = (Param)enumerateParam.nextElement();
                params.put(par.getName(), par.getValue());
            }
            desc = new KeyGeneratorDescriptor(name, def.getName(), params, this._keyGenReg);
            this._keyGenDescs.put(name, desc);
        }
    }

    protected final ClassDescriptor createClassDescriptor(ClassMapping clsMap) throws MappingException {
        if (clsMap.getMapTo() == null || clsMap.getMapTo().getTable() == null) {
            LOG.info((Object)Messages.format("mapping.ignoringMapping", clsMap.getName()));
            return null;
        }
        JDOClassDescriptor clsDesc = new JDOClassDescriptor();
        clsDesc.setMapping(clsMap);
        Class javaClass = this.resolveType(clsMap.getName());
        if (!Types.isConstructable(javaClass, true)) {
            throw new MappingException("mapping.classNotConstructable", javaClass.getName());
        }
        clsDesc.setJavaClass(javaClass);
        ClassDescriptor extDesc = this.getExtended(clsMap, javaClass);
        if (extDesc != null) {
            if (!(extDesc instanceof JDOClassDescriptor)) {
                throw new IllegalArgumentException("Extended class does not have a JDO descriptor");
            }
            ((JDOClassDescriptor)extDesc).addExtended(clsDesc);
        }
        clsDesc.setExtends(extDesc);
        clsDesc.setDepends(this.getDepended(clsMap, javaClass));
        FieldDescriptor[] allFields = this.createFieldDescriptors(clsMap, javaClass);
        this.checkFieldNameDuplicates(allFields, javaClass);
        for (int i = 0; i < allFields.length; ++i) {
            ((AbstractFieldDescriptor)allFields[i]).setContainingClassDescriptor(clsDesc);
        }
        ArrayList<FieldDescriptor> fieldList = new ArrayList<FieldDescriptor>(allFields.length);
        ArrayList<FieldDescriptor> idList = new ArrayList<FieldDescriptor>();
        if (extDesc == null) {
            for (int i = 0; i < allFields.length; ++i) {
                if (!((AbstractFieldDescriptor)allFields[i]).isIdentity()) {
                    fieldList.add(allFields[i]);
                    continue;
                }
                idList.add(allFields[i]);
            }
            if (idList.size() == 0) {
                String[] idNames = clsMap.getIdentity();
                if (idNames == null || idNames.length == 0) {
                    throw new MappingException("mapping.noIdentity", javaClass.getName());
                }
                for (int i = 0; i < idNames.length; ++i) {
                    FieldDescriptor identity = this.findIdentityByName(fieldList, idNames[i], javaClass);
                    if (identity == null) {
                        throw new MappingException("mapping.identityMissing", idNames[i], javaClass.getName());
                    }
                    idList.add(identity);
                }
            }
        } else {
            for (int i = 0; i < allFields.length; ++i) {
                fieldList.add(allFields[i]);
            }
            FieldDescriptor[] extIds = ((JDOClassDescriptor)extDesc).getIdentities();
            for (int i = 0; i < extIds.length; ++i) {
                idList.add(extIds[i]);
            }
            for (int i = 0; i < idList.size(); ++i) {
                String idName = ((FieldDescriptor)idList.get(i)).getFieldName();
                FieldDescriptor identity = this.findIdentityByName(fieldList, idName, javaClass);
                if (identity == null) continue;
                idList.set(i, identity);
            }
        }
        FieldDescriptor[] ids = new FieldDescriptor[idList.size()];
        clsDesc.setIdentities(idList.toArray(ids));
        FieldDescriptor[] fields = new FieldDescriptor[fieldList.size()];
        clsDesc.setFields(fieldList.toArray(fields));
        clsDesc.setTableName(clsMap.getMapTo().getTable());
        this.extractAndSetAccessMode(clsDesc, clsMap);
        this.extractAndAddCacheParams(clsDesc, clsMap, javaClass);
        this.extractAndAddNamedQueries(clsDesc, clsMap);
        this.extractAndSetKeyGeneratorDescriptor(clsDesc, clsMap);
        return clsDesc;
    }

    private void extractAndSetAccessMode(JDOClassDescriptor clsDesc, ClassMapping clsMap) {
        if (clsMap.getAccess() != null) {
            clsDesc.setAccessMode(AccessMode.valueOf(clsMap.getAccess().toString()));
        }
    }

    private void extractAndAddCacheParams(JDOClassDescriptor clsDesc, ClassMapping clsMap, Class javaClass) throws MappingException {
        clsDesc.addCacheParam("name", clsMap.getName());
        CacheTypeMapping cacheMapping = clsMap.getCacheTypeMapping();
        if (cacheMapping != null) {
            String type = cacheMapping.getType();
            if ("none".equalsIgnoreCase(type) && (class$org$exolab$castor$jdo$TimeStampable == null ? (class$org$exolab$castor$jdo$TimeStampable = JDOMappingLoader.class$("org.exolab.castor.jdo.TimeStampable")) : class$org$exolab$castor$jdo$TimeStampable).isAssignableFrom(javaClass)) {
                throw new MappingException(Messages.format("persist.wrongCacheTypeSpecified", clsMap.getName()));
            }
            clsDesc.addCacheParam("type", type);
            Param[] params = cacheMapping.getParam();
            for (int i = 0; i < params.length; ++i) {
                clsDesc.addCacheParam(params[i].getName(), params[i].getValue());
            }
            String debug = new Boolean(cacheMapping.getDebug()).toString();
            clsDesc.addCacheParam("debug", debug);
            String capacity = Long.toString(cacheMapping.getCapacity());
            clsDesc.addCacheParam("capacity", capacity);
            clsDesc.addCacheParam("ttl", capacity);
        }
    }

    private void extractAndAddNamedQueries(JDOClassDescriptor clsDesc, ClassMapping clsMap) throws MappingException {
        Enumeration namedQueriesEnum = clsMap.enumerateNamedQuery();
        while (namedQueriesEnum.hasMoreElements()) {
            NamedQuery query = (NamedQuery)namedQueriesEnum.nextElement();
            String queryName = query.getName();
            if (this._queryNames.contains(queryName)) {
                throw new MappingException("Duplicate entry for named query with name " + queryName);
            }
            this._queryNames.add(queryName);
            clsDesc.addNamedQuery(queryName, query.getQuery());
        }
    }

    private void extractAndSetKeyGeneratorDescriptor(JDOClassDescriptor clsDesc, ClassMapping clsMap) {
        KeyGeneratorDescriptor keyGenDesc = null;
        String keyGenName = clsMap.getKeyGenerator();
        if (keyGenName != null && (keyGenDesc = (KeyGeneratorDescriptor)this._keyGenDescs.get(keyGenName)) == null) {
            keyGenDesc = new KeyGeneratorDescriptor(keyGenName, keyGenName, new Properties(), this._keyGenReg);
            this._keyGenDescs.put(keyGenName, keyGenDesc);
        }
        clsDesc.setKeyGeneratorDescriptor(keyGenDesc);
    }

    protected final FieldDescriptor findIdentityByName(List fldList, String idName, Class javaClass) throws MappingException {
        for (int i = 0; i < fldList.size(); ++i) {
            FieldDescriptor field = (FieldDescriptor)fldList.get(i);
            if (!idName.equals(field.getFieldName())) continue;
            if (!(field instanceof JDOFieldDescriptor)) {
                throw new IllegalStateException("Identity field must be of type JDOFieldDescriptor");
            }
            String[] sqlName = ((JDOFieldDescriptor)field).getSQLName();
            if (sqlName == null) {
                throw new MappingException("mapping.noSqlName", field.getFieldName(), javaClass.getName());
            }
            fldList.remove(i);
            return field;
        }
        return null;
    }

    protected final void resolveRelations(ClassDescriptor clsDesc) {
        FieldDescriptor[] fields = clsDesc.getFields();
        for (int i = 0; i < fields.length; ++i) {
            FieldDescriptor field = fields[i];
            ClassDescriptor desc = this.getDescriptor(field.getFieldType().getName());
            if (desc == null || !(field instanceof FieldDescriptorImpl)) continue;
            ((FieldDescriptorImpl)field).setClassDescriptor(desc);
        }
    }

    protected String[] getSqlTypes(FieldMapping fieldMap) {
        int current;
        if (fieldMap.getSql() == null) {
            return new String[0];
        }
        String sqlType = fieldMap.getSql().getType();
        if (sqlType == null) {
            return new String[0];
        }
        ArrayList<String> types = new ArrayList<String>();
        int begin = 0;
        int state = 0;
        block4: for (current = 0; current < sqlType.length(); ++current) {
            switch (state) {
                case 0: {
                    if (sqlType.charAt(current) == ' ') {
                        types.add(sqlType.substring(begin, current));
                        begin = current + 1;
                        continue block4;
                    }
                    if (sqlType.charAt(current) != '[') continue block4;
                    state = 1;
                    continue block4;
                }
                case 1: {
                    if (sqlType.charAt(current) != ']') continue block4;
                    state = 0;
                }
            }
        }
        types.add(sqlType.substring(begin, current));
        String[] result = new String[types.size()];
        return types.toArray(result);
    }

    protected TypeInfo getTypeInfo(Class fieldType, CollectionHandler colHandler, FieldMapping fieldMap) throws MappingException {
        TypeConvertor convertorTo = null;
        TypeConvertor convertorFrom = null;
        String convertorParam = null;
        String typeName = null;
        Class sqlType = null;
        fieldType = Types.typeFromPrimitive(fieldType);
        String[] sqlTypes = this.getSqlTypes(fieldMap);
        if (fieldMap.getSql() != null && sqlTypes.length > 0) {
            typeName = sqlTypes[0];
            sqlType = SQLTypeInfos.sqlTypeName2javaType(JDOMappingLoader.definition2type(typeName));
        } else {
            sqlType = fieldType;
        }
        if (this._factory != null) {
            sqlType = this._factory.adjustSqlType(sqlType);
        }
        if (fieldType != sqlType) {
            block14: {
                try {
                    convertorTo = SQLTypeConverters.getConvertor(sqlType, fieldType);
                }
                catch (MappingException ex) {
                    boolean isTypeSafeEnum = false;
                    if (fieldType != null && !JDOMappingLoader.isPrimitive(fieldType)) {
                        Constructor cons = null;
                        try {
                            cons = fieldType.getConstructor(EMPTY_ARGS);
                            if (!Modifier.isPublic(cons.getModifiers())) {
                                cons = null;
                            }
                        }
                        catch (NoSuchMethodException nsmx) {
                            // empty catch block
                        }
                        try {
                            int mods;
                            Method method;
                            Class<?> returnType;
                            if (cons == null && (returnType = (method = fieldType.getMethod("valueOf", STRING_ARG)).getReturnType()) != null && fieldType.isAssignableFrom(returnType) && Modifier.isStatic(mods = method.getModifiers())) {
                                convertorTo = new SQLTypeConverters.Convertor(sqlType, fieldType){
                                    private Method method = null;

                                    public Object convert(Object obj, String param) {
                                        try {
                                            if (this.method == null) {
                                                this.method = this.toType().getMethod("valueOf", STRING_ARG);
                                            }
                                            return this.method.invoke((Object)this.toType(), (String)obj);
                                        }
                                        catch (Exception ex) {
                                            return null;
                                        }
                                    }
                                };
                                Types.addEnumType(fieldType);
                                isTypeSafeEnum = true;
                            }
                        }
                        catch (NoSuchMethodException nsmx) {
                            // empty catch block
                        }
                    }
                    if (isTypeSafeEnum) break block14;
                    throw new MappingException("mapping.noConvertor", sqlType.getName(), fieldType.getName());
                }
            }
            convertorFrom = SQLTypeConverters.getConvertor(fieldType, sqlType);
            if (typeName != null) {
                convertorParam = JDOMappingLoader.definition2param(typeName);
            }
        }
        return new TypeInfo(fieldType, convertorTo, convertorFrom, convertorParam, fieldMap.getRequired(), null, colHandler);
    }

    protected AbstractFieldDescriptor createFieldDesc(Class javaClass, FieldMapping fieldMap) throws MappingException {
        int[] sqlTypeNum;
        if (fieldMap.getSql() == null) {
            return super.createFieldDesc(javaClass, fieldMap);
        }
        String fieldName = fieldMap.getName();
        Class fieldType = null;
        if (fieldMap.getType() != null) {
            fieldType = this.resolveType(fieldMap.getType());
        }
        CollectionHandler colHandler = null;
        if (fieldMap.getCollection() != null) {
            Class colType = CollectionHandlers.getCollectionType(fieldMap.getCollection().toString());
            colHandler = CollectionHandlers.getHandler(colType);
            if (colType.getName().equals("java.util.Iterator") && fieldMap.getLazy()) {
                String err = "Lazy loading not supported for collection type 'iterator'";
                throw new MappingException(err);
            }
            if (colType.getName().equals("java.util.Enumeration") && fieldMap.getLazy()) {
                String err = "Lazy loading not supported for collection type 'enumerate'";
                throw new MappingException(err);
            }
        }
        TypeInfo typeInfo = this.getTypeInfo(fieldType, colHandler, fieldMap);
        ExtendedFieldHandler exfHandler = null;
        FieldHandler handler = null;
        if (fieldMap.getHandler() != null) {
            Class handlerClass;
            if (!(class$org$exolab$castor$mapping$FieldHandler == null ? (class$org$exolab$castor$mapping$FieldHandler = JDOMappingLoader.class$("org.exolab.castor.mapping.FieldHandler")) : class$org$exolab$castor$mapping$FieldHandler).isAssignableFrom(handlerClass = this.resolveType(fieldMap.getHandler()))) {
                String err = "The class '" + fieldMap.getHandler() + "' must implement " + (class$org$exolab$castor$mapping$FieldHandler == null ? (class$org$exolab$castor$mapping$FieldHandler = JDOMappingLoader.class$("org.exolab.castor.mapping.FieldHandler")) : class$org$exolab$castor$mapping$FieldHandler).getName();
                throw new MappingException(err);
            }
            Constructor constructor = null;
            try {
                constructor = handlerClass.getConstructor(new Class[0]);
                handler = (FieldHandler)constructor.newInstance(new Object[0]);
            }
            catch (Exception except) {
                String err = "The class '" + handlerClass.getName() + "' must have a default public constructor.";
                throw new MappingException(err);
            }
            if (handler instanceof ExtendedFieldHandler) {
                exfHandler = (ExtendedFieldHandler)handler;
            }
            colHandler = typeInfo.getCollectionHandler();
            typeInfo.setCollectionHandler(null);
            handler = new FieldHandlerImpl(handler, typeInfo);
            typeInfo.setCollectionHandler(colHandler);
        }
        boolean generalized = exfHandler instanceof GeneralizedFieldHandler;
        FieldHandler custom = handler;
        if (generalized) {
            fieldType = ((GeneralizedFieldHandler)exfHandler).getFieldType();
        }
        if (generalized || handler == null) {
            AbstractMappingLoader.TypeInfoReference typeInfoRef = new AbstractMappingLoader.TypeInfoReference(this);
            typeInfoRef.typeInfo = typeInfo;
            handler = this.createFieldHandler(javaClass, fieldType, fieldMap, typeInfoRef);
            if (custom != null) {
                ((GeneralizedFieldHandler)exfHandler).setFieldHandler(handler);
                handler = custom;
            } else {
                typeInfo = typeInfoRef.typeInfo;
            }
        }
        String[] sqlName = fieldMap.getSql().getName();
        String[] sqlTypes = this.getSqlTypes(fieldMap);
        if (sqlTypes.length > 0) {
            sqlTypeNum = new int[sqlTypes.length];
            for (int i = 0; i < sqlTypes.length; ++i) {
                String sqlTypeString = JDOMappingLoader.definition2type(sqlTypes[i]);
                Class sqlType = SQLTypeInfos.sqlTypeName2javaType(sqlTypeString);
                if (this._factory != null) {
                    sqlType = this._factory.adjustSqlType(sqlType);
                }
                sqlTypeNum[i] = SQLTypeInfos.javaType2sqlTypeNum(sqlType);
            }
        } else {
            Class sqlType = typeInfo.getFieldType();
            if (this._factory != null) {
                sqlType = this._factory.adjustSqlType(sqlType);
            }
            sqlTypeNum = new int[]{SQLTypeInfos.javaType2sqlTypeNum(sqlType)};
        }
        JDOFieldDescriptorImpl jdoFieldDescriptor = new JDOFieldDescriptorImpl(fieldName, typeInfo, handler, fieldMap.getTransient(), sqlName, sqlTypeNum, fieldMap.getSql().getManyTable(), fieldMap.getSql().getManyKey(), !SqlDirtyType.IGNORE.equals(fieldMap.getSql().getDirty()), fieldMap.getSql().getReadOnly());
        jdoFieldDescriptor.setRequired(fieldMap.getRequired());
        if (exfHandler != null) {
            ((FieldHandlerFriend)exfHandler).setFieldDescriptor(jdoFieldDescriptor);
        }
        if (fieldMap.getSql().getTransient()) {
            jdoFieldDescriptor.setTransient(true);
        }
        return jdoFieldDescriptor;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

