/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import sun.awt.AppContext;
import sun.awt.SunToolkit;
import sun.awt.UNIXToolkit;
import sun.awt.X11.Native;
import sun.awt.X11.WindowPropertyGetter;
import sun.awt.X11.XAtom;
import sun.awt.X11.XClipboard;
import sun.awt.X11.XDataTransferer;
import sun.awt.X11.XEvent;
import sun.awt.X11.XEventDispatcher;
import sun.awt.X11.XPropertyEvent;
import sun.awt.X11.XSelectionClearEvent;
import sun.awt.X11.XSelectionEvent;
import sun.awt.X11.XSelectionRequestEvent;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XWindow;
import sun.awt.X11.XWindowAttributes;
import sun.awt.X11.XlibWrapper;
import sun.awt.datatransfer.DataTransferer;

public class XSelection {
    private static final Hashtable<XAtom, XSelection> table = new Hashtable();
    private static final Object lock = new Object();
    private static final XAtom selectionPropertyAtom = XAtom.get("XAWT_SELECTION");
    public static final long MAX_LENGTH = 1000000L;
    public static final int MAX_PROPERTY_SIZE;
    private static long SELECTION_TIMEOUT;
    private static final XEventDispatcher incrementalTransferHandler;
    private static WindowPropertyGetter propertyGetter;
    private final XAtom selectionAtom;
    private final XClipboard clipboard;
    private Transferable contents = null;
    private Map formatMap = null;
    private long[] formats = null;
    private AppContext appContext = null;
    private static long lastRequestServerTime;
    private long ownershipTime = 0L;
    private boolean isOwner;
    private volatile XAtom targetsPropertyAtom;
    private static volatile Set targetsPropertyAtoms;
    private volatile boolean isSelectionNotifyProcessed;
    private long convertSelectionTime;

    static XSelection getSelection(XAtom xAtom) {
        return table.get(xAtom);
    }

    public XSelection(XAtom xAtom, XClipboard xClipboard) {
        if (xAtom == null) {
            throw new NullPointerException("Null atom");
        }
        this.selectionAtom = xAtom;
        this.clipboard = xClipboard;
        table.put(this.selectionAtom, this);
    }

    public XAtom getSelectionAtom() {
        return this.selectionAtom;
    }

    void initializeSelectionForTrackingChanges() {
        this.targetsPropertyAtom = XAtom.get("XAWT_TARGETS_OF_SELECTION:" + this.selectionAtom.getName());
        if (targetsPropertyAtoms == null) {
            targetsPropertyAtoms = Collections.synchronizedSet(new HashSet(2));
        }
        targetsPropertyAtoms.add(this.targetsPropertyAtom.getAtom());
        this.isSelectionNotifyProcessed = true;
    }

    void deinitializeSelectionForTrackingChanges() {
        if (targetsPropertyAtoms != null && this.targetsPropertyAtom != null) {
            targetsPropertyAtoms.remove(this.targetsPropertyAtom.getAtom());
        }
        this.isSelectionNotifyProcessed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean setOwner(Transferable transferable, Map map, long[] lArray, long l) {
        long l2 = XWindow.getXAWTRootWindow().getWindow();
        long l3 = this.selectionAtom.getAtom();
        if (l == 0L) {
            l = XToolkit.getCurrentServerTime();
        }
        this.contents = transferable;
        this.formatMap = map;
        this.formats = lArray;
        this.appContext = AppContext.getAppContext();
        this.ownershipTime = l;
        XToolkit.awtLock();
        try {
            XlibWrapper.XSetSelectionOwner(XToolkit.getDisplay(), l3, l2, l);
            if (XlibWrapper.XGetSelectionOwner(XToolkit.getDisplay(), l3) != l2) {
                this.reset();
                boolean bl = false;
                return bl;
            }
            this.isOwner = true;
            if (this.clipboard != null) {
                this.clipboard.checkChangeHere(transferable);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void waitForSelectionNotify(WindowPropertyGetter windowPropertyGetter) throws InterruptedException {
        long l = System.currentTimeMillis();
        XToolkit.awtLock();
        try {
            do {
                DataTransferer.getInstance().processDataConversionRequests();
                XToolkit.awtLockWait(250L);
            } while (propertyGetter == windowPropertyGetter && System.currentTimeMillis() < l + SELECTION_TIMEOUT);
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public long[] getTargets(long l) {
        if (XToolkit.isToolkitThread()) {
            throw new Error("UNIMPLEMENTED");
        }
        long[] lArray = null;
        Object object = lock;
        synchronized (object) {
            SELECTION_TIMEOUT = UNIXToolkit.getDatatransferTimeout();
            WindowPropertyGetter windowPropertyGetter = new WindowPropertyGetter(XWindow.getXAWTRootWindow().getWindow(), selectionPropertyAtom, 0L, 1000000L, true, 0L);
            try {
                XToolkit.awtLock();
                try {
                    propertyGetter = windowPropertyGetter;
                    lastRequestServerTime = l;
                    XlibWrapper.XConvertSelection(XToolkit.getDisplay(), this.getSelectionAtom().getAtom(), XDataTransferer.TARGETS_ATOM.getAtom(), selectionPropertyAtom.getAtom(), XWindow.getXAWTRootWindow().getWindow(), l);
                    try {
                        XSelection.waitForSelectionNotify(windowPropertyGetter);
                        propertyGetter = null;
                    }
                    catch (InterruptedException interruptedException) {
                        long[] lArray2;
                        try {
                            lArray2 = new long[]{};
                            propertyGetter = null;
                        }
                        catch (Throwable throwable) {
                            propertyGetter = null;
                            throw throwable;
                        }
                        XToolkit.awtUnlock();
                        windowPropertyGetter.dispose();
                        return lArray2;
                    }
                }
                finally {
                    XToolkit.awtUnlock();
                }
            }
            finally {
                windowPropertyGetter.dispose();
            }
        }
    }

    private static long[] getFormats(WindowPropertyGetter windowPropertyGetter) {
        int n;
        long[] lArray = null;
        if (windowPropertyGetter.isExecuted() && !windowPropertyGetter.isDisposed() && (windowPropertyGetter.getActualType() == 4L || windowPropertyGetter.getActualType() == XDataTransferer.TARGETS_ATOM.getAtom()) && windowPropertyGetter.getActualFormat() == 32 && (n = windowPropertyGetter.getNumberOfItems()) > 0) {
            long l = windowPropertyGetter.getData();
            lArray = new long[n];
            for (int i = 0; i < n; ++i) {
                lArray[i] = Native.getLong(l + (long)(i * XAtom.getAtomSize()));
            }
        }
        return lArray != null ? lArray : new long[]{};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getTargetsDelayed() {
        XToolkit.awtLock();
        try {
            long l = System.currentTimeMillis();
            if (this.isSelectionNotifyProcessed || l >= this.convertSelectionTime + SELECTION_TIMEOUT) {
                this.convertSelectionTime = l;
                XlibWrapper.XConvertSelection(XToolkit.getDisplay(), this.getSelectionAtom().getAtom(), XDataTransferer.TARGETS_ATOM.getAtom(), this.targetsPropertyAtom.getAtom(), XWindow.getXAWTRootWindow().getWindow(), 0L);
                this.isSelectionNotifyProcessed = false;
            }
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public byte[] getData(long l, long l2) throws IOException {
        if (XToolkit.isToolkitThread()) {
            throw new Error("UNIMPLEMENTED");
        }
        byte[] byArray = null;
        Object object = lock;
        synchronized (object) {
            SELECTION_TIMEOUT = UNIXToolkit.getDatatransferTimeout();
            WindowPropertyGetter windowPropertyGetter = new WindowPropertyGetter(XWindow.getXAWTRootWindow().getWindow(), selectionPropertyAtom, 0L, 1000000L, false, 0L);
            try {
                XToolkit.awtLock();
                try {
                    propertyGetter = windowPropertyGetter;
                    lastRequestServerTime = l2;
                    XlibWrapper.XConvertSelection(XToolkit.getDisplay(), this.getSelectionAtom().getAtom(), l, selectionPropertyAtom.getAtom(), XWindow.getXAWTRootWindow().getWindow(), l2);
                    try {
                        XSelection.waitForSelectionNotify(windowPropertyGetter);
                        propertyGetter = null;
                    }
                    catch (InterruptedException interruptedException) {
                        byte[] byArray2;
                        try {
                            byArray2 = new byte[]{};
                            propertyGetter = null;
                        }
                        catch (Throwable throwable) {
                            propertyGetter = null;
                            throw throwable;
                        }
                        XToolkit.awtUnlock();
                        windowPropertyGetter.dispose();
                        return byArray2;
                    }
                }
                finally {
                    XToolkit.awtUnlock();
                }
            }
            finally {
                windowPropertyGetter.dispose();
            }
        }
    }

    boolean isOwner() {
        return this.isOwner;
    }

    public void lostOwnership() {
        this.isOwner = false;
        if (this.clipboard != null) {
            this.clipboard.run();
        }
    }

    public synchronized void reset() {
        this.contents = null;
        this.formatMap = null;
        this.formats = null;
        this.appContext = null;
        this.ownershipTime = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean convertAndStore(long l, long l2, long l3) {
        int n = 8;
        byte[] byArray = null;
        long l4 = 0L;
        int n2 = 0;
        try {
            SunToolkit.insertTargetMapping(this, this.appContext);
            byArray = DataTransferer.getInstance().convertData(this, this.contents, l2, this.formatMap, XToolkit.isToolkitThread());
        }
        catch (IOException iOException) {
            return false;
        }
        if (byArray == null) {
            return false;
        }
        n2 = byArray.length;
        try {
            if (n2 > 0) {
                if (n2 <= MAX_PROPERTY_SIZE) {
                    l4 = Native.toData(byArray);
                } else {
                    new IncrementalDataProvider(l, l3, l2, 8, byArray);
                    l4 = XlibWrapper.unsafe.allocateMemory(XAtom.getAtomSize());
                    Native.putLong(l4, n2);
                    l2 = XDataTransferer.INCR_ATOM.getAtom();
                    n = 32;
                    n2 = 1;
                }
            }
            XToolkit.awtLock();
            try {
                XlibWrapper.XChangeProperty(XToolkit.getDisplay(), l, l3, l2, n, 0, l4, n2);
            }
            finally {
                XToolkit.awtUnlock();
            }
        }
        finally {
            if (l4 != 0L) {
                XlibWrapper.unsafe.freeMemory(l4);
                l4 = 0L;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void handleSelectionRequest(XSelectionRequestEvent var1_1) {
        block32: {
            var2_2 = var1_1.get_property();
            var4_3 = var1_1.get_requestor();
            var6_4 = var1_1.get_time();
            var8_5 = var1_1.get_target();
            var10_6 = 0;
            var11_7 = false;
            if (this.ownershipTime != 0L && (var6_4 == 0L || var6_4 >= this.ownershipTime)) {
                var2_2 = var1_1.get_property();
                if (var8_5 == XDataTransferer.MULTIPLE_ATOM.getAtom()) {
                    if (var2_2 != 0L) {
                        var12_8 = new WindowPropertyGetter(var4_3, XAtom.get(var2_2), 0L, 1000000L, false, 0L);
                        try {
                            var12_8.execute();
                            if (var12_8.getActualFormat() != 32 || var12_8.getNumberOfItems() % 2 != 0) ** GOTO lbl70
                            var13_11 = var12_8.getNumberOfItems() / 2;
                            var15_12 = var12_8.getData();
                            var17_14 = false;
                            var18_15 = 0;
                            while ((long)var18_15 < var13_11) {
                                var19_16 = Native.getLong(var15_12, 2 * var18_15);
                                if (!this.convertAndStore(var4_3, var19_16, var21_17 = Native.getLong(var15_12, 2 * var18_15 + 1))) {
                                    Native.putLong(var15_12, 2 * var18_15, 0L);
                                    var17_14 = true;
                                }
                                ++var18_15;
                            }
                            if (var17_14) {
                                XToolkit.awtLock();
                                try {
                                    XlibWrapper.XChangeProperty(XToolkit.getDisplay(), var4_3, var2_2, var12_8.getActualType(), var12_8.getActualFormat(), 0, var12_8.getData(), var12_8.getNumberOfItems());
                                }
                                finally {
                                    XToolkit.awtUnlock();
                                }
                            }
                            var11_7 = true;
                        }
                        finally {
                            var12_8.dispose();
                        }
                    }
                } else {
                    if (var2_2 == 0L) {
                        var2_2 = var8_5;
                    }
                    if (var8_5 == XDataTransferer.TARGETS_ATOM.getAtom()) {
                        var12_9 = 0L;
                        var14_20 = 0;
                        var10_6 = 32;
                        var15_13 = this.formats;
                        if (var15_13 == null) {
                            throw new IllegalStateException("Not an owner.");
                        }
                        var14_20 = var15_13.length;
                        try {
                            if (var14_20 > 0) {
                                var12_9 = Native.allocateLongArray(var14_20);
                                Native.put(var12_9, var15_13);
                            }
                            var11_7 = true;
                            XToolkit.awtLock();
                            try {
                                XlibWrapper.XChangeProperty(XToolkit.getDisplay(), var4_3, var2_2, var8_5, var10_6, 0, var12_9, var14_20);
                                break block32;
                            }
                            finally {
                                XToolkit.awtUnlock();
                            }
                        }
                        finally {
                            if (var12_9 != 0L) {
                                XlibWrapper.unsafe.freeMemory(var12_9);
                                var12_9 = 0L;
                            }
                        }
                    }
                    var11_7 = this.convertAndStore(var4_3, var8_5, var2_2);
                }
            }
        }
        if (!var11_7) {
            var2_2 = 0L;
        }
        var12_10 = new XSelectionEvent();
        try {
            var12_10.set_type(31);
            var12_10.set_send_event(true);
            var12_10.set_requestor(var4_3);
            var12_10.set_selection(this.selectionAtom.getAtom());
            var12_10.set_target(var8_5);
            var12_10.set_property(var2_2);
            var12_10.set_time(var6_4);
            XToolkit.awtLock();
            try {
                XlibWrapper.XSendEvent(XToolkit.getDisplay(), var4_3, false, 0L, var12_10.pData);
            }
            finally {
                XToolkit.awtUnlock();
            }
        }
        finally {
            var12_10.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkChange(XSelectionEvent xSelectionEvent) {
        Object object;
        if (targetsPropertyAtoms == null || targetsPropertyAtoms.isEmpty()) {
            return;
        }
        long l = xSelectionEvent.get_property();
        long[] lArray = null;
        if (l == 0L) {
            lArray = new long[]{};
        } else {
            if (!targetsPropertyAtoms.contains(l)) {
                return;
            }
            object = new WindowPropertyGetter(XWindow.getXAWTRootWindow().getWindow(), XAtom.get(l), 0L, 1000000L, true, 0L);
            try {
                ((WindowPropertyGetter)object).execute();
                lArray = XSelection.getFormats((WindowPropertyGetter)object);
            }
            finally {
                ((WindowPropertyGetter)object).dispose();
            }
        }
        object = XAtom.get(xSelectionEvent.get_selection());
        XSelection xSelection = XSelection.getSelection((XAtom)object);
        if (xSelection != null) {
            xSelection.isSelectionNotifyProcessed = true;
            if (xSelection.clipboard != null) {
                xSelection.clipboard.checkChange(lArray);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        XToolkit.awtLock();
        try {
            MAX_PROPERTY_SIZE = (int)(XlibWrapper.XMaxRequestSize(XToolkit.getDisplay()) * 4L - 100L);
        }
        finally {
            XToolkit.awtUnlock();
        }
        SELECTION_TIMEOUT = UNIXToolkit.getDatatransferTimeout();
        incrementalTransferHandler = new IncrementalTransferHandler();
        propertyGetter = null;
        XToolkit.addEventDispatcher(XWindow.getXAWTRootWindow().getWindow(), new SelectionEventHandler());
    }

    private static class IncrementalDataProvider
    implements XEventDispatcher {
        private final long requestor;
        private final long property;
        private final long target;
        private final int format;
        private final byte[] data;
        private int offset = 0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IncrementalDataProvider(long l, long l2, long l3, int n, byte[] byArray) {
            if (n != 8) {
                throw new IllegalArgumentException("Unsupported format: " + n);
            }
            this.requestor = l;
            this.property = l2;
            this.target = l3;
            this.format = n;
            this.data = byArray;
            XWindowAttributes xWindowAttributes = new XWindowAttributes();
            try {
                XToolkit.awtLock();
                try {
                    XlibWrapper.XGetWindowAttributes(XToolkit.getDisplay(), l, xWindowAttributes.pData);
                    XlibWrapper.XSelectInput(XToolkit.getDisplay(), l, xWindowAttributes.get_your_event_mask() | 0x400000L);
                }
                finally {
                    XToolkit.awtUnlock();
                }
            }
            finally {
                xWindowAttributes.dispose();
            }
            XToolkit.addEventDispatcher(l, this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dispatchEvent(XEvent xEvent) {
            switch (xEvent.get_type()) {
                case 28: {
                    XPropertyEvent xPropertyEvent = xEvent.get_xproperty();
                    if (xPropertyEvent.get_window() != this.requestor || xPropertyEvent.get_state() != 1 || xPropertyEvent.get_atom() != this.property) break;
                    int n = this.data.length - this.offset;
                    long l = 0L;
                    if (n > MAX_PROPERTY_SIZE) {
                        n = MAX_PROPERTY_SIZE;
                    }
                    if (n > 0) {
                        l = XlibWrapper.unsafe.allocateMemory(n);
                        for (int i = 0; i < n; ++i) {
                            Native.putByte(l + (long)i, this.data[this.offset + i]);
                        }
                    } else {
                        assert (n == 0);
                        XToolkit.removeEventDispatcher(this.requestor, this);
                    }
                    XToolkit.awtLock();
                    try {
                        XlibWrapper.XChangeProperty(XToolkit.getDisplay(), this.requestor, this.property, this.target, this.format, 0, l, n);
                    }
                    finally {
                        XToolkit.awtUnlock();
                    }
                    if (l != 0L) {
                        XlibWrapper.unsafe.freeMemory(l);
                        l = 0L;
                    }
                    this.offset += n;
                }
            }
        }
    }

    private static class IncrementalTransferHandler
    implements XEventDispatcher {
        private IncrementalTransferHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dispatchEvent(XEvent xEvent) {
            switch (xEvent.get_type()) {
                case 28: {
                    XPropertyEvent xPropertyEvent = xEvent.get_xproperty();
                    if (xPropertyEvent.get_state() != 0 || xPropertyEvent.get_atom() != selectionPropertyAtom.getAtom()) break;
                    XToolkit.awtLock();
                    try {
                        if (propertyGetter != null) {
                            propertyGetter.execute();
                            propertyGetter = null;
                        }
                        XToolkit.awtLockNotifyAll();
                        break;
                    }
                    finally {
                        XToolkit.awtUnlock();
                    }
                }
            }
        }
    }

    private static class SelectionEventHandler
    implements XEventDispatcher {
        private SelectionEventHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dispatchEvent(XEvent xEvent) {
            switch (xEvent.get_type()) {
                case 31: {
                    XSelectionEvent xSelectionEvent = xEvent.get_xselection();
                    XSelection.checkChange(xSelectionEvent);
                    XToolkit.awtLock();
                    try {
                        if (propertyGetter != null && xSelectionEvent.get_time() == lastRequestServerTime) {
                            if (xSelectionEvent.get_property() == selectionPropertyAtom.getAtom()) {
                                propertyGetter.execute();
                                propertyGetter = null;
                            } else if (xSelectionEvent.get_property() == 0L) {
                                propertyGetter.dispose();
                                propertyGetter = null;
                            }
                        }
                        XToolkit.awtLockNotifyAll();
                        break;
                    }
                    finally {
                        XToolkit.awtUnlock();
                    }
                }
                case 30: {
                    XSelectionRequestEvent xSelectionRequestEvent = xEvent.get_xselectionrequest();
                    long l = xSelectionRequestEvent.get_selection();
                    XSelection xSelection = XSelection.getSelection(XAtom.get(l));
                    if (xSelection == null) break;
                    xSelection.handleSelectionRequest(xSelectionRequestEvent);
                    break;
                }
                case 29: {
                    XSelectionClearEvent xSelectionClearEvent = xEvent.get_xselectionclear();
                    long l = xSelectionClearEvent.get_selection();
                    XSelection xSelection = XSelection.getSelection(XAtom.get(l));
                    if (xSelection != null) {
                        xSelection.lostOwnership();
                    }
                    XToolkit.awtLock();
                    try {
                        XToolkit.awtLockNotifyAll();
                        break;
                    }
                    finally {
                        XToolkit.awtUnlock();
                    }
                }
            }
        }
    }
}

