/*
 * Decompiled with CFR 0.152.
 */
package mediaLib;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import mediaLib.Constants;
import mediaLib.mediaLibException;
import mediaLib.mediaLibImageColormap;

public class mediaLibImage
implements Cloneable,
Constants,
Serializable {
    protected int type = 1;
    protected int channels = 1;
    protected int width = 256;
    protected int height = 256;
    protected int stride = 256;
    protected int offset = 0;
    protected Object data;
    protected int format;
    protected int[] borders;
    private static final int RAS_MAGIC = 1504078485;
    private static final int RT_OLD = 0;
    private static final int RT_STANDARD = 1;
    private static final int RT_BYTE_ENCODED = 2;
    private static final int RT_FORMAT_RGB = 3;
    private static final int RT_FORMAT_TIFF = 4;
    private static final int RT_FORMAT_IFF = 5;
    private static final int RT_EXPERIMENTAL = 65535;
    private static final int RMT_NONE = 0;
    private static final int RMT_EQUAL_RGB = 1;
    private static final int RMT_RAW = 2;
    private int depth;
    private int length;
    private int rttype;
    private int maptype;
    private int maplength;
    private URL url;
    public static final int UNKNOWN = 0;
    public static final int INDEXED = 1;
    public static final int GRAYSCALE = 2;
    public static final int RGB = 3;
    public static final int BGR = 4;
    public static final int ARGB = 5;
    public static final int ABGR = 6;
    public static final int PACKED_ARGB = 7;
    public static final int PACKED_ABGR = 8;

    public mediaLibImage(int n, int n2, int n3, int n4) {
        int[] nArray = new int[4];
        nArray[2] = 256;
        nArray[3] = 256;
        this.borders = nArray;
        this.depth = 0;
        this.length = 0;
        this.rttype = 1;
        this.maptype = 0;
        this.maplength = 0;
        this.url = null;
        this.createImage(n, n2, n3, n4);
    }

    public mediaLibImage(int n, int n2, int n3, int n4, int n5) {
        int[] nArray = new int[4];
        nArray[2] = 256;
        nArray[3] = 256;
        this.borders = nArray;
        this.depth = 0;
        this.length = 0;
        this.rttype = 1;
        this.maptype = 0;
        this.maplength = 0;
        this.url = null;
        this.createImage(n, n2, n3, n4);
        this.setFormat(n5);
    }

    public mediaLibImage(int n, int n2, int n3, int n4, int n5, int n6, int n7, Object object) {
        int[] nArray = new int[4];
        nArray[2] = 256;
        nArray[3] = 256;
        this.borders = nArray;
        this.depth = 0;
        this.length = 0;
        this.rttype = 1;
        this.maptype = 0;
        this.maplength = 0;
        this.url = null;
        this.type = n;
        this.channels = n2;
        this.width = n3;
        this.height = n4;
        this.stride = n5;
        this.offset = n6;
        this.format = n7;
        this.data = object;
        this.borders[0] = 0;
        this.borders[1] = 0;
        this.borders[2] = n3;
        this.borders[3] = n4;
    }

    public mediaLibImage(int n, int n2, int n3, int n4, int n5, int n6, Object object) {
        int[] nArray = new int[4];
        nArray[2] = 256;
        nArray[3] = 256;
        this.borders = nArray;
        this.depth = 0;
        this.length = 0;
        this.rttype = 1;
        this.maptype = 0;
        this.maplength = 0;
        this.url = null;
        this.type = n;
        this.channels = n2;
        this.width = n3;
        this.height = n4;
        this.stride = n5;
        this.offset = n6;
        this.data = object;
        this.format = 0;
        this.borders[0] = 0;
        this.borders[1] = 0;
        this.borders[2] = n3;
        this.borders[3] = n4;
    }

    public mediaLibImage(int n, int n2, int n3, int n4, int n5, int[] nArray) {
        int[] nArray2 = new int[4];
        nArray2[2] = 256;
        nArray2[3] = 256;
        this.borders = nArray2;
        this.depth = 0;
        this.length = 0;
        this.rttype = 1;
        this.maptype = 0;
        this.maplength = 0;
        this.url = null;
        this.createImage(n, n2, n3, n4);
        this.setColor(nArray);
        this.setFormat(n5);
    }

    public mediaLibImage(int n, int n2, int n3, int n4, int[] nArray) {
        int[] nArray2 = new int[4];
        nArray2[2] = 256;
        nArray2[3] = 256;
        this.borders = nArray2;
        this.depth = 0;
        this.length = 0;
        this.rttype = 1;
        this.maptype = 0;
        this.maplength = 0;
        this.url = null;
        this.createImage(n, n2, n3, n4);
        this.setColor(nArray);
    }

    public mediaLibImage(File file) {
        int[] nArray = new int[4];
        nArray[2] = 256;
        nArray[3] = 256;
        this.borders = nArray;
        this.depth = 0;
        this.length = 0;
        this.rttype = 1;
        this.maptype = 0;
        this.maplength = 0;
        this.url = null;
        this.offset = 0;
        this.readSunImage(file);
    }

    public mediaLibImage(InputStream inputStream) throws IOException {
        int[] nArray = new int[4];
        nArray[2] = 256;
        nArray[3] = 256;
        this.borders = nArray;
        this.depth = 0;
        this.length = 0;
        this.rttype = 1;
        this.maptype = 0;
        this.maplength = 0;
        this.url = null;
        this.offset = 0;
        this.readSunImage(inputStream);
    }

    public mediaLibImage(URL uRL) {
        int[] nArray = new int[4];
        nArray[2] = 256;
        nArray[3] = 256;
        this.borders = nArray;
        this.depth = 0;
        this.length = 0;
        this.rttype = 1;
        this.maptype = 0;
        this.maplength = 0;
        this.url = null;
        this.url = uRL;
        this.offset = 0;
        this.readSunImage(this.url);
    }

    protected void checkChannels(mediaLibImage mediaLibImage2) {
        if (this.getChannels() != mediaLibImage2.getChannels()) {
            throw new mediaLibException(5);
        }
    }

    protected void checkChannels(double[] dArray) {
        if (this.getChannels() > dArray.length) {
            throw new mediaLibException(11);
        }
    }

    protected void checkChannels(int[] nArray) {
        if (this.getChannels() > nArray.length) {
            throw new mediaLibException(11);
        }
    }

    protected void checkChannels(short[] sArray) {
        if (this.getChannels() > sArray.length) {
            throw new mediaLibException(11);
        }
    }

    protected void checkCompatibility(mediaLibImage mediaLibImage2) {
        if (mediaLibImage2.getType() != this.type) {
            throw new mediaLibException(4);
        }
        if (mediaLibImage2.getChannels() != this.channels) {
            throw new mediaLibException(5);
        }
    }

    protected void checkSize(mediaLibImage mediaLibImage2) {
        if (this.getWidth() != mediaLibImage2.getWidth()) {
            throw new mediaLibException(6);
        }
        if (this.getHeight() != mediaLibImage2.getHeight()) {
            throw new mediaLibException(7);
        }
    }

    protected void checkType(mediaLibImage mediaLibImage2) {
        if (mediaLibImage2.getType() != this.getType()) {
            throw new mediaLibException(4);
        }
    }

    public Object clone() {
        try {
            mediaLibImage mediaLibImage2 = (mediaLibImage)super.clone();
            switch (this.type) {
                case 0: {
                    mediaLibImage2.data = ((byte[])this.data).clone();
                    break;
                }
                case 1: {
                    mediaLibImage2.data = ((byte[])this.data).clone();
                    break;
                }
                case 2: {
                    mediaLibImage2.data = ((short[])this.data).clone();
                    break;
                }
                case 3: {
                    mediaLibImage2.data = ((int[])this.data).clone();
                    break;
                }
                case 4: {
                    mediaLibImage2.data = ((float[])this.data).clone();
                    break;
                }
                case 5: {
                    mediaLibImage2.data = ((double[])this.data).clone();
                    break;
                }
            }
            return mediaLibImage2;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString());
        }
    }

    public mediaLibImage createCompatibleImage() {
        try {
            mediaLibImage mediaLibImage2 = (mediaLibImage)super.clone();
            switch (this.type) {
                case 0: {
                    mediaLibImage2.data = new byte[((byte[])this.data).length];
                    break;
                }
                case 1: {
                    mediaLibImage2.data = new byte[((byte[])this.data).length];
                    break;
                }
                case 2: {
                    mediaLibImage2.data = new short[((short[])this.data).length];
                    break;
                }
                case 3: {
                    mediaLibImage2.data = new int[((int[])this.data).length];
                    break;
                }
                case 4: {
                    mediaLibImage2.data = new float[((float[])this.data).length];
                    break;
                }
                case 5: {
                    mediaLibImage2.data = new double[((double[])this.data).length];
                    break;
                }
            }
            return mediaLibImage2;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString());
        }
    }

    private void createImage(int n, int n2, int n3, int n4) {
        this.type = n;
        this.channels = n2;
        this.width = n3;
        this.height = n4;
        this.offset = 0;
        this.format = 0;
        this.borders[0] = 0;
        this.borders[1] = 0;
        this.borders[2] = n3;
        this.borders[3] = n4;
        if (this.channels >= 1 && this.channels <= 4) {
            this.stride = this.channels * this.width;
            switch (this.type) {
                case 0: {
                    this.depth = this.channels;
                    this.stride = (this.stride + 7) / 8;
                    this.data = new byte[this.stride * this.height];
                    break;
                }
                case 1: {
                    this.depth = this.channels * 8;
                    this.data = new byte[this.stride * this.height];
                    break;
                }
                case 2: {
                    this.depth = this.channels * 16;
                    this.data = new short[this.stride * this.height];
                    break;
                }
                case 3: {
                    this.depth = this.channels * 32;
                    this.data = new int[this.stride * this.height];
                    break;
                }
                case 4: {
                    this.depth = this.channels * 32;
                    this.data = new float[this.stride * this.height];
                    break;
                }
                case 5: {
                    this.depth = this.channels * 64;
                    this.data = new double[this.stride * this.height];
                    break;
                }
                default: {
                    System.err.println("Wrong data type.");
                    break;
                }
            }
        } else {
            System.err.println("Wrong channels.");
        }
    }

    public mediaLibImage createSubimage(int n, int n2, int n3, int n4) {
        mediaLibImage.validate(this);
        if (n3 <= 0 || n4 <= 0) {
            throw new mediaLibException(11);
        }
        if (this.type == 0) {
            n &= 0xFFFFFFF8;
        }
        if (n + n3 <= 0 || n2 + n4 <= 0 || n >= this.width || n2 >= this.height) {
            throw new mediaLibException(11);
        }
        if (n < 0) {
            n3 += n;
            n = 0;
        }
        if (n2 < 0) {
            n4 += n2;
            n2 = 0;
        }
        if (n + n3 > this.width) {
            n3 = this.width - n;
        }
        if (n2 + n4 > this.height) {
            n4 = this.height - n2;
        }
        int n5 = this.getOffset();
        n5 = this.type == 0 ? (n5 += n2 * this.stride + (n >> 3) * this.channels) : (n5 += n2 * this.stride + n * this.channels);
        return new mediaLibImage(this.getType(), this.getChannels(), n3, n4, this.getStride(), n5, this.getData());
    }

    public byte[] getBitData() {
        if (this.type == 0) {
            return (byte[])this.data;
        }
        return null;
    }

    public int[] getBorder() {
        return this.borders;
    }

    public byte[] getByteData() {
        if (this.type == 1) {
            return (byte[])this.data;
        }
        return null;
    }

    public int getChannels() {
        return this.channels;
    }

    public Object getData() {
        return this.data;
    }

    public double[] getDoubleData() {
        if (this.type == 5) {
            return (double[])this.data;
        }
        return null;
    }

    public float[] getFloatData() {
        if (this.type == 4) {
            return (float[])this.data;
        }
        return null;
    }

    public int getFormat() {
        return this.format;
    }

    public int getHeight() {
        return this.height;
    }

    public int[] getIntData() {
        if (this.type == 3) {
            return (int[])this.data;
        }
        return null;
    }

    public String getName() {
        return this.url.toString();
    }

    public int getOffset() {
        return this.offset;
    }

    public short[] getShortData() {
        if (this.type == 2) {
            return (short[])this.data;
        }
        return null;
    }

    public int getStride() {
        return this.stride;
    }

    public int getType() {
        return this.type;
    }

    public URL getURL() {
        return this.url;
    }

    public int getWidth() {
        return this.width;
    }

    public void readSunImage(File file) {
        String string = file.getAbsolutePath();
        try {
            this.url = new URL("file:" + string);
        }
        catch (MalformedURLException malformedURLException) {
            System.err.println("Malformed URL exception -> file:" + string);
            return;
        }
        this.offset = 0;
        this.readSunImage(this.url);
    }

    public void readSunImage(InputStream inputStream) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        try {
            int n = dataInputStream.readInt();
            if (n != 1504078485) {
                System.err.println("Not a Sun raster file.");
                dataInputStream.close();
                return;
            }
            this.width = dataInputStream.readInt();
            this.height = dataInputStream.readInt();
            this.depth = dataInputStream.readInt();
            this.length = dataInputStream.readInt();
            this.type = 1;
            this.channels = this.depth / 8;
            this.stride = this.channels * this.width;
            this.rttype = dataInputStream.readInt();
            if (this.rttype != 1) {
                System.err.println("Unsupported data type.");
                dataInputStream.close();
                return;
            }
            this.maptype = dataInputStream.readInt();
            this.maplength = dataInputStream.readInt();
            this.maplength /= 3;
            if (this.channels == 1 && this.maplength != 0) {
                this.format = 1;
            } else if (this.channels == 1 && this.maplength == 0) {
                this.format = 2;
            } else if (this.channels == 3) {
                this.format = 4;
            } else if (this.channels == 4) {
                this.format = 6;
            }
            byte[] byArray = new byte[this.maplength];
            byte[] byArray2 = new byte[this.maplength];
            byte[] byArray3 = new byte[this.maplength];
            dataInputStream.readFully(byArray);
            dataInputStream.readFully(byArray2);
            dataInputStream.readFully(byArray3);
            this.data = new byte[this.length];
            dataInputStream.readFully((byte[])this.data);
            System.gc();
        }
        catch (IOException iOException) {
            System.err.print("IOException when reading data from stream ");
            throw iOException;
        }
        try {
            dataInputStream.close();
        }
        catch (IOException iOException) {
            System.err.print("IOException when closing data input stream ");
            throw iOException;
        }
    }

    public void readSunImage(URL uRL) {
        InputStream inputStream;
        this.url = uRL;
        try {
            inputStream = this.url.openStream();
        }
        catch (IOException iOException) {
            System.err.println("IOException when opening Stream -> " + this.url.toString());
            return;
        }
        try {
            this.readSunImage(inputStream);
        }
        catch (IOException iOException) {
            System.err.println("-> " + this.url.toString());
        }
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            System.err.println("IOException when closing stream -> " + this.url.toString());
        }
    }

    public void setBorder(int n, int n2, int n3, int n4) {
        if (n < 0 || n > this.width || n3 < 0 || n3 > this.width || n >= n3) {
            throw new mediaLibException(11);
        }
        if (n2 < 0 || n2 > this.height || n4 < 0 || n4 > this.height || n2 >= n4) {
            throw new mediaLibException(11);
        }
        this.borders[0] = n;
        this.borders[1] = n2;
        this.borders[2] = n3;
        this.borders[3] = n4;
    }

    public void setColor(double[] dArray) {
        mediaLibImage.validate(this);
        this.checkChannels(dArray);
        if (this.getType() == 0 || this.getType() == 1 || this.getType() == 2 || this.getType() == 3) {
            throw new mediaLibException(4);
        }
        int n = this.getStride();
        int n2 = this.getOffset();
        switch (this.getType()) {
            case 4: {
                float[] fArray = this.getFloatData();
                int n3 = 0;
                while (n3 < this.height) {
                    int n4 = 0;
                    int n5 = n2;
                    while (n4 < this.width) {
                        int n6 = 0;
                        while (n6 < this.channels) {
                            fArray[n5 + n6] = (float)dArray[n6];
                            ++n6;
                        }
                        ++n4;
                        n5 += this.channels;
                    }
                    ++n3;
                    n2 += n;
                }
                break;
            }
            case 5: {
                double[] dArray2 = this.getDoubleData();
                int n7 = 0;
                while (n7 < this.height) {
                    int n8 = 0;
                    int n9 = n2;
                    while (n8 < this.width) {
                        int n10 = 0;
                        while (n10 < this.channels) {
                            dArray2[n9 + n10] = dArray[n10];
                            ++n10;
                        }
                        ++n8;
                        n9 += this.channels;
                    }
                    ++n7;
                    n2 += n;
                }
                break;
            }
        }
    }

    public void setColor(int[] nArray) {
        mediaLibImage.validate(this);
        this.checkChannels(nArray);
        if (this.getType() == 0) {
            throw new mediaLibException(4);
        }
        int n = this.getStride();
        int n2 = this.getOffset();
        switch (this.getType()) {
            case 1: {
                byte[] byArray = this.getByteData();
                int n3 = 0;
                while (n3 < this.height) {
                    int n4 = 0;
                    int n5 = n2;
                    while (n4 < this.width) {
                        int n6 = 0;
                        while (n6 < this.channels) {
                            byArray[n5 + n6] = (byte)nArray[n6];
                            ++n6;
                        }
                        ++n4;
                        n5 += this.channels;
                    }
                    ++n3;
                    n2 += n;
                }
                break;
            }
            case 2: {
                short[] sArray = this.getShortData();
                int n7 = 0;
                while (n7 < this.height) {
                    int n8 = 0;
                    int n9 = n2;
                    while (n8 < this.width) {
                        int n10 = 0;
                        while (n10 < this.channels) {
                            sArray[n9 + n10] = (short)nArray[n10];
                            ++n10;
                        }
                        ++n8;
                        n9 += this.channels;
                    }
                    ++n7;
                    n2 += n;
                }
                break;
            }
            case 3: {
                int[] nArray2 = this.getIntData();
                int n11 = 0;
                while (n11 < this.height) {
                    int n12 = 0;
                    int n13 = n2;
                    while (n12 < this.width) {
                        int n14 = 0;
                        while (n14 < this.channels) {
                            nArray2[n13 + n14] = nArray[n14];
                            ++n14;
                        }
                        ++n12;
                        n13 += this.channels;
                    }
                    ++n11;
                    n2 += n;
                }
                break;
            }
        }
    }

    public void setFormat(int n) {
        this.format = n;
    }

    private boolean testData() {
        if (this.offset < 0) {
            throw new mediaLibException(9);
        }
        int n = 0;
        int n2 = 0;
        int n3 = this.width * this.channels;
        switch (this.type) {
            case 0: {
                n = ((byte[])this.data).length;
                if (n == 0) {
                    return true;
                }
                n3 = (n3 + 7) / 8;
                break;
            }
            case 1: {
                n = ((byte[])this.data).length;
                if (n != 0) break;
                return true;
            }
            case 2: {
                n = ((short[])this.data).length;
                if (n != 0) break;
                return true;
            }
            case 3: {
                n = ((int[])this.data).length;
                if (n != 0) break;
                return true;
            }
            case 4: {
                n = ((float[])this.data).length;
                if (n != 0) break;
                return true;
            }
            case 5: {
                n = ((double[])this.data).length;
                if (n != 0) break;
                return true;
            }
        }
        n2 = n - this.offset;
        if (n2 <= 0) {
            throw new mediaLibException(9);
        }
        return n2 < (this.height - 1) * this.stride + n3;
    }

    protected void validate() {
        mediaLibImage.validate(this);
    }

    protected static void validate(mediaLibImage mediaLibImage2) {
        if (mediaLibImage2.data == null) {
            throw new NullPointerException();
        }
        if (mediaLibImage2.type != 0 && mediaLibImage2.type != 1 && mediaLibImage2.type != 2 && mediaLibImage2.type != 3 && mediaLibImage2.type != 4 && mediaLibImage2.type != 5) {
            throw new mediaLibException(4);
        }
        if (mediaLibImage2.channels < 1 || mediaLibImage2.channels > 4) {
            throw new mediaLibException(5);
        }
        if (mediaLibImage2.width <= 0) {
            throw new mediaLibException(6);
        }
        if (mediaLibImage2.height <= 0) {
            throw new mediaLibException(7);
        }
        int n = mediaLibImage2.width * mediaLibImage2.channels;
        if (mediaLibImage2.type == 0) {
            n = (n + 7) / 8;
        }
        if (mediaLibImage2.stride <= 0 || mediaLibImage2.stride < n) {
            throw new mediaLibException(8);
        }
        boolean bl = mediaLibImage2.testData();
        if (bl) {
            throw new mediaLibException(10);
        }
    }

    protected static void validate(mediaLibImage mediaLibImage2, int n) {
        mediaLibImage.validate(mediaLibImage2);
        if (mediaLibImage2.channels != 1) {
            throw new mediaLibException(5);
        }
        if (mediaLibImage2.type != n) {
            throw new mediaLibException(4);
        }
    }

    protected static void validate(mediaLibImage mediaLibImage2, mediaLibImage mediaLibImage3) {
        if (mediaLibImage2.data == null || mediaLibImage3.data == null) {
            throw new NullPointerException();
        }
        if (mediaLibImage2.type != 0 && mediaLibImage2.type != 1 && mediaLibImage2.type != 2 && mediaLibImage2.type != 3 && mediaLibImage2.type != 4 && mediaLibImage2.type != 5 || mediaLibImage3.type != 0 && mediaLibImage3.type != 1 && mediaLibImage3.type != 2 && mediaLibImage3.type != 3 && mediaLibImage3.type != 4 && mediaLibImage3.type != 5) {
            throw new mediaLibException(4);
        }
        if (mediaLibImage2.channels < 1 || mediaLibImage2.channels > 4 || mediaLibImage3.channels < 1 || mediaLibImage3.channels > 4) {
            throw new mediaLibException(5);
        }
        if (mediaLibImage2.width <= 0 || mediaLibImage3.width <= 0) {
            throw new mediaLibException(6);
        }
        if (mediaLibImage2.height <= 0 || mediaLibImage3.height <= 0) {
            throw new mediaLibException(7);
        }
        int n = mediaLibImage2.width * mediaLibImage2.channels;
        int n2 = mediaLibImage3.width * mediaLibImage3.channels;
        if (mediaLibImage2.type == 0) {
            n = (n + 7) / 8;
        }
        if (mediaLibImage3.type == 0) {
            n2 = (n2 + 7) / 8;
        }
        if (mediaLibImage2.stride <= 0 || mediaLibImage2.stride < n || mediaLibImage3.stride <= 0 || mediaLibImage3.stride < n2) {
            throw new mediaLibException(8);
        }
        boolean bl = mediaLibImage2.testData();
        boolean bl2 = mediaLibImage3.testData();
        if (bl || bl2) {
            throw new mediaLibException(10);
        }
    }

    protected static void validate(mediaLibImage mediaLibImage2, mediaLibImage mediaLibImage3, mediaLibImage mediaLibImage4) {
        if (mediaLibImage2.data == null || mediaLibImage3.data == null || mediaLibImage4.data == null) {
            throw new NullPointerException();
        }
        if (mediaLibImage2.type != 0 && mediaLibImage2.type != 1 && mediaLibImage2.type != 2 && mediaLibImage2.type != 3 || mediaLibImage3.type != 0 && mediaLibImage3.type != 1 && mediaLibImage3.type != 2 && mediaLibImage3.type != 3 || mediaLibImage4.type != 0 && mediaLibImage4.type != 1 && mediaLibImage4.type != 2 && mediaLibImage4.type != 3) {
            throw new mediaLibException(4);
        }
        if (mediaLibImage2.channels < 1 || mediaLibImage2.channels > 4 || mediaLibImage3.channels < 1 || mediaLibImage3.channels > 4 || mediaLibImage4.channels < 1 || mediaLibImage4.channels > 4) {
            throw new mediaLibException(5);
        }
        if (mediaLibImage2.width <= 0 || mediaLibImage3.width <= 0 || mediaLibImage4.width <= 0) {
            throw new mediaLibException(6);
        }
        if (mediaLibImage2.height <= 0 || mediaLibImage3.height <= 0 || mediaLibImage4.height <= 0) {
            throw new mediaLibException(7);
        }
        int n = mediaLibImage2.width * mediaLibImage2.channels;
        int n2 = mediaLibImage3.width * mediaLibImage3.channels;
        int n3 = mediaLibImage4.width * mediaLibImage4.channels;
        if (mediaLibImage2.type == 0) {
            n = (n + 7) / 8;
        }
        if (mediaLibImage3.type == 0) {
            n2 = (n2 + 7) / 8;
        }
        if (mediaLibImage4.type == 0) {
            n3 = (n3 + 7) / 8;
        }
        if (mediaLibImage2.stride <= 0 || mediaLibImage2.stride < n || mediaLibImage3.stride <= 0 || mediaLibImage3.stride < n2 || mediaLibImage4.stride <= 0 || mediaLibImage4.stride < n3) {
            throw new mediaLibException(8);
        }
        boolean bl = mediaLibImage2.testData();
        boolean bl2 = mediaLibImage3.testData();
        boolean bl3 = mediaLibImage4.testData();
        if (bl || bl2 || bl3) {
            throw new mediaLibException(10);
        }
    }

    protected static void validate(mediaLibImage mediaLibImage2, mediaLibImage mediaLibImage3, mediaLibImage mediaLibImage4, int n) {
        mediaLibImage.validate(mediaLibImage2, mediaLibImage3, mediaLibImage4);
        if (mediaLibImage2.type != 1) {
            throw new mediaLibException(4);
        }
        if (mediaLibImage2.channels < 3 || mediaLibImage3.channels < 3 || mediaLibImage4.channels < 3) {
            throw new mediaLibException(5);
        }
        if (mediaLibImage2.channels == 4 && n != 1 && n != 8) {
            throw new mediaLibException(5);
        }
    }

    protected static void validate(mediaLibImage mediaLibImage2, mediaLibImage mediaLibImage3, mediaLibImage mediaLibImage4, mediaLibImage mediaLibImage5) {
        if (mediaLibImage2.data == null || mediaLibImage3.data == null || mediaLibImage4.data == null || mediaLibImage5.data == null) {
            throw new NullPointerException();
        }
        if (mediaLibImage2.type != 0 && mediaLibImage2.type != 1 && mediaLibImage2.type != 2 && mediaLibImage2.type != 3 || mediaLibImage3.type != 0 && mediaLibImage3.type != 1 && mediaLibImage3.type != 2 && mediaLibImage3.type != 3 || mediaLibImage4.type != 0 && mediaLibImage4.type != 1 && mediaLibImage4.type != 2 && mediaLibImage4.type != 3 || mediaLibImage5.type != 0 && mediaLibImage5.type != 1 && mediaLibImage5.type != 2 && mediaLibImage5.type != 3) {
            throw new mediaLibException(4);
        }
        if (mediaLibImage2.channels < 1 || mediaLibImage2.channels > 4 || mediaLibImage3.channels < 1 || mediaLibImage3.channels > 4 || mediaLibImage4.channels < 1 || mediaLibImage4.channels > 4 || mediaLibImage5.channels < 1 || mediaLibImage5.channels > 4) {
            throw new mediaLibException(5);
        }
        if (mediaLibImage2.width <= 0 || mediaLibImage3.width <= 0 || mediaLibImage4.width <= 0 || mediaLibImage5.width <= 0) {
            throw new mediaLibException(6);
        }
        if (mediaLibImage2.height <= 0 || mediaLibImage3.height <= 0 || mediaLibImage4.height <= 0 || mediaLibImage5.height <= 0) {
            throw new mediaLibException(7);
        }
        int n = mediaLibImage2.width * mediaLibImage2.channels;
        int n2 = mediaLibImage3.width * mediaLibImage3.channels;
        int n3 = mediaLibImage4.width * mediaLibImage4.channels;
        int n4 = mediaLibImage5.width * mediaLibImage5.channels;
        if (mediaLibImage2.type == 0) {
            n = (n + 7) / 8;
        }
        if (mediaLibImage3.type == 0) {
            n2 = (n2 + 7) / 8;
        }
        if (mediaLibImage4.type == 0) {
            n3 = (n3 + 7) / 8;
        }
        if (mediaLibImage5.type == 0) {
            n4 = (n4 + 7) / 8;
        }
        if (mediaLibImage2.stride <= 0 || mediaLibImage2.stride < n || mediaLibImage3.stride <= 0 || mediaLibImage3.stride < n2 || mediaLibImage4.stride <= 0 || mediaLibImage4.stride < n3 || mediaLibImage5.stride <= 0 || mediaLibImage5.stride < n4) {
            throw new mediaLibException(8);
        }
        boolean bl = mediaLibImage2.testData();
        boolean bl2 = mediaLibImage3.testData();
        boolean bl3 = mediaLibImage4.testData();
        boolean bl4 = mediaLibImage5.testData();
        if (bl || bl2 || bl3 || bl4) {
            throw new mediaLibException(10);
        }
    }

    protected static void validate_Fp(mediaLibImage mediaLibImage2) {
        if (mediaLibImage2.data == null) {
            throw new NullPointerException();
        }
        if (mediaLibImage2.type != 4 && mediaLibImage2.type != 5) {
            throw new mediaLibException(4);
        }
        if (mediaLibImage2.channels < 1 || mediaLibImage2.channels > 4) {
            throw new mediaLibException(5);
        }
        if (mediaLibImage2.width <= 0) {
            throw new mediaLibException(6);
        }
        if (mediaLibImage2.height <= 0) {
            throw new mediaLibException(7);
        }
        int n = mediaLibImage2.width * mediaLibImage2.channels;
        if (mediaLibImage2.stride <= 0 || mediaLibImage2.stride < n) {
            throw new mediaLibException(8);
        }
        boolean bl = mediaLibImage2.testData();
        if (bl) {
            throw new mediaLibException(10);
        }
    }

    protected static void validate_Fp(mediaLibImage mediaLibImage2, mediaLibImage mediaLibImage3) {
        if (mediaLibImage2.data == null || mediaLibImage3.data == null) {
            throw new NullPointerException();
        }
        if (mediaLibImage2.type != 4 && mediaLibImage2.type != 5 || mediaLibImage3.type != 4 && mediaLibImage3.type != 5) {
            throw new mediaLibException(4);
        }
        if (mediaLibImage2.channels < 1 || mediaLibImage2.channels > 4 || mediaLibImage3.channels < 1 || mediaLibImage3.channels > 4) {
            throw new mediaLibException(5);
        }
        if (mediaLibImage2.width <= 0 || mediaLibImage3.width <= 0) {
            throw new mediaLibException(6);
        }
        if (mediaLibImage2.height <= 0 || mediaLibImage3.height <= 0) {
            throw new mediaLibException(7);
        }
        int n = mediaLibImage2.width * mediaLibImage2.channels;
        int n2 = mediaLibImage3.width * mediaLibImage3.channels;
        if (mediaLibImage2.stride <= 0 || mediaLibImage2.stride < n || mediaLibImage3.stride <= 0 || mediaLibImage3.stride < n2) {
            throw new mediaLibException(8);
        }
        boolean bl = mediaLibImage2.testData();
        boolean bl2 = mediaLibImage3.testData();
        if (bl || bl2) {
            throw new mediaLibException(10);
        }
    }

    protected static void validate_Fp(mediaLibImage mediaLibImage2, mediaLibImage mediaLibImage3, mediaLibImage mediaLibImage4) {
        if (mediaLibImage2.data == null || mediaLibImage3.data == null || mediaLibImage4.data == null) {
            throw new NullPointerException();
        }
        if (mediaLibImage2.type != 4 && mediaLibImage2.type != 5 || mediaLibImage3.type != 4 && mediaLibImage3.type != 5 || mediaLibImage4.type != 4 && mediaLibImage4.type != 5) {
            throw new mediaLibException(4);
        }
        if (mediaLibImage2.channels < 1 || mediaLibImage2.channels > 4 || mediaLibImage3.channels < 1 || mediaLibImage3.channels > 4 || mediaLibImage4.channels < 1 || mediaLibImage4.channels > 4) {
            throw new mediaLibException(5);
        }
        if (mediaLibImage2.width <= 0 || mediaLibImage3.width <= 0 || mediaLibImage4.width <= 0) {
            throw new mediaLibException(6);
        }
        if (mediaLibImage2.height <= 0 || mediaLibImage3.height <= 0 || mediaLibImage4.height <= 0) {
            throw new mediaLibException(7);
        }
        int n = mediaLibImage2.width * mediaLibImage2.channels;
        int n2 = mediaLibImage3.width * mediaLibImage3.channels;
        int n3 = mediaLibImage4.width * mediaLibImage4.channels;
        if (mediaLibImage2.stride <= 0 || mediaLibImage2.stride < n || mediaLibImage3.stride <= 0 || mediaLibImage3.stride < n2 || mediaLibImage4.stride <= 0 || mediaLibImage4.stride < n3) {
            throw new mediaLibException(8);
        }
        boolean bl = mediaLibImage2.testData();
        boolean bl2 = mediaLibImage3.testData();
        boolean bl3 = mediaLibImage4.testData();
        if (bl || bl2 || bl3) {
            throw new mediaLibException(10);
        }
    }

    public void writeSunImage(File file) throws mediaLibException {
        FileOutputStream fileOutputStream;
        if (file.exists() && !file.canWrite()) {
            System.err.println("Current execution context is not allowed to write to file ->" + file.getAbsolutePath());
            return;
        }
        try {
            fileOutputStream = new FileOutputStream(file);
        }
        catch (IOException iOException) {
            System.err.println("IOException while opening file output stream ->" + file.getAbsolutePath());
            return;
        }
        try {
            this.writeSunImage(fileOutputStream);
        }
        catch (IOException iOException) {
            System.err.println("-> " + file.getAbsolutePath());
        }
        catch (mediaLibException mediaLibException2) {
            throw mediaLibException2;
        }
        try {
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            System.err.println("IOException while closing file output stream ->" + file.getAbsolutePath());
            return;
        }
    }

    public void writeSunImage(File file, mediaLibImageColormap mediaLibImageColormap2) throws mediaLibException {
        FileOutputStream fileOutputStream;
        if (file.exists() && !file.canWrite()) {
            System.err.println("Current execution context is not allowed to write to file ->" + file.getAbsolutePath());
            return;
        }
        try {
            fileOutputStream = new FileOutputStream(file);
        }
        catch (IOException iOException) {
            System.err.println("IOException while opening file output stream ->" + file.getAbsolutePath());
            return;
        }
        try {
            this.writeSunImage(fileOutputStream, mediaLibImageColormap2);
        }
        catch (IOException iOException) {
            System.err.println("-> " + file.getAbsolutePath());
        }
        catch (mediaLibException mediaLibException2) {
            throw mediaLibException2;
        }
        try {
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            System.err.println("IOException while closing file output stream ->" + file.getAbsolutePath());
            return;
        }
    }

    public void writeSunImage(OutputStream outputStream) throws IOException, mediaLibException {
        if (this.type != 1) {
            throw new mediaLibException(4);
        }
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        try {
            dataOutputStream.writeInt(1504078485);
            dataOutputStream.writeInt(this.width);
            dataOutputStream.writeInt(this.height);
            dataOutputStream.writeInt(this.channels * 8);
            dataOutputStream.writeInt(this.width * this.channels * this.height);
            dataOutputStream.writeInt(1);
            dataOutputStream.writeInt(0);
            dataOutputStream.writeInt(0);
            byte[] byArray = new byte[this.width * this.channels];
            byte[] byArray2 = this.getByteData();
            int n = this.offset;
            int n2 = 0;
            while (n2 < this.height) {
                int n3 = 0;
                while (n3 < this.width * this.channels) {
                    byArray[n3] = byArray2[n + n3];
                    ++n3;
                }
                n += this.stride;
                dataOutputStream.write(byArray, 0, this.width * this.channels);
                ++n2;
            }
            System.gc();
        }
        catch (IOException iOException) {
            System.err.print("IOException when writing data to stream ");
            throw iOException;
        }
        try {
            dataOutputStream.close();
        }
        catch (IOException iOException) {
            System.err.print("IOException when closing data output stream ");
            throw iOException;
        }
    }

    public void writeSunImage(OutputStream outputStream, mediaLibImageColormap mediaLibImageColormap2) throws IOException, mediaLibException {
        if (this.type != 1) {
            throw new mediaLibException(4);
        }
        if (mediaLibImageColormap2.getInType() != 1 || mediaLibImageColormap2.getOutType() != 1) {
            throw new mediaLibException(12);
        }
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        try {
            dataOutputStream.writeInt(1504078485);
            dataOutputStream.writeInt(this.width);
            dataOutputStream.writeInt(this.height);
            dataOutputStream.writeInt(this.channels * 8);
            dataOutputStream.writeInt(this.width * this.channels * this.height);
            dataOutputStream.writeInt(1);
            dataOutputStream.writeInt(1);
            dataOutputStream.writeInt(this.maplength * 3);
            dataOutputStream.write((byte[])mediaLibImageColormap2.getRedMap(), 0, mediaLibImageColormap2.getLength());
            dataOutputStream.write((byte[])mediaLibImageColormap2.getGreenMap(), 0, mediaLibImageColormap2.getLength());
            dataOutputStream.write((byte[])mediaLibImageColormap2.getBlueMap(), 0, mediaLibImageColormap2.getLength());
            byte[] byArray = new byte[this.width * this.channels];
            byte[] byArray2 = this.getByteData();
            int n = this.offset;
            int n2 = 0;
            while (n2 < this.height) {
                int n3 = 0;
                while (n3 < this.width * this.channels) {
                    byArray[n3] = byArray2[n + n3];
                    ++n3;
                }
                n += this.stride;
                dataOutputStream.write(byArray, 0, this.width * this.channels);
                ++n2;
            }
            System.gc();
        }
        catch (IOException iOException) {
            System.err.print("IOException when writing data to stream ");
            throw iOException;
        }
        try {
            dataOutputStream.close();
        }
        catch (IOException iOException) {
            System.err.print("IOException when closing data output stream ");
            throw iOException;
        }
    }

    public void writeSunImage(URL uRL) throws mediaLibException {
        String string = uRL.getFile();
        File file = new File(string);
        this.writeSunImage(file);
    }

    public void writeSunImage(URL uRL, mediaLibImageColormap mediaLibImageColormap2) throws mediaLibException {
        String string = uRL.getFile();
        File file = new File(string);
        this.writeSunImage(file, mediaLibImageColormap2);
    }
}

