/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.gdevice;

import com.insightful.gdevice.SCanvasAWT;
import com.insightful.gdevice.SCanvasRectangle;
import com.insightful.gdevice.SFactoryAWT;
import com.insightful.gdevice.SGraphCommand;
import com.insightful.gdevice.SGui;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.io.InputStream;
import java.net.URL;

public class SApplet
extends Applet {
    static final String SPJ_FILE_PARAMETER = "spjgraph.filename";
    static final String SPJ_DEFAULT_FILENAME = "graph.spj";
    static final String SPJ_GRAPHICS2D_PARAMETER = "spjgraph.graphics.2d";
    protected SGui m_gui = null;
    public static final int BORDER_SIZE = 4;
    private static final String m_initVersionString = "1.3";
    private static final String m_versionDateResourceFile = "graphlet.build.date";
    private static String m_versionString = null;

    public void init() {
        boolean bl;
        Object object;
        Object object2;
        Object object3;
        System.out.println("S-PLUS Graphlet version " + this.getGraphletVersionString());
        this.setGraphics2DFlag();
        this.setLayout(new BorderLayout());
        this.m_gui = new SGui(this);
        this.add("Center", this.m_gui);
        if (!this.m_gui.propGraphOnly()) {
            object3 = new Canvas();
            ((Component)object3).setBackground(Color.black);
            ((Component)object3).setSize(4, 4);
            this.add("North", (Component)object3);
            Canvas canvas = new Canvas();
            canvas.setBackground(Color.black);
            canvas.setSize(4, 4);
            this.add("West", canvas);
            object2 = new Canvas();
            ((Component)object2).setBackground(Color.black);
            ((Component)object2).setSize(4, 4);
            this.add("East", (Component)object2);
            object = new Canvas();
            ((Component)object).setBackground(Color.black);
            ((Component)object).setSize(4, 4);
            this.add("South", (Component)object);
        }
        this.setVisible(true);
        object3 = this.getParameter(SPJ_FILE_PARAMETER);
        boolean bl2 = bl = object3 == null || ((String)object3).length() == 0;
        if (bl) {
            object3 = SPJ_DEFAULT_FILENAME;
        }
        if ((object2 = this.openGraphStream((String)object3)) == null) {
            object = bl ? "Applet parameter spjgraph.filename not given; can't open graph.spj" : "Can't open SPJ file: " + (String)object3;
            System.out.println((String)object);
            this.m_gui.addCanvas(SCanvasAWT.createErrorCanvas((String)object));
        } else {
            this.m_gui.loadInputStream((InputStream)object2);
            if (this.m_gui.getTabCount() < 1) {
                this.m_gui.addCanvas(SCanvasAWT.createErrorCanvas("SPJ File " + (String)object3 + " is empty"));
            }
        }
    }

    protected void setGraphics2DFlag() {
        String string;
        boolean bl;
        block10: {
            bl = false;
            string = "";
            try {
                String string2 = this.getParameter(SPJ_GRAPHICS2D_PARAMETER);
                if (string2 == null) {
                    Class<?> clazz = null;
                    Class<?> clazz2 = null;
                    try {
                        clazz = Class.forName("java.awt.Graphics2D");
                        clazz2 = Class.forName("java.awt.print.PrinterJob");
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (clazz == null) {
                        string = "Graphics2D not found";
                        bl = false;
                    } else if (clazz2 == null) {
                        string = "PrinterJob not found";
                        bl = false;
                    } else {
                        string = "Graphics2D and PrinterJob found";
                        bl = true;
                    }
                    break block10;
                }
                string = "spjgraph.graphics.2d=" + string2;
                bl = string2.equalsIgnoreCase("YES") || string2.equalsIgnoreCase("ON") || string2.equalsIgnoreCase("Y") || string2.equalsIgnoreCase("T") || string2.equalsIgnoreCase("TRUE");
            }
            catch (Throwable throwable) {
                string = "error: " + throwable;
                bl = false;
            }
        }
        string = string != null && string.length() > 0 ? " (" + string + ")" : "";
        System.out.println("Setting Graphics2D flag to " + (bl ? "true" : "false") + string);
        if (!bl) {
            SGraphCommand.setFactory(new SFactoryAWT());
        }
    }

    protected InputStream openGraphStream(String string) {
        InputStream inputStream = null;
        URL uRL = null;
        try {
            uRL = new URL(this.getCodeBase(), string);
            inputStream = uRL.openConnection().getInputStream();
            System.out.println("opened url as stream: " + uRL);
            return inputStream;
        }
        catch (Exception exception) {
            System.out.println(exception);
            try {
                uRL = new URL(this.getDocumentBase(), string);
                inputStream = uRL.openConnection().getInputStream();
                System.out.println("opened url as stream: " + uRL);
                return inputStream;
            }
            catch (Exception exception2) {
                System.out.println(exception2);
                try {
                    inputStream = this.getClass().getResourceAsStream(string);
                    System.out.println("opened resource as stream: " + string);
                    return inputStream;
                }
                catch (Exception exception3) {
                    System.out.println(exception3);
                    return null;
                }
            }
        }
    }

    public String getGraphletVersionString() {
        if (m_versionString == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(m_initVersionString);
            stringBuffer.append(" (");
            try {
                int n;
                InputStream inputStream = this.getClass().getResourceAsStream(m_versionDateResourceFile);
                while ((n = inputStream.read()) >= 0) {
                    char c = (char)n;
                    if (c == '\n' || c == '\t' || c == '\r') continue;
                    stringBuffer.append(c);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            stringBuffer.append(")");
            m_versionString = stringBuffer.toString();
        }
        return m_versionString;
    }

    public String getSelectedTags() {
        String[] stringArray = this.m_gui.getSelectedTags();
        String string = this.formatTagString(stringArray);
        return string;
    }

    public void setSelectedTags(String string) {
        String[] stringArray = this.parseTagString(string);
        this.m_gui.setSelectedTags(stringArray);
    }

    public String getCurrentPageTag() {
        return this.m_gui.getCurrentPageTagName();
    }

    public String getCurrentPageTagName() {
        return this.m_gui.getCurrentPageTagName();
    }

    public int getCurrentPageNumber() {
        return this.m_gui.getCurrentPageNumber();
    }

    public int getNumberPages() {
        return this.m_gui.getNumberPages();
    }

    public void setCurrentPageByTag(String string) {
        this.m_gui.setCurrentPageByTagName(string);
    }

    public void setCurrentPageByTagName(String string) {
        this.m_gui.setCurrentPageByTagName(string);
    }

    public void setCurrentPageByNumber(int n) {
        this.m_gui.setCurrentPageByNumber(n);
    }

    public void setCurrentPageBack() {
        this.m_gui.setCurrentPageBack();
    }

    public void setCurrentPageForward() {
        this.m_gui.setCurrentPageForward();
    }

    public int getPageWithTagName(String string) {
        return this.m_gui.getPageWithTagName(string) + 1;
    }

    public String getPageTagName(int n) {
        String string = n < 1 || n > this.getNumberPages() ? null : this.m_gui.getPageTagName(n - 1);
        return string == null ? "" : string;
    }

    public String getPageTag(int n) {
        String string = n < 1 || n > this.getNumberPages() ? null : this.m_gui.getPageTag(n - 1);
        return string == null ? "" : string;
    }

    public String getPageTitle(int n) {
        String string = n < 1 || n > this.getNumberPages() ? null : this.m_gui.getPageTitle(n - 1);
        return string == null ? "" : string;
    }

    public void setPageTag(int n, String string) {
        if (n >= 1 && n <= this.getNumberPages()) {
            this.m_gui.setPageTag(n - 1, string);
        }
    }

    public void setPageTitle(int n, String string) {
        if (n >= 1 && n <= this.getNumberPages()) {
            this.m_gui.setPageTitle(n - 1, string);
        }
    }

    public void removePage(int n) {
        this.m_gui.removePage(n - 1);
    }

    public void removeAllPages() {
        this.m_gui.removeAllPages();
    }

    public void insertPage(int n) {
        if (n < 1) {
            n = 1;
        } else if (n > this.getNumberPages()) {
            n = this.getNumberPages() + 1;
        }
        this.m_gui.insertPage(n - 1);
    }

    public void addPage() {
        this.m_gui.addPage();
    }

    public void clearSelectedTags() {
        this.m_gui.clearSelectedTags();
    }

    public void addSelectedTag(String string) {
        this.m_gui.addSelectedTag(string);
    }

    public void removeSelectedTag(String string) {
        this.m_gui.removeSelectedTag(string);
    }

    public void toggleSelectedTag(String string) {
        this.m_gui.toggleSelectedTag(string);
    }

    public boolean isSelectedTag(String string) {
        return this.m_gui.isSelectedTag(string);
    }

    public String getSelectionRect() {
        SCanvasRectangle sCanvasRectangle = this.m_gui.getSelectionRect();
        String string = this.formatRectString(sCanvasRectangle);
        return string;
    }

    public void setSelectionRect(String string) {
        SCanvasRectangle sCanvasRectangle = this.parseRectString(string);
        this.m_gui.setSelectionRect(sCanvasRectangle);
    }

    public double getZoom() {
        return this.m_gui.getZoom();
    }

    public void setZoom(double d) {
        this.m_gui.setZoom(d);
    }

    public void setZoomToRect(String string) {
        SCanvasRectangle sCanvasRectangle = this.parseRectString(string);
        this.m_gui.setZoomToRect(sCanvasRectangle);
    }

    public void setZoomToSelectionRect() {
        SCanvasRectangle sCanvasRectangle = this.m_gui.getSelectionRect();
        this.m_gui.setZoomToRect(sCanvasRectangle);
    }

    public String getSelectionRectTags() {
        SCanvasRectangle sCanvasRectangle = this.m_gui.getSelectionRect();
        String[] stringArray = this.m_gui.getTagsInRect(sCanvasRectangle);
        String string = this.formatTagString(stringArray);
        return string;
    }

    public String getRectTags(String string) {
        SCanvasRectangle sCanvasRectangle = this.parseRectString(string);
        String[] stringArray = this.m_gui.getTagsInRect(sCanvasRectangle);
        String string2 = this.formatTagString(stringArray);
        return string2;
    }

    public String getSelectionRectKeys() {
        boolean bl = this.m_gui.getSelectionRectShiftDown();
        boolean bl2 = this.m_gui.getSelectionRectControlDown();
        if (bl) {
            if (bl2) {
                return "shift,control";
            }
            return "shift";
        }
        if (bl2) {
            return "control";
        }
        return "";
    }

    public void setSelectionRectKeys(String string) {
        string = string == null ? "" : string.toLowerCase();
        this.m_gui.setSelectionRectShiftDown(string.indexOf("shift") >= 0);
        this.m_gui.setSelectionRectControlDown(string.indexOf("control") >= 0);
    }

    public void selectTagsFromSelectionRect() {
        this.m_gui.selectTagsFromSelectionRect();
    }

    public void showOptionsDialog() {
        this.m_gui.showOptions();
    }

    public void setOption(String string, String string2) {
        boolean bl;
        boolean bl2;
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        boolean bl3 = bl2 = (bl = string2.equalsIgnoreCase("true")) || string2.equalsIgnoreCase("false");
        if (bl2) {
            if (string.equalsIgnoreCase("displayMousePosition")) {
                this.m_gui.setOptionDisplayMousePosition(bl);
            } else if (string.equalsIgnoreCase("enableActiveRegions")) {
                this.m_gui.setOptionEnableActiveRegions(bl);
            } else if (string.equalsIgnoreCase("displayPageTabs")) {
                this.m_gui.setOptionDisplayPageTabs(bl);
            } else if (string.equalsIgnoreCase("printSelectedRegions")) {
                this.m_gui.setOptionPrintSelectedRegions(bl);
            }
        } else if (string.equalsIgnoreCase("mousePositionDigits")) {
            try {
                this.m_gui.setOptionMousePositionDigits(Integer.parseInt(string2));
            }
            catch (Exception exception) {}
        } else if (string.equalsIgnoreCase("printPage")) {
            if (string2.equalsIgnoreCase("view")) {
                this.m_gui.setOptionPrintUnzoomedPage(false);
                this.m_gui.setOptionPrintMultiplePages(false);
            } else if (string2.equalsIgnoreCase("one")) {
                this.m_gui.setOptionPrintUnzoomedPage(true);
                this.m_gui.setOptionPrintMultiplePages(false);
            } else if (string2.equalsIgnoreCase("all")) {
                this.m_gui.setOptionPrintUnzoomedPage(true);
                this.m_gui.setOptionPrintMultiplePages(true);
            }
        }
    }

    public String getOption(String string) {
        if (string == null) {
            string = "";
        }
        if (string.equalsIgnoreCase("displayMousePosition")) {
            return this.m_gui.getOptionDisplayMousePosition() ? "true" : "false";
        }
        if (string.equalsIgnoreCase("mousePositionDigits")) {
            return Integer.toString(this.m_gui.getOptionMousePositionDigits());
        }
        if (string.equalsIgnoreCase("enableActiveRegions")) {
            return this.m_gui.getOptionEnableActiveRegions() ? "true" : "false";
        }
        if (string.equalsIgnoreCase("displayPageTabs")) {
            return this.m_gui.getOptionDisplayPageTabs() ? "true" : "false";
        }
        if (string.equalsIgnoreCase("printSelectedRegions")) {
            return this.m_gui.getOptionPrintSelectedRegions() ? "true" : "false";
        }
        if (string.equalsIgnoreCase("printPage")) {
            boolean bl = this.m_gui.getOptionPrintUnzoomedPage();
            boolean bl2 = this.m_gui.getOptionPrintMultiplePages();
            if (bl2) {
                return "all";
            }
            if (bl) {
                return "one";
            }
            return "view";
        }
        return null;
    }

    public void showPrintDialog() {
        this.m_gui.printAction();
    }

    public void showHelpDialog() {
        this.m_gui.showHelp();
    }

    private SCanvasRectangle parseRectString(String string) {
        double d;
        if (string == null) {
            return null;
        }
        double[] dArray = new double[4];
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            int n2 = string.indexOf(",", n);
            String string2 = null;
            if (n2 < 0) {
                string2 = string.substring(n);
                n = string.length();
            } else {
                string2 = string.substring(n, n2);
                n = n2 + 1;
            }
            try {
                dArray[i] = Double.valueOf(string2);
                continue;
            }
            catch (Exception exception) {
                return null;
            }
        }
        double d2 = Math.max(0.0, Math.min(1.0, dArray[0]));
        double d3 = Math.max(0.0, Math.min(1.0, dArray[1]));
        double d4 = 1.0 - Math.max(0.0, Math.min(1.0, dArray[2]));
        double d5 = 1.0 - Math.max(0.0, Math.min(1.0, dArray[3]));
        if (d2 > d3) {
            d = d2;
            d2 = d3;
            d3 = d;
        }
        if (d4 > d5) {
            d = d4;
            d4 = d5;
            d5 = d;
        }
        SCanvasRectangle sCanvasRectangle = new SCanvasRectangle((float)d2, (float)d4, (float)(d3 - d2), (float)(d5 - d4));
        return sCanvasRectangle;
    }

    private String formatRectString(SCanvasRectangle sCanvasRectangle) {
        if (sCanvasRectangle == null) {
            return "0,0,1,1";
        }
        float f = sCanvasRectangle.minX() < 0.0f ? 0.0f : sCanvasRectangle.minX();
        float f2 = sCanvasRectangle.maxX() > 1.0f ? 1.0f : sCanvasRectangle.maxX();
        float f3 = 1.0f - (sCanvasRectangle.maxY() > 1.0f ? 1.0f : sCanvasRectangle.maxY());
        float f4 = 1.0f - (sCanvasRectangle.minY() < 0.0f ? 0.0f : sCanvasRectangle.minY());
        return "" + f + "," + f2 + "," + f3 + "," + f4;
    }

    private String formatTagString(String[] stringArray) {
        if (stringArray == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(stringArray[i]);
        }
        return stringBuffer.toString();
    }

    private String[] parseTagString(String string) {
        if (string == null || string.equals("")) {
            return new String[0];
        }
        int n = 0;
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            if (string.charAt(i) != ',') continue;
            ++n;
        }
        String[] stringArray = new String[n + 1];
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            if (string.charAt(i) != ',') continue;
            stringArray[n3++] = string.substring(n4, i);
            n4 = i + 1;
        }
        stringArray[n3++] = string.substring(n4);
        return stringArray;
    }
}

