/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.ui.text;

import java.util.ArrayList;
import java.util.regex.PatternSyntaxException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.fieldassist.ComboContentAdapter;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.text.FindReplaceDocumentAdapterContentProposalProvider;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.search.internal.core.text.PatternConstructor;
import org.eclipse.search.internal.ui.Messages;
import org.eclipse.search.internal.ui.SearchMessages;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.search.internal.ui.text.FileSearchQuery;
import org.eclipse.search.internal.ui.text.ReplaceRefactoring;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.fieldassist.ContentAssistCommandAdapter;

public class ReplaceConfigurationPage
extends UserInputWizardPage {
    private static final String SETTINGS_GROUP = "ReplaceDialog2";
    private static final String SETTINGS_REPLACE_WITH = "replace_with";
    private final ReplaceRefactoring fReplaceRefactoring;
    private Combo fTextField;
    private Button fReplaceWithRegex;
    private Label fStatusLabel;
    private ContentAssistCommandAdapter fTextFieldContentAssist;

    public ReplaceConfigurationPage(ReplaceRefactoring refactoring) {
        super("ReplaceConfigurationPage");
        this.fReplaceRefactoring = refactoring;
    }

    public void createControl(Composite parent) {
        String[] previousReplaceWith;
        Composite result = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        result.setLayout((Layout)layout);
        Label description = new Label(result, 0);
        int numberOfMatches = this.fReplaceRefactoring.getNumberOfMatches();
        int numberOfFiles = this.fReplaceRefactoring.getNumberOfFiles();
        Object[] arguments = new String[]{String.valueOf(numberOfMatches), String.valueOf(numberOfFiles)};
        if (numberOfMatches > 1 && numberOfFiles > 1) {
            description.setText(Messages.format(SearchMessages.ReplaceConfigurationPage_description_many_in_many, arguments));
        } else if (numberOfMatches == 1) {
            description.setText(SearchMessages.ReplaceConfigurationPage_description_one_in_one);
        } else {
            description.setText(Messages.format(SearchMessages.ReplaceConfigurationPage_description_many_in_one, arguments));
        }
        description.setLayoutData((Object)new GridData(1, 2, false, false, 2, 1));
        FileSearchQuery query = this.fReplaceRefactoring.getQuery();
        Label label1 = new Label(result, 0);
        label1.setText(SearchMessages.ReplaceConfigurationPage_replace_label);
        Text clabel = new Text(result, 2056);
        clabel.setText(query.getSearchString());
        GridData gd = new GridData(768);
        gd.widthHint = this.convertWidthInCharsToPixels(50);
        clabel.setLayoutData((Object)gd);
        Label label2 = new Label(result, 0);
        label2.setText(SearchMessages.ReplaceConfigurationPage_with_label);
        this.fTextField = new Combo(result, 4);
        gd = new GridData(768);
        gd.widthHint = this.convertWidthInCharsToPixels(50);
        this.fTextField.setLayoutData((Object)gd);
        this.fTextField.setFocus();
        this.fTextField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ReplaceConfigurationPage.this.updateOKStatus();
            }
        });
        IDialogSettings settings = SearchPlugin.getDefault().getDialogSettings().getSection(SETTINGS_GROUP);
        if (settings != null && (previousReplaceWith = settings.getArray(SETTINGS_REPLACE_WITH)) != null) {
            this.fTextField.setItems(previousReplaceWith);
            this.fTextField.select(0);
        }
        ComboContentAdapter contentAdapter = new ComboContentAdapter();
        FindReplaceDocumentAdapterContentProposalProvider replaceProposer = new FindReplaceDocumentAdapterContentProposalProvider(false);
        this.fTextFieldContentAssist = new ContentAssistCommandAdapter((Control)this.fTextField, (IControlContentAdapter)contentAdapter, (IContentProposalProvider)replaceProposer, "org.eclipse.ui.edit.text.contentAssist.proposals", new char[]{'$', '\\'}, true);
        new Label(result, 0);
        this.fReplaceWithRegex = new Button(result, 32);
        this.fReplaceWithRegex.setText(SearchMessages.ReplaceConfigurationPage_isRegex_label);
        this.fReplaceWithRegex.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReplaceConfigurationPage.this.setContentAssistsEnablement(ReplaceConfigurationPage.this.fReplaceWithRegex.getSelection());
            }
        });
        if (query.isRegexSearch()) {
            this.fReplaceWithRegex.setSelection(true);
        } else {
            this.fReplaceWithRegex.setSelection(false);
            this.fReplaceWithRegex.setEnabled(false);
        }
        this.fStatusLabel = new Label(result, 0);
        gd = new GridData(768);
        gd.verticalAlignment = 1024;
        gd.horizontalSpan = 2;
        this.fStatusLabel.setLayoutData((Object)gd);
        this.setContentAssistsEnablement(this.fReplaceWithRegex.getSelection());
        this.setControl((Control)result);
        Dialog.applyDialogFont((Control)result);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.search.replace_dialog_context");
    }

    /*
     * Unable to fully structure code
     */
    final void updateOKStatus() {
        block4: {
            status = new RefactoringStatus();
            if (this.fReplaceWithRegex != null && this.fReplaceWithRegex.getSelection()) {
                try {
                    PatternConstructor.interpretReplaceEscapes(this.fReplaceWithRegex.getText(), this.fReplaceRefactoring.getQuery().getSearchString(), "\n");
                    break block4;
                }
                catch (PatternSyntaxException e) {
                    locMessage = e.getLocalizedMessage();
                    i = 0;
                    ** while (i < locMessage.length() && "\n\r".indexOf((int)locMessage.charAt((int)i)) == -1)
                }
lbl-1000:
                // 1 sources

                {
                    ++i;
                    continue;
                }
lbl13:
                // 1 sources

                status.addError(locMessage.substring(0, i));
            }
        }
        this.setPageComplete(status);
    }

    private void setContentAssistsEnablement(boolean enable) {
        this.fTextFieldContentAssist.setEnabled(enable);
    }

    protected boolean performFinish() {
        this.initializeRefactoring();
        this.storeSettings();
        return super.performFinish();
    }

    public IWizardPage getNextPage() {
        this.initializeRefactoring();
        this.storeSettings();
        return super.getNextPage();
    }

    private void storeSettings() {
        String[] items = this.fTextField.getItems();
        ArrayList<String> history = new ArrayList<String>();
        history.add(this.fTextField.getText());
        int historySize = Math.min(items.length, 6);
        int i = 0;
        while (i < historySize) {
            String curr = items[i];
            if (!history.contains(curr)) {
                history.add(curr);
            }
            ++i;
        }
        IDialogSettings settings = SearchPlugin.getDefault().getDialogSettings().addNewSection(SETTINGS_GROUP);
        settings.put(SETTINGS_REPLACE_WITH, history.toArray(new String[history.size()]));
    }

    private void initializeRefactoring() {
        this.fReplaceRefactoring.setReplaceString(this.fTextField.getText());
    }
}

