/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splusserver.security;

import com.insightful.splusserver.api.CommonApi;
import com.insightful.splusserver.exception.api.ApiException;
import com.insightful.splusserver.security.UserDetails;
import java.util.ArrayList;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.AuthenticationServiceException;
import org.acegisecurity.BadCredentialsException;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.acegisecurity.providers.dao.AbstractUserDetailsAuthenticationProvider;
import org.acegisecurity.providers.dao.SaltSource;
import org.acegisecurity.providers.encoding.PasswordEncoder;
import org.acegisecurity.providers.encoding.PlaintextPasswordEncoder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;

public abstract class DaoAuthenticationProvider
extends AbstractUserDetailsAuthenticationProvider {
    private PasswordEncoder passwordEncoder = new PlaintextPasswordEncoder();
    private SaltSource saltSource;
    private boolean includeDetailsObject = true;
    private Log mLog = LogFactory.getLog(DaoAuthenticationProvider.class);

    protected void additionalAuthenticationChecks(org.acegisecurity.userdetails.UserDetails userDetails, UsernamePasswordAuthenticationToken authentication) throws AuthenticationException {
        Object salt = null;
        if (this.saltSource != null) {
            salt = this.saltSource.getSalt(userDetails);
        }
        if (!this.passwordEncoder.isPasswordValid(userDetails.getPassword(), authentication.getCredentials().toString(), salt)) {
            throw new BadCredentialsException(this.messages.getMessage("AbstractUserDetailsAuthenticationProvider.badCredentials", "Bad credentials"), this.includeDetailsObject ? userDetails : null);
        }
    }

    public PasswordEncoder getPasswordEncoder() {
        return this.passwordEncoder;
    }

    public SaltSource getSaltSource() {
        return this.saltSource;
    }

    protected final org.acegisecurity.userdetails.UserDetails retrieveUser(String username, UsernamePasswordAuthenticationToken authentication) throws AuthenticationException {
        UserDetails loadedUser;
        try {
            GrantedAuthority[] authorities;
            String password = authentication.getCredentials().toString();
            CommonApi api = this.getApi();
            api.setUserName(username);
            api.setPassword(password);
            if (api.validateUserCredentials().booleanValue()) {
                ArrayList<String> activeRoles = new ArrayList<String>();
                String BUSINESS_USER = "BU";
                if (!activeRoles.contains(BUSINESS_USER)) {
                    activeRoles.add(BUSINESS_USER);
                }
                authorities = new GrantedAuthority[activeRoles.size()];
                int i = 0;
                for (String role : activeRoles) {
                    authorities[i++] = new GrantedAuthorityImpl("ROLE_" + role);
                }
            } else {
                throw new BadCredentialsException("User not authenticated");
            }
            loadedUser = new UserDetails(username, password, Boolean.TRUE, Boolean.TRUE, Boolean.TRUE, Boolean.TRUE, authorities);
        }
        catch (DataAccessException repositoryProblem) {
            throw new AuthenticationServiceException(repositoryProblem.getMessage(), (Throwable)repositoryProblem);
        }
        catch (ApiException e) {
            throw new DataAccessResourceFailureException("Api was not created", (Throwable)e);
        }
        catch (Exception e) {
            this.mLog.error((Object)e);
            throw new BadCredentialsException("User not authenticated", (Throwable)e);
        }
        if (loadedUser == null) {
            throw new AuthenticationServiceException("UserDetailsService returned null, which is an interface contract violation");
        }
        return loadedUser;
    }

    public void setPasswordEncoder(PasswordEncoder passwordEncoder) {
        this.passwordEncoder = passwordEncoder;
    }

    public void setSaltSource(SaltSource saltSource) {
        this.saltSource = saltSource;
    }

    public boolean isIncludeDetailsObject() {
        return this.includeDetailsObject;
    }

    public void setIncludeDetailsObject(boolean includeDetailsObject) {
        this.includeDetailsObject = includeDetailsObject;
    }

    protected abstract CommonApi getApi() throws ApiException;
}

