/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splusserver.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.naming.Context;
import javax.naming.InitialContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EnvironmentUtil {
    private static final Log log = LogFactory.getLog(EnvironmentUtil.class);

    public static String getEnviromentUrl(String urlPropName) {
        String endpointUri = null;
        try {
            InitialContext initCtx = new InitialContext();
            Context envCtx = (Context)initCtx.lookup("java:comp/env");
            endpointUri = (String)envCtx.lookup(urlPropName);
            endpointUri = EnvironmentUtil.getTrueHostName(endpointUri);
        }
        catch (Exception e) {
            log.debug((Object)("Retrieving global property: " + urlPropName + "  failed with exception: "), (Throwable)e);
        }
        return endpointUri;
    }

    public static String getTrueHostName(String connectString) {
        if (!connectString.contains("//localhost")) {
            return connectString;
        }
        try {
            InetAddress addr = InetAddress.getLocalHost();
            String trueHostName = "//" + addr.getHostName();
            String returnString = new String(connectString);
            String trueHostString = returnString.replace("//localhost", trueHostName);
            return trueHostString;
        }
        catch (UnknownHostException e) {
            log.error((Object)"Could not get local host name!", (Throwable)e);
            return connectString;
        }
    }
}

