/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splusserver.util;

import com.insightful.splusserver.domain.tree.Node;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeUtil {
    public static Node generatePath(String path) {
        Node rootNode = null;
        Node currentNode = null;
        String currentPath = "";
        String[] pathElements = StringUtils.split((String)path, (String)"/");
        for (int i = 0; i < pathElements.length; ++i) {
            Node newNode = null;
            Node.NodeType type = i < pathElements.length - 1 ? Node.NodeType.Folder : Node.NodeType.Leaf;
            currentPath = currentPath + "/" + pathElements[i];
            newNode = new Node();
            newNode.setName(pathElements[i]);
            newNode.setAction(currentPath);
            newNode.setType(type);
            if (currentNode != null) {
                currentNode.addChild(newNode);
            }
            currentNode = newNode;
            if (i != 0) continue;
            rootNode = currentNode;
        }
        return rootNode;
    }

    public static void addToTree(List<Node> tree, Node path) {
        boolean added = false;
        for (Node n : tree) {
            if (!StringUtils.equals((String)n.getName(), (String)path.getName())) continue;
            List treeChildren = n.getChildren();
            List pathChildren = path.getChildren();
            if (CollectionUtils.isEmpty((Collection)pathChildren)) continue;
            Node pathChild = (Node)pathChildren.get(0);
            TreeUtil.addToTree(treeChildren, pathChild);
            added = true;
            n.setType(Node.NodeType.Folder);
            break;
        }
        if (!added) {
            tree.add(path);
        }
    }
}

