/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus;

import com.insightful.controls.SplusDialog;
import com.insightful.splus.SplusOptionsManager;
import com.insightful.splus.SplusSystem;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class DialogOptionsDialog
extends JDialog {
    JButton okButton;
    JButton cancelButton;
    JButton helpButton;
    ButtonListener buttonListener;
    JPanel buttonPanel;
    JPanel graphPanel;
    JPanel textPanel;
    JCheckBox createGraphCheckBox;
    JCheckBox echoCommandCheckBox;
    String createGraphInitialValue;
    String echoCommandInitialValue;

    public DialogOptionsDialog() {
        this(SplusSystem.getDefaultFrame());
    }

    public DialogOptionsDialog(Frame frame) {
        super(frame, "Dialog Options", true);
        try {
            this.graphPanel = new JPanel();
            this.graphPanel.setBorder(BorderFactory.createTitledBorder("Graphs"));
            this.graphPanel.setLayout(new BoxLayout(this.graphPanel, 1));
            this.createGraphCheckBox = new JCheckBox("Create New Graph Window");
            this.graphPanel.add(this.createGraphCheckBox);
            this.createGraphInitialValue = SplusOptionsManager.getOption("new.graphsheet");
            this.createGraphCheckBox.setSelected(this.createGraphInitialValue.equals("") || this.createGraphInitialValue.equals("T") || this.createGraphInitialValue.equals("TRUE"));
            this.textPanel = new JPanel();
            this.textPanel.setBorder(BorderFactory.createTitledBorder("Text"));
            this.textPanel.setLayout(new BoxLayout(this.textPanel, 1));
            this.echoCommandCheckBox = new JCheckBox("Echo Dialog Command");
            this.textPanel.add(this.echoCommandCheckBox);
            this.echoCommandInitialValue = SplusOptionsManager.getOption("echoCommand");
            this.echoCommandCheckBox.setSelected(this.echoCommandInitialValue.equals("T") || this.echoCommandInitialValue.equals("TRUE"));
            this.buttonPanel = new JPanel();
            this.buttonListener = new ButtonListener();
            this.okButton = new JButton("OK");
            this.okButton.addActionListener(this.buttonListener);
            this.cancelButton = new JButton("Cancel");
            this.cancelButton.addActionListener(this.buttonListener);
            this.helpButton = new JButton("Help");
            this.helpButton.addActionListener(this.buttonListener);
            this.buttonPanel.add(this.okButton);
            this.buttonPanel.add(this.cancelButton);
            this.buttonPanel.add(Box.createHorizontalGlue());
            this.buttonPanel.add(this.helpButton);
            Box box = Box.createVerticalBox();
            box.add(this.graphPanel);
            box.add(this.textPanel);
            this.getContentPane().add((Component)box, "Center");
            this.getContentPane().add((Component)this.buttonPanel, "South");
            this.getRootPane().setDefaultButton(this.okButton);
            this.pack();
            SplusDialog.centerComponent(this, frame);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    class ButtonListener
    implements ActionListener {
        ButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JButton jButton = (JButton)actionEvent.getSource();
            if (jButton == DialogOptionsDialog.this.okButton) {
                String string;
                String string2;
                String string3 = string2 = DialogOptionsDialog.this.createGraphCheckBox.isSelected() ? "T" : "F";
                if (!string2.equals(DialogOptionsDialog.this.createGraphInitialValue)) {
                    SplusOptionsManager.setOption("new.graphsheet", string2);
                }
                String string4 = string = DialogOptionsDialog.this.echoCommandCheckBox.isSelected() ? "T" : "F";
                if (!string.equals(DialogOptionsDialog.this.echoCommandInitialValue)) {
                    SplusOptionsManager.setOption("echoCommand", string);
                }
                DialogOptionsDialog.this.dispose();
            } else if (jButton == DialogOptionsDialog.this.cancelButton) {
                DialogOptionsDialog.this.dispose();
            } else if (jButton == DialogOptionsDialog.this.helpButton) {
                SplusSystem.getHelpQueryHandler().displayHelpOnTopic("Dialog_Options");
            }
        }
    }
}

