/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus;

import java.io.File;
import java.io.FileOutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;

public class SplusSessionFactoryLog {
    private static boolean g_isWin = System.getProperty("os.name").toLowerCase().indexOf("windows") >= 0;
    private String logname;
    private FileOutputStream logStream;
    private boolean logDaily = false;
    private Thread logUpdate;
    private boolean writing;

    public SplusSessionFactoryLog(int n) {
        try {
            String string;
            File file;
            boolean bl;
            this.logname = System.getProperty("splus.factory.log");
            if (this.logname == null || this.logname.length() == 0) {
                this.logname = System.getProperty("splus.shome") + "/adm/logs/factory_" + n + ".log";
            }
            boolean bl2 = bl = !(file = new File(this.logname)).exists();
            if (g_isWin && bl) {
                file.getParentFile().mkdirs();
            }
            this.logStream = new FileOutputStream(this.logname, true);
            if (!g_isWin && bl) {
                try {
                    string = "chmod 666 " + this.logname;
                    Runtime.getRuntime().exec(string);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    System.err.println("\n\nCan't set permissions on logfile.\n");
                }
            }
            if ((string = System.getProperty("splus.factory.rotate")) != null && string.equals("true")) {
                this.logDaily = true;
            }
            this.writing = true;
            this.logUpdate = new Thread(new Runnable(){

                public void run() {
                    while (SplusSessionFactoryLog.this.writing) {
                        try {
                            Thread.currentThread();
                            Thread.sleep(86400000L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (!SplusSessionFactoryLog.this.logDaily || !SplusSessionFactoryLog.this.writing) continue;
                        SplusSessionFactoryLog.this.rotate();
                    }
                }
            });
            this.logUpdate.start();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println("\nWith file: " + this.logname + ": \n");
            System.err.println("\tCan't open log file.  Fix permissions.\n");
            System.exit(1);
        }
    }

    private synchronized void rotate() {
        try {
            this.logStream.flush();
            this.logStream.close();
            String string = this.logname + "." + new SimpleDateFormat("yyyyMMddHHmm").format(new Date());
            new File(this.logname).renameTo(new File(string));
            this.logStream = new FileOutputStream(this.logname);
            String string2 = "chmod 666 " + this.logname;
            Runtime.getRuntime().exec(string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println("\n\nLog rotation failed. Reverting.\n\n");
            try {
                this.logStream = new FileOutputStream(this.logname, true);
            }
            catch (Exception exception2) {
                exception2.printStackTrace();
                System.err.println("\n\nLog file is broken.  Terminating.\n");
                System.exit(1);
            }
        }
    }

    public synchronized void setName(String string) {
        try {
            this.logStream.flush();
            this.logStream.close();
            this.logStream = new FileOutputStream(string, true);
            this.logname = string;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println("\n\nReverting to prior log file\n\n");
            try {
                this.logStream = new FileOutputStream(this.logname, true);
            }
            catch (Exception exception2) {
                exception2.printStackTrace();
                System.err.println("\n\nLog file is broken.  Bailing.\n");
                System.exit(1);
            }
        }
    }

    public String getName() {
        return this.logname;
    }

    public void setDaily(boolean bl) {
        this.logDaily = bl;
    }

    public boolean getDaily() {
        return this.logDaily;
    }

    public synchronized void append(String string) {
        String string2 = new SimpleDateFormat("yyyy.MM.dd.HH:mm:ss.SSS").format(new Date()) + " " + string + "\n";
        try {
            this.logStream.write(string2.getBytes());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void release() {
        this.writing = false;
        this.logUpdate.interrupt();
    }

    protected void finalize() throws Throwable {
        this.writing = false;
        this.logUpdate.interrupt();
    }
}

