/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus;

import com.insightful.gdevice.SCanvas;
import com.insightful.splus.RemoteFileInputStream;
import com.insightful.splus.RemoteFileOutputStream;
import com.insightful.splus.SplusDataResult;
import com.insightful.splus.SplusEngineQueryHandler;
import com.insightful.splus.SplusGui;
import com.insightful.splus.SplusMinGui;
import com.insightful.splus.SplusServerFileHandler;
import com.insightful.splus.SplusSession;
import com.insightful.splus.SplusSessionImpl;
import com.insightful.splus.SplusSystem;
import com.insightful.splus.SplusWinSessionImpl;
import com.insightful.splus.client.ServerFileSystemView;
import com.insightful.splus.graph.CanvasTabbedPane;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import javax.swing.JComponent;
import javax.swing.filechooser.FileSystemView;

public class SplusUserApp
implements SplusEngineQueryHandler,
SplusServerFileHandler {
    static SplusSession m_splusSession = null;
    static CanvasTabbedPane m_canvasPanel = null;
    static Object m_evalSync = new Object();
    static boolean m_evalInProgress = false;
    private static FileSystemView m_fileSystemView = null;
    private static SplusUserApp theApp = new SplusUserApp();

    private SplusUserApp() {
        SplusSystem.setEngineQueryHandler(this);
        SplusSystem.setServerFileHandler(this);
    }

    static SplusSession getSession() {
        if (m_splusSession == null) {
            SplusUserApp.startSession(new String[0]);
        }
        return m_splusSession;
    }

    public static void startSession(String[] stringArray) {
        block12: {
            try {
                if (m_splusSession != null) break block12;
                if (System.getProperty("splus.client.mode") == null) {
                    if (System.getProperty("os.name", "").toLowerCase().indexOf("windows") < 0) {
                        if (SplusGui.getSplusUsePipes()) {
                            m_splusSession = new SplusSessionImpl(stringArray);
                        } else {
                            System.setProperty("splus.interactive.commandline", "F");
                            m_splusSession = new SplusWinSessionImpl(stringArray);
                        }
                    } else {
                        m_splusSession = new SplusWinSessionImpl(stringArray);
                    }
                } else if (System.getProperty("splus.server.password") == null) {
                    m_splusSession = SplusSessionImpl.getRemoteSession(true, null, stringArray);
                } else {
                    m_splusSession = SplusSessionImpl.getRemoteSession(false, null, stringArray);
                    try {
                        Runtime runtime = Runtime.getRuntime();
                        Class[] classArray = new Class[]{Class.forName("java.lang.Thread")};
                        Object[] objectArray = new Object[]{new Thread(new Runnable(){

                            public void run() {
                                SplusUserApp.endSession(false);
                            }
                        })};
                        Method method = runtime.getClass().getMethod("addShutdownHook", classArray);
                        method.invoke((Object)runtime, objectArray);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                m_canvasPanel = new CanvasTabbedPane(false);
                new SplusMinGui(false){

                    public void showNewCanvas(SCanvas sCanvas) {
                        m_canvasPanel.removeAllTabs();
                        m_canvasPanel.setActiveCanvas(sCanvas);
                        m_canvasPanel.addCanvasTab(sCanvas);
                    }
                };
            }
            catch (Exception exception) {
                exception.printStackTrace(System.out);
            }
        }
    }

    static void endSession(boolean bl) {
        if (m_splusSession != null && System.getProperty("splus.client.mode") != null) {
            try {
                m_splusSession.sessionExit(bl);
            }
            catch (Exception exception) {
                // empty catch block
            }
            m_splusSession = null;
        }
    }

    public static SplusDataResult eval(String string) {
        return SplusUserApp.eval(string, false, true, true, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SplusDataResult eval(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        String string2 = "unknown error";
        Object object = m_evalSync;
        synchronized (object) {
            if (m_evalInProgress) {
                throw new RuntimeException("SplusUserApp.eval called while eval in progress");
            }
            m_evalInProgress = true;
        }
        try {
            if (SplusUserApp.getSession() == null) {
                throw new Exception("Can't access S-PLUS session");
            }
            Object object2 = object = SplusUserApp.getSession().evalDataQuery("{" + string + "}", bl, bl2, bl3, bl4, bl5);
            return object2;
        }
        catch (Exception exception) {
            string2 = exception.getLocalizedMessage();
        }
        finally {
            m_evalInProgress = false;
        }
        return new SplusDataResult("", "SplusUserApp.eval error: " + string2, string, new String[0]);
    }

    public static JComponent getGraph() {
        SplusUserApp.getSession();
        return m_canvasPanel;
    }

    public FileSystemView getServerFileSystemView() {
        if (m_fileSystemView == null) {
            if (System.getProperty("splus.client.mode", "").equals("true")) {
                try {
                    m_fileSystemView = new ServerFileSystemView(SplusUserApp.getSession().getClientUtilities());
                }
                catch (RemoteException remoteException) {
                    remoteException.printStackTrace();
                }
            } else {
                m_fileSystemView = FileSystemView.getFileSystemView();
            }
        }
        return m_fileSystemView;
    }

    public FileInputStream getServerFileInputStream(String string) throws FileNotFoundException {
        if (System.getProperty("splus.client.mode", "").equals("true")) {
            return new RemoteFileInputStream(string, SplusUserApp.getSession());
        }
        return new FileInputStream(string);
    }

    public FileOutputStream getServerFileOutputStream(String string) throws FileNotFoundException, IOException {
        if (System.getProperty("splus.client.mode", "").equals("true")) {
            return new RemoteFileOutputStream(string, SplusUserApp.getSession());
        }
        return new FileOutputStream(string);
    }

    public SplusDataResult processDataQuery(String string) {
        return SplusUserApp.eval(string);
    }

    public SplusDataResult processFileChooserDataQuery(String string) {
        return SplusUserApp.eval(string);
    }

    public SplusDataResult processDataQuery(String string, int n) {
        return SplusUserApp.eval(string);
    }

    public void processDialogCommand(String string) {
        SplusUserApp.eval(string);
    }

    public void writeEngineOutput(String string, boolean bl) {
    }
}

