/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.graph;

import com.insightful.controls.SplusDialog;
import com.insightful.gdevice.SCanvasPaneController;
import com.insightful.splus.SplusMinGui;
import com.insightful.splus.SplusSystem;
import com.insightful.splus.graph.CanvasTabbedPane;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class GraphOptionsDialog
extends JDialog {
    JButton okButton;
    JButton cancelButton;
    JButton helpButton;
    ButtonListener buttonListener;
    JPanel buttonPanel;
    JPanel colorSchemePanel;
    ButtonGroup grpNewGraph;
    JComboBox colorScheme;
    JCheckBox m_cbDisplayMouse = new JCheckBox("Display mouse position");
    JCheckBox m_cbDisplayActive = new JCheckBox("Enable active regions");
    JTextField m_tfMouseFractionDigits = new JTextField(3);
    private static final String NEW_TAB_IN_EXPRESSION = "Delete pages, then add new pages";
    private static final String NEW_TAB = "New page";
    private static final String EXISTING_TAB = "Reuse page";

    public GraphOptionsDialog() {
        this(SplusSystem.getDefaultFrame());
    }

    protected boolean showHelpButton() {
        return !(SplusSystem.getCanvasHandler() instanceof SplusMinGui);
    }

    public GraphOptionsDialog(Frame frame) {
        super(frame, "Graph Options", true);
        try {
            JPanel jPanel = GraphOptionsDialog.makeTitleBox(null);
            JPanel jPanel2 = GraphOptionsDialog.makeTitleBox("New Plot Action");
            this.grpNewGraph = new ButtonGroup();
            int n = CanvasTabbedPane.getClearReaction();
            JRadioButton jRadioButton = new JRadioButton(NEW_TAB_IN_EXPRESSION, n == 0);
            jRadioButton.setActionCommand(NEW_TAB_IN_EXPRESSION);
            jRadioButton.setToolTipText("Delete any existing pages, and then add a new page with each plot");
            this.grpNewGraph.add(jRadioButton);
            jPanel2.add(jRadioButton);
            jRadioButton = new JRadioButton(NEW_TAB, n == 1);
            jRadioButton.setActionCommand(NEW_TAB);
            jRadioButton.setToolTipText("Add a new page with each plot");
            this.grpNewGraph.add(jRadioButton);
            jPanel2.add(jRadioButton);
            jRadioButton = new JRadioButton(EXISTING_TAB, n == 2);
            jRadioButton.setActionCommand(EXISTING_TAB);
            jRadioButton.setToolTipText("Reuse the current page with each plot");
            this.grpNewGraph.add(jRadioButton);
            jPanel2.add(jRadioButton);
            this.buttonPanel = new JPanel();
            this.buttonListener = new ButtonListener();
            this.okButton = new JButton("OK");
            this.okButton.addActionListener(this.buttonListener);
            this.cancelButton = new JButton("Cancel");
            this.cancelButton.addActionListener(this.buttonListener);
            this.helpButton = new JButton("Help");
            this.helpButton.addActionListener(this.buttonListener);
            this.buttonPanel.add(this.okButton);
            this.buttonPanel.add(this.cancelButton);
            if (this.showHelpButton()) {
                this.buttonPanel.add(Box.createHorizontalGlue());
                this.buttonPanel.add(this.helpButton);
            }
            this.getRootPane().setDefaultButton(this.okButton);
            JPanel jPanel3 = GraphOptionsDialog.makeTitleBox("Mouse Actions");
            jPanel3.add(GraphOptionsDialog.makeLeftFlowPanel(this.m_cbDisplayActive));
            jPanel3.add(GraphOptionsDialog.makeLeftFlowPanel(this.m_cbDisplayMouse));
            jPanel3.add(GraphOptionsDialog.makeLeftFlowPanel(new JLabel("Mouse position digits:  "), this.m_tfMouseFractionDigits));
            this.m_cbDisplayMouse.setSelected(SCanvasPaneController.getShowMouseLocation());
            this.m_cbDisplayActive.setSelected(SCanvasPaneController.getShowActiveRegions());
            this.m_tfMouseFractionDigits.setText(Integer.toString(SCanvasPaneController.getLocatorFractionDigits()));
            jPanel.add(jPanel2);
            jPanel.add(Box.createVerticalStrut(5));
            jPanel.add(jPanel3);
            jPanel.setAlignmentX(0.0f);
            this.getContentPane().add((Component)jPanel, "Center");
            this.getContentPane().add((Component)this.buttonPanel, "South");
            this.pack();
            SplusDialog.centerComponent(this, SplusSystem.getDefaultFrame());
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    static JPanel makeTitleBox(String string) {
        JPanel jPanel = new JPanel();
        if (string != null) {
            jPanel.setBorder(BorderFactory.createTitledBorder(string));
        }
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setAlignmentX(0.0f);
        return jPanel;
    }

    static JPanel makeLeftFlowPanel(JComponent jComponent) {
        JPanel jPanel = new JPanel(new FlowLayout(0, 0, 0));
        jPanel.add(jComponent);
        return jPanel;
    }

    static JPanel makeLeftFlowPanel(JComponent jComponent, JComponent jComponent2) {
        JPanel jPanel = GraphOptionsDialog.makeLeftFlowPanel(jComponent);
        jPanel.add(jComponent2);
        return jPanel;
    }

    String getSelectedColorSchemeName() {
        return (String)this.colorScheme.getSelectedItem();
    }

    class ButtonListener
    implements ActionListener {
        ButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JButton jButton = (JButton)actionEvent.getSource();
            if (jButton == GraphOptionsDialog.this.okButton) {
                String string = GraphOptionsDialog.this.grpNewGraph.getSelection().getActionCommand();
                if (string.equals(GraphOptionsDialog.NEW_TAB_IN_EXPRESSION)) {
                    CanvasTabbedPane.setClearReaction(0);
                } else if (string.equals(GraphOptionsDialog.NEW_TAB)) {
                    CanvasTabbedPane.setClearReaction(1);
                } else {
                    CanvasTabbedPane.setClearReaction(2);
                }
                SCanvasPaneController.setShowMouseLocation(GraphOptionsDialog.this.m_cbDisplayMouse.isSelected());
                SCanvasPaneController.setShowActiveRegions(GraphOptionsDialog.this.m_cbDisplayActive.isSelected());
                try {
                    SCanvasPaneController.setLocatorFractionDigits(Integer.parseInt(GraphOptionsDialog.this.m_tfMouseFractionDigits.getText()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                GraphOptionsDialog.this.dispose();
            } else if (jButton == GraphOptionsDialog.this.cancelButton) {
                GraphOptionsDialog.this.dispose();
            } else if (jButton == GraphOptionsDialog.this.helpButton) {
                SplusSystem.getHelpQueryHandler().displayHelpOnTopic("Graph_Options");
            }
        }
    }
}

