/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.mlib;

import com.sun.media.jai.mlib.JaiI18N;
import com.sun.media.jai.mlib.MediaLibAccessor;
import com.sun.media.jai.mlib.MlibUtils;
import com.sun.media.jai.util.ImageUtil;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import javax.media.jai.ImageLayout;
import javax.media.jai.PointOpImage;
import javax.media.jai.TileCache;
import mediaLib.mediaLibImage;
import mediaLibwrapper.Image;

final class MlibSubtractFromConstOpImage
extends PointOpImage {
    private double[] constants;

    public MlibSubtractFromConstOpImage(RenderedImage renderedImage, TileCache tileCache, ImageLayout imageLayout, double[] dArray) {
        super(renderedImage, tileCache, imageLayout, true);
        this.constants = MlibUtils.initConstants(dArray, this.getSampleModel().getNumBands());
        this.permitInPlaceOperation();
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        Raster raster = rasterArray[0];
        int n = MediaLibAccessor.findCompatibleTag(rasterArray, writableRaster);
        MediaLibAccessor mediaLibAccessor = new MediaLibAccessor(raster, rectangle, n);
        MediaLibAccessor mediaLibAccessor2 = new MediaLibAccessor(writableRaster, rectangle, n);
        mediaLibImage[] mediaLibImageArray = mediaLibAccessor.getMediaLibImages();
        mediaLibImage[] mediaLibImageArray2 = mediaLibAccessor2.getMediaLibImages();
        switch (mediaLibAccessor2.getDataType()) {
            case 0: 
            case 2: 
            case 3: {
                int[] nArray = new int[this.constants.length];
                int n2 = 0;
                while (n2 < this.constants.length) {
                    nArray[n2] = ImageUtil.clampRoundInt(this.constants[n2]);
                    ++n2;
                }
                n2 = 0;
                while (n2 < mediaLibImageArray2.length) {
                    int[] nArray2 = mediaLibAccessor2.getIntParameters(n2, nArray);
                    Image.ConstSub((mediaLibImage)mediaLibImageArray2[n2], (mediaLibImage)mediaLibImageArray[n2], (int[])nArray2);
                    ++n2;
                }
                break;
            }
            case 4: 
            case 5: {
                int n3 = 0;
                while (n3 < mediaLibImageArray2.length) {
                    double[] dArray = mediaLibAccessor2.getDoubleParameters(n3, this.constants);
                    Image.ConstSub_Fp((mediaLibImage)mediaLibImageArray2[n3], (mediaLibImage)mediaLibImageArray[n3], (double[])dArray);
                    ++n3;
                }
                break;
            }
            default: {
                String string = this.getClass().getName();
                throw new RuntimeException(String.valueOf(string) + JaiI18N.getString("MlibUshort"));
            }
        }
        if (mediaLibAccessor2.isDataCopy()) {
            mediaLibAccessor2.clampDataArrays();
            mediaLibAccessor2.copyDataToRaster();
        }
    }
}

