/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.util;

import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.awt.image.Raster;
import java.util.Vector;
import javax.media.jai.PlanarImage;

public class PlanarImageProducer
implements ImageProducer {
    PlanarImage im;
    Vector consumers = new Vector();

    public PlanarImageProducer(PlanarImage planarImage) {
        this.im = planarImage.createSnapshot();
    }

    public void addConsumer(ImageConsumer imageConsumer) {
        if (!this.consumers.contains(imageConsumer)) {
            this.consumers.add(imageConsumer);
        }
        this.produceImage();
    }

    public boolean isConsumer(ImageConsumer imageConsumer) {
        return this.consumers.contains(imageConsumer);
    }

    private synchronized void produceImage() {
        int n = this.consumers.size();
        int n2 = this.im.getMinX();
        int n3 = this.im.getMinY();
        int n4 = this.im.getWidth();
        int n5 = this.im.getHeight();
        int n6 = this.im.getSampleModel().getNumBands();
        int n7 = n4 * n6;
        ColorModel colorModel = this.im.getColorModel();
        int[] nArray = new int[n7];
        Rectangle rectangle = new Rectangle(n2, n3, n4, 1);
        int n8 = 0;
        while (n8 < n) {
            ImageConsumer imageConsumer = (ImageConsumer)this.consumers.elementAt(n8);
            imageConsumer.setHints(22);
            ++n8;
        }
        int n9 = n3;
        while (n9 < n3 + n5) {
            rectangle.y = n9;
            Raster raster = this.im.getData(rectangle);
            raster.getPixels(n2, n9, n4, 1, nArray);
            int n10 = 0;
            while (n10 < n) {
                ImageConsumer imageConsumer = (ImageConsumer)this.consumers.elementAt(n10);
                imageConsumer.setPixels(0, n9 - n3, n4, 1, colorModel, nArray, 0, n7);
                ++n10;
            }
            ++n9;
        }
        int n11 = 0;
        while (n11 < n) {
            ImageConsumer imageConsumer = (ImageConsumer)this.consumers.elementAt(n11);
            imageConsumer.imageComplete(3);
            ++n11;
        }
    }

    public void removeConsumer(ImageConsumer imageConsumer) {
        this.consumers.remove(imageConsumer);
    }

    public void requestTopDownLeftRightResend(ImageConsumer imageConsumer) {
        this.startProduction(imageConsumer);
    }

    public void startProduction(ImageConsumer imageConsumer) {
        if (!this.consumers.contains(imageConsumer)) {
            this.consumers.add(imageConsumer);
        }
        this.produceImage();
    }
}

