/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.datatypes;

import org.apache.fop.datatypes.PercentBase;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.expr.PropertyException;

public class LengthBase
implements PercentBase {
    public static final int CUSTOM_BASE = 0;
    public static final int FONTSIZE = 1;
    public static final int INH_FONTSIZE = 2;
    public static final int CONTAINING_BOX = 3;
    public static final int CONTAINING_REFAREA = 4;
    public static final int BLOCK_WIDTH = 5;
    public static final int BLOCK_HEIGHT = 6;
    public static final int IMAGE_INTRINSIC_WIDTH = 7;
    public static final int IMAGE_INTRINSIC_HEIGHT = 8;
    public static final int[] PERCENT_BASED_LENGTH_TYPES = new int[]{0, 1, 2, 3, 4, 7, 8};
    protected FObj parentFO;
    private PropertyList propertyList;
    private int iBaseType;

    public LengthBase(FObj parentFO, PropertyList plist, int iBaseType) {
        this.parentFO = parentFO;
        this.propertyList = plist;
        this.iBaseType = iBaseType;
    }

    protected FObj getParentFO() {
        return this.parentFO;
    }

    protected PropertyList getPropertyList() {
        return this.propertyList;
    }

    public int getDimension() {
        return 1;
    }

    public double getBaseValue() {
        return 1.0;
    }

    public int getBaseLength() throws PropertyException {
        switch (this.iBaseType) {
            case 1: {
                return this.propertyList.get(94).getLength().getValue();
            }
            case 2: {
                return this.propertyList.getInherited(94).getLength().getValue();
            }
            case 5: {
                return this.parentFO.getLayoutDimension(PercentBase.BLOCK_IPD).intValue();
            }
            case 6: {
                return this.parentFO.getLayoutDimension(PercentBase.BLOCK_BPD).intValue();
            }
            case 4: {
                FObj fo;
                for (fo = this.parentFO; fo != null && !fo.generatesReferenceAreas(); fo = fo.findNearestAncestorFObj()) {
                }
                if (fo != null && fo instanceof FObj) {
                    return fo.getLayoutDimension(PercentBase.BLOCK_IPD).intValue();
                }
                return 0;
            }
            case 7: {
                return this.propertyList.getFObj().getLayoutDimension(PercentBase.IMAGE_INTRINSIC_WIDTH).intValue();
            }
            case 8: {
                return this.propertyList.getFObj().getLayoutDimension(PercentBase.IMAGE_INTRINSIC_HEIGHT).intValue();
            }
            case 0: {
                return 0;
            }
        }
        this.parentFO.getLogger().error("Unknown base type for LengthBase.");
        return 0;
    }
}

