/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.properties;

import org.apache.fop.datatypes.Length;
import org.apache.fop.datatypes.Numeric;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.fonts.Font;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.FontMetrics;

public class CommonFont {
    public String fontFamily;
    public int fontSelectionStrategy;
    public Length fontSize;
    public int fontStretch;
    public Numeric fontSizeAdjust;
    public String fontStyle;
    public int fontVariant;
    public String fontWeight;
    private Font fontState;

    public CommonFont(PropertyList pList) throws PropertyException {
        this.fontFamily = pList.get(92).getString();
        this.fontSelectionStrategy = pList.get(93).getEnum();
        this.fontSize = pList.get(94).getLength();
        this.fontStretch = pList.get(96).getEnum();
        this.fontSizeAdjust = pList.get(95).getNumeric();
        this.fontStyle = pList.get(97).getString();
        this.fontVariant = pList.get(98).getEnum();
        this.fontWeight = pList.get(99).getString();
    }

    public Font getFontState(FontInfo fontInfo) {
        if (this.fontState == null) {
            int font_weight = 400;
            if (!this.fontWeight.equals("bolder") && !this.fontWeight.equals("lighter")) {
                try {
                    font_weight = Integer.parseInt(this.fontWeight);
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
            if ((font_weight = font_weight / 100 * 100) < 100) {
                font_weight = 100;
            } else if (font_weight > 900) {
                font_weight = 900;
            }
            String fname = fontInfo.fontLookup(this.fontFamily, this.fontStyle, font_weight);
            FontMetrics metrics = fontInfo.getMetricsFor(fname);
            this.fontState = new Font(fname, metrics, this.fontSize.getValue());
        }
        return this.fontState;
    }
}

